/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

using Gwibber;

namespace Gwibber.Test
{
  public class UtilsSuite
  {
    public UtilsSuite ()
    {
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/time_string_seconds",
                               UtilsSuite.test_time_string_seconds);
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/time_string_minute",
                               UtilsSuite.test_time_string_minute);
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/time_string_minutes",
                               UtilsSuite.test_time_string_minutes);
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/time_string_hour",
                               UtilsSuite.test_time_string_hour);
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/time_string_hours",
                               UtilsSuite.test_time_string_hours);
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/time_string_day",
                               UtilsSuite.test_time_string_day);
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/time_string_days",
                               UtilsSuite.test_time_string_days);
      GLib.Test.add_data_func ("/Unit/Gwibber/Utils/avatar_path",
                               UtilsSuite.test_avatar_path);
    }

    internal static void test_time_string_seconds ()
    {
      var utils = new Gwibber.Utils ();
      time_t _t = time_t ();
      Time n = Time.gm (_t);
      Time lt = Time.local (_t);
      n.isdst = lt.isdst;
      var t = (int)n.mktime() - 59;
      var ts = utils.generate_time_string (t);
      assert (ts == "a few seconds ago");
    }

    internal static void test_time_string_minute ()
    {
      var utils = new Gwibber.Utils ();
      time_t _t = time_t ();
      Time n = Time.gm (_t);
      Time lt = Time.local (_t);
      n.isdst = lt.isdst; 
      var t = (int)n.mktime() - 60;
      var ts = utils.generate_time_string (t);
      assert (ts == "1 minute ago");
    }
    internal static void test_time_string_minutes ()
    {
      var utils = new Gwibber.Utils ();
      time_t _t = time_t ();
      Time n = Time.gm (_t);
      Time lt = Time.local (_t);
      n.isdst = lt.isdst; 
      var t = (int)n.mktime() - 3559;
      var ts = utils.generate_time_string (t);
      assert (ts.contains ("minutes ago"));
    }
    internal static void test_time_string_hour ()
    {
      var utils = new Gwibber.Utils ();
      time_t _t = time_t ();
      Time n = Time.gm (_t);
      Time lt = Time.local (_t);
      n.isdst = lt.isdst; 
      var t = (int)n.mktime() - 3601;
      var ts = utils.generate_time_string (t);
      assert (ts == "1 hour ago");
    }
    internal static void test_time_string_hours ()
    {
      var utils = new Gwibber.Utils ();
      time_t _t = time_t ();
      Time n = Time.gm (_t);
      Time lt = Time.local (_t);
      n.isdst = lt.isdst; 
      var t = (int)n.mktime() - 7201;
      var ts = utils.generate_time_string (t);
      assert (ts.contains ("hours ago"));
    }
    internal static void test_time_string_day ()
    {
      var utils = new Gwibber.Utils ();
      time_t _t = time_t ();
      Time n = Time.gm (_t);
      Time lt = Time.local (_t);
      n.isdst = lt.isdst; 
      var t = (int)n.mktime() - 86400;
      var ts = utils.generate_time_string (t);
      assert (ts == "1 day ago");
    }
    internal static void test_time_string_days ()
    {
      var utils = new Gwibber.Utils ();
      time_t _t = time_t ();
      Time n = Time.gm (_t);
      Time lt = Time.local (_t);
      n.isdst = lt.isdst; 
      var t = (int)n.mktime() - 172800;
      var ts = utils.generate_time_string (t);
      assert (ts.contains ("days ago"));
    }
    internal static void test_avatar_path ()
    {
      var utils = new Gwibber.Utils ();
      string url = "http://test.com/avatar";
      string avatar_path = utils.avatar_path (url);
      assert (avatar_path == Path.build_path (Path.DIR_SEPARATOR_S, Environment.get_user_cache_dir(), "gwibber/avatars", GLib.Checksum.compute_for_string(GLib.ChecksumType.SHA1, url)));
      url = "http://test.com/this_is_a_very_long_avatar_url_that_should_cause_test_failures_as_per_bug_845374_which_is_scheduled_to_be_fixed_in_a_later_release_but_hopefully_will_be_patched_before_then";
      stdout.printf(GLib.Checksum.compute_for_string(GLib.ChecksumType.SHA1, url, url.length));
      avatar_path = utils.avatar_path (url);
      assert (avatar_path == Path.build_path (Path.DIR_SEPARATOR_S, Environment.get_user_cache_dir(), "gwibber/avatars", GLib.Checksum.compute_for_string(GLib.ChecksumType.SHA1, url)));
    }
  }
}
