/* daemon.c generated by valac 0.15.2, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include "gwibber.h"
#include <dee.h>
#include <dee-icu.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <config.h>
#include <gee.h>
#include <locale.h>


#define UNITY_GWIBBER_TYPE_DAEMON (unity_gwibber_daemon_get_type ())
#define UNITY_GWIBBER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemon))
#define UNITY_GWIBBER_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonClass))
#define UNITY_GWIBBER_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GWIBBER_TYPE_DAEMON))
#define UNITY_GWIBBER_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GWIBBER_TYPE_DAEMON))
#define UNITY_GWIBBER_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonClass))

typedef struct _UnityGwibberDaemon UnityGwibberDaemon;
typedef struct _UnityGwibberDaemonClass UnityGwibberDaemonClass;
typedef struct _UnityGwibberDaemonPrivate UnityGwibberDaemonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dee_icu_term_filter_destroy0(var) ((var == NULL) ? NULL : (var = (dee_icu_term_filter_destroy (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_GWIBBER_TYPE_CATEGORIES (unity_gwibber_categories_get_type ())
typedef struct _UnityGwibberDaemonUpdateGlobalSearchData UnityGwibberDaemonUpdateGlobalSearchData;
typedef struct _UnityGwibberDaemonUpdateScopeSearchData UnityGwibberDaemonUpdateScopeSearchData;
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UnityGwibberDaemon {
	GObject parent_instance;
	UnityGwibberDaemonPrivate * priv;
};

struct _UnityGwibberDaemonClass {
	GObjectClass parent_class;
};

struct _UnityGwibberDaemonPrivate {
	UnityLens* lens;
	UnityScope* scope;
	GwibberStreams* streams_service;
	GwibberService* service;
	GwibberAccounts* accounts;
	GwibberUtils* utils;
	DeeModel* _model;
	DeeModel* _streams_model;
	DeeFilter _sort_filter;
	DeeModelIter* _stream_iter_first;
	DeeModelIter* _stream_iter_last;
	DeeAnalyzer* _analyzer;
	DeeIndex* _index;
	DeeICUTermFilter* _ascii_filter;
};

typedef enum  {
	UNITY_GWIBBER_CATEGORIES_MESSAGES = 0,
	UNITY_GWIBBER_CATEGORIES_REPLIES,
	UNITY_GWIBBER_CATEGORIES_IMAGES,
	UNITY_GWIBBER_CATEGORIES_VIDEOS,
	UNITY_GWIBBER_CATEGORIES_LINKS,
	UNITY_GWIBBER_CATEGORIES_PRIVATE,
	UNITY_GWIBBER_CATEGORIES_PUBLIC
} UnityGwibberCategories;

struct _UnityGwibberDaemonUpdateGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityGwibberDaemon* self;
	UnityLensSearch* search;
	GCancellable* cancellable;
	UnityScope* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* results_model;
	UnityLensSearch* _tmp4_;
	gboolean _tmp5_;
	UnityLensSearch* _tmp6_;
	DeeSerializableModel* _tmp7_;
	UnityLensSearch* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	UnityLensSearch* _tmp11_;
};

struct _UnityGwibberDaemonUpdateScopeSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityGwibberDaemon* self;
	UnityLensSearch* search;
	GCancellable* cancellable;
	UnityLensSearch* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSerializableModel* results_model;
	UnityLensSearch* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	guint _tmp7_;
	UnityLensSearch* _tmp8_;
};


static gpointer unity_gwibber_daemon_parent_class = NULL;

#define UNITY_GWIBBER_BUS_NAME "com.canonical.Unity.Lens.Gwibber"
GType unity_gwibber_daemon_get_type (void) G_GNUC_CONST;
#define UNITY_GWIBBER_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonPrivate))
enum  {
	UNITY_GWIBBER_DAEMON_DUMMY_PROPERTY
};
static void unity_gwibber_daemon_populate_filters (UnityGwibberDaemon* self);
static UnityCheckOptionFilter* unity_gwibber_daemon_create_account_filter (UnityGwibberDaemon* self);
static void __lambda2_ (UnityGwibberDaemon* self, GwibberAccount* source);
static void ___lambda2__gwibber_accounts_created (GwibberAccounts* _sender, GwibberAccount* account, gpointer self);
static void __lambda3_ (UnityGwibberDaemon* self);
static void ___lambda3__gwibber_accounts_deleted (GwibberAccounts* _sender, const gchar* id, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void unity_gwibber_daemon_populate_categories (UnityGwibberDaemon* self);
static gboolean unity_gwibber_daemon_is_empty_search (UnityGwibberDaemon* self, UnityLensSearch* search);
static void unity_gwibber_daemon_update_global_search_data_free (gpointer _data);
static void unity_gwibber_daemon_update_global_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_gwibber_daemon_update_global_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_);
static gboolean unity_gwibber_daemon_update_global_search_co (UnityGwibberDaemonUpdateGlobalSearchData* _data_);
GType unity_gwibber_categories_get_type (void) G_GNUC_CONST;
static void unity_gwibber_daemon_update_results_model (UnityGwibberDaemon* self, DeeModel* results_model, const gchar* search, UnityGwibberCategories* category);
static void unity_gwibber_daemon_update_scope_search_data_free (gpointer _data);
static void unity_gwibber_daemon_update_scope_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_gwibber_daemon_update_scope_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_);
static gboolean unity_gwibber_daemon_update_scope_search_co (UnityGwibberDaemonUpdateScopeSearchData* _data_);
static gint _____lambda4_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b);
static gint ______lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint __lambda5_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b);
static gint ___lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean unity_gwibber_daemon_matches_filters (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, GeeList* stream_ids, GeeList* account_ids);
static void unity_gwibber_daemon_add_result (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, DeeModel* results_model);
static gchar** _variant_get1 (GVariant* value, int* result_length1);
UnityGwibberDaemon* unity_gwibber_daemon_new (void);
UnityGwibberDaemon* unity_gwibber_daemon_construct (GType object_type);
static GObject * unity_gwibber_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_gwibber_daemon___lambda6_ (UnityGwibberDaemon* self);
static void __unity_gwibber_daemon___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gchar* _unity_gwibber_daemon___lambda7_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search);
static gchar* __unity_gwibber_daemon___lambda7__unity_scope_generate_search_key (UnityScope* _sender, UnityLensSearch* search, gpointer self);
static void _unity_gwibber_daemon___lambda8_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable);
static void __unity_gwibber_daemon___lambda8__unity_scope_search_changed (UnityScope* _sender, UnityLensSearch* search, UnitySearchType search_type, GCancellable* cancellable, gpointer self);
static void _unity_gwibber_daemon___lambda9_ (UnityGwibberDaemon* self, GObject* obj, GParamSpec* pspec);
static void __unity_gwibber_daemon___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_gwibber_daemon___lambda10_ (UnityGwibberDaemon* self);
static void __unity_gwibber_daemon___lambda10__unity_scope_filters_changed (UnityScope* _sender, gpointer self);
static void _unity_gwibber_daemon___lambda11_ (UnityGwibberDaemon* self, DeeTermList* terms_in, DeeTermList* terms_out);
static void __unity_gwibber_daemon___lambda11__dee_term_filter_func (DeeTermList* terms_in, DeeTermList* terms_out, gpointer self);
static gchar* _unity_gwibber_daemon___lambda12_ (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter);
static gchar* __unity_gwibber_daemon___lambda12__dee_model_reader_func (DeeModel* model, DeeModelIter* iter, gpointer self);
static void unity_gwibber_daemon_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda2_ (UnityGwibberDaemon* self, GwibberAccount* source) {
	g_return_if_fail (source != NULL);
}


static void ___lambda2__gwibber_accounts_created (GwibberAccounts* _sender, GwibberAccount* account, gpointer self) {
	__lambda2_ (self, account);
}


static void __lambda3_ (UnityGwibberDaemon* self) {
}


static void ___lambda3__gwibber_accounts_deleted (GwibberAccounts* _sender, const gchar* id, gpointer self) {
	__lambda3_ (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void unity_gwibber_daemon_populate_filters (UnityGwibberDaemon* self) {
	GList* filters;
	UnityLens* _tmp26_;
	GwibberAccounts* _tmp27_;
	GwibberAccounts* _tmp28_;
	g_return_if_fail (self != NULL);
	filters = NULL;
	{
		const gchar* _tmp0_ = NULL;
		UnityCheckOptionFilter* _tmp1_;
		UnityCheckOptionFilter* filter;
		const gchar* _tmp2_ = NULL;
		UnityFilterOption* _tmp3_ = NULL;
		UnityFilterOption* _tmp4_;
		const gchar* _tmp5_ = NULL;
		UnityFilterOption* _tmp6_ = NULL;
		UnityFilterOption* _tmp7_;
		const gchar* _tmp8_ = NULL;
		UnityFilterOption* _tmp9_ = NULL;
		UnityFilterOption* _tmp10_;
		const gchar* _tmp11_ = NULL;
		UnityFilterOption* _tmp12_ = NULL;
		UnityFilterOption* _tmp13_;
		const gchar* _tmp14_ = NULL;
		UnityFilterOption* _tmp15_ = NULL;
		UnityFilterOption* _tmp16_;
		const gchar* _tmp17_ = NULL;
		UnityFilterOption* _tmp18_ = NULL;
		UnityFilterOption* _tmp19_;
		const gchar* _tmp20_ = NULL;
		UnityFilterOption* _tmp21_ = NULL;
		UnityFilterOption* _tmp22_;
		UnityFilter* _tmp23_;
		_tmp0_ = _ ("Stream");
		_tmp1_ = unity_check_option_filter_new ("stream", _tmp0_, NULL, FALSE);
		filter = _tmp1_;
		_tmp2_ = _ ("Messages");
		_tmp3_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "messages", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		_tmp5_ = _ ("Replies");
		_tmp6_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "replies", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		_tmp8_ = _ ("Images");
		_tmp9_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "images", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = _ ("Videos");
		_tmp12_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "videos", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		_tmp14_ = _ ("Links");
		_tmp15_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "links", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
		_tmp17_ = _ ("Private");
		_tmp18_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "private", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		_tmp20_ = _ ("Public");
		_tmp21_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "public", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
		_tmp23_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp23_);
		_g_object_unref0 (filter);
	}
	{
		UnityCheckOptionFilter* _tmp24_ = NULL;
		UnityCheckOptionFilter* filter;
		UnityFilter* _tmp25_;
		_tmp24_ = unity_gwibber_daemon_create_account_filter (self);
		filter = _tmp24_;
		_tmp25_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp25_);
		_g_object_unref0 (filter);
	}
	_tmp26_ = self->priv->lens;
	unity_lens_set_filters (_tmp26_, filters);
	_tmp27_ = self->priv->accounts;
	g_signal_connect_object (_tmp27_, "created", (GCallback) ___lambda2__gwibber_accounts_created, self, 0);
	_tmp28_ = self->priv->accounts;
	g_signal_connect_object (_tmp28_, "deleted", (GCallback) ___lambda3__gwibber_accounts_deleted, self, 0);
	__g_list_free__g_object_unref0_0 (filters);
}


static UnityCheckOptionFilter* unity_gwibber_daemon_create_account_filter (UnityGwibberDaemon* self) {
	UnityCheckOptionFilter* result = NULL;
	GIcon* icon = NULL;
	GFile* icon_file = NULL;
	const gchar* _tmp0_ = NULL;
	UnityCheckOptionFilter* _tmp1_;
	UnityCheckOptionFilter* filter;
	GwibberAccounts* _tmp2_;
	GList* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Account");
	_tmp1_ = unity_check_option_filter_new ("account_id", _tmp0_, NULL, FALSE);
	filter = _tmp1_;
	_tmp2_ = self->priv->accounts;
	_tmp3_ = gwibber_accounts_list (_tmp2_);
	{
		GList* _acct_collection = NULL;
		GList* _acct_it = NULL;
		_acct_collection = _tmp3_;
		for (_acct_it = _acct_collection; _acct_it != NULL; _acct_it = _acct_it->next) {
			GwibberAccount* _tmp4_;
			GwibberAccount* _acct = NULL;
			_tmp4_ = _g_object_ref0 ((GwibberAccount*) _acct_it->data);
			_acct = _tmp4_;
			{
				GwibberAccount* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GwibberAccount* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				GFile* _tmp21_ = NULL;
				GFile* _tmp22_;
				GFileIcon* _tmp23_;
				GwibberAccount* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp5_ = _acct;
				_tmp6_ = gwibber_account_get_service (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (PKGDATADIR "/plugins/", _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strconcat (_tmp9_, "/ui/icons/16x16/", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = _acct;
				_tmp13_ = gwibber_account_get_service (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp16_, ".png", NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_build_filename (_tmp18_, NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_file_new_for_path (_tmp20_);
				_g_object_unref0 (icon_file);
				icon_file = _tmp21_;
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				_tmp22_ = icon_file;
				_tmp23_ = (GFileIcon*) g_file_icon_new (_tmp22_);
				_g_object_unref0 (icon);
				icon = (GIcon*) _tmp23_;
				_tmp24_ = _acct;
				_tmp25_ = gwibber_account_get_name (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_ != NULL) {
					UnityCheckOptionFilter* _tmp27_;
					GwibberAccount* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					GwibberAccount* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					GIcon* _tmp34_;
					UnityFilterOption* _tmp35_ = NULL;
					UnityFilterOption* _tmp36_;
					_tmp27_ = filter;
					_tmp28_ = _acct;
					_tmp29_ = gwibber_account_get_id (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = _acct;
					_tmp32_ = gwibber_account_get_name (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = icon;
					_tmp35_ = unity_options_filter_add_option ((UnityOptionsFilter*) _tmp27_, _tmp30_, _tmp33_, _tmp34_);
					_tmp36_ = _tmp35_;
					_g_object_unref0 (_tmp36_);
				} else {
					UnityCheckOptionFilter* _tmp37_;
					GwibberAccount* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					GwibberAccount* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					GwibberAccount* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					GIcon* _tmp51_;
					UnityFilterOption* _tmp52_ = NULL;
					UnityFilterOption* _tmp53_;
					_tmp37_ = filter;
					_tmp38_ = _acct;
					_tmp39_ = gwibber_account_get_id (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = _acct;
					_tmp42_ = gwibber_account_get_service (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strconcat (_tmp43_, "/", NULL);
					_tmp45_ = _tmp44_;
					_tmp46_ = _acct;
					_tmp47_ = gwibber_account_get_username (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strconcat (_tmp45_, _tmp48_, NULL);
					_tmp50_ = _tmp49_;
					_tmp51_ = icon;
					_tmp52_ = unity_options_filter_add_option ((UnityOptionsFilter*) _tmp37_, _tmp40_, _tmp50_, _tmp51_);
					_tmp53_ = _tmp52_;
					_g_object_unref0 (_tmp53_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp45_);
				}
				_g_object_unref0 (_acct);
			}
		}
		__g_list_free__g_object_unref0_0 (_acct_collection);
	}
	result = filter;
	_g_object_unref0 (icon_file);
	_g_object_unref0 (icon);
	return result;
}


static void unity_gwibber_daemon_populate_categories (UnityGwibberDaemon* self) {
	GList* categories;
	GIcon* icon = NULL;
	GThemedIcon* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GIcon* _tmp2_;
	UnityCategory* _tmp3_;
	UnityCategory* cat;
	UnityCategory* _tmp4_;
	UnityCategory* _tmp5_;
	GThemedIcon* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GIcon* _tmp8_;
	UnityCategory* _tmp9_;
	UnityCategory* _tmp10_;
	UnityCategory* _tmp11_;
	GThemedIcon* _tmp12_;
	const gchar* _tmp13_ = NULL;
	GIcon* _tmp14_;
	UnityCategory* _tmp15_;
	UnityCategory* _tmp16_;
	UnityCategory* _tmp17_;
	GThemedIcon* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GIcon* _tmp20_;
	UnityCategory* _tmp21_;
	UnityCategory* _tmp22_;
	UnityCategory* _tmp23_;
	GThemedIcon* _tmp24_;
	const gchar* _tmp25_ = NULL;
	GIcon* _tmp26_;
	UnityCategory* _tmp27_;
	UnityCategory* _tmp28_;
	UnityCategory* _tmp29_;
	GThemedIcon* _tmp30_;
	const gchar* _tmp31_ = NULL;
	GIcon* _tmp32_;
	UnityCategory* _tmp33_;
	UnityCategory* _tmp34_;
	UnityCategory* _tmp35_;
	GThemedIcon* _tmp36_;
	const gchar* _tmp37_ = NULL;
	GIcon* _tmp38_;
	UnityCategory* _tmp39_;
	UnityCategory* _tmp40_;
	UnityCategory* _tmp41_;
	UnityLens* _tmp42_;
	g_return_if_fail (self != NULL);
	categories = NULL;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("tray-message");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp0_;
	_tmp1_ = _ ("Messages");
	_tmp2_ = icon;
	_tmp3_ = unity_category_new (_tmp1_, _tmp2_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	cat = _tmp3_;
	_tmp4_ = cat;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	categories = g_list_append (categories, _tmp5_);
	_tmp6_ = (GThemedIcon*) g_themed_icon_new ("mail_reply");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp6_;
	_tmp7_ = _ ("Replies");
	_tmp8_ = icon;
	_tmp9_ = unity_category_new (_tmp7_, _tmp8_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp9_;
	_tmp10_ = cat;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	categories = g_list_append (categories, _tmp11_);
	_tmp12_ = (GThemedIcon*) g_themed_icon_new ("gnome-mime-image");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp12_;
	_tmp13_ = _ ("Images");
	_tmp14_ = icon;
	_tmp15_ = unity_category_new (_tmp13_, _tmp14_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp15_;
	_tmp16_ = cat;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	categories = g_list_append (categories, _tmp17_);
	_tmp18_ = (GThemedIcon*) g_themed_icon_new ("video");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp18_;
	_tmp19_ = _ ("Videos");
	_tmp20_ = icon;
	_tmp21_ = unity_category_new (_tmp19_, _tmp20_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp21_;
	_tmp22_ = cat;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	categories = g_list_append (categories, _tmp23_);
	_tmp24_ = (GThemedIcon*) g_themed_icon_new ("web-browser");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp24_;
	_tmp25_ = _ ("Links");
	_tmp26_ = icon;
	_tmp27_ = unity_category_new (_tmp25_, _tmp26_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp27_;
	_tmp28_ = cat;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	categories = g_list_append (categories, _tmp29_);
	_tmp30_ = (GThemedIcon*) g_themed_icon_new ("mail-send-receive");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp30_;
	_tmp31_ = _ ("Private");
	_tmp32_ = icon;
	_tmp33_ = unity_category_new (_tmp31_, _tmp32_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp33_;
	_tmp34_ = cat;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	categories = g_list_append (categories, _tmp35_);
	_tmp36_ = (GThemedIcon*) g_themed_icon_new ("evolution");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp36_;
	_tmp37_ = _ ("Public");
	_tmp38_ = icon;
	_tmp39_ = unity_category_new (_tmp37_, _tmp38_, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp39_;
	_tmp40_ = cat;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	categories = g_list_append (categories, _tmp41_);
	_tmp42_ = self->priv->lens;
	unity_lens_set_categories (_tmp42_, categories);
	_g_object_unref0 (cat);
	_g_object_unref0 (icon);
	__g_list_free__g_object_unref0_0 (categories);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean unity_gwibber_daemon_is_empty_search (UnityGwibberDaemon* self, UnityLensSearch* search) {
	gboolean result = FALSE;
	UnityLensSearch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (search != NULL, FALSE);
	_tmp0_ = search;
	_tmp1_ = unity_lens_search_get_search_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static void unity_gwibber_daemon_update_global_search_data_free (gpointer _data) {
	UnityGwibberDaemonUpdateGlobalSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityGwibberDaemonUpdateGlobalSearchData, _data_);
}


static void unity_gwibber_daemon_update_global_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityGwibberDaemonUpdateGlobalSearchData* _data_;
	UnityGwibberDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityGwibberDaemonUpdateGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_gwibber_daemon_update_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_gwibber_daemon_update_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_gwibber_daemon_update_global_search_co (_data_);
}


static void unity_gwibber_daemon_update_global_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_) {
	UnityGwibberDaemonUpdateGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_gwibber_daemon_update_global_search_co (UnityGwibberDaemonUpdateGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->scope;
	_data_->_tmp1_ = unity_scope_get_global_results_model (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->results_model = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->search;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = unity_gwibber_daemon_is_empty_search (_data_->self, _data_->_tmp4_);
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = _data_->search;
		g_signal_emit_by_name (_data_->_tmp6_, "finished");
		_g_object_unref0 (_data_->results_model);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->results_model;
	_data_->_tmp8_ = _data_->search;
	_data_->_tmp9_ = unity_lens_search_get_search_string (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	unity_gwibber_daemon_update_results_model (_data_->self, (DeeModel*) _data_->_tmp7_, _data_->_tmp10_, NULL);
	_data_->_tmp11_ = _data_->search;
	g_signal_emit_by_name (_data_->_tmp11_, "finished");
	_g_object_unref0 (_data_->results_model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_gwibber_daemon_update_scope_search_data_free (gpointer _data) {
	UnityGwibberDaemonUpdateScopeSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityGwibberDaemonUpdateScopeSearchData, _data_);
}


static void unity_gwibber_daemon_update_scope_search (UnityGwibberDaemon* self, UnityLensSearch* search, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityGwibberDaemonUpdateScopeSearchData* _data_;
	UnityGwibberDaemon* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (UnityGwibberDaemonUpdateScopeSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_gwibber_daemon_update_scope_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_gwibber_daemon_update_scope_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->cancellable = _tmp4_;
	unity_gwibber_daemon_update_scope_search_co (_data_);
}


static void unity_gwibber_daemon_update_scope_search_finish (UnityGwibberDaemon* self, GAsyncResult* _res_) {
	UnityGwibberDaemonUpdateScopeSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_gwibber_daemon_update_scope_search_co (UnityGwibberDaemonUpdateScopeSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->search;
	_data_->_tmp1_ = unity_lens_search_get_results_model (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->results_model = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->search;
	_data_->_tmp5_ = unity_lens_search_get_search_string (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	unity_gwibber_daemon_update_results_model (_data_->self, (DeeModel*) _data_->results_model, _data_->_tmp6_, NULL);
	_data_->_tmp7_ = 0U;
	_data_->_tmp7_ = dee_model_get_n_rows ((DeeModel*) _data_->results_model);
	g_message ("daemon.vala:276: %u results", _data_->_tmp7_);
	_data_->_tmp8_ = _data_->search;
	g_signal_emit_by_name (_data_->_tmp8_, "finished");
	_g_object_unref0 (_data_->results_model);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint _____lambda4_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b) {
	gint result = 0;
	gint _tmp0_ = 0;
	DeeModelIter* _tmp1_;
	DeeModelIter* _tmp2_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = a;
	_tmp2_ = b;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = 0;
	} else {
		gint _tmp3_ = 0;
		DeeModelIter* _tmp4_;
		DeeModelIter* _tmp5_;
		gint _tmp6_;
		_tmp4_ = a;
		_tmp5_ = b;
		if (((void*) _tmp4_) > ((void*) _tmp5_)) {
			_tmp3_ = 1;
		} else {
			_tmp3_ = -1;
		}
		_tmp6_ = _tmp3_;
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


static gint ______lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = _____lambda4_ (self, a, b);
	return result;
}


static gint __lambda5_ (UnityGwibberDaemon* self, DeeModelIter* a, DeeModelIter* b) {
	gint result = 0;
	GwibberStreamModelColumn col;
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	DeeModel* _tmp3_;
	DeeModelIter* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	col = GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP;
	_tmp0_ = self->priv->_model;
	_tmp1_ = b;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) col);
	_tmp3_ = self->priv->_model;
	_tmp4_ = a;
	_tmp5_ = dee_model_get_string (_tmp3_, _tmp4_, (guint) col);
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
	result = _tmp6_;
	return result;
}


static gint ___lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda5_ (self, a, b);
	return result;
}


static void unity_gwibber_daemon_update_results_model (UnityGwibberDaemon* self, DeeModel* results_model, const gchar* search, UnityGwibberCategories* category) {
	DeeModelIter* iter = NULL;
	DeeModelIter* end = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* stream_ids;
	UnityScope* _tmp1_;
	UnityFilter* _tmp2_ = NULL;
	UnityCheckOptionFilter* filter;
	UnityCheckOptionFilter* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GeeArrayList* _tmp16_;
	GeeArrayList* account_ids;
	UnityScope* _tmp17_;
	UnityFilter* _tmp18_ = NULL;
	UnityCheckOptionFilter* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	DeeModel* _tmp32_;
	DeeModel* _tmp33_;
	DeeModelIter* _tmp34_ = NULL;
	DeeModel* _tmp35_;
	DeeModelIter* _tmp36_ = NULL;
	DeeModel* _tmp37_;
	DeeModelIter* _tmp38_ = NULL;
	DeeModelIter* _tmp39_;
	GObject* _tmp40_ = NULL;
	GObject* _tmp41_;
	DeeTermList* term_list;
	DeeAnalyzer* _tmp42_;
	DeeICUTermFilter* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	DeeTermList* _tmp47_;
	GSequence* _tmp48_;
	GSequence* matches;
	GSequence* _tmp86_;
	GSequence* _tmp87_;
	GSequenceIter* _tmp88_ = NULL;
	GSequenceIter* match_iter;
	GSequence* _tmp89_;
	GSequenceIter* _tmp90_ = NULL;
	GSequenceIter* match_end_iter;
	DeeTermList* _tmp105_;
	guint _tmp106_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	stream_ids = _tmp0_;
	_tmp1_ = self->priv->scope;
	_tmp2_ = unity_scope_get_filter (_tmp1_, "stream");
	filter = UNITY_IS_CHECK_OPTION_FILTER (_tmp2_) ? ((UnityCheckOptionFilter*) _tmp2_) : NULL;
	_tmp3_ = filter;
	_tmp4_ = unity_filter_get_filtering ((UnityFilter*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		UnityCheckOptionFilter* _tmp6_;
		GList* _tmp7_;
		_tmp6_ = filter;
		_tmp7_ = ((UnityOptionsFilter*) _tmp6_)->options;
		{
			GList* option_collection = NULL;
			GList* option_it = NULL;
			option_collection = _tmp7_;
			for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
				UnityFilterOption* _tmp8_;
				UnityFilterOption* option = NULL;
				_tmp8_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
				option = _tmp8_;
				{
					UnityFilterOption* _tmp9_;
					gboolean _tmp10_;
					gboolean _tmp11_;
					_tmp9_ = option;
					_tmp10_ = unity_filter_option_get_active (_tmp9_);
					_tmp11_ = _tmp10_;
					if (_tmp11_) {
						GeeArrayList* _tmp12_;
						UnityFilterOption* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						_tmp12_ = stream_ids;
						_tmp13_ = option;
						_tmp14_ = unity_filter_option_get_id (_tmp13_);
						_tmp15_ = _tmp14_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp15_);
					}
					_g_object_unref0 (option);
				}
			}
		}
	}
	_tmp16_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	account_ids = _tmp16_;
	_tmp17_ = self->priv->scope;
	_tmp18_ = unity_scope_get_filter (_tmp17_, "account_id");
	_g_object_unref0 (filter);
	filter = UNITY_IS_CHECK_OPTION_FILTER (_tmp18_) ? ((UnityCheckOptionFilter*) _tmp18_) : NULL;
	_tmp19_ = filter;
	_tmp20_ = unity_filter_get_filtering ((UnityFilter*) _tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		UnityCheckOptionFilter* _tmp22_;
		GList* _tmp23_;
		_tmp22_ = filter;
		_tmp23_ = ((UnityOptionsFilter*) _tmp22_)->options;
		{
			GList* option_collection = NULL;
			GList* option_it = NULL;
			option_collection = _tmp23_;
			for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
				UnityFilterOption* _tmp24_;
				UnityFilterOption* option = NULL;
				_tmp24_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
				option = _tmp24_;
				{
					UnityFilterOption* _tmp25_;
					gboolean _tmp26_;
					gboolean _tmp27_;
					_tmp25_ = option;
					_tmp26_ = unity_filter_option_get_active (_tmp25_);
					_tmp27_ = _tmp26_;
					if (_tmp27_) {
						GeeArrayList* _tmp28_;
						UnityFilterOption* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						_tmp28_ = account_ids;
						_tmp29_ = option;
						_tmp30_ = unity_filter_option_get_id (_tmp29_);
						_tmp31_ = _tmp30_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp31_);
					}
					_g_object_unref0 (option);
				}
			}
		}
	}
	_tmp32_ = results_model;
	dee_model_clear (_tmp32_);
	_tmp33_ = self->priv->_model;
	_tmp34_ = dee_model_get_first_iter (_tmp33_);
	iter = _tmp34_;
	_tmp35_ = self->priv->_model;
	_tmp36_ = dee_model_get_last_iter (_tmp35_);
	end = _tmp36_;
	_tmp37_ = self->priv->_model;
	_tmp38_ = dee_model_get_first_iter (_tmp37_);
	self->priv->_stream_iter_first = _tmp38_;
	_tmp39_ = end;
	self->priv->_stream_iter_last = _tmp39_;
	_tmp40_ = g_object_new (dee_term_list_get_type (), NULL);
	_tmp41_ = G_IS_INITIALLY_UNOWNED (_tmp40_) ? g_object_ref_sink (_tmp40_) : _tmp40_;
	term_list = DEE_IS_TERM_LIST (_tmp41_) ? ((DeeTermList*) _tmp41_) : NULL;
	_tmp42_ = self->priv->_analyzer;
	_tmp43_ = self->priv->_ascii_filter;
	_tmp44_ = search;
	_tmp45_ = dee_icu_term_filter_apply (_tmp43_, _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = term_list;
	dee_analyzer_tokenize (_tmp42_, _tmp46_, _tmp47_);
	_g_free0 (_tmp46_);
	_tmp48_ = g_sequence_new (NULL);
	matches = _tmp48_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp49_;
			_tmp49_ = TRUE;
			while (TRUE) {
				gboolean _tmp50_;
				guint _tmp52_;
				DeeTermList* _tmp53_;
				guint _tmp54_ = 0U;
				DeeIndex* _tmp55_;
				DeeTermList* _tmp56_;
				guint _tmp57_;
				const gchar* _tmp58_ = NULL;
				DeeResultSet* _tmp59_ = NULL;
				DeeResultSet* result_set;
				guint _tmp60_;
				gboolean first_pass;
				GCompareDataFunc cmp_func;
				void* cmp_func_target;
				GDestroyNotify cmp_func_target_destroy_notify;
				GSequence* _tmp61_;
				GSequence* remaining;
				gboolean _tmp80_;
				GSequence* _tmp82_;
				GSequenceIter* _tmp83_ = NULL;
				GSequence* _tmp84_;
				GSequenceIter* _tmp85_ = NULL;
				_tmp50_ = _tmp49_;
				if (!_tmp50_) {
					guint _tmp51_;
					_tmp51_ = i;
					i = _tmp51_ + 1;
				}
				_tmp49_ = FALSE;
				_tmp52_ = i;
				_tmp53_ = term_list;
				_tmp54_ = dee_term_list_num_terms (_tmp53_);
				if (!(_tmp52_ < _tmp54_)) {
					break;
				}
				_tmp55_ = self->priv->_index;
				_tmp56_ = term_list;
				_tmp57_ = i;
				_tmp58_ = dee_term_list_get_term (_tmp56_, _tmp57_);
				_tmp59_ = dee_index_lookup (_tmp55_, _tmp58_, DEE_TERM_MATCH_PREFIX);
				result_set = _tmp59_;
				_tmp60_ = i;
				first_pass = _tmp60_ == ((guint) 0);
				cmp_func = ______lambda4__gcompare_data_func;
				cmp_func_target = g_object_ref (self);
				cmp_func_target_destroy_notify = g_object_unref;
				_tmp61_ = g_sequence_new (NULL);
				remaining = _tmp61_;
				{
					DeeResultSet* _tmp62_;
					DeeResultSet* _tmp63_ = NULL;
					DeeResultSet* _item_it;
					DeeModelIter* item = NULL;
					_tmp62_ = result_set;
					_tmp63_ = _vala_dee_result_set_iterator (_tmp62_);
					_item_it = _tmp63_;
					while (TRUE) {
						DeeResultSet* _tmp64_;
						DeeModelIter* _tmp65_ = NULL;
						DeeModelIter* _tmp66_;
						gboolean _tmp67_;
						_tmp64_ = _item_it;
						_tmp65_ = _vala_dee_result_set_next_value (_tmp64_);
						item = _tmp65_;
						_tmp66_ = item;
						if (!(_tmp66_ != NULL)) {
							break;
						}
						_tmp67_ = first_pass;
						if (_tmp67_) {
							GSequence* _tmp68_;
							DeeModelIter* _tmp69_;
							GCompareDataFunc _tmp70_;
							void* _tmp70__target;
							GSequenceIter* _tmp71_ = NULL;
							_tmp68_ = matches;
							_tmp69_ = item;
							_tmp70_ = cmp_func;
							_tmp70__target = cmp_func_target;
							_tmp71_ = g_sequence_insert_sorted (_tmp68_, _tmp69_, _tmp70_, _tmp70__target);
						} else {
							GSequence* _tmp72_;
							DeeModelIter* _tmp73_;
							GCompareDataFunc _tmp74_;
							void* _tmp74__target;
							GSequenceIter* _tmp75_ = NULL;
							_tmp72_ = matches;
							_tmp73_ = item;
							_tmp74_ = cmp_func;
							_tmp74__target = cmp_func_target;
							_tmp75_ = g_sequence_lookup (_tmp72_, _tmp73_, _tmp74_, _tmp74__target);
							if (_tmp75_ != NULL) {
								GSequence* _tmp76_;
								DeeModelIter* _tmp77_;
								GCompareDataFunc _tmp78_;
								void* _tmp78__target;
								GSequenceIter* _tmp79_ = NULL;
								_tmp76_ = remaining;
								_tmp77_ = item;
								_tmp78_ = cmp_func;
								_tmp78__target = cmp_func_target;
								_tmp79_ = g_sequence_insert_sorted (_tmp76_, _tmp77_, _tmp78_, _tmp78__target);
							}
						}
					}
					_g_object_unref0 (_item_it);
				}
				_tmp80_ = first_pass;
				if (!_tmp80_) {
					GSequence* _tmp81_;
					_tmp81_ = remaining;
					remaining = NULL;
					_g_sequence_free0 (matches);
					matches = _tmp81_;
				}
				_tmp82_ = matches;
				_tmp83_ = g_sequence_get_begin_iter (_tmp82_);
				_tmp84_ = matches;
				_tmp85_ = g_sequence_get_end_iter (_tmp84_);
				if (_tmp83_ == _tmp85_) {
					_g_sequence_free0 (remaining);
					(cmp_func_target_destroy_notify == NULL) ? NULL : (cmp_func_target_destroy_notify (cmp_func_target), NULL);
					cmp_func = NULL;
					cmp_func_target = NULL;
					cmp_func_target_destroy_notify = NULL;
					_g_object_unref0 (result_set);
					break;
				}
				_g_sequence_free0 (remaining);
				(cmp_func_target_destroy_notify == NULL) ? NULL : (cmp_func_target_destroy_notify (cmp_func_target), NULL);
				cmp_func = NULL;
				cmp_func_target = NULL;
				cmp_func_target_destroy_notify = NULL;
				_g_object_unref0 (result_set);
			}
		}
	}
	_tmp86_ = matches;
	g_sequence_sort (_tmp86_, ___lambda5__gcompare_data_func, self);
	_tmp87_ = matches;
	_tmp88_ = g_sequence_get_begin_iter (_tmp87_);
	match_iter = _tmp88_;
	_tmp89_ = matches;
	_tmp90_ = g_sequence_get_end_iter (_tmp89_);
	match_end_iter = _tmp90_;
	while (TRUE) {
		GSequenceIter* _tmp91_;
		GSequenceIter* _tmp92_;
		GSequenceIter* _tmp93_;
		gconstpointer _tmp94_ = NULL;
		DeeModel* _tmp95_;
		DeeModelIter* _tmp96_;
		GeeArrayList* _tmp97_;
		GeeArrayList* _tmp98_;
		gboolean _tmp99_ = FALSE;
		GSequenceIter* _tmp103_;
		GSequenceIter* _tmp104_ = NULL;
		_tmp91_ = match_iter;
		_tmp92_ = match_end_iter;
		if (!(_tmp91_ != _tmp92_)) {
			break;
		}
		_tmp93_ = match_iter;
		_tmp94_ = g_sequence_get (_tmp93_);
		iter = (DeeModelIter*) _tmp94_;
		_tmp95_ = self->priv->_model;
		_tmp96_ = iter;
		_tmp97_ = stream_ids;
		_tmp98_ = account_ids;
		_tmp99_ = unity_gwibber_daemon_matches_filters (self, _tmp95_, _tmp96_, (GeeList*) _tmp97_, (GeeList*) _tmp98_);
		if (_tmp99_) {
			DeeModel* _tmp100_;
			DeeModelIter* _tmp101_;
			DeeModel* _tmp102_;
			_tmp100_ = self->priv->_model;
			_tmp101_ = iter;
			_tmp102_ = results_model;
			unity_gwibber_daemon_add_result (self, _tmp100_, _tmp101_, _tmp102_);
		}
		_tmp103_ = match_iter;
		_tmp104_ = g_sequence_iter_next (_tmp103_);
		match_iter = _tmp104_;
	}
	_tmp105_ = term_list;
	_tmp106_ = dee_term_list_num_terms (_tmp105_);
	if (_tmp106_ > ((guint) 0)) {
		_g_sequence_free0 (matches);
		_g_object_unref0 (term_list);
		_g_object_unref0 (account_ids);
		_g_object_unref0 (filter);
		_g_object_unref0 (stream_ids);
		return;
	}
	while (TRUE) {
		DeeModelIter* _tmp107_;
		DeeModelIter* _tmp108_;
		DeeModel* _tmp109_;
		DeeModelIter* _tmp110_;
		GeeArrayList* _tmp111_;
		GeeArrayList* _tmp112_;
		gboolean _tmp113_ = FALSE;
		DeeModel* _tmp117_;
		DeeModelIter* _tmp118_;
		DeeModelIter* _tmp119_ = NULL;
		_tmp107_ = iter;
		_tmp108_ = end;
		if (!(_tmp107_ != _tmp108_)) {
			break;
		}
		_tmp109_ = self->priv->_model;
		_tmp110_ = iter;
		_tmp111_ = stream_ids;
		_tmp112_ = account_ids;
		_tmp113_ = unity_gwibber_daemon_matches_filters (self, _tmp109_, _tmp110_, (GeeList*) _tmp111_, (GeeList*) _tmp112_);
		if (_tmp113_) {
			DeeModel* _tmp114_;
			DeeModelIter* _tmp115_;
			DeeModel* _tmp116_;
			_tmp114_ = self->priv->_model;
			_tmp115_ = iter;
			_tmp116_ = results_model;
			unity_gwibber_daemon_add_result (self, _tmp114_, _tmp115_, _tmp116_);
		}
		_tmp117_ = self->priv->_model;
		_tmp118_ = iter;
		_tmp119_ = dee_model_next (_tmp117_, _tmp118_);
		iter = _tmp119_;
	}
	_g_sequence_free0 (matches);
	_g_object_unref0 (term_list);
	_g_object_unref0 (account_ids);
	_g_object_unref0 (filter);
	_g_object_unref0 (stream_ids);
}


static gchar** _variant_get1 (GVariant* value, int* result_length1) {
	gchar** _tmp16_;
	int _tmp16__length;
	int _tmp16__size;
	int _tmp16__length1;
	GVariantIter _tmp17_;
	GVariant* _tmp18_;
	_tmp16_ = g_new (gchar*, 5);
	_tmp16__length = 0;
	_tmp16__size = 4;
	_tmp16__length1 = 0;
	g_variant_iter_init (&_tmp17_, value);
	for (; (_tmp18_ = g_variant_iter_next_value (&_tmp17_)) != NULL; _tmp16__length1++) {
		if (_tmp16__size == _tmp16__length) {
			_tmp16__size = 2 * _tmp16__size;
			_tmp16_ = g_renew (gchar*, _tmp16_, _tmp16__size + 1);
		}
		_tmp16_[_tmp16__length++] = g_variant_dup_string (_tmp18_, NULL);
		g_variant_unref (_tmp18_);
	}
	*result_length1 = _tmp16__length1;
	_tmp16_[_tmp16__length] = NULL;
	return _tmp16_;
}


static gboolean unity_gwibber_daemon_matches_filters (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, GeeList* stream_ids, GeeList* account_ids) {
	gboolean result = FALSE;
	gboolean stream_match;
	gboolean account_match;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp35_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	g_return_val_if_fail (stream_ids != NULL, FALSE);
	g_return_val_if_fail (account_ids != NULL, FALSE);
	stream_match = TRUE;
	account_match = TRUE;
	_tmp0_ = stream_ids;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeList* _tmp3_;
		DeeModel* _tmp4_;
		DeeModelIter* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = stream_ids;
		_tmp4_ = model;
		_tmp5_ = iter;
		_tmp6_ = dee_model_get_string (_tmp4_, _tmp5_, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
		_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
		stream_match = _tmp7_;
	}
	_tmp8_ = account_ids;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		DeeModel* _tmp11_;
		DeeModelIter* _tmp12_;
		GVariant* _tmp13_ = NULL;
		GVariant* _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _accounts_array;
		gint _accounts_array_length1;
		gint __accounts_array_size_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		_tmp11_ = model;
		_tmp12_ = iter;
		_tmp13_ = dee_model_get_value (_tmp11_, _tmp12_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS);
		_tmp14_ = _tmp13_;
		_tmp15_ = _variant_get1 (_tmp14_, &_tmp15__length1);
		_tmp19_ = _tmp15_;
		_tmp19__length1 = _tmp15__length1;
		_g_variant_unref0 (_tmp14_);
		_accounts_array = _tmp19_;
		_accounts_array_length1 = _tmp19__length1;
		__accounts_array_size_ = _accounts_array_length1;
		_tmp20_ = _accounts_array;
		_tmp20__length1 = _accounts_array_length1;
		{
			gchar** a_collection = NULL;
			gint a_collection_length1 = 0;
			gint _a_collection_size_ = 0;
			gint a_it = 0;
			a_collection = _tmp20_;
			a_collection_length1 = _tmp20__length1;
			for (a_it = 0; a_it < _tmp20__length1; a_it = a_it + 1) {
				gchar* _tmp21_;
				gchar* a = NULL;
				_tmp21_ = g_strdup (a_collection[a_it]);
				a = _tmp21_;
				{
					const gchar* _tmp22_;
					gchar** _tmp23_;
					gchar** _tmp24_ = NULL;
					gchar** _tmp25_;
					gint _tmp25__length1;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _account;
					GeeList* _tmp29_;
					const gchar* _tmp30_;
					gboolean _tmp31_ = FALSE;
					_tmp22_ = a;
					_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ":", 0);
					_tmp25_ = _tmp24_;
					_tmp25__length1 = _vala_array_length (_tmp23_);
					_tmp26_ = _tmp25_[0];
					_tmp27_ = g_strdup (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
					_account = _tmp28_;
					_tmp29_ = account_ids;
					_tmp30_ = _account;
					_tmp31_ = gee_collection_contains ((GeeCollection*) _tmp29_, _tmp30_);
					if (!_tmp31_) {
						account_match = FALSE;
					}
					_g_free0 (_account);
					_g_free0 (a);
				}
			}
		}
		_accounts_array = (_vala_array_free (_accounts_array, _accounts_array_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp33_ = account_match;
	if (_tmp33_) {
		gboolean _tmp34_;
		_tmp34_ = stream_match;
		_tmp32_ = _tmp34_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp35_ = _tmp32_;
	result = _tmp35_;
	return result;
}


static void unity_gwibber_daemon_add_result (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter, DeeModel* results_model) {
	UnityGwibberCategories group;
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* stream_id;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	static GQuark _tmp5_label6 = 0;
	DeeModel* _tmp7_;
	DeeModelIter* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _icon_uri;
	GwibberUtils* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _avatar_cache_image;
	const gchar* _tmp14_;
	DeeModel* _tmp22_;
	DeeModel* _tmp23_;
	DeeModelIter* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	UnityGwibberCategories _tmp27_;
	DeeModel* _tmp28_;
	DeeModelIter* _tmp29_;
	const gchar* _tmp30_ = NULL;
	DeeModel* _tmp31_;
	DeeModelIter* _tmp32_;
	const gchar* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (results_model != NULL);
	group = UNITY_GWIBBER_CATEGORIES_MESSAGES;
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
	stream_id = _tmp2_;
	_tmp3_ = stream_id;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("messages")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_MESSAGES;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("replies")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_REPLIES;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("images")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_IMAGES;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("videos")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_VIDEOS;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("links")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_LINKS;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("private")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_PRIVATE;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("public")))) {
		switch (0) {
			default:
			{
				group = UNITY_GWIBBER_CATEGORIES_PUBLIC;
				break;
			}
		}
	}
	_tmp7_ = model;
	_tmp8_ = iter;
	_tmp9_ = dee_model_get_string (_tmp7_, _tmp8_, (guint) GWIBBER_STREAM_MODEL_COLUMN_ICON_URI);
	_tmp10_ = g_strdup (_tmp9_);
	_icon_uri = _tmp10_;
	_tmp11_ = self->priv->utils;
	_tmp12_ = _icon_uri;
	_tmp13_ = gwibber_utils_avatar_path (_tmp11_, _tmp12_);
	_avatar_cache_image = _tmp13_;
	_tmp14_ = _avatar_cache_image;
	if (_tmp14_ == NULL) {
		const gchar* _tmp19_;
		{
			GwibberService* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp15_ = self->priv->service;
			_tmp16_ = _icon_uri;
			_tmp17_ = gwibber_service_avatar_path (_tmp15_, _tmp16_, &_inner_error_);
			_tmp18_ = _tmp17_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_g_free0 (_avatar_cache_image);
			_avatar_cache_image = _tmp18_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (_avatar_cache_image);
			_g_free0 (_icon_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = _avatar_cache_image;
		if (_tmp19_ == NULL) {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp20_ = _icon_uri;
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (_avatar_cache_image);
			_avatar_cache_image = _tmp21_;
		}
	}
	_tmp22_ = results_model;
	_tmp23_ = model;
	_tmp24_ = iter;
	_tmp25_ = dee_model_get_string (_tmp23_, _tmp24_, (guint) GWIBBER_STREAM_MODEL_COLUMN_URL);
	_tmp26_ = _avatar_cache_image;
	_tmp27_ = group;
	_tmp28_ = self->priv->_model;
	_tmp29_ = iter;
	_tmp30_ = dee_model_get_string (_tmp28_, _tmp29_, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER);
	_tmp31_ = self->priv->_model;
	_tmp32_ = iter;
	_tmp33_ = dee_model_get_string (_tmp31_, _tmp32_, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE);
	dee_model_append (_tmp22_, _tmp25_, _tmp26_, _tmp27_, "text/html", _tmp30_, _tmp33_, NULL);
	_g_free0 (_avatar_cache_image);
	_g_free0 (_icon_uri);
}


UnityGwibberDaemon* unity_gwibber_daemon_construct (GType object_type) {
	UnityGwibberDaemon * self = NULL;
	self = (UnityGwibberDaemon*) g_object_new (object_type, NULL);
	return self;
}


UnityGwibberDaemon* unity_gwibber_daemon_new (void) {
	return unity_gwibber_daemon_construct (UNITY_GWIBBER_TYPE_DAEMON);
}


static void _unity_gwibber_daemon___lambda6_ (UnityGwibberDaemon* self) {
	UnityScope* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->scope;
	_tmp1_ = unity_scope_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		UnityScope* _tmp3_;
		_tmp3_ = self->priv->scope;
		unity_scope_queue_search_changed (_tmp3_, UNITY_SEARCH_TYPE_DEFAULT);
	}
}


static void __unity_gwibber_daemon___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_unity_gwibber_daemon___lambda6_ (self);
}


static gchar* _unity_gwibber_daemon___lambda7_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search) {
	gchar* result = NULL;
	UnityLensSearch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (lens_search != NULL, NULL);
	_tmp0_ = lens_search;
	_tmp1_ = unity_lens_search_get_search_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* __unity_gwibber_daemon___lambda7__unity_scope_generate_search_key (UnityScope* _sender, UnityLensSearch* search, gpointer self) {
	gchar* result;
	result = _unity_gwibber_daemon___lambda7_ (self, search);
	return result;
}


static void _unity_gwibber_daemon___lambda8_ (UnityGwibberDaemon* self, UnityLensSearch* lens_search, UnitySearchType search_type, GCancellable* cancellable) {
	UnitySearchType _tmp0_;
	g_return_if_fail (lens_search != NULL);
	g_return_if_fail (cancellable != NULL);
	_tmp0_ = search_type;
	if (_tmp0_ == UNITY_SEARCH_TYPE_DEFAULT) {
		UnityLensSearch* _tmp1_;
		GCancellable* _tmp2_;
		_tmp1_ = lens_search;
		_tmp2_ = cancellable;
		unity_gwibber_daemon_update_scope_search (self, _tmp1_, _tmp2_, NULL, NULL);
	} else {
		UnityLensSearch* _tmp3_;
		GCancellable* _tmp4_;
		_tmp3_ = lens_search;
		_tmp4_ = cancellable;
		unity_gwibber_daemon_update_global_search (self, _tmp3_, _tmp4_, NULL, NULL);
	}
}


static void __unity_gwibber_daemon___lambda8__unity_scope_search_changed (UnityScope* _sender, UnityLensSearch* search, UnitySearchType search_type, GCancellable* cancellable, gpointer self) {
	_unity_gwibber_daemon___lambda8_ (self, search, search_type, cancellable);
}


static void _unity_gwibber_daemon___lambda9_ (UnityGwibberDaemon* self, GObject* obj, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	UnityLens* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp7_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp1_ = self->priv->lens;
	_tmp2_ = unity_lens_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		UnityScope* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->scope;
		_tmp5_ = unity_scope_get_active (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		DeeModelIter* _tmp9_;
		DeeModel* _tmp10_;
		DeeModelIter* _tmp11_ = NULL;
		gboolean _tmp15_;
		_tmp9_ = self->priv->_stream_iter_first;
		_tmp10_ = self->priv->_model;
		_tmp11_ = dee_model_get_first_iter (_tmp10_);
		if (_tmp9_ != _tmp11_) {
			_tmp8_ = TRUE;
		} else {
			DeeModelIter* _tmp12_;
			DeeModel* _tmp13_;
			DeeModelIter* _tmp14_ = NULL;
			_tmp12_ = self->priv->_stream_iter_last;
			_tmp13_ = self->priv->_model;
			_tmp14_ = dee_model_get_last_iter (_tmp13_);
			_tmp8_ = _tmp12_ != _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			UnityScope* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = self->priv->scope;
			_tmp17_ = unity_scope_get_active (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				UnityScope* _tmp19_;
				_tmp19_ = self->priv->scope;
				unity_scope_queue_search_changed (_tmp19_, UNITY_SEARCH_TYPE_DEFAULT);
			}
		}
	}
}


static void __unity_gwibber_daemon___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_unity_gwibber_daemon___lambda9_ (self, _sender, pspec);
}


static void _unity_gwibber_daemon___lambda10_ (UnityGwibberDaemon* self) {
	UnityScope* _tmp0_;
	_tmp0_ = self->priv->scope;
	unity_scope_queue_search_changed (_tmp0_, UNITY_SEARCH_TYPE_DEFAULT);
}


static void __unity_gwibber_daemon___lambda10__unity_scope_filters_changed (UnityScope* _sender, gpointer self) {
	_unity_gwibber_daemon___lambda10_ (self);
}


static void _unity_gwibber_daemon___lambda11_ (UnityGwibberDaemon* self, DeeTermList* terms_in, DeeTermList* terms_out) {
	g_return_if_fail (terms_in != NULL);
	g_return_if_fail (terms_out != NULL);
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				guint _tmp3_;
				DeeTermList* _tmp4_;
				guint _tmp5_ = 0U;
				DeeTermList* _tmp6_;
				guint _tmp7_;
				const gchar* _tmp8_ = NULL;
				const gchar* term;
				DeeICUTermFilter* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* folded;
				DeeTermList* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = terms_in;
				_tmp5_ = dee_term_list_num_terms (_tmp4_);
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				_tmp6_ = terms_in;
				_tmp7_ = i;
				_tmp8_ = dee_term_list_get_term (_tmp6_, _tmp7_);
				term = _tmp8_;
				_tmp9_ = self->priv->_ascii_filter;
				_tmp10_ = term;
				_tmp11_ = dee_icu_term_filter_apply (_tmp9_, _tmp10_);
				folded = _tmp11_;
				_tmp12_ = terms_out;
				_tmp13_ = term;
				dee_term_list_add_term (_tmp12_, _tmp13_);
				_tmp14_ = folded;
				_tmp15_ = term;
				if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
					DeeTermList* _tmp16_;
					const gchar* _tmp17_;
					_tmp16_ = terms_out;
					_tmp17_ = folded;
					dee_term_list_add_term (_tmp16_, _tmp17_);
				}
				_g_free0 (folded);
			}
		}
	}
}


static void __unity_gwibber_daemon___lambda11__dee_term_filter_func (DeeTermList* terms_in, DeeTermList* terms_out, gpointer self) {
	_unity_gwibber_daemon___lambda11_ (self, terms_in, terms_out);
}


static gchar* _unity_gwibber_daemon___lambda12_ (UnityGwibberDaemon* self, DeeModel* model, DeeModelIter* iter) {
	gchar* result = NULL;
	GwibberStreamModelColumn sender_col;
	GwibberStreamModelColumn msg_col;
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	GwibberStreamModelColumn _tmp2_;
	const gchar* _tmp3_ = NULL;
	DeeModel* _tmp4_;
	DeeModelIter* _tmp5_;
	GwibberStreamModelColumn _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	sender_col = GWIBBER_STREAM_MODEL_COLUMN_SENDER;
	msg_col = GWIBBER_STREAM_MODEL_COLUMN_MESSAGE;
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = sender_col;
	_tmp3_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) _tmp2_);
	_tmp4_ = model;
	_tmp5_ = iter;
	_tmp6_ = msg_col;
	_tmp7_ = dee_model_get_string (_tmp4_, _tmp5_, (guint) _tmp6_);
	_tmp8_ = g_strdup_printf ("%s\n%s", _tmp3_, _tmp7_);
	result = _tmp8_;
	return result;
}


static gchar* __unity_gwibber_daemon___lambda12__dee_model_reader_func (DeeModel* model, DeeModelIter* iter, gpointer self) {
	gchar* result;
	result = _unity_gwibber_daemon___lambda12_ (self, model, iter);
	return result;
}


static GObject * unity_gwibber_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityGwibberDaemon * self;
	GwibberStreams* _tmp0_;
	GwibberService* _tmp1_;
	GwibberUtils* _tmp2_;
	GwibberAccounts* _tmp3_;
	UnityScope* _tmp4_;
	UnityScope* _tmp5_;
	UnityLens* _tmp6_;
	UnityLens* _tmp7_;
	UnityLens* _tmp8_;
	const gchar* _tmp9_ = NULL;
	UnityLens* _tmp10_;
	UnityLens* _tmp11_;
	UnityScope* _tmp12_;
	UnityScope* _tmp13_;
	UnityScope* _tmp14_;
	UnityScope* _tmp15_;
	UnityLens* _tmp16_;
	UnityScope* _tmp17_;
	GwibberStreams* _tmp21_;
	DeeModel* _tmp22_;
	DeeModel* _tmp23_;
	DeeModel* _tmp24_;
	DeeFilter _tmp25_ = {0};
	DeeModel* _tmp26_;
	DeeFilter _tmp27_;
	DeeFilterModel* _tmp28_;
	DeeICUTermFilter* _tmp29_;
	DeeTextAnalyzer* _tmp30_;
	DeeAnalyzer* _tmp31_;
	DeeModelReader _tmp32_ = {0};
	DeeModelReader reader;
	DeeModel* _tmp33_;
	DeeAnalyzer* _tmp34_;
	DeeModelReader _tmp35_;
	DeeTreeIndex* _tmp36_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_gwibber_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_GWIBBER_DAEMON (obj);
	_tmp0_ = gwibber_streams_new ();
	_g_object_unref0 (self->priv->streams_service);
	self->priv->streams_service = _tmp0_;
	_tmp1_ = gwibber_service_new ();
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp2_;
	_tmp3_ = gwibber_accounts_new ();
	_g_object_unref0 (self->priv->accounts);
	self->priv->accounts = _tmp3_;
	_tmp4_ = unity_scope_new ("/com/canonical/unity/scope/gwibber");
	_g_object_unref0 (self->priv->scope);
	self->priv->scope = _tmp4_;
	_tmp5_ = self->priv->scope;
	unity_scope_set_search_in_global (_tmp5_, TRUE);
	_tmp6_ = unity_lens_new ("/com/canonical/unity/lens/gwibber", "gwibber");
	_g_object_unref0 (self->priv->lens);
	self->priv->lens = _tmp6_;
	_tmp7_ = self->priv->lens;
	unity_lens_set_search_in_global (_tmp7_, TRUE);
	_tmp8_ = self->priv->lens;
	_tmp9_ = _ ("Enter name or content you would like to search for");
	unity_lens_set_search_hint (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->lens;
	unity_lens_set_visible (_tmp10_, TRUE);
	unity_gwibber_daemon_populate_categories (self);
	unity_gwibber_daemon_populate_filters (self);
	_tmp11_ = self->priv->lens;
	_tmp12_ = self->priv->scope;
	unity_lens_add_local_scope (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->scope;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::active", (GCallback) __unity_gwibber_daemon___lambda6__g_object_notify, self, 0);
	_tmp14_ = self->priv->scope;
	g_signal_connect_object (_tmp14_, "generate-search-key", (GCallback) __unity_gwibber_daemon___lambda7__unity_scope_generate_search_key, self, 0);
	_tmp15_ = self->priv->scope;
	g_signal_connect_object (_tmp15_, "search-changed", (GCallback) __unity_gwibber_daemon___lambda8__unity_scope_search_changed, self, 0);
	_tmp16_ = self->priv->lens;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::active", (GCallback) __unity_gwibber_daemon___lambda9__g_object_notify, self, 0);
	_tmp17_ = self->priv->scope;
	g_signal_connect_object (_tmp17_, "filters-changed", (GCallback) __unity_gwibber_daemon___lambda10__unity_scope_filters_changed, self, 0);
	{
		UnityLens* _tmp18_;
		_tmp18_ = self->priv->lens;
		unity_lens_export (_tmp18_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("daemon.vala:116: failed to export lens: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp21_ = self->priv->streams_service;
	_tmp22_ = gwibber_streams_get_stream_model (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (self->priv->_streams_model);
	self->priv->_streams_model = _tmp24_;
	setlocale (LC_COLLATE, "C");
	dee_filter_new_collator_desc ((guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP, &_tmp25_);
	self->priv->_sort_filter = _tmp25_;
	_tmp26_ = self->priv->_streams_model;
	_tmp27_ = self->priv->_sort_filter;
	_tmp28_ = (DeeFilterModel*) dee_filter_model_new (_tmp26_, &_tmp27_);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = (DeeModel*) _tmp28_;
	_tmp29_ = dee_icu_term_filter_new_ascii_folder ();
	_dee_icu_term_filter_destroy0 (self->priv->_ascii_filter);
	self->priv->_ascii_filter = _tmp29_;
	_tmp30_ = dee_text_analyzer_new ();
	_g_object_unref0 (self->priv->_analyzer);
	self->priv->_analyzer = (DeeAnalyzer*) _tmp30_;
	_tmp31_ = self->priv->_analyzer;
	dee_analyzer_add_term_filter (_tmp31_, __unity_gwibber_daemon___lambda11__dee_term_filter_func, g_object_ref (self), g_object_unref);
	dee_model_reader_new (__unity_gwibber_daemon___lambda12__dee_model_reader_func, g_object_ref (self), g_object_unref, &_tmp32_);
	reader = _tmp32_;
	_tmp33_ = self->priv->_model;
	_tmp34_ = self->priv->_analyzer;
	_tmp35_ = reader;
	_tmp36_ = dee_tree_index_new (_tmp33_, _tmp34_, &_tmp35_);
	_g_object_unref0 (self->priv->_index);
	self->priv->_index = (DeeIndex*) _tmp36_;
	return obj;
}


static void unity_gwibber_daemon_class_init (UnityGwibberDaemonClass * klass) {
	unity_gwibber_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityGwibberDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_gwibber_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_gwibber_daemon_finalize;
}


static void unity_gwibber_daemon_instance_init (UnityGwibberDaemon * self) {
	self->priv = UNITY_GWIBBER_DAEMON_GET_PRIVATE (self);
	self->priv->_stream_iter_first = NULL;
	self->priv->_stream_iter_last = NULL;
}


static void unity_gwibber_daemon_finalize (GObject* obj) {
	UnityGwibberDaemon * self;
	self = UNITY_GWIBBER_DAEMON (obj);
	_g_object_unref0 (self->priv->lens);
	_g_object_unref0 (self->priv->scope);
	_g_object_unref0 (self->priv->streams_service);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->accounts);
	_g_object_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_streams_model);
	_g_object_unref0 (self->priv->_analyzer);
	_g_object_unref0 (self->priv->_index);
	_dee_icu_term_filter_destroy0 (self->priv->_ascii_filter);
	G_OBJECT_CLASS (unity_gwibber_daemon_parent_class)->finalize (obj);
}


/**
   * The Daemon class implements all of the logic for the place.
   *
   */
GType unity_gwibber_daemon_get_type (void) {
	static volatile gsize unity_gwibber_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gwibber_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityGwibberDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gwibber_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGwibberDaemon), 0, (GInstanceInitFunc) unity_gwibber_daemon_instance_init, NULL };
		GType unity_gwibber_daemon_type_id;
		unity_gwibber_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityGwibberDaemon", &g_define_type_info, 0);
		g_once_init_leave (&unity_gwibber_daemon_type_id__volatile, unity_gwibber_daemon_type_id);
	}
	return unity_gwibber_daemon_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



