/* user-view-tile.c generated by valac 0.12.1, the Vala compiler
 * generated from user-view-tile.vala, do not modify */

/*
 * Copyright (C) 2010 Neil Jagdish Patel
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber-gtk.h"
#include <gtk/gtk.h>
#include <gwibber.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <pango/pango.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;

struct _GwibberGtkUserViewTilePrivate {
	GtkAlignment* align;
	GtkHBox* main_box;
	GtkAlignment* lalignment;
	GtkAlignment* ralignment;
	GtkEventBox* close_box;
	GtkImage* close_icon;
	GtkVBox* vbox;
	GtkLabel* name;
	GwibberStreams* _streams;
	gulong bp_handler_id;
	gulong cb_handler_id;
};

struct _Block9Data {
	int _ref_count_;
	GwibberGtkUserViewTile * self;
	GeeHashMap* stream;
};

struct _GwibberGtkUserProfileTilePrivate {
	GtkAlignment* align;
	GtkHBox* main_box;
	GtkAlignment* lalignment;
	GtkAlignment* ralignment;
	GtkEventBox* icon_box;
	GtkImage* icon;
	GtkVBox* vbox;
	GtkLabel* name;
	GtkLabel* description;
	GtkLabel* website;
	GtkLabel* followers;
	GtkLabel* friends;
	GtkImage* protected;
	GtkImage* service;
	GtkLabel* statuses;
	GwibberUtils* utils;
	GtkHBox* follower_box;
	GtkHBox* follow_box;
	GtkLabel* follow;
	GtkCheckButton* follow_but;
	GtkButton* _close;
	GtkImage* _close_icon;
	gboolean _showing;
};

struct _Block10Data {
	int _ref_count_;
	GwibberGtkUserProfileTile * self;
	gchar* _id;
	gchar* _sender_nick;
	gchar* _account;
};

struct _Block11Data {
	int _ref_count_;
	Block10Data * _data10_;
	GwibberService* service;
};


static gpointer gwibber_gtk_user_view_tile_parent_class = NULL;
static gpointer gwibber_gtk_user_profile_tile_parent_class = NULL;

#define GWIBBER_GTK_USER_VIEW_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_USER_VIEW_TILE, GwibberGtkUserViewTilePrivate))
enum  {
	GWIBBER_GTK_USER_VIEW_TILE_DUMMY_PROPERTY,
	GWIBBER_GTK_USER_VIEW_TILE_STREAMS
};
#define GWIBBER_GTK_USER_VIEW_TILE_our_padding 6
static gboolean gwibber_gtk_user_view_tile_on_draw (GwibberGtkUserViewTile* self, cairo_t* cr);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static gboolean _lambda53_ (GdkEventButton* event, Block9Data* _data9_);
static gboolean _lambda54_ (Block9Data* _data9_);
static gboolean __lambda54__gsource_func (gpointer self);
static gboolean __lambda53__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda55_ (Block9Data* _data9_);
static gboolean __lambda55__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void gwibber_gtk_user_view_tile_real_show_transient (GwibberGtkUserViewTile* self, const gchar* id, const gchar* name);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gwibber_gtk_user_view_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _gwibber_gtk_user_view_tile_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static void gwibber_gtk_user_view_tile_finalize (GObject* obj);
static void _vala_gwibber_gtk_user_view_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_user_view_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_GTK_USER_PROFILE_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_USER_PROFILE_TILE, GwibberGtkUserProfileTilePrivate))
enum  {
	GWIBBER_GTK_USER_PROFILE_TILE_DUMMY_PROPERTY,
	GWIBBER_GTK_USER_PROFILE_TILE_SHOWING
};
#define GWIBBER_GTK_USER_PROFILE_TILE_our_padding 6
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static void _lambda67_ (Block10Data* _data10_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static gboolean _lambda68_ (Block11Data* _data11_);
static gboolean __lambda68__gsource_func (gpointer self);
static void __lambda67__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static GObject * gwibber_gtk_user_profile_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda69_ (GwibberGtkUserProfileTile* self);
static void __lambda69__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gwibber_gtk_user_profile_tile_finalize (GObject* obj);
static void _vala_gwibber_gtk_user_profile_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_user_profile_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GwibberGtkUserViewTile* gwibber_gtk_user_view_tile_construct (GType object_type, GwibberStreams* streams) {
	GwibberGtkUserViewTile * self = NULL;
	g_return_val_if_fail (streams != NULL, NULL);
	self = (GwibberGtkUserViewTile*) g_object_new (object_type, "above-child", FALSE, "visible-window", FALSE, "streams", streams, NULL);
	return self;
}


GwibberGtkUserViewTile* gwibber_gtk_user_view_tile_new (GwibberStreams* streams) {
	return gwibber_gtk_user_view_tile_construct (GWIBBER_GTK_TYPE_USER_VIEW_TILE, streams);
}


static gboolean gwibber_gtk_user_view_tile_on_draw (GwibberGtkUserViewTile* self, cairo_t* cr) {
	gboolean result = FALSE;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	cairo_pattern_t* _tmp1_ = NULL;
	cairo_pattern_t* pat;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	cairo_set_line_width (cr, 1.0);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 1.0);
	cairo_move_to (cr, (gdouble) alloc.x, 0.5);
	cairo_line_to (cr, (gdouble) (alloc.x + alloc.width), 0.5);
	cairo_stroke (cr);
	_tmp1_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) alloc.height);
	pat = _tmp1_;
	cairo_pattern_add_color_stop_rgba (pat, (gdouble) 0.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.2f);
	cairo_pattern_add_color_stop_rgba (pat, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.0f);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) alloc.width, (gdouble) alloc.height);
	cairo_set_source (cr, pat);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.1);
	cairo_move_to (cr, (gdouble) alloc.x, alloc.height - 0.5);
	cairo_line_to (cr, (gdouble) (alloc.x + alloc.width), alloc.height - 0.5);
	cairo_stroke (cr);
	gtk_container_propagate_draw ((GtkContainer*) self, (GtkWidget*) self->priv->align, cr);
	result = TRUE;
	_cairo_pattern_destroy0 (pat);
	return result;
}


void gwibber_gtk_user_view_tile_reset (GwibberGtkUserViewTile* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->stream);
		g_slice_free (Block9Data, _data9_);
	}
}


static gboolean _lambda54_ (Block9Data* _data9_) {
	GwibberGtkUserViewTile * self;
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	self = _data9_->self;
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) _data9_->stream, "id");
	_tmp1_ = (gchar*) _tmp0_;
	gwibber_streams_delete (self->priv->_streams, _tmp1_);
	_g_free0 (_tmp1_);
	result = FALSE;
	return result;
}


static gboolean __lambda54__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda54_ (self);
	return result;
}


static gboolean _lambda53_ (GdkEventButton* event, Block9Data* _data9_) {
	GwibberGtkUserViewTile * self;
	gboolean result = FALSE;
	self = _data9_->self;
	gwibber_gtk_user_view_tile_reset (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda54__gsource_func, block9_data_ref (_data9_), block9_data_unref);
	result = TRUE;
	return result;
}


static gboolean __lambda53__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda53_ (event, self);
	return result;
}


static gboolean _lambda55_ (Block9Data* _data9_) {
	GwibberGtkUserViewTile * self;
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	self = _data9_->self;
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) _data9_->stream, "id");
	_tmp1_ = (gchar*) _tmp0_;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _data9_->stream, "name");
	_tmp3_ = (gchar*) _tmp2_;
	g_signal_emit_by_name (self, "show-transient", _tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = TRUE;
	return result;
}


static gboolean __lambda55__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda55_ (self);
	return result;
}


void gwibber_gtk_user_view_tile_set_details (GwibberGtkUserViewTile* self, GeeHashMap* stream) {
	Block9Data* _data9_;
	gpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gulong _tmp6_;
	gulong _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stream != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->stream = _g_object_ref0 (stream);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) _data9_->stream, "name");
	_tmp1_ = (gchar*) _tmp0_;
	_tmp2_ = g_strconcat ("<b>", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "</b>", NULL);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (self->priv->name, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (self->priv->cb_handler_id > 0) {
		g_signal_handler_disconnect ((GObject*) self->priv->close_box, self->priv->cb_handler_id);
	}
	_tmp6_ = g_signal_connect_data ((GtkWidget*) self->priv->close_box, "button-press-event", (GCallback) __lambda53__gtk_widget_button_press_event, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	self->priv->cb_handler_id = _tmp6_;
	if (self->priv->bp_handler_id > 0) {
		g_signal_handler_disconnect ((GObject*) self, self->priv->bp_handler_id);
	}
	_tmp7_ = g_signal_connect_data ((GtkWidget*) self, "button-press-event", (GCallback) __lambda55__gtk_widget_button_press_event, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	self->priv->bp_handler_id = _tmp7_;
	gtk_widget_queue_resize ((GtkWidget*) self);
	gtk_widget_show ((GtkWidget*) self);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


GwibberStreams* gwibber_gtk_user_view_tile_get_streams (GwibberGtkUserViewTile* self) {
	GwibberStreams* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_streams;
	return result;
}


void gwibber_gtk_user_view_tile_set_streams (GwibberGtkUserViewTile* self, GwibberStreams* value) {
	GwibberStreams* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_streams);
	self->priv->_streams = _tmp0_;
	g_object_notify ((GObject *) self, "streams");
}


static void gwibber_gtk_user_view_tile_real_show_transient (GwibberGtkUserViewTile* self, const gchar* id, const gchar* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (name != NULL);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static gboolean _gwibber_gtk_user_view_tile_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gwibber_gtk_user_view_tile_on_draw (self, cr);
	return result;
}


static GObject * gwibber_gtk_user_view_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkUserViewTile * self;
	GtkAlignment* _tmp0_ = NULL;
	GtkHBox* _tmp1_ = NULL;
	GtkAlignment* _tmp2_ = NULL;
	GtkAlignment* _tmp3_ = NULL;
	GtkVBox* _tmp4_ = NULL;
	GtkHBox* _tmp5_ = NULL;
	GtkHBox* hbox;
	GtkLabel* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkEventBox* _tmp8_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_user_view_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_USER_VIEW_TILE (obj);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _gwibber_gtk_user_view_tile_on_draw_gtk_widget_draw, self, 0);
	_tmp0_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 1.0f);
	_g_object_unref0 (self->priv->align);
	self->priv->align = g_object_ref_sink (_tmp0_);
	gtk_alignment_set_padding (self->priv->align, (guint) GWIBBER_GTK_USER_VIEW_TILE_our_padding, (guint) GWIBBER_GTK_USER_VIEW_TILE_our_padding, (guint) GWIBBER_GTK_USER_VIEW_TILE_our_padding, (guint) GWIBBER_GTK_USER_VIEW_TILE_our_padding);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->align);
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = g_object_ref_sink (_tmp1_);
	gtk_container_add ((GtkContainer*) self->priv->align, (GtkWidget*) self->priv->main_box);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.0f, 0.0f, 0.0f);
	_g_object_unref0 (self->priv->lalignment);
	self->priv->lalignment = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.0f, 0.0f, 0.0f);
	_g_object_unref0 (self->priv->ralignment);
	self->priv->ralignment = g_object_ref_sink (_tmp3_);
	gtk_box_pack_start ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->lalignment, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->ralignment, FALSE, FALSE, (guint) 0);
	_tmp4_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->vbox);
	self->priv->vbox = g_object_ref_sink (_tmp4_);
	gtk_box_pack_start ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->vbox, TRUE, TRUE, (guint) 0);
	_tmp5_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	hbox = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 2);
	_tmp6_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->name);
	self->priv->name = g_object_ref_sink (_tmp6_);
	gtk_label_set_markup (self->priv->name, "<b></b>");
	gtk_misc_set_alignment ((GtkMisc*) self->priv->name, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->name, TRUE, TRUE, (guint) 0);
	_tmp7_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->close_icon);
	self->priv->close_icon = g_object_ref_sink (_tmp7_);
	_tmp8_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (self->priv->close_box);
	self->priv->close_box = g_object_ref_sink (_tmp8_);
	gtk_event_box_set_visible_window (self->priv->close_box, FALSE);
	gtk_container_add ((GtkContainer*) self->priv->close_box, (GtkWidget*) self->priv->close_icon);
	gtk_container_add ((GtkContainer*) self->priv->ralignment, (GtkWidget*) self->priv->close_box);
	_g_object_unref0 (hbox);
	return obj;
}


static void gwibber_gtk_user_view_tile_class_init (GwibberGtkUserViewTileClass * klass) {
	gwibber_gtk_user_view_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkUserViewTilePrivate));
	GWIBBER_GTK_USER_VIEW_TILE_CLASS (klass)->show_transient = gwibber_gtk_user_view_tile_real_show_transient;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_user_view_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_user_view_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_user_view_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_user_view_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_USER_VIEW_TILE_STREAMS, g_param_spec_object ("streams", "streams", "streams", GWIBBER_TYPE_STREAMS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("show_transient", GWIBBER_GTK_TYPE_USER_VIEW_TILE, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberGtkUserViewTileClass, show_transient), NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
}


static void gwibber_gtk_user_view_tile_instance_init (GwibberGtkUserViewTile * self) {
	self->priv = GWIBBER_GTK_USER_VIEW_TILE_GET_PRIVATE (self);
}


static void gwibber_gtk_user_view_tile_finalize (GObject* obj) {
	GwibberGtkUserViewTile * self;
	self = GWIBBER_GTK_USER_VIEW_TILE (obj);
	_g_object_unref0 (self->priv->align);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->lalignment);
	_g_object_unref0 (self->priv->ralignment);
	_g_object_unref0 (self->priv->close_box);
	_g_object_unref0 (self->priv->close_icon);
	_g_object_unref0 (self->priv->vbox);
	_g_object_unref0 (self->priv->name);
	_g_object_unref0 (self->priv->_streams);
	G_OBJECT_CLASS (gwibber_gtk_user_view_tile_parent_class)->finalize (obj);
}


GType gwibber_gtk_user_view_tile_get_type (void) {
	static volatile gsize gwibber_gtk_user_view_tile_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_user_view_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkUserViewTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_user_view_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkUserViewTile), 0, (GInstanceInitFunc) gwibber_gtk_user_view_tile_instance_init, NULL };
		GType gwibber_gtk_user_view_tile_type_id;
		gwibber_gtk_user_view_tile_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "GwibberGtkUserViewTile", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_user_view_tile_type_id__volatile, gwibber_gtk_user_view_tile_type_id);
	}
	return gwibber_gtk_user_view_tile_type_id__volatile;
}


static void _vala_gwibber_gtk_user_view_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkUserViewTile * self;
	self = GWIBBER_GTK_USER_VIEW_TILE (object);
	switch (property_id) {
		case GWIBBER_GTK_USER_VIEW_TILE_STREAMS:
		g_value_set_object (value, gwibber_gtk_user_view_tile_get_streams (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_user_view_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkUserViewTile * self;
	self = GWIBBER_GTK_USER_VIEW_TILE (object);
	switch (property_id) {
		case GWIBBER_GTK_USER_VIEW_TILE_STREAMS:
		gwibber_gtk_user_view_tile_set_streams (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberGtkUserProfileTile* gwibber_gtk_user_profile_tile_construct (GType object_type) {
	GwibberGtkUserProfileTile * self = NULL;
	self = (GwibberGtkUserProfileTile*) g_object_new (object_type, "above-child", FALSE, "visible-window", FALSE, NULL);
	return self;
}


GwibberGtkUserProfileTile* gwibber_gtk_user_profile_tile_new (void) {
	return gwibber_gtk_user_profile_tile_construct (GWIBBER_GTK_TYPE_USER_PROFILE_TILE);
}


void gwibber_gtk_user_profile_tile_reset (GwibberGtkUserProfileTile* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_free0 (_data10_->_id);
		_g_free0 (_data10_->_sender_nick);
		_g_free0 (_data10_->_account);
		g_slice_free (Block10Data, _data10_);
	}
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		block10_data_unref (_data11_->_data10_);
		_data11_->_data10_ = NULL;
		_g_object_unref0 (_data11_->service);
		g_slice_free (Block11Data, _data11_);
	}
}


static gboolean _lambda68_ (Block11Data* _data11_) {
	Block10Data* _data10_;
	GwibberGtkUserProfileTile * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	_data10_ = _data11_->_data10_;
	self = _data10_->self;
	gwibber_service_perform (_data11_->service, _data10_->_id, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean __lambda68__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda68_ (self);
	return result;
}


static void _lambda67_ (Block10Data* _data10_) {
	GwibberGtkUserProfileTile * self;
	Block11Data* _data11_;
	GwibberService* _tmp0_ = NULL;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = _data10_->self;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->_data10_ = block10_data_ref (_data10_);
	_tmp0_ = gwibber_service_new ();
	_data11_->service = _tmp0_;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->follow_but);
	gwibber_service_follow (_data11_->service, _data10_->_account, _data10_->_sender_nick, _tmp1_, &_inner_error_);
	if (_inner_error_ != NULL) {
		block11_data_unref (_data11_);
		_data11_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 10, __lambda68__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


static void __lambda67__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda67_ (self);
}


void gwibber_gtk_user_profile_tile_set_details (GwibberGtkUserProfileTile* self, const gchar* _id, const gchar* _sender, const gchar* _sender_nick, gint _followers, gint _friends, gint _statuses, gboolean _following, gboolean _protected, const gchar* _website, const gchar* _description, const gchar* _account, const gchar* _service, const gchar* _icon_uri) {
	Block10Data* _data10_;
	gchar* _tmp0_;
	gchar* sender_str;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _avatar_cache_image;
	gboolean _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	gchar* service_icon;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->_id = g_strdup (_id);
	_data10_->_sender_nick = g_strdup (_sender_nick);
	_data10_->_account = g_strdup (_account);
	_tmp0_ = g_strdup ("");
	sender_str = _tmp0_;
	if (_sender != NULL) {
		_tmp1_ = _data10_->_sender_nick != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = strlen (_sender);
		if (_tmp2_ > 0) {
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp3_ = g_strconcat ("<b>", _sender, NULL);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strconcat (_tmp4_, "</b> (", NULL);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat (_tmp6_, _data10_->_sender_nick, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (_tmp8_, ")", NULL);
			_g_free0 (sender_str);
			sender_str = _tmp9_;
			_g_free0 (_tmp8_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp4_);
		} else {
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = g_strconcat ("<b>", _data10_->_sender_nick, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat (_tmp11_, "</b>", NULL);
			_g_free0 (sender_str);
			sender_str = _tmp12_;
			_g_free0 (_tmp11_);
		}
		gtk_label_set_markup (self->priv->name, sender_str);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->name);
	}
	if (_description != NULL) {
		gtk_label_set_markup (self->priv->description, _description);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->description);
	}
	if (_website != NULL) {
		gint _tmp13_;
		_tmp13_ = strlen (_website);
		if (_tmp13_ > 0) {
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp14_ = g_strconcat ("<a href='", _website, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp15_, "'>", NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat (_tmp17_, _website, NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp19_, "</a>", NULL);
			_tmp21_ = _tmp20_;
			gtk_label_set_markup (self->priv->website, _tmp21_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			gtk_widget_show ((GtkWidget*) self->priv->website);
		} else {
			gtk_widget_hide ((GtkWidget*) self->priv->website);
		}
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->website);
	}
	_tmp22_ = _ ("Friends");
	_tmp23_ = g_strconcat (_tmp22_, "\n", NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf ("%i", _friends);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat (_tmp24_, _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	gtk_label_set_markup (self->priv->friends, _tmp28_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_tmp29_ = _ ("Followers");
	_tmp30_ = g_strconcat (_tmp29_, "\n ", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf ("%i", _followers);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp31_, _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	gtk_label_set_markup (self->priv->followers, _tmp35_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp36_ = _ ("Statuses");
	_tmp37_ = g_strconcat (_tmp36_, "\n ", NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf ("%i", _statuses);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strconcat (_tmp38_, _tmp40_, NULL);
	_tmp42_ = _tmp41_;
	gtk_label_set_markup (self->priv->statuses, _tmp42_);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp38_);
	_tmp43_ = gwibber_utils_avatar_path (self->priv->utils, _icon_uri);
	_avatar_cache_image = _tmp43_;
	if (_avatar_cache_image != NULL) {
		gtk_image_set_from_file (self->priv->icon, _avatar_cache_image);
	} else {
		gtk_image_set_from_icon_name (self->priv->icon, "stock_person", GTK_ICON_SIZE_DIALOG);
	}
	_tmp44_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->follow_but);
	if (_tmp44_ != _following) {
	}
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->follow_but, _following);
	g_signal_connect_data ((GtkToggleButton*) self->priv->follow_but, "toggled", (GCallback) __lambda67__gtk_toggle_button_toggled, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	if (_protected) {
		gtk_widget_show ((GtkWidget*) self->priv->protected);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->protected);
	}
	_tmp45_ = g_strconcat ("ui/icons/breakdance/16x16/", _service, NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_strconcat (_tmp46_, ".png", NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_build_filename (PKGDATADIR, _tmp48_, NULL);
	_tmp50_ = _tmp49_;
	_g_free0 (_tmp48_);
	_g_free0 (_tmp46_);
	service_icon = _tmp50_;
	gtk_image_set_from_file (self->priv->service, service_icon);
	gtk_widget_show ((GtkWidget*) self->priv->service);
	_g_free0 (service_icon);
	_g_free0 (_avatar_cache_image);
	_g_free0 (sender_str);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


gboolean gwibber_gtk_user_profile_tile_get_showing (GwibberGtkUserProfileTile* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_showing;
	return result;
}


void gwibber_gtk_user_profile_tile_set_showing (GwibberGtkUserProfileTile* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_showing = value;
	if (self->priv->_showing) {
		gtk_widget_show_all ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
	g_object_notify ((GObject *) self, "showing");
}


static void _lambda69_ (GwibberGtkUserProfileTile* self) {
	gwibber_gtk_user_profile_tile_set_showing (self, FALSE);
}


static void __lambda69__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda69_ (self);
}


static GObject * gwibber_gtk_user_profile_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkUserProfileTile * self;
	GwibberUtils* _tmp0_ = NULL;
	GtkAlignment* _tmp1_ = NULL;
	GtkHBox* _tmp2_ = NULL;
	GtkAlignment* _tmp3_ = NULL;
	GtkAlignment* _tmp4_ = NULL;
	GtkEventBox* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkVBox* _tmp9_ = NULL;
	GtkHBox* _tmp10_ = NULL;
	GtkHBox* hbox;
	GtkImage* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkImage* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkHBox* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkLabel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkLabel* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GtkHBox* _tmp29_ = NULL;
	GtkCheckButton* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_user_profile_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_USER_PROFILE_TILE (obj);
	_tmp0_ = gwibber_utils_new ();
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp0_;
	_tmp1_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 1.0f);
	_g_object_unref0 (self->priv->align);
	self->priv->align = g_object_ref_sink (_tmp1_);
	gtk_alignment_set_padding (self->priv->align, (guint) GWIBBER_GTK_USER_PROFILE_TILE_our_padding, (guint) GWIBBER_GTK_USER_PROFILE_TILE_our_padding, (guint) GWIBBER_GTK_USER_PROFILE_TILE_our_padding, (guint) GWIBBER_GTK_USER_PROFILE_TILE_our_padding);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->align);
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) self->priv->align, (GtkWidget*) self->priv->main_box);
	_tmp3_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.0f, 0.0f, 0.0f);
	_g_object_unref0 (self->priv->lalignment);
	self->priv->lalignment = g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.0f, 0.0f, 0.0f);
	_g_object_unref0 (self->priv->ralignment);
	self->priv->ralignment = g_object_ref_sink (_tmp4_);
	gtk_box_pack_start ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->lalignment, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->ralignment, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (self->priv->icon_box);
	self->priv->icon_box = g_object_ref_sink (_tmp5_);
	gtk_event_box_set_visible_window (self->priv->icon_box, FALSE);
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("stock_person", GTK_ICON_SIZE_DIALOG);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = g_object_ref_sink (_tmp6_);
	gtk_container_add ((GtkContainer*) self->priv->icon_box, (GtkWidget*) self->priv->icon);
	gtk_container_add ((GtkContainer*) self->priv->lalignment, (GtkWidget*) self->priv->icon_box);
	_tmp7_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_close_icon);
	self->priv->_close_icon = g_object_ref_sink (_tmp7_);
	_tmp8_ = (GtkButton*) gtk_button_new ();
	_g_object_unref0 (self->priv->_close);
	self->priv->_close = g_object_ref_sink (_tmp8_);
	gtk_button_set_image (self->priv->_close, (GtkWidget*) self->priv->_close_icon);
	gtk_container_add ((GtkContainer*) self->priv->ralignment, (GtkWidget*) self->priv->_close);
	g_signal_connect_object (self->priv->_close, "clicked", (GCallback) __lambda69__gtk_button_clicked, self, 0);
	_tmp9_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->vbox);
	self->priv->vbox = g_object_ref_sink (_tmp9_);
	gtk_box_pack_start ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->vbox, TRUE, TRUE, (guint) 0);
	_tmp10_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	hbox = g_object_ref_sink (_tmp10_);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 2);
	_tmp11_ = (GtkImage*) gtk_image_new_from_icon_name ("gwibber", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->service);
	self->priv->service = g_object_ref_sink (_tmp11_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->service, TRUE);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->service, FALSE, FALSE, (guint) 2);
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->name);
	self->priv->name = g_object_ref_sink (_tmp12_);
	gtk_label_set_markup (self->priv->name, "<b></b>");
	gtk_label_set_single_line_mode (self->priv->name, FALSE);
	gtk_label_set_line_wrap (self->priv->name, TRUE);
	gtk_label_set_line_wrap_mode (self->priv->name, PANGO_WRAP_WORD_CHAR);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->name, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->name, FALSE, FALSE, (guint) 0);
	_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("stock_lock", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->protected);
	self->priv->protected = g_object_ref_sink (_tmp13_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->protected, TRUE);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->protected, FALSE, FALSE, (guint) 0);
	_tmp14_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->description);
	self->priv->description = g_object_ref_sink (_tmp14_);
	gtk_label_set_selectable (self->priv->description, FALSE);
	gtk_label_set_single_line_mode (self->priv->description, FALSE);
	gtk_label_set_line_wrap (self->priv->description, TRUE);
	gtk_label_set_line_wrap_mode (self->priv->description, PANGO_WRAP_WORD_CHAR);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->description, 0.0f, 0.0f);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->description, FALSE, FALSE, (guint) 2);
	_tmp15_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->website);
	self->priv->website = g_object_ref_sink (_tmp15_);
	gtk_label_set_selectable (self->priv->website, FALSE);
	gtk_label_set_single_line_mode (self->priv->website, FALSE);
	gtk_label_set_line_wrap (self->priv->website, TRUE);
	gtk_label_set_line_wrap_mode (self->priv->website, PANGO_WRAP_WORD_CHAR);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->website, 0.0f, 0.0f);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->website, FALSE, FALSE, (guint) 2);
	_tmp16_ = (GtkHBox*) gtk_hbox_new (FALSE, 2);
	_g_object_unref0 (self->priv->follower_box);
	self->priv->follower_box = g_object_ref_sink (_tmp16_);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->follower_box, FALSE, FALSE, (guint) 2);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->followers);
	self->priv->followers = g_object_ref_sink (_tmp17_);
	_tmp18_ = _ ("Followers");
	_tmp19_ = g_strconcat (_tmp18_, ": ", NULL);
	_tmp20_ = _tmp19_;
	gtk_label_set_markup (self->priv->followers, _tmp20_);
	_g_free0 (_tmp20_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->followers, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) self->priv->follower_box, (GtkWidget*) self->priv->followers, FALSE, FALSE, (guint) 2);
	_tmp21_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->friends);
	self->priv->friends = g_object_ref_sink (_tmp21_);
	_tmp22_ = _ ("Following");
	_tmp23_ = g_strconcat (_tmp22_, ": ", NULL);
	_tmp24_ = _tmp23_;
	gtk_label_set_markup (self->priv->friends, _tmp24_);
	_g_free0 (_tmp24_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->friends, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) self->priv->follower_box, (GtkWidget*) self->priv->friends, FALSE, FALSE, (guint) 2);
	_tmp25_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->statuses);
	self->priv->statuses = g_object_ref_sink (_tmp25_);
	_tmp26_ = _ ("Statuses");
	_tmp27_ = g_strconcat (_tmp26_, ": ", NULL);
	_tmp28_ = _tmp27_;
	gtk_label_set_markup (self->priv->statuses, _tmp28_);
	_g_free0 (_tmp28_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->statuses, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) self->priv->follower_box, (GtkWidget*) self->priv->statuses, FALSE, FALSE, (guint) 2);
	_tmp29_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->follow_box);
	self->priv->follow_box = g_object_ref_sink (_tmp29_);
	_tmp30_ = (GtkCheckButton*) gtk_check_button_new ();
	_g_object_unref0 (self->priv->follow_but);
	self->priv->follow_but = g_object_ref_sink (_tmp30_);
	_tmp31_ = _ ("Following");
	_tmp32_ = (GtkLabel*) gtk_label_new (_tmp31_);
	_g_object_unref0 (self->priv->follow);
	self->priv->follow = g_object_ref_sink (_tmp32_);
	gtk_label_set_selectable (self->priv->follow, FALSE);
	gtk_box_pack_start ((GtkBox*) self->priv->follow_box, (GtkWidget*) self->priv->follow_but, FALSE, FALSE, (guint) 2);
	gtk_box_pack_start ((GtkBox*) self->priv->follow_box, (GtkWidget*) self->priv->follow, FALSE, FALSE, (guint) 2);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->follow_box, FALSE, FALSE, (guint) 2);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (hbox);
	return obj;
}


static void gwibber_gtk_user_profile_tile_class_init (GwibberGtkUserProfileTileClass * klass) {
	gwibber_gtk_user_profile_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkUserProfileTilePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_user_profile_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_user_profile_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_user_profile_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_user_profile_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_USER_PROFILE_TILE_SHOWING, g_param_spec_boolean ("showing", "showing", "showing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gwibber_gtk_user_profile_tile_instance_init (GwibberGtkUserProfileTile * self) {
	self->priv = GWIBBER_GTK_USER_PROFILE_TILE_GET_PRIVATE (self);
	self->priv->_showing = FALSE;
}


static void gwibber_gtk_user_profile_tile_finalize (GObject* obj) {
	GwibberGtkUserProfileTile * self;
	self = GWIBBER_GTK_USER_PROFILE_TILE (obj);
	_g_object_unref0 (self->priv->align);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->lalignment);
	_g_object_unref0 (self->priv->ralignment);
	_g_object_unref0 (self->priv->icon_box);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->vbox);
	_g_object_unref0 (self->priv->name);
	_g_object_unref0 (self->priv->description);
	_g_object_unref0 (self->priv->website);
	_g_object_unref0 (self->priv->followers);
	_g_object_unref0 (self->priv->friends);
	_g_object_unref0 (self->priv->protected);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->statuses);
	_g_object_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->follower_box);
	_g_object_unref0 (self->priv->follow_box);
	_g_object_unref0 (self->priv->follow);
	_g_object_unref0 (self->priv->follow_but);
	_g_object_unref0 (self->priv->_close);
	_g_object_unref0 (self->priv->_close_icon);
	G_OBJECT_CLASS (gwibber_gtk_user_profile_tile_parent_class)->finalize (obj);
}


GType gwibber_gtk_user_profile_tile_get_type (void) {
	static volatile gsize gwibber_gtk_user_profile_tile_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_user_profile_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkUserProfileTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_user_profile_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkUserProfileTile), 0, (GInstanceInitFunc) gwibber_gtk_user_profile_tile_instance_init, NULL };
		GType gwibber_gtk_user_profile_tile_type_id;
		gwibber_gtk_user_profile_tile_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "GwibberGtkUserProfileTile", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_user_profile_tile_type_id__volatile, gwibber_gtk_user_profile_tile_type_id);
	}
	return gwibber_gtk_user_profile_tile_type_id__volatile;
}


static void _vala_gwibber_gtk_user_profile_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkUserProfileTile * self;
	self = GWIBBER_GTK_USER_PROFILE_TILE (object);
	switch (property_id) {
		case GWIBBER_GTK_USER_PROFILE_TILE_SHOWING:
		g_value_set_boolean (value, gwibber_gtk_user_profile_tile_get_showing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_user_profile_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkUserProfileTile * self;
	self = GWIBBER_GTK_USER_PROFILE_TILE (object);
	switch (property_id) {
		case GWIBBER_GTK_USER_PROFILE_TILE_SHOWING:
		gwibber_gtk_user_profile_tile_set_showing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



