/* daemon.c generated by valac 0.12.1, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <gwibber.h>
#include <dee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <locale.h>


#define UNITY_GWIBBER_TYPE_DAEMON (unity_gwibber_daemon_get_type ())
#define UNITY_GWIBBER_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemon))
#define UNITY_GWIBBER_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonClass))
#define UNITY_GWIBBER_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GWIBBER_TYPE_DAEMON))
#define UNITY_GWIBBER_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GWIBBER_TYPE_DAEMON))
#define UNITY_GWIBBER_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonClass))

typedef struct _UnityGwibberDaemon UnityGwibberDaemon;
typedef struct _UnityGwibberDaemonClass UnityGwibberDaemonClass;
typedef struct _UnityGwibberDaemonPrivate UnityGwibberDaemonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_GWIBBER_TYPE_CATEGORIES (unity_gwibber_categories_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UnityGwibberDaemon {
	GObject parent_instance;
	UnityGwibberDaemonPrivate * priv;
};

struct _UnityGwibberDaemonClass {
	GObjectClass parent_class;
};

struct _UnityGwibberDaemonPrivate {
	UnityLens* lens;
	UnityScope* scope;
	GwibberStreams* streams_service;
	GwibberService* service;
	GwibberUtils* utils;
	DeeModel* _model;
	DeeModel* _streams_model;
	DeeFilter* _sort_filter;
	UnityLensSearch* previous_search;
	gboolean is_dirty;
	DeeModelIter* _stream_iter_first;
	DeeModelIter* _stream_iter_last;
};

typedef enum  {
	UNITY_GWIBBER_CATEGORIES_MESSAGES = 0,
	UNITY_GWIBBER_CATEGORIES_REPLIES,
	UNITY_GWIBBER_CATEGORIES_IMAGES,
	UNITY_GWIBBER_CATEGORIES_VIDEOS,
	UNITY_GWIBBER_CATEGORIES_LINKS,
	UNITY_GWIBBER_CATEGORIES_PRIVATE,
	UNITY_GWIBBER_CATEGORIES_PUBLIC
} UnityGwibberCategories;


static gpointer unity_gwibber_daemon_parent_class = NULL;

#define UNITY_GWIBBER_BUS_NAME "com.canonical.Unity.Lens.Gwibber"
GType unity_gwibber_daemon_get_type (void) G_GNUC_CONST;
#define UNITY_GWIBBER_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_GWIBBER_TYPE_DAEMON, UnityGwibberDaemonPrivate))
enum  {
	UNITY_GWIBBER_DAEMON_DUMMY_PROPERTY
};
static void unity_gwibber_daemon_populate_filters (UnityGwibberDaemon* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void unity_gwibber_daemon_populate_categories (UnityGwibberDaemon* self);
static gboolean unity_gwibber_daemon_search_is_invalid (UnityGwibberDaemon* self, UnityLensSearch* search);
static gchar* unity_gwibber_daemon_prepare_search_string (UnityGwibberDaemon* self, UnityLensSearch* search);
static void unity_gwibber_daemon_update_global_search (UnityGwibberDaemon* self, UnityLensSearch* search);
GType unity_gwibber_categories_get_type (void) G_GNUC_CONST;
static void unity_gwibber_daemon_update_results_model (UnityGwibberDaemon* self, DeeModel* results_model, const gchar* type_id, const gchar* search, UnityGwibberCategories* category);
static gboolean _lambda0_ (UnityGwibberDaemon* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void unity_gwibber_daemon_update_search (UnityGwibberDaemon* self, UnityLensSearch* search);
static gchar* unity_gwibber_daemon_get_current_type (UnityGwibberDaemon* self);
static gboolean _lambda1_ (UnityGwibberDaemon* self);
static gboolean __lambda1__gsource_func (gpointer self);
UnityGwibberDaemon* unity_gwibber_daemon_new (void);
UnityGwibberDaemon* unity_gwibber_daemon_construct (GType object_type);
static GObject * unity_gwibber_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda2_ (UnityGwibberDaemon* self);
static void __lambda2__unity_scope_filters_changed (UnityScope* _sender, gpointer self);
static void _lambda3_ (GObject* obj, GParamSpec* pspec, UnityGwibberDaemon* self);
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda4_ (GObject* obj, GParamSpec* pspec, UnityGwibberDaemon* self);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda5_ (GObject* obj, GParamSpec* pspec, UnityGwibberDaemon* self);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_gwibber_daemon_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void unity_gwibber_daemon_populate_filters (UnityGwibberDaemon* self) {
	GList* filters;
	g_return_if_fail (self != NULL);
	filters = NULL;
	{
		const gchar* _tmp0_ = NULL;
		UnityRadioOptionFilter* _tmp1_ = NULL;
		UnityRadioOptionFilter* filter;
		const gchar* _tmp2_ = NULL;
		UnityFilterOption* _tmp3_ = NULL;
		UnityFilterOption* _tmp4_;
		const gchar* _tmp5_ = NULL;
		UnityFilterOption* _tmp6_ = NULL;
		UnityFilterOption* _tmp7_;
		const gchar* _tmp8_ = NULL;
		UnityFilterOption* _tmp9_ = NULL;
		UnityFilterOption* _tmp10_;
		const gchar* _tmp11_ = NULL;
		UnityFilterOption* _tmp12_ = NULL;
		UnityFilterOption* _tmp13_;
		const gchar* _tmp14_ = NULL;
		UnityFilterOption* _tmp15_ = NULL;
		UnityFilterOption* _tmp16_;
		const gchar* _tmp17_ = NULL;
		UnityFilterOption* _tmp18_ = NULL;
		UnityFilterOption* _tmp19_;
		const gchar* _tmp20_ = NULL;
		UnityFilterOption* _tmp21_ = NULL;
		UnityFilterOption* _tmp22_;
		UnityFilter* _tmp23_;
		_tmp0_ = _ ("Stream");
		_tmp1_ = unity_radio_option_filter_new ("stream", _tmp0_, NULL, FALSE);
		filter = _tmp1_;
		_tmp2_ = _ ("Messages");
		_tmp3_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "messages", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		_tmp5_ = _ ("Replies");
		_tmp6_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "replies", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp7_);
		_tmp8_ = _ ("Images");
		_tmp9_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "images", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = _ ("Videos");
		_tmp12_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "videos", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		_tmp14_ = _ ("Links");
		_tmp15_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "links", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
		_tmp17_ = _ ("Private");
		_tmp18_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "private", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		_tmp20_ = _ ("Public");
		_tmp21_ = unity_options_filter_add_option ((UnityOptionsFilter*) filter, "public", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp22_);
		_tmp23_ = _g_object_ref0 ((UnityFilter*) filter);
		filters = g_list_append (filters, _tmp23_);
		_g_object_unref0 (filter);
	}
	unity_lens_set_filters (self->priv->lens, filters);
	__g_list_free__g_object_unref0_0 (filters);
}


static void unity_gwibber_daemon_populate_categories (UnityGwibberDaemon* self) {
	GList* categories;
	GIcon* icon = NULL;
	GThemedIcon* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	UnityCategory* _tmp2_ = NULL;
	UnityCategory* cat;
	UnityCategory* _tmp3_;
	GThemedIcon* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	UnityCategory* _tmp6_ = NULL;
	UnityCategory* _tmp7_;
	GThemedIcon* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	UnityCategory* _tmp10_ = NULL;
	UnityCategory* _tmp11_;
	GThemedIcon* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	UnityCategory* _tmp14_ = NULL;
	UnityCategory* _tmp15_;
	GThemedIcon* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	UnityCategory* _tmp18_ = NULL;
	UnityCategory* _tmp19_;
	GThemedIcon* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	UnityCategory* _tmp22_ = NULL;
	UnityCategory* _tmp23_;
	GThemedIcon* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	UnityCategory* _tmp26_ = NULL;
	UnityCategory* _tmp27_;
	g_return_if_fail (self != NULL);
	categories = NULL;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("tray-message");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp0_;
	_tmp1_ = _ ("Messages");
	_tmp2_ = unity_category_new (_tmp1_, icon, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	cat = _tmp2_;
	_tmp3_ = _g_object_ref0 (cat);
	categories = g_list_append (categories, _tmp3_);
	_tmp4_ = (GThemedIcon*) g_themed_icon_new ("mail_reply");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp4_;
	_tmp5_ = _ ("Replies");
	_tmp6_ = unity_category_new (_tmp5_, icon, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp6_;
	_tmp7_ = _g_object_ref0 (cat);
	categories = g_list_append (categories, _tmp7_);
	_tmp8_ = (GThemedIcon*) g_themed_icon_new ("gnome-mime-image");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp8_;
	_tmp9_ = _ ("Images");
	_tmp10_ = unity_category_new (_tmp9_, icon, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp10_;
	_tmp11_ = _g_object_ref0 (cat);
	categories = g_list_append (categories, _tmp11_);
	_tmp12_ = (GThemedIcon*) g_themed_icon_new ("video");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp12_;
	_tmp13_ = _ ("Videos");
	_tmp14_ = unity_category_new (_tmp13_, icon, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp14_;
	_tmp15_ = _g_object_ref0 (cat);
	categories = g_list_append (categories, _tmp15_);
	_tmp16_ = (GThemedIcon*) g_themed_icon_new ("web-browser");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp16_;
	_tmp17_ = _ ("Links");
	_tmp18_ = unity_category_new (_tmp17_, icon, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp18_;
	_tmp19_ = _g_object_ref0 (cat);
	categories = g_list_append (categories, _tmp19_);
	_tmp20_ = (GThemedIcon*) g_themed_icon_new ("mail-send-receive");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp20_;
	_tmp21_ = _ ("Private");
	_tmp22_ = unity_category_new (_tmp21_, icon, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp22_;
	_tmp23_ = _g_object_ref0 (cat);
	categories = g_list_append (categories, _tmp23_);
	_tmp24_ = (GThemedIcon*) g_themed_icon_new ("evolution");
	_g_object_unref0 (icon);
	icon = (GIcon*) _tmp24_;
	_tmp25_ = _ ("Public");
	_tmp26_ = unity_category_new (_tmp25_, icon, UNITY_CATEGORY_RENDERER_HORIZONTAL_TILE);
	_g_object_unref0 (cat);
	cat = _tmp26_;
	_tmp27_ = _g_object_ref0 (cat);
	categories = g_list_append (categories, _tmp27_);
	unity_lens_set_categories (self->priv->lens, categories);
	_g_object_unref0 (cat);
	_g_object_unref0 (icon);
	__g_list_free__g_object_unref0_0 (categories);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean unity_gwibber_daemon_search_is_invalid (UnityGwibberDaemon* self, UnityLensSearch* search) {
	gboolean result = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (search == NULL) {
		result = TRUE;
		return result;
	} else {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = unity_lens_search_get_search_string (search);
		if (_tmp0_ == NULL) {
			result = TRUE;
			return result;
		}
	}
	_tmp1_ = unity_lens_search_get_search_string (search);
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static gchar* unity_gwibber_daemon_prepare_search_string (UnityGwibberDaemon* self, UnityLensSearch* search) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* s;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unity_lens_search_get_search_string (search);
	_tmp1_ = g_strdup (_tmp0_);
	s = _tmp1_;
	_tmp2_ = g_str_has_suffix (s, " ");
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = string_strip (s);
		_g_free0 (s);
		s = _tmp3_;
	}
	result = s;
	return result;
}


static gboolean _lambda0_ (UnityGwibberDaemon* self) {
	gboolean result = FALSE;
	g_object_thaw_notify ((GObject*) self->priv->scope);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static void unity_gwibber_daemon_update_global_search (UnityGwibberDaemon* self, UnityLensSearch* search) {
	DeeSharedModel* _tmp0_ = NULL;
	DeeSharedModel* _tmp1_;
	DeeSharedModel* results_model;
	gboolean _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* search_string;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = unity_scope_get_global_results_model (self->priv->scope);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	results_model = _tmp1_;
	_tmp2_ = unity_gwibber_daemon_search_is_invalid (self, search);
	if (_tmp2_) {
		_g_object_unref0 (results_model);
		return;
	}
	g_object_freeze_notify ((GObject*) self->priv->scope);
	_tmp3_ = unity_gwibber_daemon_prepare_search_string (self, search);
	search_string = _tmp3_;
	dee_model_clear ((DeeModel*) results_model);
	unity_gwibber_daemon_update_results_model (self, (DeeModel*) results_model, NULL, search_string, NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_signal_emit_by_name (search, "finished");
	_g_free0 (search_string);
	_g_object_unref0 (results_model);
}


static gboolean _lambda1_ (UnityGwibberDaemon* self) {
	gboolean result = FALSE;
	g_object_thaw_notify ((GObject*) self->priv->scope);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void unity_gwibber_daemon_update_search (UnityGwibberDaemon* self, UnityLensSearch* search) {
	DeeSharedModel* _tmp0_ = NULL;
	DeeSharedModel* _tmp1_;
	DeeSharedModel* results_model;
	gchar* _tmp2_ = NULL;
	gchar* search_string;
	gchar* _tmp3_ = NULL;
	gchar* type_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = unity_scope_get_results_model (self->priv->scope);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	results_model = _tmp1_;
	g_object_freeze_notify ((GObject*) self->priv->scope);
	_tmp2_ = unity_gwibber_daemon_prepare_search_string (self, search);
	search_string = _tmp2_;
	_tmp3_ = unity_gwibber_daemon_get_current_type (self);
	type_id = _tmp3_;
	g_debug ("daemon.vala:254: type_id is %s", type_id);
	dee_model_clear ((DeeModel*) results_model);
	unity_gwibber_daemon_update_results_model (self, (DeeModel*) results_model, type_id, search_string, NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	g_signal_emit_by_name (search, "finished");
	_g_free0 (type_id);
	_g_free0 (search_string);
	_g_object_unref0 (results_model);
}


static gchar* unity_gwibber_daemon_get_current_type (UnityGwibberDaemon* self) {
	gchar* result = NULL;
	UnityFilter* _tmp0_ = NULL;
	UnityFilter* _tmp1_;
	UnityRadioOptionFilter* filter;
	UnityFilterOption* _tmp2_ = NULL;
	UnityFilterOption* option;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unity_scope_get_filter (self->priv->scope, "stream");
	_tmp1_ = _tmp0_;
	filter = UNITY_IS_RADIO_OPTION_FILTER (_tmp1_) ? ((UnityRadioOptionFilter*) _tmp1_) : NULL;
	_tmp2_ = unity_radio_option_filter_get_active_option (filter);
	option = _tmp2_;
	if (option == NULL) {
		_tmp3_ = "all";
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = unity_filter_option_get_id (option);
		_tmp3_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp3_);
	result = _tmp5_;
	_g_object_unref0 (option);
	_g_object_unref0 (filter);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static void unity_gwibber_daemon_update_results_model (UnityGwibberDaemon* self, DeeModel* results_model, const gchar* type_id, const gchar* search, UnityGwibberCategories* category) {
	DeeModelIter* iter = NULL;
	DeeModelIter* end = NULL;
	gchar* search_string;
	UnityGwibberCategories group;
	DeeModelIter* _tmp0_ = NULL;
	DeeModelIter* _tmp1_ = NULL;
	DeeModelIter* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	search_string = NULL;
	group = UNITY_GWIBBER_CATEGORIES_MESSAGES;
	dee_model_clear (results_model);
	_tmp0_ = dee_model_get_first_iter (self->priv->_model);
	iter = _tmp0_;
	_tmp1_ = dee_model_get_last_iter (self->priv->_model);
	end = _tmp1_;
	_tmp2_ = dee_model_get_first_iter (self->priv->_model);
	self->priv->_stream_iter_first = _tmp2_;
	self->priv->_stream_iter_last = end;
	if (search != NULL) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_utf8_strdown (search, (gssize) (-1));
		_g_free0 (search_string);
		search_string = _tmp3_;
	}
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		if (!(iter != end)) {
			break;
		}
		if (g_strcmp0 (type_id, "messages") == 0) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp4_ = g_strcmp0 (_tmp5_, "messages") != 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			DeeModelIter* _tmp6_ = NULL;
			_tmp6_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp6_;
			continue;
		}
		if (g_strcmp0 (type_id, "replies") == 0) {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp7_ = g_strcmp0 (_tmp8_, "replies") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			DeeModelIter* _tmp9_ = NULL;
			_tmp9_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp9_;
			continue;
		}
		if (g_strcmp0 (type_id, "images") == 0) {
			const gchar* _tmp11_ = NULL;
			_tmp11_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp10_ = g_strcmp0 (_tmp11_, "images") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			DeeModelIter* _tmp12_ = NULL;
			_tmp12_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp12_;
			continue;
		}
		if (g_strcmp0 (type_id, "videos") == 0) {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp13_ = g_strcmp0 (_tmp14_, "videos") != 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			DeeModelIter* _tmp15_ = NULL;
			_tmp15_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp15_;
			continue;
		}
		if (g_strcmp0 (type_id, "links") == 0) {
			const gchar* _tmp17_ = NULL;
			_tmp17_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp16_ = g_strcmp0 (_tmp17_, "links") != 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			DeeModelIter* _tmp18_ = NULL;
			_tmp18_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp18_;
			continue;
		}
		if (g_strcmp0 (type_id, "private") == 0) {
			const gchar* _tmp20_ = NULL;
			_tmp20_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp19_ = g_strcmp0 (_tmp20_, "private") != 0;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			DeeModelIter* _tmp21_ = NULL;
			_tmp21_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp21_;
			continue;
		}
		if (g_strcmp0 (type_id, "public") == 0) {
			const gchar* _tmp23_ = NULL;
			_tmp23_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			_tmp22_ = g_strcmp0 (_tmp23_, "public") != 0;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			DeeModelIter* _tmp24_ = NULL;
			_tmp24_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp24_;
			continue;
		}
		if (search_string == NULL) {
			_tmp26_ = TRUE;
		} else {
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			gboolean _tmp30_;
			_tmp27_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER);
			_tmp28_ = g_utf8_strdown (_tmp27_, (gssize) (-1));
			_tmp29_ = _tmp28_;
			_tmp30_ = string_contains (_tmp29_, search_string);
			_tmp26_ = _tmp30_;
			_g_free0 (_tmp29_);
		}
		if (_tmp26_) {
			_tmp25_ = TRUE;
		} else {
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gboolean _tmp34_;
			_tmp31_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE);
			_tmp32_ = g_utf8_strdown (_tmp31_, (gssize) (-1));
			_tmp33_ = _tmp32_;
			_tmp34_ = string_contains (_tmp33_, search_string);
			_tmp25_ = _tmp34_;
			_g_free0 (_tmp33_);
		}
		if (_tmp25_) {
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			gchar* _icon_uri;
			gchar* _tmp44_ = NULL;
			gchar* _avatar_cache_image;
			const gchar* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			_tmp35_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
			if (g_strcmp0 (_tmp35_, "messages") == 0) {
				group = UNITY_GWIBBER_CATEGORIES_MESSAGES;
			} else {
				const gchar* _tmp36_ = NULL;
				_tmp36_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
				if (g_strcmp0 (_tmp36_, "replies") == 0) {
					group = UNITY_GWIBBER_CATEGORIES_REPLIES;
				} else {
					const gchar* _tmp37_ = NULL;
					_tmp37_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
					if (g_strcmp0 (_tmp37_, "images") == 0) {
						group = UNITY_GWIBBER_CATEGORIES_IMAGES;
					} else {
						const gchar* _tmp38_ = NULL;
						_tmp38_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
						if (g_strcmp0 (_tmp38_, "videos") == 0) {
							group = UNITY_GWIBBER_CATEGORIES_VIDEOS;
						} else {
							const gchar* _tmp39_ = NULL;
							_tmp39_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
							if (g_strcmp0 (_tmp39_, "links") == 0) {
								group = UNITY_GWIBBER_CATEGORIES_LINKS;
							} else {
								const gchar* _tmp40_ = NULL;
								_tmp40_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
								if (g_strcmp0 (_tmp40_, "private") == 0) {
									group = UNITY_GWIBBER_CATEGORIES_PRIVATE;
								} else {
									const gchar* _tmp41_ = NULL;
									_tmp41_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM);
									if (g_strcmp0 (_tmp41_, "public") == 0) {
										group = UNITY_GWIBBER_CATEGORIES_PUBLIC;
									}
								}
							}
						}
					}
				}
			}
			_tmp42_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_ICON_URI);
			_tmp43_ = g_strdup (_tmp42_);
			_icon_uri = _tmp43_;
			_tmp44_ = gwibber_utils_avatar_path (self->priv->utils, _icon_uri);
			_avatar_cache_image = _tmp44_;
			if (_avatar_cache_image == NULL) {
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_;
				_tmp45_ = gwibber_service_avatar_path (self->priv->service, _icon_uri, &_inner_error_);
				_tmp46_ = _tmp45_;
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_g_free0 (_avatar_cache_image);
				_avatar_cache_image = _tmp46_;
				goto __finally0;
				__catch0_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_free0 (_avatar_cache_image);
					_g_free0 (_icon_uri);
					_g_free0 (search_string);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				if (_avatar_cache_image == NULL) {
					gchar* _tmp47_;
					_tmp47_ = g_strdup (_icon_uri);
					_g_free0 (_avatar_cache_image);
					_avatar_cache_image = _tmp47_;
				}
			}
			_tmp48_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_URL);
			_tmp49_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_SENDER);
			_tmp50_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE);
			dee_model_append (results_model, _tmp48_, _avatar_cache_image, group, "text/html", _tmp49_, _tmp50_, NULL);
			_g_free0 (_avatar_cache_image);
			_g_free0 (_icon_uri);
		}
		if (iter == end) {
			iter = NULL;
		} else {
			DeeModelIter* _tmp51_ = NULL;
			_tmp51_ = dee_model_next (self->priv->_model, iter);
			iter = _tmp51_;
		}
	}
	_g_free0 (search_string);
}


UnityGwibberDaemon* unity_gwibber_daemon_construct (GType object_type) {
	UnityGwibberDaemon * self = NULL;
	self = (UnityGwibberDaemon*) g_object_new (object_type, NULL);
	return self;
}


UnityGwibberDaemon* unity_gwibber_daemon_new (void) {
	return unity_gwibber_daemon_construct (UNITY_GWIBBER_TYPE_DAEMON);
}


static void _lambda2_ (UnityGwibberDaemon* self) {
	UnityLensSearch* _tmp0_ = NULL;
	_tmp0_ = unity_scope_get_active_search (self->priv->scope);
	if (_tmp0_ != NULL) {
		self->priv->is_dirty = TRUE;
		g_object_notify ((GObject*) self->priv->scope, "active-search");
	}
}


static void __lambda2__unity_scope_filters_changed (UnityScope* _sender, gpointer self) {
	_lambda2_ (self);
}


static void _lambda3_ (GObject* obj, GParamSpec* pspec, UnityGwibberDaemon* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp1_ = unity_lens_get_active (self->priv->lens);
	if (_tmp1_) {
		UnityLensSearch* _tmp2_ = NULL;
		_tmp2_ = unity_scope_get_active_search (self->priv->scope);
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		DeeModelIter* _tmp4_ = NULL;
		_tmp4_ = dee_model_get_first_iter (self->priv->_model);
		if (self->priv->_stream_iter_first != _tmp4_) {
			_tmp3_ = TRUE;
		} else {
			DeeModelIter* _tmp5_ = NULL;
			_tmp5_ = dee_model_get_last_iter (self->priv->_model);
			_tmp3_ = self->priv->_stream_iter_last != _tmp5_;
		}
		if (_tmp3_) {
			self->priv->is_dirty = TRUE;
			g_object_notify ((GObject*) self->priv->scope, "active-search");
		}
	}
}


static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda3_ (_sender, pspec, self);
}


static void _lambda4_ (GObject* obj, GParamSpec* pspec, UnityGwibberDaemon* self) {
	UnityLensSearch* _tmp0_ = NULL;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* search;
	UnityLensSearch* _tmp2_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = unity_scope_get_active_search (self->priv->scope);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	search = _tmp1_;
	self->priv->is_dirty = FALSE;
	unity_gwibber_daemon_update_search (self, search);
	_tmp2_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = _tmp2_;
	_g_object_unref0 (search);
}


static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda4_ (_sender, pspec, self);
}


static void _lambda5_ (GObject* obj, GParamSpec* pspec, UnityGwibberDaemon* self) {
	UnityLensSearch* _tmp0_ = NULL;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* search;
	gboolean _tmp2_;
	UnityLensSearch* _tmp3_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = unity_scope_get_active_global_search (self->priv->scope);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	search = _tmp1_;
	_tmp2_ = unity_gwibber_daemon_search_is_invalid (self, search);
	if (_tmp2_) {
		_g_object_unref0 (search);
		return;
	}
	unity_gwibber_daemon_update_global_search (self, search);
	_tmp3_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = _tmp3_;
	_g_object_unref0 (search);
}


static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda5_ (_sender, pspec, self);
}


static GObject * unity_gwibber_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityGwibberDaemon * self;
	GwibberStreams* _tmp0_ = NULL;
	GwibberService* _tmp1_ = NULL;
	GwibberUtils* _tmp2_ = NULL;
	UnityScope* _tmp3_ = NULL;
	UnityLens* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	DeeModel* _tmp6_ = NULL;
	DeeModel* _tmp7_;
	DeeFilter* _tmp8_ = NULL;
	DeeFilterModel* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_gwibber_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_GWIBBER_DAEMON (obj);
	_tmp0_ = gwibber_streams_new ();
	_g_object_unref0 (self->priv->streams_service);
	self->priv->streams_service = _tmp0_;
	_tmp1_ = gwibber_service_new ();
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp2_;
	_tmp3_ = unity_scope_new ("/com/canonical/unity/scope/gwibber");
	_g_object_unref0 (self->priv->scope);
	self->priv->scope = _tmp3_;
	unity_scope_set_search_in_global (self->priv->scope, TRUE);
	_tmp4_ = unity_lens_new ("/com/canonical/unity/lens/gwibber", "gwibber");
	_g_object_unref0 (self->priv->lens);
	self->priv->lens = _tmp4_;
	unity_lens_set_search_in_global (self->priv->lens, TRUE);
	_tmp5_ = _ ("Enter name or content you would like to search for");
	unity_lens_set_search_hint (self->priv->lens, _tmp5_);
	unity_lens_set_visible (self->priv->lens, TRUE);
	unity_gwibber_daemon_populate_categories (self);
	unity_gwibber_daemon_populate_filters (self);
	unity_lens_add_local_scope (self->priv->lens, self->priv->scope);
	g_signal_connect_object (self->priv->scope, "filters-changed", (GCallback) __lambda2__unity_scope_filters_changed, self, 0);
	g_signal_connect_object ((GObject*) self->priv->lens, "notify::active", (GCallback) __lambda3__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->scope, "notify::active-search", (GCallback) __lambda4__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->scope, "notify::active-global-search", (GCallback) __lambda5__g_object_notify, self, 0);
	unity_lens_export (self->priv->lens, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch1_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("daemon.vala:110: failed to export lens: %s", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp6_ = gwibber_streams_get_stream_model (self->priv->streams_service);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->_streams_model);
	self->priv->_streams_model = _tmp7_;
	setlocale (LC_COLLATE, "C");
	_tmp8_ = dee_filter_new_collator_desc ((guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTAMP);
	self->priv->_sort_filter = _tmp8_;
	_tmp9_ = (DeeFilterModel*) dee_filter_model_new (self->priv->_sort_filter, self->priv->_streams_model);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = (DeeModel*) _tmp9_;
	return obj;
}


static void unity_gwibber_daemon_class_init (UnityGwibberDaemonClass * klass) {
	unity_gwibber_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityGwibberDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_gwibber_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_gwibber_daemon_finalize;
}


static void unity_gwibber_daemon_instance_init (UnityGwibberDaemon * self) {
	self->priv = UNITY_GWIBBER_DAEMON_GET_PRIVATE (self);
	self->priv->_stream_iter_first = NULL;
	self->priv->_stream_iter_last = NULL;
}


static void unity_gwibber_daemon_finalize (GObject* obj) {
	UnityGwibberDaemon * self;
	self = UNITY_GWIBBER_DAEMON (obj);
	_g_object_unref0 (self->priv->lens);
	_g_object_unref0 (self->priv->scope);
	_g_object_unref0 (self->priv->streams_service);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_streams_model);
	_g_object_unref0 (self->priv->previous_search);
	G_OBJECT_CLASS (unity_gwibber_daemon_parent_class)->finalize (obj);
}


/**
   * The Daemon class implements all of the logic for the place.
   *
   */
GType unity_gwibber_daemon_get_type (void) {
	static volatile gsize unity_gwibber_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gwibber_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityGwibberDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gwibber_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGwibberDaemon), 0, (GInstanceInitFunc) unity_gwibber_daemon_instance_init, NULL };
		GType unity_gwibber_daemon_type_id;
		unity_gwibber_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityGwibberDaemon", &g_define_type_info, 0);
		g_once_init_leave (&unity_gwibber_daemon_type_id__volatile, unity_gwibber_daemon_type_id);
	}
	return unity_gwibber_daemon_type_id__volatile;
}



