#
# Copyright (C) 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Copyright (C) 2010 Ken VanDine <ken.vandine@canonical.com>
#
# Twitter widgets for Gwibber
#

import gtk
from gtk import Builder
import gwibber.microblog

class AccountWidget(gtk.VBox):
  """AccountWidget: A widget that provides a user interface for configuring twitter accounts in Gwibber
  """
  
  def __init__(self, account=None):
    """Creates the account pane for configuring twitter accounts"""
    gtk.VBox.__init__( self, False, 20 )
    self.ui = gtk.Builder()
    self.ui.set_translation_domain ("gwibber")
    self.ui.add_from_file (gwibber.resources.get_ui_asset("gwibber-accounts-twitter.ui"))
    self.ui.connect_signals(self)
    self.vbox_settings = self.ui.get_object("vbox_settings")
    self.pack_start(self.vbox_settings, False, False)
    self.vbox_settings.show_all()
    
"""
    gtk.VBox.__init__( self, False, 20 )
    username_box = gtk.HBox(False,2)
    self.pack_start(username_box, False, False)
    username_label = gtk.Label("Username:")
    username_box.pack_start(username_label, False, False)
    username_entry = gtk.Entry()
    username_box.pack_start(username_entry, False, False)
    username_box.show_all()

    password_box = gtk.HBox(False,2)
    self.pack_start(password_box, False, False)
    password_label = gtk.Label("Password:")
    password_box.pack_start(password_label, False, False)
    password_entry = gtk.Entry()
    password_entry.set_visibility(False)
    password_box.pack_start(password_entry, False, False)
    password_box.show_all()

    button_box = gtk.HButtonBox()
    button_box.set_border_width(5)
    button_box.set_layout(gtk.BUTTONBOX_END)
    button_box.set_spacing(0)
    cancel_button = gtk.Button(stock='gtk-cancel')
    button_box.add(cancel_button)
    cancel_button.connect("clicked", self.on_cancel_clicked)
    save_button = gtk.Button(stock='gtk-save')
    button_box.add(save_button)
    save_button.connect("clicked", self.on_save_clicked)
    self.pack_end(button_box, False, False)
    button_box.show_all()

  def on_cancel_clicked(elf, widget, data=None):
    print "on_cancel_clicked"
  
  def on_save_clicked(elf, widget, data=None):
    print "on_save_clicked"
"""
