// Generated by gtkmmproc -- DO NOT MODIFY!


#include <atkmm/text.h>
#include <atkmm/private/text_p.h>

#include <atk/atk-enum-types.h>
// -*- c++ -*-
/* $Id: text.ccg,v 1.1 2003/01/21 13:37:07 murrayc Exp $ */

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <atkmm/object.h>
#include <glib.h>
#include <algorithm> /* for std::swap() */


// static
GType Glib::Value<Atk::TextAttribute>::value_type()
{
  return atk_text_attribute_get_type();
}


namespace Atk
{

/**** Atk::Attribute *******************************************************/

Attribute::Attribute()
{
  gobject_.name  = 0;
  gobject_.value = 0;
}

Attribute::Attribute(const Glib::ustring& name, const Glib::ustring& value)
{
  gobject_.name  = g_strndup(name .data(), name .bytes());
  gobject_.value = g_strndup(value.data(), value.bytes());
}

Attribute::Attribute(const AtkAttribute* gobject)
{
  g_return_if_fail(gobject != 0);

  gobject_.name  = g_strdup(gobject->name);
  gobject_.value = g_strdup(gobject->value);
}

Attribute::~Attribute()
{
  g_free(gobject_.name);
  g_free(gobject_.value);
}

Attribute::Attribute(const Attribute& other)
{
  gobject_.name  = g_strdup(other.gobject_.name);
  gobject_.value = g_strdup(other.gobject_.value);
}

Attribute& Attribute::operator=(const Attribute& other)
{
  Attribute temp (other);
  swap(temp);
  return *this;
}

void Attribute::swap(Attribute& other)
{
  std::swap(gobject_.name,  other.gobject_.name);
  std::swap(gobject_.value, other.gobject_.value);
}


/**** Atk::TextAttribute ***************************************************/

// static
TextAttribute TextAttribute::for_name(const Glib::ustring& name)
{
  return TextAttribute(int(atk_text_attribute_for_name(name.c_str())));
}

// static
Glib::ustring TextAttribute::get_name(TextAttribute attribute)
{
  if(const char *const name = atk_text_attribute_get_name(AtkTextAttribute(int(attribute))))
    return Glib::ustring(name);
  else
    return Glib::ustring();
}

// static
Glib::ustring TextAttribute::get_value(TextAttribute attribute, int index)
{
  if(const char *const value = atk_text_attribute_get_value(AtkTextAttribute(int(attribute)), index))
    return Glib::ustring(value);
  else
    return Glib::ustring();
}

} // namespace Atk


namespace
{


static void Text_signal_text_changed_callback(AtkText* self, gint p0,gint p1,void* data)
{
  using namespace Atk;
  typedef sigc::slot< void,int,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
, p1
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Text_signal_text_changed_info =
{
  "text_changed",
  (GCallback) &Text_signal_text_changed_callback,
  (GCallback) &Text_signal_text_changed_callback
};


static void Text_signal_text_caret_moved_callback(AtkText* self, gint p0,void* data)
{
  using namespace Atk;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Text_signal_text_caret_moved_info =
{
  "text_caret_moved",
  (GCallback) &Text_signal_text_caret_moved_callback,
  (GCallback) &Text_signal_text_caret_moved_callback
};


static const Glib::SignalProxyInfo Text_signal_text_selection_changed_info =
{
  "text_selection_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Text_signal_text_attributes_changed_info =
{
  "text_attributes_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Atk
{


 Glib::ustring Attribute::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->name);
}
 
 Glib::ustring Attribute::get_value() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->value);
}
 

} // namespace Atk

// static
GType Glib::Value<Atk::BuiltinTextAttribute>::value_type()
{
  return atk_text_attribute_get_type();
}

// static
GType Glib::Value<Atk::TextBoundary>::value_type()
{
  return atk_text_boundary_get_type();
}

// static
GType Glib::Value<Atk::TextClipType>::value_type()
{
  return atk_text_clip_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Atk::Text> wrap(AtkText* object, bool take_copy)
{
  return Glib::RefPtr<Atk::Text>( dynamic_cast<Atk::Text*> (Glib::wrap_auto_interface<Atk::Text> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Atk
{


/* The *_Class implementation: */

const Glib::Interface_Class& Text_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &Text_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = atk_text_get_type();
  }

  return *this;
}

void Text_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->get_text = &get_text_vfunc_callback;
  klass->get_character_at_offset = &get_character_at_offset_vfunc_callback;
  klass->get_text_after_offset = &get_text_after_offset_vfunc_callback;
  klass->get_text_at_offset = &get_text_at_offset_vfunc_callback;
  klass->get_text_before_offset = &get_text_before_offset_vfunc_callback;
  klass->get_caret_offset = &get_caret_offset_vfunc_callback;
  klass->get_character_extents = &get_character_extents_vfunc_callback;
  klass->get_run_attributes = &get_run_attributes_vfunc_callback;
  klass->get_default_attributes = &get_default_attributes_vfunc_callback;
  klass->get_character_count = &get_character_count_vfunc_callback;
  klass->get_offset_at_point = &get_offset_at_point_vfunc_callback;
  klass->get_n_selections = &get_n_selections_vfunc_callback;
  klass->get_selection = &get_selection_vfunc_callback;
  klass->add_selection = &add_selection_vfunc_callback;
  klass->remove_selection = &remove_selection_vfunc_callback;
  klass->set_selection = &set_selection_vfunc_callback;
  klass->set_caret_offset = &set_caret_offset_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->text_changed = &text_changed_callback;
  klass->text_caret_moved = &text_caret_moved_callback;
  klass->text_selection_changed = &text_selection_changed_callback;
  klass->text_attributes_changed = &text_attributes_changed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
gchar* Text_Class::get_text_vfunc_callback(AtkText* self, gint start_offset, gint end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_text_vfunc(start_offset
, end_offset
)).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_text)
    return (*base->get_text)(self, start_offset, end_offset);


  typedef gchar* RType;
  return RType();
}
gunichar Text_Class::get_character_at_offset_vfunc_callback(AtkText* self, gint offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_character_at_offset_vfunc(offset
);
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_character_at_offset)
    return (*base->get_character_at_offset)(self, offset);


  typedef gunichar RType;
  return RType();
}
gchar* Text_Class::get_text_after_offset_vfunc_callback(AtkText* self, gint offset, AtkTextBoundary boundary_type, gint* start_offset, gint* end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_text_after_offset_vfunc(offset
, ((TextBoundary)(boundary_type))
, *(start_offset)
, *(end_offset)
)).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_text_after_offset)
    return (*base->get_text_after_offset)(self, offset, boundary_type, start_offset, end_offset);


  typedef gchar* RType;
  return RType();
}
gchar* Text_Class::get_text_at_offset_vfunc_callback(AtkText* self, gint offset, AtkTextBoundary boundary_type, gint* start_offset, gint* end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_text_at_offset_vfunc(offset
, ((TextBoundary)(boundary_type))
, *(start_offset)
, *(end_offset)
)).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_text_at_offset)
    return (*base->get_text_at_offset)(self, offset, boundary_type, start_offset, end_offset);


  typedef gchar* RType;
  return RType();
}
gchar* Text_Class::get_text_before_offset_vfunc_callback(AtkText* self, gint offset, AtkTextBoundary boundary_type, gint* start_offset, gint* end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_text_before_offset_vfunc(offset
, ((TextBoundary)(boundary_type))
, *(start_offset)
, *(end_offset)
)).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_text_before_offset)
    return (*base->get_text_before_offset)(self, offset, boundary_type, start_offset, end_offset);


  typedef gchar* RType;
  return RType();
}
gint Text_Class::get_caret_offset_vfunc_callback(AtkText* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_caret_offset_vfunc();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_caret_offset)
    return (*base->get_caret_offset)(self);


  typedef gint RType;
  return RType();
}
void Text_Class::get_character_extents_vfunc_callback(AtkText* self, gint offset, gint* x, gint* y, gint* width, gint* height, AtkCoordType coords)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->get_character_extents_vfunc(offset
, *(x)
, *(y)
, *(width)
, *(height)
, ((CoordType)(coords))
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_character_extents)
    (*base->get_character_extents)(self, offset, x, y, width, height, coords);

}
AtkAttributeSet* Text_Class::get_run_attributes_vfunc_callback(AtkText* self, gint offset, gint* start_offset, gint* end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_run_attributes_vfunc(offset
, *(start_offset)
, *(end_offset)
);
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_run_attributes)
    return (*base->get_run_attributes)(self, offset, start_offset, end_offset);


  typedef AtkAttributeSet* RType;
  return RType();
}
AtkAttributeSet* Text_Class::get_default_attributes_vfunc_callback(AtkText* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_default_attributes_vfunc();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_default_attributes)
    return (*base->get_default_attributes)(self);


  typedef AtkAttributeSet* RType;
  return RType();
}
gint Text_Class::get_character_count_vfunc_callback(AtkText* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_character_count_vfunc();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_character_count)
    return (*base->get_character_count)(self);


  typedef gint RType;
  return RType();
}
gint Text_Class::get_offset_at_point_vfunc_callback(AtkText* self, gint x, gint y, AtkCoordType coords)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_offset_at_point_vfunc(x
, y
, ((CoordType)(coords))
);
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_offset_at_point)
    return (*base->get_offset_at_point)(self, x, y, coords);


  typedef gint RType;
  return RType();
}
gint Text_Class::get_n_selections_vfunc_callback(AtkText* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return obj->get_n_selections_vfunc();
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_n_selections)
    return (*base->get_n_selections)(self);


  typedef gint RType;
  return RType();
}
gchar* Text_Class::get_selection_vfunc_callback(AtkText* self, gint selection_num, gint* start_offset, gint* end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return g_strdup((obj->get_selection_vfunc(selection_num
, *(start_offset)
, *(end_offset)
)).c_str());
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->get_selection)
    return (*base->get_selection)(self, selection_num, start_offset, end_offset);


  typedef gchar* RType;
  return RType();
}
gboolean Text_Class::add_selection_vfunc_callback(AtkText* self, gint start_offset, gint end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->add_selection_vfunc(start_offset
, end_offset
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->add_selection)
    return (*base->add_selection)(self, start_offset, end_offset);


  typedef gboolean RType;
  return RType();
}
gboolean Text_Class::remove_selection_vfunc_callback(AtkText* self, gint selection_num)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->remove_selection_vfunc(selection_num
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->remove_selection)
    return (*base->remove_selection)(self, selection_num);


  typedef gboolean RType;
  return RType();
}
gboolean Text_Class::set_selection_vfunc_callback(AtkText* self, gint selection_num, gint start_offset, gint end_offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->set_selection_vfunc(selection_num
, start_offset
, end_offset
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_selection)
    return (*base->set_selection)(self, selection_num, start_offset, end_offset);


  typedef gboolean RType;
  return RType();
}
gboolean Text_Class::set_caret_offset_vfunc_callback(AtkText* self, gint offset)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->set_caret_offset_vfunc(offset
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)  );

  // Call the original underlying C function:
  if(base && base->set_caret_offset)
    return (*base->set_caret_offset)(self, offset);


  typedef gboolean RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Text_Class::text_changed_callback(AtkText* self, gint p0, gint p1)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_changed(p0
, p1
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->text_changed)
    (*base->text_changed)(self, p0, p1);
}
void Text_Class::text_caret_moved_callback(AtkText* self, gint p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_caret_moved(p0
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->text_caret_moved)
    (*base->text_caret_moved)(self, p0);
}
void Text_Class::text_selection_changed_callback(AtkText* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_selection_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->text_selection_changed)
    (*base->text_selection_changed)(self);
}
void Text_Class::text_attributes_changed_callback(AtkText* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_attributes_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->text_attributes_changed)
    (*base->text_attributes_changed)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Text_Class::wrap_new(GObject* object)
{
  return new Text((AtkText*)(object));
}


/* The implementation: */

Text::Text()
:
  Glib::Interface(text_class_.init())
{}

Text::Text(AtkText* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

Text::~Text()
{}

// static
void Text::add_interface(GType gtype_implementer)
{
  text_class_.init().add_interface(gtype_implementer);
}

Text::CppClassType Text::text_class_; // initialize static member

GType Text::get_type()
{
  return text_class_.init().get_type();
}

GType Text::get_base_type()
{
  return atk_text_get_type();
}

Glib::ustring Text::get_text(int start_offset, int end_offset) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(atk_text_get_text(const_cast<AtkText*>(gobj()), start_offset, end_offset));
}

gunichar Text::get_character_at_offset(int offset) const
{
  return atk_text_get_character_at_offset(const_cast<AtkText*>(gobj()), offset);
}

Glib::ustring Text::get_text_after_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(atk_text_get_text_after_offset(const_cast<AtkText*>(gobj()), offset, ((AtkTextBoundary)(boundary_type)), &start_offset, &end_offset));
}

Glib::ustring Text::get_text_at_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(atk_text_get_text_at_offset(const_cast<AtkText*>(gobj()), offset, ((AtkTextBoundary)(boundary_type)), &start_offset, &end_offset));
}

Glib::ustring Text::get_text_before_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(atk_text_get_text_before_offset(const_cast<AtkText*>(gobj()), offset, ((AtkTextBoundary)(boundary_type)), &start_offset, &end_offset));
}

int Text::get_caret_offset() const
{
  return atk_text_get_caret_offset(const_cast<AtkText*>(gobj()));
}

void Text::get_character_extents(int offset, int& x, int& y, int& width, int& height, CoordType coords) const
{
atk_text_get_character_extents(const_cast<AtkText*>(gobj()), offset, &x, &y, &width, &height, ((AtkCoordType)(coords))); 
}

AttributeSet Text::get_run_attributes(int offset, int& start_offset, int& end_offset) const
{
  return AttributeSet(atk_text_get_run_attributes(const_cast<AtkText*>(gobj()), offset, &start_offset, &end_offset), Glib::OWNERSHIP_DEEP);
}

AttributeSet Text::get_default_attributes() const
{
  return AttributeSet(atk_text_get_default_attributes(const_cast<AtkText*>(gobj())), Glib::OWNERSHIP_DEEP);
}

int Text::get_character_count() const
{
  return atk_text_get_character_count(const_cast<AtkText*>(gobj()));
}

int Text::get_offset_at_point(int x, int y, CoordType coords) const
{
  return atk_text_get_offset_at_point(const_cast<AtkText*>(gobj()), x, y, ((AtkCoordType)(coords)));
}

int Text::get_n_selections() const
{
  return atk_text_get_n_selections(const_cast<AtkText*>(gobj()));
}

Glib::ustring Text::get_selection(int selection_num, int& start_offset, int& end_offset) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(atk_text_get_selection(const_cast<AtkText*>(gobj()), selection_num, &start_offset, &end_offset));
}

bool Text::add_selection(int start_offset, int end_offset)
{
  return atk_text_add_selection(gobj(), start_offset, end_offset);
}

bool Text::remove_selection(int selection_num)
{
  return atk_text_remove_selection(gobj(), selection_num);
}

bool Text::set_selection(int selection_num, int start_offset, int end_offset)
{
  return atk_text_set_selection(gobj(), selection_num, start_offset, end_offset);
}

bool Text::set_caret_offset(int offset)
{
  return atk_text_set_caret_offset(gobj(), offset);
}

void Text::get_range_extents(int start_offset, int end_offset, CoordType coord_type, Rectangle& rect)
{
atk_text_get_range_extents(gobj(), start_offset, end_offset, ((AtkCoordType)(coord_type)), &(rect)); 
}

AtkTextRange** Text::get_bounded_ranges(const Rectangle& rect, CoordType coord_type, TextClipType x_clip_type, TextClipType y_clip_type)
{
  return atk_text_get_bounded_ranges(gobj(), const_cast<AtkTextRectangle*>(&(rect)), ((AtkCoordType)(coord_type)), ((AtkTextClipType)(x_clip_type)), ((AtkTextClipType)(y_clip_type)));
}


Glib::SignalProxy2< void,int,int > Text::signal_text_changed()
{
  return Glib::SignalProxy2< void,int,int >(this, &Text_signal_text_changed_info);
}


Glib::SignalProxy1< void,int > Text::signal_text_caret_moved()
{
  return Glib::SignalProxy1< void,int >(this, &Text_signal_text_caret_moved_info);
}


Glib::SignalProxy0< void > Text::signal_text_selection_changed()
{
  return Glib::SignalProxy0< void >(this, &Text_signal_text_selection_changed_info);
}


Glib::SignalProxy0< void > Text::signal_text_attributes_changed()
{
  return Glib::SignalProxy0< void >(this, &Text_signal_text_attributes_changed_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Atk::Text::on_text_changed(int position, int length)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->text_changed)
    (*base->text_changed)(gobj(),position,length);
}
void Atk::Text::on_text_caret_moved(int location)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->text_caret_moved)
    (*base->text_caret_moved)(gobj(),location);
}
void Atk::Text::on_text_selection_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->text_selection_changed)
    (*base->text_selection_changed)(gobj());
}
void Atk::Text::on_text_attributes_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->text_attributes_changed)
    (*base->text_attributes_changed)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
Glib::ustring Atk::Text::get_text_vfunc(int start_offset, int end_offset) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_text)
    return Glib::convert_const_gchar_ptr_to_ustring((*base->get_text)(const_cast<AtkText*>(gobj()),start_offset,end_offset));

  typedef Glib::ustring RType;
  return RType();
}
gunichar Atk::Text::get_character_at_offset_vfunc(int offset) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_character_at_offset)
    return (*base->get_character_at_offset)(const_cast<AtkText*>(gobj()),offset);

  typedef gunichar RType;
  return RType();
}
Glib::ustring Atk::Text::get_text_after_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_text_after_offset)
    return Glib::convert_const_gchar_ptr_to_ustring((*base->get_text_after_offset)(const_cast<AtkText*>(gobj()),offset,((AtkTextBoundary)(boundary_type)),&start_offset,&end_offset));

  typedef Glib::ustring RType;
  return RType();
}
Glib::ustring Atk::Text::get_text_at_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_text_at_offset)
    return Glib::convert_const_gchar_ptr_to_ustring((*base->get_text_at_offset)(const_cast<AtkText*>(gobj()),offset,((AtkTextBoundary)(boundary_type)),&start_offset,&end_offset));

  typedef Glib::ustring RType;
  return RType();
}
Glib::ustring Atk::Text::get_text_before_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_text_before_offset)
    return Glib::convert_const_gchar_ptr_to_ustring((*base->get_text_before_offset)(const_cast<AtkText*>(gobj()),offset,((AtkTextBoundary)(boundary_type)),&start_offset,&end_offset));

  typedef Glib::ustring RType;
  return RType();
}
int Atk::Text::get_caret_offset_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_caret_offset)
    return (*base->get_caret_offset)(const_cast<AtkText*>(gobj()));

  typedef int RType;
  return RType();
}
void Atk::Text::get_character_extents_vfunc(int offset, int& x, int& y, int& width, int& height, CoordType coords) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_character_extents)
    (*base->get_character_extents)(const_cast<AtkText*>(gobj()),offset,&x,&y,&width,&height,((AtkCoordType)(coords)));
}
AtkAttributeSet* Atk::Text::get_run_attributes_vfunc(int offset, int& start_offset, int& end_offset) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_run_attributes)
    return (*base->get_run_attributes)(const_cast<AtkText*>(gobj()),offset,&start_offset,&end_offset);

  typedef AtkAttributeSet* RType;
  return RType();
}
AtkAttributeSet* Atk::Text::get_default_attributes_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_default_attributes)
    return (*base->get_default_attributes)(const_cast<AtkText*>(gobj()));

  typedef AtkAttributeSet* RType;
  return RType();
}
int Atk::Text::get_character_count_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_character_count)
    return (*base->get_character_count)(const_cast<AtkText*>(gobj()));

  typedef int RType;
  return RType();
}
int Atk::Text::get_offset_at_point_vfunc(int x, int y, CoordType coords) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_offset_at_point)
    return (*base->get_offset_at_point)(const_cast<AtkText*>(gobj()),x,y,((AtkCoordType)(coords)));

  typedef int RType;
  return RType();
}
int Atk::Text::get_n_selections_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_n_selections)
    return (*base->get_n_selections)(const_cast<AtkText*>(gobj()));

  typedef int RType;
  return RType();
}
Glib::ustring Atk::Text::get_selection_vfunc(int selection_num, int& start_offset, int& end_offset) const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->get_selection)
    return Glib::convert_const_gchar_ptr_to_ustring((*base->get_selection)(const_cast<AtkText*>(gobj()),selection_num,&start_offset,&end_offset));

  typedef Glib::ustring RType;
  return RType();
}
bool Atk::Text::add_selection_vfunc(int start_offset, int end_offset) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->add_selection)
    return (*base->add_selection)(gobj(),start_offset,end_offset);

  typedef bool RType;
  return RType();
}
bool Atk::Text::remove_selection_vfunc(int selection_num) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->remove_selection)
    return (*base->remove_selection)(gobj(),selection_num);

  typedef bool RType;
  return RType();
}
bool Atk::Text::set_selection_vfunc(int selection_num, int start_offset, int end_offset) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_selection)
    return (*base->set_selection)(gobj(),selection_num,start_offset,end_offset);

  typedef bool RType;
  return RType();
}
bool Atk::Text::set_caret_offset_vfunc(int offset) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->set_caret_offset)
    return (*base->set_caret_offset)(gobj(),offset);

  typedef bool RType;
  return RType();
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Atk


