.\" t
.TH GROFF_CHAR @MAN7EXT@ "@MDATE@" "@VERSION@"
.SH NAME
groff_char \- groff glyph names
.SH DESCRIPTION
.\" The lines above were designed to satisfy `apropos'.
.
.\" For best results, format this document with `groff' (GNU roff).
.
.
.\" --------------------------------------------------------------------
.\" Legal terms
.\" --------------------------------------------------------------------
.
.ig
groff_char(7)

This file is part of groff (GNU roff).

File position: <groff_src_top>/man/groff_char.man

Copyright (C) 1989-2004, 2006-2009, 2012
  Free Software Foundation, Inc.
written by Werner Lemberg <wl@gnu.org>
with additions by Bernd Warken <bwarken@mayn.de>
revised to use real tables by Eric S. Raymond <esr@thyrsus.com>

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHOR, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.ig
A copy of the GNU Free Documentation License is also available in this
Debian package as /usr/share/doc/groff/copyright.
..
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.do nr groff_char_C \n[.C]
.cp 0
.
.\" groff only
.\".if \n(.g .ne 2v
.\".if \n(.g .sv 2v
.
.ds aq \(aq
.
.\" non-groff
.if !\n(.g .if '\(aq'' .ds aq \'
.
.nr Sp 2n
.
.do if !r ECFONTS .do fspecial CR R
.
.
.\" --------------------------------------------------------------------
.\" .SH DESCRIPTION
.\" --------------------------------------------------------------------
.
This manual page lists the standard
.B groff
glyph names and the default input mapping, \%latin1.
.
The glyphs in this document look different depending
on which output device was chosen (with option
.B \-T
for the
.BR man (1)
program or the roff formatter).
.
Glyphs not available for the device that
is being used to print or view this manual page are marked with
.ie \n(.g `(N/A)'; the device currently used is `\*(.T'.
.el `(N/A)'.
.
.
.P
In the actual version,
.B groff
provides only \%8-bit characters for direct input and named entities
for further glyphs.
.
On ASCII platforms, input character codes in the range 0 to 127 (decimal)
represent the usual \%7-bit ASCII characters, while codes between 127
and 255 are interpreted as the corresponding characters in the
.I \%latin1
.RI ( \%ISO-8859-1 )
code set by default.
.
This mapping is contained in the file \f(CWlatin1.tmac\fP
and can be changed by loading a different input encoding.
.
Note that some of the input characters are reserved by
.BR groff ,
either for internal use or for special input purposes.
.
On EBCDIC platforms, only code page
.I cp1047
is supported (which contains the same characters as \%latin1; the
input encoding file is called \f(CWcp1047.tmac\fP).
.
Again, some input characters are reserved for internal and special purposes.
.
.
.P
All roff systems provide the concept of named glyphs.
.
In traditional roff systems, only names of length\ 2 were used, while
groff also provides support for longer names.
.
It is strongly suggested that only named glyphs are used for all
character representations outside of the printable \%7-bit ASCII range.
.
.
.P
Some of the predefined groff escape sequences (with names of length\ 1)
also produce single glyphs; these exist for historical reasons or
are printable versions of syntactical characters.
.
They include `\f(CW\e\e\fP', `\f(CW\e\'\fP', `\f(CW\e`\fP', `\f(CW\e-\fP',
`\f(CW\e.\fP', and `\f(CW\ee\fP'; see
.BR groff (@MAN7EXT@).
.
.
.P
In groff, all of these different types of characters and glyphs can be
tested positively with the `\f(CW.if\ c\fP' conditional.
.
.
.\" --------------------------------------------------------------------
.SH REFERENCE
.\" --------------------------------------------------------------------
.
In this section, the glyphs in groff are specified in tabular
form.
.
The meaning of the columns is as follows.
.
.
.TP
.I "Output"
shows how the glyph is printed for the current device; although
this can have quite a different shape on other devices, it always
represents the same glyph.
.
.
.TP
.I "Input"
specifies how the glyph is input either directly by a key on the
keyboard, or by a groff escape sequence.
.
.
.TP
.I "Code"
applies to glyphs which can be input with a single character, and
gives the ISO \%latin1 decimal code of that input character.
.
Note that this code is equivalent to the lowest 256 Unicode characters,
including \%7-bit ASCII in the range 0 to\ 127.
.
.
.TP
.I "PostScript"
gives the usual PostScript name of the glyph.
.
.
.TP
.I "Unicode"
is the glyph name used in composite glyph names.
.
.
.
.\" --------------------------------------------------------------------
.SS "7-bit Character Codes 32\(en126"
.\" --------------------------------------------------------------------
.
These are the basic glyphs having 7-bit ASCII code values assigned.
.
They are identical to the printable characters of the
character standards \%ISO-8859-1 (\%latin1) and Unicode (range
.IR "Basic Latin" ).
.
The glyph names used in composite glyph names are `u0020' up to `u007E'.
.
.
.P
Note that input characters in the range \%0\-31 and character 127 are
.I not
printable characters.
.
Most of them are invalid input characters for
.B groff
anyway, and the valid ones have special meaning.
.
For EBCDIC, the printable characters are in the range \%66\-255.
.
.
.TP
48\-57
Decimal digits 0 to\ 9 (print as themselves).
.
.
.TP
65\-90
Upper case letters A\-Z (print as themselves).
.
.
.TP
97\-122
Lower case letters a\(enz (print as themselves).
.
.
.P
Most of the remaining characters not in the just described ranges print as
themselves; the only exceptions are the following characters:
.
.
.TP
.B \`
the ISO \%latin1 `Grave Accent' (code\ 96) prints as `, a left single
quotation mark; the original character can be obtained with `\f(CW\e`\fP'.
.
.
.TP
.B \*(aq
the ISO \%latin1 `Apostrophe' (code\ 39) prints as ', a right single
quotation mark; the original character can be obtained with `\f(CW\e(aq\fP'.
.
.
.TP
.B -
the ISO \%latin1 `Hyphen, Minus Sign' (code\ 45) prints as a hyphen; a
minus sign can be obtained with `\f(CW\e-\fP'.
.
.
.TP
.B ~
the ISO \%latin1 `Tilde' (code\ 126) is reduced in size to be usable as
a diacritic; a larger glyph can be obtained with `\f(CW\e(ti\fP'.
.
.
.TP
.B ^
the ISO \%latin1 `Circumflex Accent' (code\ 94) is reduced in size to be
usable as a diacritic; a larger glyph can be obtained with `\f(CW\e(ha\fP'.
.
.
.P
.TS
l l l l l l.
Output	Input	Code	PostScript	Unicode	Notes
_
\[char33]	\[char33]	33	exclam	u0021
\[char34]	\[char34]	34	quotedbl	u0022
\[char35]	\[char35]	35	numbersign	u0023
\[char36]	\[char36]	36	dollar	u0024
\[char37]	\[char37]	37	percent	u0025
\[char38]	\[char38]	38	ampersand	u0026
\[char39]	\[char39]	39	quoteright	u0027
\[char40]	\[char40]	40	parenleft	u0028
\[char41]	\[char41]	41	parenright	u0029
\[char42]	\[char42]	42	asterisk	u002A
\[char43]	\[char43]	43	plus	u002B
\[char44]	\[char44]	44	comma	u002C
\[char45]	\[char45]	45	hyphen	u2010
\[char46]	\[char46]	46	period	u002E
\[char47]	\[char47]	47	slash	u002F
\[char58]	\[char58]	58	colon	u003A
\[char59]	\[char59]	59	semicolon	u003B
\[char60]	\[char60]	60	less	u003C
\[char61]	\[char61]	61	equal	u003D
\[char62]	\[char62]	62	greater	u003E
\[char63]	\[char63]	63	question	u003F
\[char64]	\[char64]	64	at	u0040
\[char91]	\[char91]	91	bracketleft	u005B
\[char92]	\[char92]	92	backslash	u005C
\[char93]	\[char93]	93	bracketright	u005D
\[char94]	\[char94]	94	circumflex	u005E	circumflex accent
\[char95]	\[char95]	95	underscore	u005F
\[char96]	\[char96]	96	quoteleft	u0060
\[char123]	\[char123]	123	braceleft	u007B
\[char124]	\[char124]	124	bar	u007C
\[char125]	\[char125]	125	braceright	u007D
\[char126]	\[char126]	126	tilde	u007E	tilde accent
.TE
.
.
.\" --------------------------------------------------------------------
.SS "8-bit Character Codes 160 to 255"
.\" --------------------------------------------------------------------
.
They are interpreted as printable characters according to the
.I latin1
.RI ( ISO-8859-1 )
code set, being identical to the Unicode range
.IR "Latin-1 Supplement" .
.
.
.P
Input characters in range 128\-159 (on non-EBCDIC hosts) are not printable
characters.
.
.
.TP
160
.
the ISO \%latin1
.I no-break space
is mapped to `\f(CW\e~\fP', the stretchable space character.
.
.
.TP
173
.
the soft hyphen control character.
.
.B groff
never uses this character for output (thus it is omitted in the
table below); the input character\ 173 is mapped onto `\f(CW\e%\fP'.
.
.
.P
The remaining ranges (\%161\-172, \%174\-255)
are printable characters that print as themselves.
.
Although they can be specified directly with the keyboard on systems
with a \%latin1 code page, it is better to use their glyph names;
see next section.
.
.P
.TS
l l l l l l.
Output	Input	Code	PostScript	Unicode	Notes
_
\[char161]	\[char161]	161	exclamdown	u00A1	inverted exclamation mark
\[char162]	\[char162]	162	cent	u00A2
\[char163]	\[char163]	163	sterling	u00A3
\[char164]	\[char164]	164	currency	u00A4
\[char165]	\[char165]	165	yen	u00A5
\[char166]	\[char166]	166	brokenbar	u00A6
\[char167]	\[char167]	167	section	u00A7
\[char168]	\[char168]	168	dieresis	u00A8
\[char169]	\[char169]	169	copyright	u00A9
\[char170]	\[char170]	170	ordfeminine	u00AA
\[char171]	\[char171]	171	guillemotleft	u00AB
\[char172]	\[char172]	172	logicalnot	u00AC
\[char174]	\[char174]	174	registered	u00AE
\[char175]	\[char175]	175	macron	u00AF
\[char176]	\[char176]	176	degree	u00B0
\[char177]	\[char177]	177	plusminus	u00B1
\[char178]	\[char178]	178	twosuperior	u00B2
\[char179]	\[char179]	179	threesuperior	u00B3
\[char180]	\[char180]	180	acute	u00B4	acute accent
\[char181]	\[char181]	181	mu	u00B5	micro sign
\[char182]	\[char182]	182	paragraph	u00B6
\[char183]	\[char183]	183	periodcentered	u00B7
\[char184]	\[char184]	184	cedilla	u00B8
\[char185]	\[char185]	185	onesuperior	u00B9
\[char186]	\[char186]	186	ordmasculine	u00BA
\[char187]	\[char187]	187	guillemotright	u00BB
\[char188]	\[char188]	188	onequarter	u00BC
\[char189]	\[char189]	189	onehalf	u00BD
\[char190]	\[char190]	190	threequarters	u00BE
\[char191]	\[char191]	191	questiondown	u00BF
\[char192]	\[char192]	192	Agrave	u0041_0300
\[char193]	\[char193]	193	Aacute	u0041_0301
\[char194]	\[char194]	194	Acircumflex	u0041_0302
\[char195]	\[char195]	195	Atilde	u0041_0303
\[char196]	\[char196]	196	Adieresis	u0041_0308
\[char197]	\[char197]	197	Aring	u0041_030A
\[char198]	\[char198]	198	AE	u00C6
\[char199]	\[char199]	199	Ccedilla	u0043_0327
\[char200]	\[char200]	200	Egrave	u0045_0300
\[char201]	\[char201]	201	Eacute	u0045_0301
\[char202]	\[char202]	202	Ecircumflex	u0045_0302
\[char203]	\[char203]	203	Edieresis	u0045_0308
\[char204]	\[char204]	204	Igrave	u0049_0300
\[char205]	\[char205]	205	Iacute	u0049_0301
\[char206]	\[char206]	206	Icircumflex	u0049_0302
\[char207]	\[char207]	207	Idieresis	u0049_0308
\[char208]	\[char208]	208	Eth	u00D0
\[char209]	\[char209]	209	Ntilde	u004E_0303
\[char210]	\[char210]	210	Ograve	u004F_0300
\[char211]	\[char211]	211	Oacute	u004F_0301
\[char212]	\[char212]	212	Ocircumflex	u004F_0302
\[char213]	\[char213]	213	Otilde	u004F_0303
\[char214]	\[char214]	214	Odieresis	u004F_0308
\[char215]	\[char215]	215	multiply	u00D7
\[char216]	\[char216]	216	Oslash	u00D8
\[char217]	\[char217]	217	Ugrave	u0055_0300
\[char218]	\[char218]	218	Uacute	u0055_0301
\[char219]	\[char219]	219	Ucircumflex	u0055_0302
\[char220]	\[char220]	220	Udieresis	u0055_0308
\[char221]	\[char221]	221	Yacute	u0059_0301
\[char222]	\[char222]	222	Thorn	u00DE
\[char223]	\[char223]	223	germandbls	u00DF
\[char224]	\[char224]	224	agrave	u0061_0300
\[char225]	\[char225]	225	aacute	u0061_0301
\[char226]	\[char226]	226	acircumflex	u0061_0302
\[char227]	\[char227]	227	atilde	u0061_0303
\[char228]	\[char228]	228	adieresis	u0061_0308
\[char229]	\[char229]	229	aring	u0061_030A
\[char230]	\[char230]	230	ae	u00E6
\[char231]	\[char231]	231	ccedilla	u0063_0327
\[char232]	\[char232]	232	egrave	u0065_0300
\[char233]	\[char233]	233	eacute	u0065_0301
\[char234]	\[char234]	234	ecircumflex	u0065_0302
\[char235]	\[char235]	235	edieresis	u0065_0308
\[char236]	\[char236]	236	igrave	u0069_0300
\[char237]	\[char237]	237	iacute	u0069_0301
\[char238]	\[char238]	238	icircumflex	u0069_0302
\[char239]	\[char239]	239	idieresis	u0069_0308
\[char240]	\[char240]	240	eth	u00F0
\[char241]	\[char241]	241	ntilde	u006E_0303
\[char242]	\[char242]	242	ograve	u006F_0300
\[char243]	\[char243]	243	oacute	u006F_0301
\[char244]	\[char244]	244	ocircumflex	u006F_0302
\[char245]	\[char245]	245	otilde	u006F_0303
\[char246]	\[char246]	246	odieresis	u006F_0308
\[char247]	\[char247]	247	divide	u00F7
\[char248]	\[char248]	248	oslash	u00F8
\[char249]	\[char249]	249	ugrave	u0075_0300
\[char250]	\[char250]	250	uacute	u0075_0301
\[char251]	\[char251]	251	ucircumflex	u0075_0302
\[char252]	\[char252]	252	udieresis	u0075_0308
\[char253]	\[char253]	253	yacute	u0079_0301
\[char254]	\[char254]	254	thorn	u00FE
\[char255]	\[char255]	255	ydieresis	u0079_0308
.TE
.
.
.\" --------------------------------------------------------------------
.SS "Named Glyphs"
.\" --------------------------------------------------------------------
.
Glyph names can be embedded into the document text by using escape
sequences.
.
.BR groff (@MAN7EXT@)
describes how these escape sequences look.
.
Glyph names can consist of quite arbitrary characters from the
ASCII or \%latin1 code set, not only alphanumeric characters.
.
Here some examples:
.
.TP
\f(CW\e(\fP\fIch\fP
A glyph having the 2-character name
.IR ch .
.
.TP
\f(CW\e[\fP\,\fIchar_name\/\fP\f(CW]\fP
A glyph having the name
.I char_name
(having length 1, 2, 3, .\|.\|.).
.
Note that `\fIc\fP' is not the same as
`\f(CW\e[\fP\,\fIc\/\fP\f(CW]\fP' (\,\fIc\fP\ a single character):
The latter is internally mapped to glyph name `\e\fIc\fP'.
.
By default, groff defines a single glyph name starting with a backslash,
namely \%`\e-', which can be either accessed as `\f(CW\e\-\fP' or
`\f(CW\e[-]\fP'.
.
.TP
\f(CW\e[\fP\,\fIbase_glyph composite_1 composite_2 .\|.\|.\/\fP\f(CW]\fP
A composite glyph; see below for a more detailed description.
.
.
.P
In groff, each \%8-bit input character can also referred to by the construct
`\f(CW\e[char\fP\,\fIn\/\fP\f(CW]\fP' where
.I n
is the decimal code of the character, a number between 0 and\ 255
without leading zeros (those entities are
.I not
glyph names).
.
They are normally mapped onto glyphs using the \f(CW.trin\fP request.
.
Another special convention is the handling of glyphs with names directly
derived from a Unicode code point; this is discussed below.
.
Moreover, new glyph names can be created by the \f(CW.char\fP request; see
.BR groff (@MAN7EXT@).
.
.P
In the following, a plus sign in the `Notes' column indicates that this
particular glyph name appears in the PS version of the original troff
documentation, CSTR\ 54.
.
.P
Entries marked with `***' denote glyphs for mathematical purposes (mainly
used for DVI output).  Normally, such glyphs have metrics which make them
unusable in normal text.
.
.
.P
.TS
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[-D]	\e[-D]	Eth	u00D0	uppercase eth
\[Sd]	\e[Sd]	eth	u00F0	lowercase eth
\[TP]	\e[TP]	Thorn	u00DE	uppercase thorn
\[Tp]	\e[Tp]	thorn	u00FE	lowercase thorn
\[ss]	\e[ss]	germandbls	u00DF	German sharp s
.TE
.
.P
.I Ligatures and Other Latin Glyphs
.P
.TS
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[ff]	\e[ff]	ff	u0066_0066	ff ligature +
\[fi]	\e[fi]	fi	u0066_0069	fi ligature +
\[fl]	\e[fl]	fl	u0066_006C	fl ligature +
\[Fi]	\e[Fi]	ffi	u0066_0066_0069	ffi ligature +
\[Fl]	\e[Fl]	ffl	u0066_0066_006C	ffl ligature +
\[/L]	\e[/L]	Lslash	u0141	(Polish)
\[/l]	\e[/l]	lslash	u0142	(Polish)
\[/O]	\e[/O]	Oslash	u00D8	(Scandinavian)
\[/o]	\e[/o]	oslash	u00F8	(Scandinavian)
\[AE]	\e[AE]	AE	u00C6
\[ae]	\e[ae]	ae	u00E6
\[OE]	\e[OE]	OE	u0152
\[oe]	\e[oe]	oe	u0153
\[IJ]	\e[IJ]	IJ	u0132	(Dutch)
\[ij]	\e[ij]	ij	u0133	(Dutch)
\[.i]	\e[.i]	dotlessi	u0131	(Turkish)
\[.j]	\e[.j]	dotlessj	u0237	j without a dot
.TE
.
.P
.I Accented Characters
.P
.TS
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\['A]	\e['A]	Aacute	u0041_0301
\['C]	\e['C]	Cacute	u0043_0301
\['E]	\e['E]	Eacute	u0045_0301
\['I]	\e['I]	Iacute	u0049_0301
\['O]	\e['O]	Oacute	u004F_0301
\['U]	\e['U]	Uacute	u0055_0301
\['Y]	\e['Y]	Yacute	u0059_0301
\['a]	\e['a]	aacute	u0061_0301
\['c]	\e['c]	cacute	u0063_0301
\['e]	\e['e]	eacute	u0065_0301
\['i]	\e['i]	iacute	u0069_0301
\['o]	\e['o]	oacute	u006F_0301
\['u]	\e['u]	uacute	u0075_0301
\['y]	\e['y]	yacute	u0079_0301
\[:A]	\e[:A]	Adieresis	u0041_0308	A with umlaut
\[:E]	\e[:E]	Edieresis	u0045_0308
\[:I]	\e[:I]	Idieresis	u0049_0308
\[:O]	\e[:O]	Odieresis	u004F_0308
\[:U]	\e[:U]	Udieresis	u0055_0308
\[:Y]	\e[:Y]	Ydieresis	u0059_0308
\[:a]	\e[:a]	adieresis	u0061_0308
\[:e]	\e[:e]	edieresis	u0065_0308
\[:i]	\e[:i]	idieresis	u0069_0308
\[:o]	\e[:o]	odieresis	u006F_0308
\[:u]	\e[:u]	udieresis	u0075_0308
\[:y]	\e[:y]	ydieresis	u0079_0308
\[^A]	\e[^A]	Acircumflex	u0041_0302
\[^E]	\e[^E]	Ecircumflex	u0045_0302
\[^I]	\e[^I]	Icircumflex	u0049_0302
\[^O]	\e[^O]	Ocircumflex	u004F_0302
\[^U]	\e[^U]	Ucircumflex	u0055_0302
\[^a]	\e[^a]	acircumflex	u0061_0302
\[^e]	\e[^e]	ecircumflex	u0065_0302
\[^i]	\e[^i]	icircumflex	u0069_0302
\[^o]	\e[^o]	ocircumflex	u006F_0302
\[^u]	\e[^u]	ucircumflex	u0075_0302
\[`A]	\e[`A]	Agrave	u0041_0300
\[`E]	\e[`E]	Egrave	u0045_0300
\[`I]	\e[`I]	Igrave	u0049_0300
\[`O]	\e[`O]	Ograve	u004F_0300
\[`U]	\e[`U]	Ugrave	u0055_0300
\[`a]	\e[`a]	agrave	u0061_0300
\[`e]	\e[`e]	egrave	u0065_0300
\[`i]	\e[`i]	igrave	u0069_0300
\[`o]	\e[`o]	ograve	u006F_0300
\[`u]	\e[`u]	ugrave	u0075_0300
\[~A]	\e[~A]	Atilde	u0041_0303
\[~N]	\e[~N]	Ntilde	u004E_0303
\[~O]	\e[~O]	Otilde	u004F_0303
\[~a]	\e[~a]	atilde	u0061_0303
\[~n]	\e[~n]	ntilde	u006E_0303
\[~o]	\e[~o]	otilde	u006F_0303
\[vS]	\e[vS]	Scaron	u0053_030C
\[vs]	\e[vs]	scaron	u0073_030C
\[vZ]	\e[vZ]	Zcaron	u005A_030C
\[vz]	\e[vz]	zcaron	u007A_030C
\[,C]	\e[,C]	Ccedilla	u0043_0327
\[,c]	\e[,c]	ccedilla	u0063_0327
\[oA]	\e[oA]	Aring	u0041_030A
\[oa]	\e[oa]	aring	u0061_030A
.TE
.
.P
.I Accents
.P
The
.B composite
request is used to map most of the accents to non-spacing glyph names;
the values given in parentheses are the original (spacing) ones.
.
.P
.TS
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[a"]	\e[a"]	hungarumlaut	u030B (u02DD)	(Hungarian)
\[a-]	\e[a-]	macron	u0304 (u00AF)
\[a.]	\e[a.]	dotaccent	u0307 (u02D9)
\[a^]	\e[a^]	circumfle	u0302 (u005E)
\[aa]	\e[aa]	acute	u0301 (u00B4)	+
\[ga]	\e[ga]	grave	u0300 (u0060)	+
\[ab]	\e[ab]	breve	u0306 (u02D8)
\[ac]	\e[ac]	cedilla	u0327 (u00B8)
\[ad]	\e[ad]	dieresis	u0308 (u00A8)	umlaut
\[ah]	\e[ah]	caron	u030C (u02C7)
\[ao]	\e[ao]	ring	u030A (u02DA)	circle
\[a~]	\e[a~]	tilde	u0303 (u007E)
\[ho]	\e[ho]	ogonek	u0328 (u02DB)	hook
\[ha]	\e[ha]	asciicircum	u005E	(spacing)
\[ti]	\e[ti]	asciitilde	u007E	(spacing)
.TE
.
.P
.I Quotes
.P
.TS
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[Bq]	\e[Bq]	quotedblbase	u201E	low double comma quote
\[bq]	\e[bq]	quotesinglbase	u201A	low single comma quote
\[lq]	\e[lq]	quotedblleft	u201C
\[rq]	\e[rq]	quotedblright	u201D
\[oq]	\e[oq]	quoteleft	u2018	single open quote
\[cq]	\e[cq]	quoteright	u2019	single closing quote
\[aq]	\e[aq]	quotesingle	u0027	apostrophe quote (ASCII 39)
\[dq]	\e[dq]	quotedbl	u0022	double quote (ASCII 34)
\[Fo]	\e[Fo]	guillemotleft	u00AB
\[Fc]	\e[Fc]	guillemotright	u00BB
\[fo]	\e[fo]	guilsinglleft	u2039
\[fc]	\e[fc]	guilsinglright	u203A
.TE
.
.P
.I Punctuation
.P
.TS
l l l l l.
Output	Input	PostScript	Unicode Notes
_
\[r!]	\e[r!]	exclamdown	u00A1
\[r?]	\e[r?]	questiondown	u00BF
\[em]	\e[em]	emdash	u2014	+
\[en]	\e[en]	endash	u2013
\[hy]	\e[hy]	hyphen	u2010	+
.TE
.
.P
.I Brackets
.P
The extensible bracket pieces are font-invariant glyphs.
.
In classical troff only one glyph was available to vertically extend
brackets, braces, and parentheses: `bv'.
.
We map it rather arbitrarily to u23AA.
.
.P
Note that not all devices contain extensible bracket pieces which can
be piled up with `\f(CW\eb\fP' due to the restrictions of the escape's
piling algorithm.
.
A general solution to build brackets out of pieces is the following
macro:
.
.P
.nf
.RS
.ft C
\&.\e" Make a pile centered vertically 0.5em
\&.\e" above the baseline.
\&.\e" The first argument is placed at the top.
\&.\e" The pile is returned in string `pile'
\&.eo
\&.de pile-make
\&.  nr pile-wd 0
\&.  nr pile-ht 0
\&.  ds pile-args
\&.
\&.  nr pile-# \en[.$]
\&.  while \en[pile-#] \e{\e
\&.    nr pile-wd (\en[pile-wd] >? \ew'\e$[\en[pile-#]]')
\&.    nr pile-ht +(\en[rst] - \en[rsb])
\&.    as pile-args \ev'\en[rsb]u'\e"
\&.    as pile-args \eZ'\e$[\en[pile-#]]'\e"
\&.    as pile-args \ev'-\en[rst]u'\e"
\&.    nr pile-# -1
\&.  \e}
\&.
\&.  ds pile \ev'(-0.5m + (\en[pile-ht]u / 2u))'\e"
\&.  as pile \e*[pile-args]\e"
\&.  as pile \ev'((\en[pile-ht]u / 2u) + 0.5m)'\e"
\&.  as pile \eh'\en[pile-wd]u'\e"
\&..
\&.ec
.ft
.RE
.fi
.
.P
Another complication is the fact that some glyphs which represent bracket
pieces in original troff can be used for other mathematical symbols also,
for example `lf' and `rf' which provide the `floor' operator.
.
Other devices (most notably for DVI output) don't unify such glyphs.
.
For this reason, the four glyphs `lf', `rf', `lc', and `rc' are not
unified with similarly looking bracket pieces.
.
In
.BR groff ,
only glyphs with long names are guaranteed to pile up correctly for all
devices (provided those glyphs exist).
.
.P

.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[lB]	\e[lB]	bracketleft	u005B
\[rB]	\e[rB]	bracketright	u005D
\[lC]	\e[lC]	braceleft	u007B
\[rC]	\e[rC]	braceright	u007D
\[la]	\e[la]	angleleft	u27E8	left angle bracket
\[ra]	\e[ra]	angleright	u27E9	right angle bracket

\[bv]	\e[bv]	braceex	u23AA	vertical extension *** +
\[braceex]	\e[braceex]	braceex	u23AA

\[bracketlefttp]	\e[bracketlefttp]	bracketlefttp	u23A1
\[bracketleftbt]	\e[bracketleftbt]	bracketleftbt	u23A3
\[bracketleftex]	\e[bracketleftex]	bracketleftex	u23A2
\[bracketrighttp]	\e[bracketrighttp]	bracketrighttp	u23A4
\[bracketrightbt]	\e[bracketrightbt]	bracketrightbt	u23A6
\[bracketrightex]	\e[bracketrightex]	bracketrightex	u23A5

\[lt]	\e[lt]	bracelefttp	u23A7	+
\[bracelefttp]	\e[bracelefttp]	bracelefttp	u23A7
\[lk]	\e[lk]	braceleftmid	u23A8	+
\[braceleftmid]	\e[braceleftmid]	braceleftmid	u23A8
\[lb]	\e[lb]	braceleftbt	u23A9	+
\[braceleftbt]	\e[braceleftbt]	braceleftbt	u23A9
\[braceleftex]	\e[braceleftex]	braceleftex	u23AA
\[rt]	\e[rt]	bracerighttp	u23AB	+
\[bracerighttp]	\e[bracerighttp]	bracerighttp	u23AB
\[rk]	\e[rk]	bracerightmid	u23AC	+
\[bracerightmid]	\e[bracerightmid]	bracerightmid	u23AC
\[rb]	\e[rb]	bracerightbt	u23AD	+
\[bracerightbt]	\e[bracerightbt]	bracerightbt	u23AD
\[bracerightex]	\e[bracerightex]	bracerightex	u23AA
.
\[parenlefttp]	\e[parenlefttp]	parenlefttp	u239B
\[parenleftbt]	\e[parenleftbt]	parenleftbt	u239D
\[parenleftex]	\e[parenleftex]	parenleftex	u239C
\[parenrighttp]	\e[parenrighttp]	parenrighttp	u239E
\[parenrightbt]	\e[parenrightbt]	parenrightbt	u23A0
\[parenrightex]	\e[parenrightex]	parenrightex	u239F
.TE
.
.P
.I Arrows
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[<-]	\e[<-]	arrowleft	u2190	+
\[->]	\e[->]	arrowright	u2192	+
\[<>]	\e[<>]	arrowboth	u2194	(horizontal)
\[da]	\e[da]	arrowdown	u2193	+
\[ua]	\e[ua]	arrowup	u2191	+
\[va]	\e[va]	arrowupdn	u2195
\[lA]	\e[lA]	arrowdblleft	u21D0
\[rA]	\e[rA]	arrowdblright	u21D2
\[hA]	\e[hA]	arrowdblboth	u21D4	(horizontal)
\[dA]	\e[dA]	arrowdbldown	u21D3
\[uA]	\e[uA]	arrowdblup	u21D1
\[vA]	\e[vA]	uni21D5	u21D5	vertical double-headed double arrow
\[an]	\e[an]	arrowhorizex	u23AF	horizontal arrow extension
.TE
.
.P
.I Lines
.P
The font-invariant glyphs `br', `ul', and `rn' form corners;
they can be used to build boxes.
.
Note that both the PostScript and the Unicode-derived names of
these three glyphs are just rough approximations.
.
.P
`rn' also serves in classical troff as the horizontal extension of the
square root sign.
.
.P
`ru' is a font-invariant glyph, namely a rule of length 0.5m.
.
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[ba]	\e[ba]	bar	u007C 
\[br]	\e[br]	SF110000	u2502	box rule +
\[ul]	\e[ul]	underscore	u005F	+
\[rn]	\e[rn]	overline	u203E	+
\[ru]	\e[ru]	---	---	baseline rule +
\[bb]	\e[bb]	brokenbar	u00A6
\[sl]	\e[sl]	slash	u002F	+
\[rs]	\e[rs]	backslash	u005C	reverse solidus
.TE
.P
Use `\f(CW\e[radicalex]\fP', not `\f(CW\e[overline]\fP', for
continuation of square root.
.
.P
.I Text markers
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[ci]	\e[ci]	circle	u25CB	+
\[bu]	\e[bu]	bullet	u2022	+
\[dd]	\e[dd]	daggerdbl	u2021	double dagger sign +
\[dg]	\e[dg]	dagger	u2020	+
\[lz]	\e[lz]	lozenge	u25CA
\[sq]	\e[sq]	uni25A1	u25A1	white square +
\[ps]	\e[ps]	paragraph	u00B6
\[sc]	\e[sc]	section	u00A7	+
\[lh]	\e[lh]	uni261C	u261C	hand pointing left +
\[rh]	\e[rh]	a14	u261E	hand pointing right +
\[at]	\e[at]	at	u0040
\[sh]	\e[sh]	numbersign	u0023
\[CR]	\e[CR]	carriagereturn	u21B5
\[OK]	\e[OK]	a19	u2713	check mark, tick
.TE
.
.P
.I Legal Symbols
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[co]	\e[co]	copyright	u00A9	+
\[rg]	\e[rg]	registered	u00AE	+
\[tm]	\e[tm]	trademark	u2122
\[bs]	\e[bs]	---	---	AT&T Bell Labs logo +
.TE
.P
The Bell Labs logo is not supported in groff.
.
.P
.I Currency symbols
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[Do]	\e[Do]	dollar	u0024
\[ct]	\e[ct]	cent	u00A2	+
\[eu]	\e[eu]	---	u20AC	official Euro symbol
\[Eu]	\e[Eu]	Euro	u20AC	font-specific Euro glyph variant
\[Ye]	\e[Ye]	yen	u00A5
\[Po]	\e[Po]	sterling	u00A3	British currency sign
\[Cs]	\e[Cs]	currency	u00A4	Scandinavian currency sign
\[Fn]	\e[Fn]	florin	u0192	Dutch currency sign
.TE
.
.P
.I Units
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[de]	\e[de]	degree	u00B0	+
\[%0]	\e[%0]	perthousand	u2030	per thousand, per mille sign
\[fm]	\e[fm]	minute	u2032	footmark, prime +
\[sd]	\e[sd]	second	u2033
\[mc]	\e[mc]	mu	u00B5	micro sign
\[Of]	\e[Of]	ordfeminine	u00AA
\[Om]	\e[Om]	ordmasculine	u00BA
.TE
.
.P
.I Logical Symbols
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[AN]	\e[AN]	logicaland	u2227
\[OR]	\e[OR]	logicalor	u2228
\[no]	\e[no]	logicalnot	u00AC	+
\[tno]	\e[tno]	logicalnot	u00AC	text variant of `no'
\[te]	\e[te]	existential	u2203	there exists
\[fa]	\e[fa]	universal	u2200	for all
\[st]	\e[st]	suchthat	u220B
\[3d]	\e[3d]	therefore	u2234
\[tf]	\e[tf]	therefore	u2234
\[or]	\e[or]	bar	u007C	bitwise OR operator (as used in C) +
.TE
.
.P
.I Mathematical Symbols
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[12]	\e[12]	onehalf	u00BD	+
\[14]	\e[14]	onequarter	u00BC	+
\[34]	\e[34]	threequarters	u00BE	+
\[18]	\e[18]	oneeighth	u215B
\[38]	\e[38]	threeeighths	u215C
\[58]	\e[58]	fiveeighths	u215D
\[78]	\e[78]	seveneighths	u215E
\[S1]	\e[S1]	onesuperior	u00B9
\[S2]	\e[S2]	twosuperior	u00B2
\[S3]	\e[S3]	threesuperior	u00B3

\[pl]	\e[pl]	plus	u002B	plus in special font +
\[mi]	\e[mi]	minus	u2212	minus in special font +
\[-+]	\e[-+]	uni2213	u2213
\[+-]	\e[+-]	plusminus	u00B1	+
\[t+-]	\e[t+-]	plusminus	u00B1	text variant of `+\-'
\[pc]	\e[pc]	periodcentered	u00B7
\[md]	\e[md]	dotmath	u22C5	multiplication dot
\[mu]	\e[mu]	multiply	u00D7	+
\[tmu]	\e[tmu]	multiply	u00D7	text variant of `mu'
\[c*]	\e[c*]	circlemultiply	u2297	multiply sign in a circle
\[c+]	\e[c+]	circleplus	u2295	plus in a circle
\[di]	\e[di]	divide	u00F7	division +
\[tdi]	\e[tdi]	divide	u00F7	text variant of `di'
\[f/]	\e[f/]	fraction	u2044	bar for fractions
\[**]	\e[**]	asteriskmath	u2217	+

\[<=]	\e[<=]	lessequal	u2264	+
\[>=]	\e[>=]	greaterequal	u2265	+
\[<<]	\e[<<]	uni226A	u226A	much less
\[>>]	\e[>>]	uni226B	u226B	much greater
\[eq]	\e[eq]	equal	u003D	equals in special font +
\[!=]	\e[!=]	notequal	u003D_0338	+
\[==]	\e[==]	equivalence	u2261	+
\[ne]	\e[ne]	uni2262	u2261_0338
\[=~]	\e[=~]	congruent	u2245	approx.\& equal
\[|=]	\e[|=]	uni2243	u2243	asymptot.\& equal to +
\[ap]	\e[ap]	similar	u223C	+
\[~~]	\e[~~]	approxequal	u2248	almost equal to
\[~=]	\e[~=]	approxequal	u2248
\[pt]	\e[pt]	proportional	u221D	+

\[es]	\e[es]	emptyset	u2205	+
\[mo]	\e[mo]	element	u2208	+
\[nm]	\e[nm]	notelement	u2208_0338
\[sb]	\e[sb]	propersubset	u2282	+
\[nb]	\e[nb]	notsubset	u2282_0338
\[sp]	\e[sp]	propersuperset	u2283	+
\[nc]	\e[nc]	uni2285	u2283_0338	not superset
\[ib]	\e[ib]	reflexsubset	u2286	+
\[ip]	\e[ip]	reflexsuperset	u2287	+
\[ca]	\e[ca]	intersection	u2229	intersection, cap +
\[cu]	\e[cu]	union	u222A	union, cup +

\[/_]	\e[/_]	angle	u2220
\[pp]	\e[pp]	perpendicular	u22A5
\[is]	\e[is]	integral	u222B	+
\[integral]	\e[integral]	integral	u222B	***
\[sum]	\e[sum]	summation	u2211	***
\[product]	\e[product]	product	u220F	***
\[coproduct]	\e[coproduct]	uni2210	u2210	***
\[gr]	\e[gr]	gradient	u2207	+
\[sr]	\e[sr]	radical	u221A	square root +
\[sqrt]	\e[sqrt]	radical	u221A	***
\[radicalex]	\e[radicalex]	radicalex	---	square root continuation
\[sqrtex]	\e[sqrtex]	radicalex	---	***

\[lc]	\e[lc]	uni2308	u2308	left ceiling +
\[rc]	\e[rc]	uni2309	u2309	right ceiling +
\[lf]	\e[lf]	uni230A	u230A	left floor +
\[rf]	\e[rf]	uni230B	u230B	right floor +

\[if]	\e[if]	infinity	u221E	+
\[Ah]	\e[Ah]	aleph	u2135
\[Im]	\e[Im]	Ifraktur	u2111	Gothic I, imaginary
\[Re]	\e[Re]	Rfraktur	u211C	Gothic R, real
\[wp]	\e[wp]	weierstrass	u2118	Weierstrass p
\[pd]	\e[pd]	partialdiff	u2202	partial differentiation +
\[-h]	\e[-h]	uni210F	u210F	Planck constant / 2pi
\[hbar]	\e[hbar]	uni210F	u210F
.TE
.
.P
.I Greek glyphs
.P
These glyphs are intended for technical use, not for real Greek; normally,
the uppercase letters have upright shape, and the lowercase ones are
slanted.
.
There is a problem with the mapping of letter phi to Unicode.
.
Prior to Unicode version\ 3.0, the difference between U+03C6, GREEK
SMALL LETTER PHI, and U+03D5, GREEK PHI SYMBOL, was not clearly described;
only the glyph shapes in the Unicode book could be used as a reference.
.
Starting with Unicode\ 3.0, the reference glyphs have been exchanged and
described verbally also: In mathematical context, U+03D5 is the stroked
variant and U+03C6 the curly glyph.
.
Unfortunately, most font vendors didn't update their fonts to
this (incompatible) change in Unicode.
.
At the time of this writing (January 2006), it is not clear yet whether
the Adobe Glyph Names `phi' and `phi1' also change its meaning if used for
mathematics, thus compatibility problems are likely to happen \(en being
conservative, groff currently assumes that `phi' in a PostScript symbol
font is the stroked version.
.P
In groff, symbol `\f(CW\e[*f]\fP' always denotes the stroked version of
phi, and `\f(CW\e[+f]\fP' the curly variant.
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[*A]	\e[*A]	Alpha	u0391	+
\[*B]	\e[*B]	Beta	u0392	+
\[*G]	\e[*G]	Gamma	u0393	+
\[*D]	\e[*D]	Delta	u0394	+
\[*E]	\e[*E]	Epsilon	u0395	+
\[*Z]	\e[*Z]	Zeta	u0396	+
\[*Y]	\e[*Y]	Eta	u0397	+
\[*H]	\e[*H]	Theta	u0398	+
\[*I]	\e[*I]	Iota	u0399	+
\[*K]	\e[*K]	Kappa	u039A	+
\[*L]	\e[*L]	Lambda	u039B	+
\[*M]	\e[*M]	Mu	u039C	+
\[*N]	\e[*N]	Nu	u039D	+
\[*C]	\e[*C]	Xi	u039E	+
\[*O]	\e[*O]	Omicron	u039F	+
\[*P]	\e[*P]	Pi	u03A0	+
\[*R]	\e[*R]	Rho	u03A1	+
\[*S]	\e[*S]	Sigma	u03A3	+
\[*T]	\e[*T]	Tau	u03A4	+
\[*U]	\e[*U]	Upsilon	u03A5	+
\[*F]	\e[*F]	Phi	u03A6	+
\[*X]	\e[*X]	Chi	u03A7	+
\[*Q]	\e[*Q]	Psi	u03A8	+
\[*W]	\e[*W]	Omega	u03A9	+
\[*a]	\e[*a]	alpha	u03B1	+
\[*b]	\e[*b]	beta	u03B2	+
\[*g]	\e[*g]	gamma	u03B3	+
\[*d]	\e[*d]	delta	u03B4	+
\[*e]	\e[*e]	epsilon	u03B5	+
\[*z]	\e[*z]	zeta	u03B6	+
\[*y]	\e[*y]	eta	u03B7	+
\[*h]	\e[*h]	theta	u03B8	+
\[*i]	\e[*i]	iota	u03B9	+
\[*k]	\e[*k]	kappa	u03BA	+
\[*l]	\e[*l]	lambda	u03BB	+
\[*m]	\e[*m]	mu	u03BC	+
\[*n]	\e[*n]	nu	u03BD	+
\[*c]	\e[*c]	xi	u03BE	+
\[*o]	\e[*o]	omicron	u03BF	+
\[*p]	\e[*p]	pi	u03C0	+
\[*r]	\e[*r]	rho	u03C1	+
\[ts]	\e[ts]	sigma1	u03C2	terminal sigma +
\[*s]	\e[*s]	sigma	u03C3	+
\[*t]	\e[*t]	tau	u03C4	+
\[*u]	\e[*u]	upsilon	u03C5	+
\[*f]	\e[*f]	phi	u03D5	(stroked glyph) +
\[*x]	\e[*x]	chi	u03C7	+
\[*q]	\e[*q]	psi	u03C8	+
\[*w]	\e[*w]	omega	u03C9	+
\[+h]	\e[+h]	theta1	u03D1	variant theta
\[+f]	\e[+f]	phi1	u03C6	variant phi (curly shape)
\[+p]	\e[+p]	omega1	u03D6	variant pi, looking like omega
\[+e]	\e[+e]	uni03F5	u03F5	variant epsilon
.TE
.
.P
.I Card symbols
.P
.TS
expand;
l l l l l.
Output	Input	PostScript	Unicode	Notes
_
\[CL]	\e[CL]	club	u2663	black club suit
\[SP]	\e[SP]	spade	u2660	black spade suit
\[HE]	\e[HE]	heart	u2665	black heart suit
\[u2661]	\e[u2661]	uni2661	u2661	white heart suit
\[DI]	\e[DI]	diamond	u2666	black diamond suit
\[u2662]	\e[u2662]	uni2662	u2662	white diamond suit
.TE
.
.
.\" --------------------------------------------------------------------
.SH "AUTHOR"
.\" --------------------------------------------------------------------
.
Copyright \(co 1989\-2004, 2006\-2009, 2012 Free Software Foundation, Inc.
.
.P
This document is distributed under the terms of the FDL (GNU Free
Documentation License) version 1.3 or later.
.
You should have received a copy of the FDL on your system, it is also
available on-line at the
.UR http://\:www.gnu.org/\:copyleft/\:fdl.html
GNU copyleft site
.UE .
.
.P
This document is part of
.IR groff ,
the GNU roff distribution.
.
It was written by
.MT jjc@jclark.com
James Clark
.ME
with additions by
.MT wl@gnu.org
Werner Lemberg
.ME
and
.MT bwarken@mayn.de
Bernd Warken
.ME .
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
.TP
.BR groff (@MAN1EXT@)
the GNU roff formatter
.
.TP
.BR groff (@MAN7EXT@)
a short reference of the groff formatting language
.
.
.P
.IR "An extension to the troff character set for Europe" ,
E.G.\& Keizer, K.J.\& Simonsen, J.\& Akkerhuis; EUUG Newsletter, Volume 9,
No.\& 2, Summer 1989
.
.
.P
.UR http://\:www.unicode.org
The Unicode Standard
.UE
.
.cp \n[groff_char_C]
.
.\" --------------------------------------------------------------------
.\" Emacs settings
.\" --------------------------------------------------------------------
.\" Local Variables:
.\" mode: nroff
.\" tab-width: 20
.\" End:
