#ifndef GRAIL_FIXTURE_H
#define GRAIL_FIXTURE_H

#include <gtest/gtest.h>
#include <oif/grail.h>
#include "frame_mock.h"

#include <list>
#include <set>

class GrailGesture
{
  public:
  bool HasTouch(UFTouchId touch_id) const
  {
    return touches.find(touch_id) != touches.end();
  }
  unsigned int id;
  std::set<UFTouchId> touches;
  bool construction_finished;
  UGGestureState state;
};

class GrailTest : public ::testing::Test
{
  public:
  virtual void SetUp()
  {
    grail_handle = NULL;
    FillFakeDeviceStruct();
  }

  virtual void TearDown()
  {
    if (grail_handle)
      grail_delete_v3(grail_handle);
  }

  protected:

  UGSubscription CreateSubscription(unsigned int num_touches,
      UGGestureTypeMask gesture_mask, UFDevice device, UFWindowId window_id);

  void FillFakeDeviceStruct();
  void SendDeviceAddedEvent();
  void SendFrameEvent(
      uint64_t time,
      UFWindowId window_id,
      const struct UFTouch_ &touch_struct);
  void SendFrameEvent(
      uint64_t time,
      UFWindowId window_id,
      std::vector<struct UFTouch_> &touches);
  void SendDeviceAddedEvent(uint64_t time);

  void BeginTouch(int touch_id);
  void BeginTouchWindowCoords(int touch_id, float window_x, float window_y);
  void GiveTouchOwnership(int touch_id);
  void SetTouchWindowCoords(int touch_id, float window_x, float window_y);
  /* Updates the time of all touches in the "touches" vector and sends that vector
     in a frame event to grail */
  void UpdateTouches();
  void EndTouch(int touch_id);
  std::vector<struct UFTouch_>::iterator FindTouch(unsigned int touch_id);

  /* Fetches and processes all pending grail events, updating grail_gestures
     list accordingly. */
  void ProcessGrailEvents();
  GrailGesture *GestureWithId(unsigned int id);

  /* Helper function for debugging purposes.
     Prints all gestures in grail's queue.
   */
  void PrintPendingGestures();
  void PrintSlice(UGSlice slice);

  UGHandle grail_handle;
  std::shared_ptr<struct UFDevice_> device_ptr;

  uint64_t time;
  UFWindowId fake_window_id;
  std::vector<struct UFTouch_> touches;

  /*
    A representation of the currently active gestures according to the grail events
    fetched by ProcessGrailEvents()
   */
  std::list<GrailGesture> grail_gestures;

  private:
  void ProcessSlice(UGSlice slice);
  void AddNewGesture(UGSlice slice);
  void UpdateGesture(UGSlice slice);
  void EndGesture(UGSlice slice);
};

#endif // GRAIL_FIXTURE
