/* Copyright (C) 2004 Bart
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 
#include "../include/linux_swap.h"

namespace GParted
{

FS linux_swap::get_filesystem_support()
{
	FS fs ;
	fs .filesystem = GParted::FS_LINUX_SWAP ;
	
	if ( ! Glib::find_program_in_path( "mkswap" ) .empty() )
	{
		fs .create = GParted::FS::EXTERNAL ;
		fs .grow = GParted::FS::EXTERNAL ;
		fs .shrink = GParted::FS::EXTERNAL ;
	}
	
	fs .copy = GParted::FS::GPARTED ;
	fs .move = GParted::FS::GPARTED ;
	
	return fs ;
}

void linux_swap::set_used_sectors( Partition & partition ) 
{
}

void linux_swap::get_label( Partition & partition )
{
}

bool linux_swap::create( const Partition & new_partition, OperationDetail & operationdetail )
{
	return ! execute_command( "mkswap " + new_partition .get_path(), operationdetail ) ;
}

bool linux_swap::resize( const Partition & partition_new, OperationDetail & operationdetail, bool fill_partition )
{
	operationdetail .add_child( OperationDetail( 
		String::ucompose( _("create new %1 filesystem"), Utils::get_filesystem_string( FS_LINUX_SWAP ) ) ) ) ;
	if ( create( partition_new, operationdetail .get_last_child() ) ) 
	{
		operationdetail .get_last_child() .set_status( STATUS_SUCCES ) ;
		return true ;
	}
	else
	{
		operationdetail .get_last_child() .set_status( STATUS_ERROR ) ;
		return false ;
	}
}

bool linux_swap::copy( const Glib::ustring & src_part_path,
		       const Glib::ustring & dest_part_path,
		       OperationDetail & operationdetail )
{
	return true ;
}

bool linux_swap::check_repair( const Partition & partition, OperationDetail & operationdetail )
{
	return true ;
}

} //GParted
