
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_epg.h>

#include "common.h"

static          gboolean
test_epg_connection(GMythBackendInfo * backend_info)
{
    GMythEPG       *epg = gmyth_epg_new();
    gboolean        res = FALSE;

    res = gmyth_epg_connect(epg, backend_info);

    gmyth_epg_disconnect(epg);
    if (epg != NULL)
        g_object_unref(epg);

    return res;
}


static          gboolean
test_epg_get_channels(GMythBackendInfo * backend_info)
{
    GMythEPG       *epg = gmyth_epg_new();
    GList          *clist;
    gint            i,
                    length;

    if (!gmyth_epg_connect(epg, backend_info)) {
        return FALSE;
    }

    length = gmyth_epg_get_channel_list(epg, &clist);
    g_debug("==== %d channels found in the EPG ====\n", length);
    for (i = 0; i < length; i++) {
        GMythChannelInfo *channel_info =
            (GMythChannelInfo *) g_list_nth_data(clist, i);

        gmyth_channel_info_print(channel_info);
    }

    g_list_free(clist);
    gmyth_epg_disconnect(epg);
    if (epg != NULL)
        g_object_unref(epg);
}

static          gboolean
test_epg_get_channel_icon(GMythBackendInfo * backend_info)
{
    GMythEPG       *epg = gmyth_epg_new();
    GList          *clist;
    gint            i,
                    length;

    if (!gmyth_epg_connect(epg, backend_info)) {
        return FALSE;
    }

    length = gmyth_epg_get_channel_list(epg, &clist);
    g_debug("==== %d channels found in the EPG ====\n", length);
    for (i = 0; i < length; i++) {
        GMythChannelInfo *channel_info =
            (GMythChannelInfo *) g_list_nth_data(clist, i);

        if (gmyth_epg_channel_has_icon(epg, channel_info)) {
            gchar          *icon_name =
                g_strdup_printf("%s.jpg", channel_info->channel_name->str);
            guint8         *icon_data = NULL;
            guint           icon_length;

            g_debug("Channel %s has icon %s\n",
                    channel_info->channel_name->str,
                    channel_info->channel_icon->str);

            if (gmyth_epg_channel_get_icon
                (epg, channel_info, &icon_data, &icon_length)) {
                FILE           *outfile = fopen(icon_name, "w+");
                if (fwrite(icon_data, icon_length, 1, outfile) ==
                    icon_length)
                    g_debug("\tIcon saved as %s", icon_name);
                else
                    g_debug
                        ("\tError while downloading the file or writing it");

                g_free(icon_data);
            }
            g_free(icon_name);

        } else {
            g_debug("Channel %s does not have icon\n",
                    channel_info->channel_name->str);
        }
        gmyth_channel_info_print(channel_info);
    }

    g_list_free(clist);
    gmyth_epg_disconnect(epg);
    g_object_unref(epg);

    return TRUE;
}

int
main(int args, const char **argv)
{

    GMythBackendInfo *backend_info;
    g_type_init();
    g_thread_init(NULL);

    if (args < 2) {
        g_debug("Type %s myth://hostname:port/?mythconverg\n", argv[0]);
        return -1;
    }

    backend_info = gmyth_backend_info_new_with_uri(argv[1]);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    test_epg_connection(backend_info);
    test_epg_get_channels(backend_info);
    test_epg_get_channel_icon(backend_info);

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return (0);
}
