#!/usr/bin/python

import re
import sys
import os
import shutil
from testing_tools import is_coverage, get_gcda

def build_dir(exe):
    t = get_gcda(exe)
    a = re.search("(/.*)/tests/.*" ,t)
    print "GMyth base build directory - %s" % a.groups()[0]
    return a.groups()[0]

def remove_all_gcov_info(base_dir):
    os.system('for gfile in `find ' + base_dir + ' -name \"*.gcov\" -print`; do rm -f $gfile; done')

def gen_cov_info(build_dir):
    # remove all the useless GCOV information
    remove_all_gcov_info(build_dir)
    if os.path.exists('coverage'):
        shutil.rmtree('coverage')
    os.mkdir('coverage')
    os.chdir('coverage')
    #base_dir = '../' + os.environ['top_srcdir'] + '/src'
    #base_dir = build_dir + '/tests'
    os.system('lcov -d ' + build_dir + '/src -b ' + build_dir + '/src --compat-libtool -z')
    os.system('lcov -d ' + build_dir + '/src -b ' + build_dir + '/src --compat-libtool -c -o gmyth.info')
    #os.system('lcov -d ' + build_dir + ' -z')
    #os.system('lcov -d ' + build_dir + ' -c -o gmyth.info')
    os.system('genhtml gmyth.info')

exe = 'gmyth_test_connection'
exe = [ '.libs/' + exe ]
if is_coverage(exe):
    bdir = build_dir(exe)
    gen_cov_info(bdir)
sys.exit(0)
