/**
 * GMyth Library
 *
 * @file gmyth/gmyth_uri.h
 * 
 * @brief <p> GMythURI utils
 *  - Extracts and parses a URI char string, in according with the RFC 2396 
 *    [http://www.ietf.org/rfc/rfc2396.txt]
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GMYTH_URI_H_
#define _GMYTH_URI_H_

#include <glib.h>
#include <glib-object.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

G_BEGIN_DECLS
#define GMYTH_URI_TYPE               (gmyth_uri_get_type ())
#define GMYTH_URI(obj)          		 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_URI_TYPE, GMythURI))
#define GMYTH_URI_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_URI_TYPE, GMythURIClass))
#define IS_GMYTH_URI(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_URI_TYPE))
#define IS_GMYTH_URI_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_URI_TYPE))
#define GMYTH_URI_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_URI_TYPE, GMythURIClass))
typedef struct _GMythURI GMythURI;
typedef struct _GMythURIClass GMythURIClass;


    /****************************************
	 * Data Type
	 ****************************************/

struct _GMythURIClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
    /*
     * no one for now 
     */
};

struct _GMythURI {

    GObject         parent;

    GString        *uri;
    GString        *host;
    gint            port;
    GString        *protocol;
    GString        *path;
    GString        *fragment;
    GString        *user;
    GString        *password;
    GString        *query;

};

GType           gmyth_uri_get_type(void);
GMythURI       *gmyth_uri_new(void);
GMythURI       *gmyth_uri_new_with_value(const gchar * value);
gboolean        gmyth_uri_is_equals(GMythURI * uri1, GMythURI * uri2);
gboolean        gmyth_uri_is_livetv(GMythURI * uri);
gint            gmyth_uri_get_channel_num(GMythURI * uri);
gchar          *gmyth_uri_get_channel_name(GMythURI * uri);
char           *gmyth_uri_to_string(const GMythURI * uri);
gboolean        gmyth_uri_is_local_file(const GMythURI * uri);

#define 	gmyth_uri_get_host(urip) 			( urip->host != NULL ? urip->host->str : "" )
#define 	gmyth_uri_get_port(urip) 			( urip->port )
#define 	gmyth_uri_get_protocol(urip) 	( urip->protocol != NULL ? urip->protocol->str : "" )
#define 	gmyth_uri_get_path(urip) 			( urip->path != NULL ? urip->path->str : "" )
#define 	gmyth_uri_get_user(urip) 			( urip->user != NULL ? urip->user->str : "" )
#define    	gmyth_uri_get_password(urip) 	( urip->password != NULL ? urip->password->str : "" )
#define 	gmyth_uri_get_fragment(urip) 	( urip->fragment != NULL ? urip->fragment->str : "" )
#define 	gmyth_uri_get_query(urip) 		( urip->query != NULL ? urip->query->str : "" )

G_END_DECLS
#endif                          /* _GMYTH_URI_H_ */
