/**
 * GMyth Library
 *
 * @file gmyth/gmyth_monitor_handler.h
 * 
 * @brief <p> GMythMonitorHandler deals with the streaming media events remote/local
 * that are sent to the MythTV frontend.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Lins Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_MONITOR_HANDLER_H__
#define __GMYTH_MONITOR_HANDLER_H__

#include <glib-object.h>
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

#include "gmyth_socket.h"
#include "gmyth_uri.h"

G_BEGIN_DECLS
#define GMYTH_MONITOR_HANDLER_TYPE               (gmyth_monitor_handler_get_type ())
#define GMYTH_MONITOR_HANDLER(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_MONITOR_HANDLER_TYPE, GMythMonitorHandler))
#define GMYTH_MONITOR_HANDLER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_MONITOR_HANDLER_TYPE, GMythMonitorHandlerClass))
#define IS_GMYTH_MONITOR_HANDLER(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_MONITOR_HANDLER_TYPE))
#define IS_GMYTH_MONITOR_HANDLER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_MONITOR_HANDLER_TYPE))
#define GMYTH_MONITOR_HANDLER_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_MONITOR_HANDLER_TYPE, GMythMonitorHandlerClass))
#define GMYTHTV_MONITOR_HANDLER_READ_ERROR	-314
    enum {
    GMYTH_BACKEND_NO_MESSAGE = 0,
    GMYTH_BACKEND_PROGRAM_INFO_CHANGED,
    GMYTH_BACKEND_DONE_RECORDING,
    GMYTH_BACKEND_STOP_LIVETV
};

typedef struct _GMythMonitorHandler GMythMonitorHandler;
typedef struct _GMythMonitorHandlerClass GMythMonitorHandlerClass;

struct _GMythMonitorHandlerClass {
    GObjectClass    parent_class;

    /*
     * callbacks
     */
    guint           backend_events_handler_signal_id;

    /*
     * signal default handlers
     */
    void            (*backend_events_handler) (GMythMonitorHandler *
                                               monitor, gint msg_code,
                                               gchar * message);
};

struct _GMythMonitorHandler {
    GObject         parent;

    /*
     * MythTV version number 
     */
    gint            mythtv_version;

    /*
     * socket descriptors 
     */
    GMythSocket    *event_sock;

    //gpointer(*gmyth_monitor_handler_listener) (gpointer data);

    gchar          *hostname;
    gint            port;

    gint64          actual_index;

    gboolean        allow_msgs_listener;

    /*
     * stores the messages coming from the backend 
     */
    GHashTable     *backend_msgs;

    GMutex         *mutex;
    guint           io_source;
};

GType           gmyth_monitor_handler_get_type(void);

GMythMonitorHandler *gmyth_monitor_handler_new(void);

gboolean        gmyth_monitor_handler_open(GMythMonitorHandler * monitor,
                                           const gchar * hostname,
                                           gint port);

gboolean        gmyth_monitor_handler_start(GMythMonitorHandler * monitor);

void            gmyth_monitor_handler_close(GMythMonitorHandler * monitor);

G_END_DECLS
#endif                          /* __GMYTH_MONITOR_HANDLER_H__ */
