/**
 * GMyth Library
 * 
 * @file gmyth/gmyth_common.h
 * 
 * @brief <p> This file contains basic common functions for the gmyth library.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Leonardo Sobral Cunha <leonardo.cunha@indt.org.br>
 * @author Rosfran Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GMYTH_COMMON_H_
#define GMYTH_COMMON_H_

#include <glib.h>
#include <time.h>

#include "gmyth_programinfo.h"

G_BEGIN_DECLS
    /**
    * The GMythChannelInfo structure represents the channel information
    * stored in the backend database.
    */
    typedef struct {
    /** The channel ID in backend database */
    gint            channel_ID;

    /** The channel number */
    GString        *channel_num;

    /** The channel name in backend database */
    GString        *channel_name;

    /** The channel icon path in the backend database */
    GString        *channel_icon;
} GMythChannelInfo;

void            gmyth_free_channel_list     (GList *list);
void            gmyth_free_program_list     (GList *list);
void            gmyth_channel_info_free     (GMythChannelInfo *channel_info);
void            gmyth_channel_info_print    (GMythChannelInfo *channel_info);
void            gmyth_program_info_print    (GMythProgramInfo *program_info);

G_END_DECLS
#endif                          /* GMYTH_COMMON_H_ */
