% FUNCTION F=gf_linsolve(args)
% 
%   * X = gf_linsolve('gmres',Spmat M, vec b[, int restart][, Precond
%   P][,'noisy'][,'res', r][,'maxiter', n])
%   Solve `M.X = b` with the generalized minimum residuals method.  Optionally
%   using `P` as preconditioner. The default value of the restart parameter is 50.
% 
%   * X = gf_linsolve('cg',Spmat M, vec b [, Precond P][,'noisy'][,'res',
%   r][,'maxiter', n])
%   Solve `M.X = b` with the conjugated gradient method.  Optionally using `P` as
%   preconditioner.
% 
%   * X = gf_linsolve('bicgstab',Spmat M, vec b [, Precond P][,'noisy'][,'res',
%   r][,'maxiter', n])
%   Solve `M.X = b` with the bi-conjugated gradient stabilized method.  Optionally
%   using `P` as a preconditioner.
% 
%   * {U, cond} = gf_linsolve('lu',Spmat M, vec b)
%   Alias for gf_linsolve('superlu',...)
% 
%   * {U, cond} = gf_linsolve('superlu',Spmat M, vec b)
%   Solve `M.U = b` apply the SuperLU solver (sparse LU factorization).  The
%   condition number estimate `cond` is returned with the solution `U`.
% 
function [varargout]=gf_linsolve(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('linsolve',varargin{:});
  else
    gf_matlab('linsolve',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
