/* import-pidgin.c generated by valac 0.11.7, the Vala compiler
 * generated from import-pidgin.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <stdio.h>
#include <gee.h>


#define FOLKS_TYPE_IMPORTER (folks_importer_get_type ())
#define FOLKS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMPORTER, FolksImporter))
#define FOLKS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IMPORTER, FolksImporterClass))
#define FOLKS_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMPORTER))
#define FOLKS_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IMPORTER))
#define FOLKS_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IMPORTER, FolksImporterClass))

typedef struct _FolksImporter FolksImporter;
typedef struct _FolksImporterClass FolksImporterClass;
typedef struct _FolksImporterPrivate FolksImporterPrivate;

#define FOLKS_IMPORTERS_TYPE_PIDGIN (folks_importers_pidgin_get_type ())
#define FOLKS_IMPORTERS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidgin))
#define FOLKS_IMPORTERS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))
#define FOLKS_IMPORTERS_IS_PIDGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_IS_PIDGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_IMPORTERS_TYPE_PIDGIN))
#define FOLKS_IMPORTERS_PIDGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginClass))

typedef struct _FolksImportersPidgin FolksImportersPidgin;
typedef struct _FolksImportersPidginClass FolksImportersPidginClass;
typedef struct _FolksImportersPidginPrivate FolksImportersPidginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksImportersPidginImportData FolksImportersPidginImportData;
typedef struct _FolksImportersPidginParseBlistData FolksImportersPidginParseBlistData;
typedef struct _FolksImportersPidginParseGroupData FolksImportersPidginParseGroupData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksImportersPidginParseContactData FolksImportersPidginParseContactData;

typedef enum  {
	FOLKS_IMPORT_ERROR_MALFORMED_INPUT
} FolksImportError;
#define FOLKS_IMPORT_ERROR folks_import_error_quark ()
struct _FolksImporter {
	GObject parent_instance;
	FolksImporterPrivate * priv;
};

struct _FolksImporterClass {
	GObjectClass parent_class;
	void (*import) (FolksImporter* self, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*import_finish) (FolksImporter* self, GAsyncResult* _res_, GError** error);
};

struct _FolksImportersPidgin {
	FolksImporter parent_instance;
	FolksImportersPidginPrivate * priv;
};

struct _FolksImportersPidginClass {
	FolksImporterClass parent_class;
};

struct _FolksImportersPidginPrivate {
	FolksPersonaStore* destination_store;
	guint persona_count;
};

struct _FolksImportersPidginImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	FolksPersonaStore* destination_store;
	gchar* source_filename;
	guint result;
	FolksPersonaStore* _tmp0_;
	gchar* _tmp1_;
	gchar* filename;
	gboolean _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* file;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GFileInfo* file_info;
	GFileInfo* _tmp11_;
	GFileInfo* _tmp12_;
	GError * e;
	const gchar* _tmp13_;
	GError* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	xmlDoc* _tmp18_;
	xmlDoc* xml_doc;
	const gchar* _tmp19_;
	GError* _tmp20_;
	xmlNode* _tmp21_;
	xmlNode* root_node;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	xmlNode* iter;
	gboolean _tmp28_;
	gboolean _tmp29_;
	const gchar* _tmp30_;
	GError * _inner_error_;
};

struct _FolksImportersPidginParseBlistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	xmlNode* blist_node;
	xmlNode* iter;
	gboolean _tmp0_;
	gboolean _tmp1_;
};

struct _FolksImportersPidginParseGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	xmlNode* group_node;
	gchar* _tmp0_;
	gchar* group_name;
	xmlNode* iter;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersona* _tmp3_;
	FolksPersona* persona;
	gboolean _tmp4_;
	FolksGroupDetails* _tmp5_;
	FolksGroupDetails* group_details;
	GError * e;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GError * _inner_error_;
};

struct _FolksImportersPidginParseContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksImportersPidgin* self;
	xmlNode* contact_node;
	FolksPersona* result;
	gchar* alias;
	GHashTable* _tmp0_;
	GHashTable* im_addresses;
	gchar* _tmp1_;
	gchar* im_address_string;
	xmlNode* iter;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* blist_protocol;
	gchar* _tmp5_;
	gchar* tp_protocol;
	xmlNode* subiter;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* im_address;
	gconstpointer _tmp9_;
	FolksLinkedHashSet* _tmp10_;
	FolksLinkedHashSet* im_address_set;
	FolksLinkedHashSet* _tmp11_;
	gchar* _tmp12_;
	FolksLinkedHashSet* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	guint _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GHashTable* _tmp28_;
	GHashTable* details;
	GValue im_addresses_value;
	gchar* _tmp29_;
	GValue* _tmp30_;
	FolksPersona* persona;
	FolksPersona* _tmp31_;
	FolksPersona* _tmp32_;
	GError * e;
	const gchar* _tmp33_;
	gboolean _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GError * _inner_error_;
};


static gpointer folks_importers_pidgin_parent_class = NULL;

GType folks_importer_get_type (void) G_GNUC_CONST;
GQuark folks_import_error_quark (void);
GType folks_importers_pidgin_get_type (void) G_GNUC_CONST;
#define FOLKS_IMPORTERS_PIDGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_IMPORTERS_TYPE_PIDGIN, FolksImportersPidginPrivate))
enum  {
	FOLKS_IMPORTERS_PIDGIN_DUMMY_PROPERTY
};
static void folks_importers_pidgin_real_import_data_free (gpointer _data);
static void folks_importers_pidgin_real_import (FolksImporter* base, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_importers_pidgin_real_import_co (FolksImportersPidginImportData* data);
static void folks_importers_pidgin_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_importers_pidgin_parse_blist (FolksImportersPidgin* self, xmlNode* blist_node, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_importers_pidgin_parse_blist_finish (FolksImportersPidgin* self, GAsyncResult* _res_);
static void folks_importers_pidgin_parse_blist_data_free (gpointer _data);
static gboolean folks_importers_pidgin_parse_blist_co (FolksImportersPidginParseBlistData* data);
static void folks_importers_pidgin_parse_group (FolksImportersPidgin* self, xmlNode* group_node, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_importers_pidgin_parse_group_finish (FolksImportersPidgin* self, GAsyncResult* _res_);
static void folks_importers_pidgin_parse_blist_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_importers_pidgin_parse_group_data_free (gpointer _data);
static gboolean folks_importers_pidgin_parse_group_co (FolksImportersPidginParseGroupData* data);
static void folks_importers_pidgin_parse_contact (FolksImportersPidgin* self, xmlNode* contact_node, GAsyncReadyCallback _callback_, gpointer _user_data_);
static FolksPersona* folks_importers_pidgin_parse_contact_finish (FolksImportersPidgin* self, GAsyncResult* _res_);
static void folks_importers_pidgin_parse_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_importers_pidgin_parse_contact_data_free (gpointer _data);
static gboolean folks_importers_pidgin_parse_contact_co (FolksImportersPidginParseContactData* data);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static gchar* folks_importers_pidgin_blist_protocol_to_tp_protocol (FolksImportersPidgin* self, const gchar* blist_protocol);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void folks_importers_pidgin_parse_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksImportersPidgin* folks_importers_pidgin_new (void);
FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type);
FolksImporter* folks_importer_construct (GType object_type);
static void folks_importers_pidgin_finalize (GObject* obj);


static void folks_importers_pidgin_real_import_data_free (gpointer _data) {
	FolksImportersPidginImportData* data;
	data = _data;
	_g_object_unref0 (data->destination_store);
	_g_free0 (data->source_filename);
	_g_object_unref0 (data->self);
	g_slice_free (FolksImportersPidginImportData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_importers_pidgin_real_import (FolksImporter* base, FolksPersonaStore* destination_store, const gchar* source_filename, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidgin * self;
	FolksImportersPidginImportData* _data_;
	self = (FolksImportersPidgin*) base;
	_data_ = g_slice_new0 (FolksImportersPidginImportData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_real_import);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_real_import_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->destination_store = _g_object_ref0 (destination_store);
	_data_->source_filename = g_strdup (source_filename);
	folks_importers_pidgin_real_import_co (_data_);
}


static guint folks_importers_pidgin_real_import_finish (FolksImporter* base, GAsyncResult* _res_, GError** error) {
	guint result;
	FolksImportersPidginImportData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0U;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void folks_importers_pidgin_import_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginImportData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_importers_pidgin_real_import_co (data);
}


static gboolean folks_importers_pidgin_real_import_co (FolksImportersPidginImportData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = _g_object_ref0 (data->destination_store);
	_g_object_unref0 (data->self->priv->destination_store);
	data->self->priv->destination_store = data->_tmp0_;
	data->_tmp1_ = g_strdup (data->source_filename);
	data->filename = data->_tmp1_;
	if (data->filename == NULL) {
		data->_tmp2_ = TRUE;
	} else {
		data->_tmp3_ = NULL;
		data->_tmp3_ = string_strip (data->filename);
		data->_tmp4_ = data->_tmp3_;
		data->_tmp2_ = g_strcmp0 (data->_tmp4_, "") == 0;
		_g_free0 (data->_tmp4_);
	}
	if (data->_tmp2_) {
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_get_home_dir ();
		data->_tmp6_ = NULL;
		data->_tmp6_ = g_build_filename (data->_tmp5_, ".purple", "blist.xml", NULL, NULL);
		_g_free0 (data->filename);
		data->filename = data->_tmp6_;
	}
	data->_tmp7_ = NULL;
	data->_tmp7_ = g_file_new_for_path (data->filename);
	data->file = data->_tmp7_;
	data->_tmp8_ = g_file_query_exists (data->file, NULL);
	if (!data->_tmp8_) {
		data->_tmp9_ = NULL;
		data->_tmp9_ = _ ("File %s does not exist.");
		data->_tmp10_ = NULL;
		data->_tmp10_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, data->_tmp9_, data->filename);
		data->_inner_error_ = data->_tmp10_;
		if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_state_ = 1;
	g_file_query_info_async (data->file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, folks_importers_pidgin_import_ready, data);
	return FALSE;
	_state_1:
	data->_tmp11_ = NULL;
	data->_tmp11_ = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
	data->_tmp12_ = data->_tmp11_;
	if (data->_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_g_object_unref0 (data->file_info);
	data->file_info = data->_tmp12_;
	goto __finally5;
	__catch5_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp13_ = NULL;
		data->_tmp13_ = _ ("Failed to get information about file %s: %s");
		data->_tmp14_ = NULL;
		data->_tmp14_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, data->_tmp13_, data->filename, data->e->message);
		data->_inner_error_ = data->_tmp14_;
		_g_error_free0 (data->e);
		goto __finally5;
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp15_ = g_file_info_get_attribute_boolean (data->file_info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!data->_tmp15_) {
		data->_tmp16_ = NULL;
		data->_tmp16_ = _ ("File %s is not readable.");
		data->_tmp17_ = NULL;
		data->_tmp17_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, data->_tmp16_, data->filename);
		data->_inner_error_ = data->_tmp17_;
		if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp18_ = NULL;
	data->_tmp18_ = xmlParseFile (data->filename);
	data->xml_doc = data->_tmp18_;
	if (data->xml_doc == NULL) {
		data->_tmp19_ = NULL;
		data->_tmp19_ = _ ("The Pidgin buddy list file '%s' could not be loaded.");
		data->_tmp20_ = NULL;
		data->_tmp20_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, data->_tmp19_, data->filename);
		data->_inner_error_ = data->_tmp20_;
		if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp21_ = NULL;
	data->_tmp21_ = xmlDocGetRootElement (data->xml_doc);
	data->root_node = data->_tmp21_;
	if (data->root_node == NULL) {
		data->_tmp23_ = TRUE;
	} else {
		data->_tmp23_ = g_strcmp0 (data->root_node->name, "purple") != 0;
	}
	if (data->_tmp23_) {
		data->_tmp22_ = TRUE;
	} else {
		data->_tmp24_ = NULL;
		data->_tmp24_ = xmlGetProp (data->root_node, "version");
		data->_tmp25_ = data->_tmp24_;
		data->_tmp22_ = g_strcmp0 (data->_tmp25_, "1.0") != 0;
		_g_free0 (data->_tmp25_);
	}
	if (data->_tmp22_) {
		xmlFreeDoc (data->xml_doc);
		data->_tmp26_ = NULL;
		data->_tmp26_ = _ ("The Pidgin buddy list file '%s' could not be loaded: the root element " \
"could not be found or was not recognised.");
		data->_tmp27_ = NULL;
		data->_tmp27_ = g_error_new (FOLKS_IMPORT_ERROR, FOLKS_IMPORT_ERROR_MALFORMED_INPUT, data->_tmp26_, data->filename);
		data->_inner_error_ = data->_tmp27_;
		if (data->_inner_error_->domain == FOLKS_IMPORT_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->file_info);
			_g_object_unref0 (data->file);
			_g_free0 (data->filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		data->iter = data->root_node->children;
		{
			data->_tmp28_ = TRUE;
			while (TRUE) {
				if (!data->_tmp28_) {
					data->iter = data->iter->next;
				}
				data->_tmp28_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp29_ = TRUE;
				} else {
					data->_tmp29_ = g_strcmp0 (data->iter->name, "blist") != 0;
				}
				if (data->_tmp29_) {
					continue;
				}
				data->_state_ = 2;
				folks_importers_pidgin_parse_blist (data->self, data->iter, folks_importers_pidgin_import_ready, data);
				return FALSE;
				_state_2:
				folks_importers_pidgin_parse_blist_finish (data->self, data->_res_);
			}
		}
	}
	xmlFreeDoc (data->xml_doc);
	data->_tmp30_ = NULL;
	data->_tmp30_ = _ ("Imported %u buddies from '%s'.\n");
	fprintf (stdout, data->_tmp30_, data->self->priv->persona_count, data->filename);
	data->result = data->self->priv->persona_count;
	_g_object_unref0 (data->file_info);
	_g_object_unref0 (data->file);
	_g_free0 (data->filename);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->file_info);
	_g_object_unref0 (data->file);
	_g_free0 (data->filename);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_importers_pidgin_parse_blist_data_free (gpointer _data) {
	FolksImportersPidginParseBlistData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksImportersPidginParseBlistData, data);
}


static void folks_importers_pidgin_parse_blist (FolksImportersPidgin* self, xmlNode* blist_node, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidginParseBlistData* _data_;
	_data_ = g_slice_new0 (FolksImportersPidginParseBlistData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_parse_blist);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_parse_blist_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->blist_node = blist_node;
	folks_importers_pidgin_parse_blist_co (_data_);
}


static void folks_importers_pidgin_parse_blist_finish (FolksImportersPidgin* self, GAsyncResult* _res_) {
	FolksImportersPidginParseBlistData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_importers_pidgin_parse_blist_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginParseBlistData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_importers_pidgin_parse_blist_co (data);
}


static gboolean folks_importers_pidgin_parse_blist_co (FolksImportersPidginParseBlistData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->iter = data->blist_node->children;
		{
			data->_tmp0_ = TRUE;
			while (TRUE) {
				if (!data->_tmp0_) {
					data->iter = data->iter->next;
				}
				data->_tmp0_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp1_ = TRUE;
				} else {
					data->_tmp1_ = g_strcmp0 (data->iter->name, "group") != 0;
				}
				if (data->_tmp1_) {
					continue;
				}
				data->_state_ = 1;
				folks_importers_pidgin_parse_group (data->self, data->iter, folks_importers_pidgin_parse_blist_ready, data);
				return FALSE;
				_state_1:
				folks_importers_pidgin_parse_group_finish (data->self, data->_res_);
			}
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_importers_pidgin_parse_group_data_free (gpointer _data) {
	FolksImportersPidginParseGroupData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksImportersPidginParseGroupData, data);
}


static void folks_importers_pidgin_parse_group (FolksImportersPidgin* self, xmlNode* group_node, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidginParseGroupData* _data_;
	_data_ = g_slice_new0 (FolksImportersPidginParseGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_parse_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_parse_group_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->group_node = group_node;
	folks_importers_pidgin_parse_group_co (_data_);
}


static void folks_importers_pidgin_parse_group_finish (FolksImportersPidgin* self, GAsyncResult* _res_) {
	FolksImportersPidginParseGroupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_importers_pidgin_parse_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginParseGroupData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_importers_pidgin_parse_group_co (data);
}


static gboolean folks_importers_pidgin_parse_group_co (FolksImportersPidginParseGroupData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = xmlGetProp (data->group_node, "name");
	data->group_name = data->_tmp0_;
	{
		data->iter = data->group_node->children;
		{
			data->_tmp1_ = TRUE;
			while (TRUE) {
				if (!data->_tmp1_) {
					data->iter = data->iter->next;
				}
				data->_tmp1_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp2_ = TRUE;
				} else {
					data->_tmp2_ = g_strcmp0 (data->iter->name, "contact") != 0;
				}
				if (data->_tmp2_) {
					continue;
				}
				data->_state_ = 1;
				folks_importers_pidgin_parse_contact (data->self, data->iter, folks_importers_pidgin_parse_group_ready, data);
				return FALSE;
				_state_1:
				data->_tmp3_ = NULL;
				data->_tmp3_ = folks_importers_pidgin_parse_contact_finish (data->self, data->_res_);
				data->persona = data->_tmp3_;
				if (data->persona == NULL) {
					data->_tmp4_ = TRUE;
				} else {
					data->_tmp4_ = !FOLKS_IS_GROUP_DETAILS (data->persona);
				}
				if (data->_tmp4_) {
					_g_object_unref0 (data->persona);
					continue;
				}
				data->_tmp5_ = _g_object_ref0 (FOLKS_GROUP_DETAILS (data->persona));
				data->group_details = data->_tmp5_;
				data->_state_ = 2;
				folks_group_details_change_group (data->group_details, data->group_name, TRUE, folks_importers_pidgin_parse_group_ready, data);
				return FALSE;
				_state_2:
				folks_group_details_change_group_finish (data->group_details, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->group_details);
					goto __catch6_g_error;
				}
				_g_object_unref0 (data->group_details);
				goto __finally6;
				__catch6_g_error:
				{
					data->e = data->_inner_error_;
					data->_inner_error_ = NULL;
					data->_tmp6_ = NULL;
					data->_tmp6_ = _ ("Error changing group of Pidgin.Persona '%s': %s\n");
					data->_tmp7_ = NULL;
					data->_tmp7_ = folks_persona_get_iid (data->persona);
					fprintf (stderr, data->_tmp6_, data->_tmp7_, data->e->message);
					_g_error_free0 (data->e);
				}
				__finally6:
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->persona);
					_g_free0 (data->group_name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (data->persona);
			}
		}
	}
	_g_free0 (data->group_name);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_importers_pidgin_parse_contact_data_free (gpointer _data) {
	FolksImportersPidginParseContactData* data;
	data = _data;
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (FolksImportersPidginParseContactData, data);
}


static void folks_importers_pidgin_parse_contact (FolksImportersPidgin* self, xmlNode* contact_node, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksImportersPidginParseContactData* _data_;
	_data_ = g_slice_new0 (FolksImportersPidginParseContactData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_importers_pidgin_parse_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_importers_pidgin_parse_contact_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->contact_node = contact_node;
	folks_importers_pidgin_parse_contact_co (_data_);
}


static FolksPersona* folks_importers_pidgin_parse_contact_finish (FolksImportersPidgin* self, GAsyncResult* _res_) {
	FolksPersona* result;
	FolksImportersPidginParseContactData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void folks_importers_pidgin_parse_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksImportersPidginParseContactData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_importers_pidgin_parse_contact_co (data);
}


static gboolean folks_importers_pidgin_parse_contact_co (FolksImportersPidginParseContactData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->alias = NULL;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	data->im_addresses = data->_tmp0_;
	data->_tmp1_ = g_strdup ("");
	data->im_address_string = data->_tmp1_;
	{
		data->iter = data->contact_node->children;
		{
			data->_tmp2_ = TRUE;
			while (TRUE) {
				if (!data->_tmp2_) {
					data->iter = data->iter->next;
				}
				data->_tmp2_ = FALSE;
				if (!(data->iter != NULL)) {
					break;
				}
				if (data->iter->type != XML_ELEMENT_NODE) {
					data->_tmp3_ = TRUE;
				} else {
					data->_tmp3_ = g_strcmp0 (data->iter->name, "buddy") != 0;
				}
				if (data->_tmp3_) {
					continue;
				}
				data->_tmp4_ = NULL;
				data->_tmp4_ = xmlGetProp (data->iter, "proto");
				data->blist_protocol = data->_tmp4_;
				if (data->blist_protocol == NULL) {
					_g_free0 (data->blist_protocol);
					continue;
				}
				data->_tmp5_ = NULL;
				data->_tmp5_ = folks_importers_pidgin_blist_protocol_to_tp_protocol (data->self, data->blist_protocol);
				data->tp_protocol = data->_tmp5_;
				if (data->tp_protocol == NULL) {
					_g_free0 (data->tp_protocol);
					_g_free0 (data->blist_protocol);
					continue;
				}
				{
					data->subiter = data->iter->children;
					{
						data->_tmp6_ = TRUE;
						while (TRUE) {
							if (!data->_tmp6_) {
								data->subiter = data->subiter->next;
							}
							data->_tmp6_ = FALSE;
							if (!(data->subiter != NULL)) {
								break;
							}
							if (data->subiter->type != XML_ELEMENT_NODE) {
								continue;
							}
							if (g_strcmp0 (data->subiter->name, "alias") == 0) {
								data->_tmp7_ = NULL;
								data->_tmp7_ = xmlNodeGetContent (data->subiter);
								_g_free0 (data->alias);
								data->alias = data->_tmp7_;
							} else {
								if (g_strcmp0 (data->subiter->name, "name") == 0) {
									data->_tmp8_ = NULL;
									data->_tmp8_ = xmlNodeGetContent (data->subiter);
									data->im_address = data->_tmp8_;
									data->_tmp9_ = NULL;
									data->_tmp9_ = g_hash_table_lookup (data->im_addresses, data->tp_protocol);
									data->_tmp10_ = _g_object_ref0 ((FolksLinkedHashSet*) data->_tmp9_);
									data->im_address_set = data->_tmp10_;
									if (data->im_address_set == NULL) {
										data->_tmp11_ = NULL;
										data->_tmp11_ = folks_linked_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
										_g_object_unref0 (data->im_address_set);
										data->im_address_set = data->_tmp11_;
										data->_tmp12_ = g_strdup (data->tp_protocol);
										data->_tmp13_ = _g_object_ref0 (data->im_address_set);
										g_hash_table_insert (data->im_addresses, data->_tmp12_, data->_tmp13_);
									}
									gee_abstract_collection_add ((GeeAbstractCollection*) data->im_address_set, data->im_address);
									data->_tmp14_ = NULL;
									data->_tmp14_ = g_strdup_printf ("    %s\n", data->im_address);
									data->_tmp15_ = data->_tmp14_;
									data->_tmp16_ = g_strconcat (data->im_address_string, data->_tmp15_, NULL);
									_g_free0 (data->im_address_string);
									data->im_address_string = data->_tmp16_;
									_g_free0 (data->_tmp15_);
									_g_object_unref0 (data->im_address_set);
									_g_free0 (data->im_address);
								}
							}
						}
					}
				}
				_g_free0 (data->tp_protocol);
				_g_free0 (data->blist_protocol);
			}
		}
	}
	data->_tmp18_ = g_hash_table_size (data->im_addresses);
	if (data->_tmp18_ < 2) {
		if (data->alias == NULL) {
			data->_tmp20_ = TRUE;
		} else {
			data->_tmp21_ = NULL;
			data->_tmp21_ = string_strip (data->alias);
			data->_tmp22_ = data->_tmp21_;
			data->_tmp20_ = g_strcmp0 (data->_tmp22_, "") == 0;
			_g_free0 (data->_tmp22_);
		}
		if (data->_tmp20_) {
			data->_tmp19_ = TRUE;
		} else {
			data->_tmp23_ = NULL;
			data->_tmp23_ = string_strip (data->alias);
			data->_tmp24_ = data->_tmp23_;
			data->_tmp25_ = NULL;
			data->_tmp25_ = string_strip (data->im_address_string);
			data->_tmp26_ = data->_tmp25_;
			data->_tmp19_ = g_strcmp0 (data->_tmp24_, data->_tmp26_) == 0;
			_g_free0 (data->_tmp26_);
			_g_free0 (data->_tmp24_);
		}
		data->_tmp17_ = data->_tmp19_;
	} else {
		data->_tmp17_ = FALSE;
	}
	if (data->_tmp17_) {
		data->_tmp27_ = NULL;
		data->_tmp27_ = _ ("Ignoring buddy with no alias and only one IM address:\n%s");
		fprintf (stdout, data->_tmp27_, data->im_address_string);
		data->result = NULL;
		_g_free0 (data->im_address_string);
		_g_hash_table_unref0 (data->im_addresses);
		_g_free0 (data->alias);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp28_ = NULL;
	data->_tmp28_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details = data->_tmp28_;
	g_value_init (&data->im_addresses_value, G_TYPE_HASH_TABLE);
	g_value_set_boxed (&data->im_addresses_value, data->im_addresses);
	data->_tmp29_ = g_strdup ("im-addresses");
	data->_tmp30_ = __g_value_dup0 (&data->im_addresses_value);
	g_hash_table_insert (data->details, data->_tmp29_, data->_tmp30_);
	data->_state_ = 1;
	folks_persona_store_add_persona_from_details (data->self->priv->destination_store, data->details, folks_importers_pidgin_parse_contact_ready, data);
	return FALSE;
	_state_1:
	data->_tmp31_ = NULL;
	data->_tmp31_ = folks_persona_store_add_persona_from_details_finish (data->self->priv->destination_store, data->_res_, &data->_inner_error_);
	data->_tmp32_ = data->_tmp31_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			goto __catch7_folks_persona_store_error;
		}
		_g_object_unref0 (data->persona);
		G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
		_g_hash_table_unref0 (data->details);
		_g_free0 (data->im_address_string);
		_g_hash_table_unref0 (data->im_addresses);
		_g_free0 (data->alias);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->persona);
	data->persona = data->_tmp32_;
	goto __finally7;
	__catch7_folks_persona_store_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp33_ = NULL;
		data->_tmp33_ = _ ("Failed to create new persona for buddy with alias '%s' and IM addresse" \
"s:\n" \
"%s\n" \
"Error: %s\n");
		fprintf (stderr, data->_tmp33_, data->alias, data->im_address_string, data->e->message);
		data->result = NULL;
		_g_error_free0 (data->e);
		_g_object_unref0 (data->persona);
		G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
		_g_hash_table_unref0 (data->details);
		_g_free0 (data->im_address_string);
		_g_hash_table_unref0 (data->im_addresses);
		_g_free0 (data->alias);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->persona);
		G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
		_g_hash_table_unref0 (data->details);
		_g_free0 (data->im_address_string);
		_g_hash_table_unref0 (data->im_addresses);
		_g_free0 (data->alias);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->alias != NULL) {
		data->_tmp34_ = FOLKS_IS_ALIAS_DETAILS (data->persona);
	} else {
		data->_tmp34_ = FALSE;
	}
	if (data->_tmp34_) {
		folks_alias_details_set_alias (FOLKS_ALIAS_DETAILS (data->persona), data->alias);
	}
	data->_tmp35_ = NULL;
	data->_tmp35_ = _ ("Created persona '%s' for buddy with alias '%s' and IM addresses:\n%s");
	data->_tmp36_ = NULL;
	data->_tmp36_ = folks_persona_get_uid (data->persona);
	fprintf (stdout, data->_tmp35_, data->_tmp36_, data->alias, data->im_address_string);
	data->self->priv->persona_count++;
	data->result = data->persona;
	G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
	_g_hash_table_unref0 (data->details);
	_g_free0 (data->im_address_string);
	_g_hash_table_unref0 (data->im_addresses);
	_g_free0 (data->alias);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->persona);
	G_IS_VALUE (&data->im_addresses_value) ? (g_value_unset (&data->im_addresses_value), NULL) : NULL;
	_g_hash_table_unref0 (data->details);
	_g_free0 (data->im_address_string);
	_g_hash_table_unref0 (data->im_addresses);
	_g_free0 (data->alias);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* folks_importers_pidgin_blist_protocol_to_tp_protocol (FolksImportersPidgin* self, const gchar* blist_protocol) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* tp_protocol;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (blist_protocol != NULL, NULL);
	_tmp0_ = g_strdup (blist_protocol);
	tp_protocol = _tmp0_;
	_tmp1_ = g_str_has_prefix (blist_protocol, "prpl-");
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = string_substring (blist_protocol, (glong) 5, (glong) (-1));
		_g_free0 (tp_protocol);
		tp_protocol = _tmp2_;
	}
	if (g_strcmp0 (tp_protocol, "bonjour") == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("local-xmpp");
		_g_free0 (tp_protocol);
		tp_protocol = _tmp3_;
	} else {
		if (g_strcmp0 (tp_protocol, "novell") == 0) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("groupwise");
			_g_free0 (tp_protocol);
			tp_protocol = _tmp4_;
		} else {
			if (g_strcmp0 (tp_protocol, "gg") == 0) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("gadugadu");
				_g_free0 (tp_protocol);
				tp_protocol = _tmp5_;
			} else {
				if (g_strcmp0 (tp_protocol, "meanwhile") == 0) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup ("sametime");
					_g_free0 (tp_protocol);
					tp_protocol = _tmp6_;
				} else {
					if (g_strcmp0 (tp_protocol, "simple") == 0) {
						gchar* _tmp7_;
						_tmp7_ = g_strdup ("sip");
						_g_free0 (tp_protocol);
						tp_protocol = _tmp7_;
					}
				}
			}
		}
	}
	result = tp_protocol;
	return result;
}


FolksImportersPidgin* folks_importers_pidgin_construct (GType object_type) {
	FolksImportersPidgin * self = NULL;
	self = (FolksImportersPidgin*) folks_importer_construct (object_type);
	return self;
}


FolksImportersPidgin* folks_importers_pidgin_new (void) {
	return folks_importers_pidgin_construct (FOLKS_IMPORTERS_TYPE_PIDGIN);
}


static void folks_importers_pidgin_class_init (FolksImportersPidginClass * klass) {
	folks_importers_pidgin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksImportersPidginPrivate));
	FOLKS_IMPORTER_CLASS (klass)->import = folks_importers_pidgin_real_import;
	FOLKS_IMPORTER_CLASS (klass)->import_finish = folks_importers_pidgin_real_import_finish;
	G_OBJECT_CLASS (klass)->finalize = folks_importers_pidgin_finalize;
}


static void folks_importers_pidgin_instance_init (FolksImportersPidgin * self) {
	self->priv = FOLKS_IMPORTERS_PIDGIN_GET_PRIVATE (self);
	self->priv->persona_count = (guint) 0;
}


static void folks_importers_pidgin_finalize (GObject* obj) {
	FolksImportersPidgin * self;
	self = FOLKS_IMPORTERS_PIDGIN (obj);
	_g_object_unref0 (self->priv->destination_store);
	G_OBJECT_CLASS (folks_importers_pidgin_parent_class)->finalize (obj);
}


GType folks_importers_pidgin_get_type (void) {
	static volatile gsize folks_importers_pidgin_type_id__volatile = 0;
	if (g_once_init_enter (&folks_importers_pidgin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImportersPidginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_importers_pidgin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImportersPidgin), 0, (GInstanceInitFunc) folks_importers_pidgin_instance_init, NULL };
		GType folks_importers_pidgin_type_id;
		folks_importers_pidgin_type_id = g_type_register_static (FOLKS_TYPE_IMPORTER, "FolksImportersPidgin", &g_define_type_info, 0);
		g_once_init_leave (&folks_importers_pidgin_type_id__volatile, folks_importers_pidgin_type_id);
	}
	return folks_importers_pidgin_type_id__volatile;
}



