<?
	/**
	 * Create the images for the Firefox file picker in the specified
	 * directory.
	 */
	function createFilepicker($dir) {
		renderFilepicker($dir.'Filepicker.png', 24);
	}
	
	/**
	 * Render a complete toolbar image to a given file.
	 *
	 * The columns are:
	 * Up, Home, New Folder
	 *
	 * The rows are:
	 * Normal, Hover, Disabled
	 */
	function renderFilepicker($filename, $size) {
		// define the icons to render
		$icons = array(
			array(ACTIONS, 'go-up'),
			array(PLACES, 'user-home'),
			array(ACTIONS, 'folder-new')
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$highlight = renderHighlight($firstrow);
		$disabled = renderDisabled($firstrow);
		
		// create single PNG containing all states
		$states = array($firstrow, $highlight, $disabled);
		$filepicker =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($filepicker, $filename);
	}
	
?>