# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import config, plugin_registry
from elisa.core.application import Application
from elisa.core.application import DEFAULT_CONFIG, CONFIG_DIR, CONFIG_FILE
import os

class TestApplication(ElisaTestCase):
    test_conf = "test.conf"

    def setUp(self):
        ElisaTestCase.setUp(self)
        self.app = Application('test.conf')
        
    def test_default_config(self):
        """ Load the default config file
        """
        try:
            os.unlink('test.conf')
        except:
            pass

        default_config = DEFAULT_CONFIG % {'version': 'test',
                                           'install_date': 'none'}
        c = config.Config('test.conf', default_config)
        self.assertEqual(c.get_filename(), 'test.conf')
        self.assertEqual(c.get_config_dir(), os.getcwd())
        c.write()
        f = open('test.conf')
        self.assertEqual(f.read(), default_config)

    def test_create_config_dir(self):
        """
        """
        default = CONFIG_DIR
        self.failUnless(os.path.exists(default))

        # pity this doesn't work!
        # os.renames(default, '.elisa.bak')
        os.system('mv %s %s' % (default, '.elisa.bak'))


        f = os.path.join(CONFIG_DIR,CONFIG_FILE)
        os.makedirs(CONFIG_DIR)
        c = config.Config(f)
        c.write()

        self.failUnless(os.path.exists(default))

        #os.renames('.elisa.bak', default)
        os.system('mv %s %s' % ('.elisa.bak/*', default))
        os.system('rm -fr %s' % '.elisa.bak')

    test_create_config_dir.skip = "Shall we really interact with the developer's filesystem ?"


    def test_attributes(self):

        self.failUnless(isinstance(self.app.config, config.Config))
        self.failUnless(isinstance(self.app.plugin_registry,
                                   plugin_registry.PluginRegistry))
        # TODO: test all other attributes: interface_controller, *_manager


    def test_start_stop(self):

        self.app.start()

        self.assertEquals(self.app.running, True)

        def stopped(r):
            self.assertEquals(self.app.running, False)
            stopped.called = True

        stopped.called = False

        dfr = self.app.stop(stop_reactor=False)
        dfr.addCallback(stopped)
        dfr.addCallback(lambda r: self.check_called(stopped))
        return dfr
    
    def test_restart(self):
        """
        This one is tricky because application.restart() spawns a new process
        
        """
        self.app.start()

        def restarted(r):
            self.assertEquals(self.app.running, True)
            restarted.called = True

        restarted.called = False

        dfr = self.app.restart()

        # FIXME: restore this if app.stop() one day returns a Deferred
        restarted(True)
        self.check_called(restarted)
##         dfr.addCallback(restarted)
##         dfr.addCallback(self.check_called, restarted)
##         return dfr
    test_restart.skip = "should go in a integration test"
