# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from pigment_transition import PigmentTransition

from pgm.timing import implicit


class FadeoutTransition(PigmentTransition):

    def apply(self, view, end_callback=None):
        PigmentTransition.apply(self, view, end_callback)

        params = {"duration": 500,
                  "transformation": implicit.DECELERATE,
                  "end_callback": lambda x: self.stop()}
        self.implicit.setup_next_animations(**params)

        self.implicit.opacity = 0
