# Copyright 2011 Canonical Ltd.
#
# This file is part of desktopcouch.
#
# desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
"""Tests for the plug-ins loading."""

import os

from desktopcouch.application import plugins
from unittest import TestCase
from desktopcouch.application.tests import test_context
import desktopcouch.application.platform as platform


class TestLoadPlugins(TestCase):
    """Tests for loading plug-ins."""

    def setUp(self):
        self.couchdb_port = platform.find_port(ctx=test_context)

    def test_load_plugins(self):
        """Test that plug-ins are loaded correctly."""
        # pylint: disable=W0201
        old_paths = plugins.DESKTOPCOUCH_PLUGIN_PATHS
        plugins.DESKTOPCOUCH_PLUGIN_PATHS = [os.path.join(
                os.path.dirname(__file__))]
        self._imported = None

        def _fake_import(name, *args, **kwargs):
            """Fake import to check that we get imported."""
            modname = name.replace('.test_', '.tests.test_')
            if modname == __name__:
                self._imported = modname
        old_import = __import__
        __builtins__['__import__'] = _fake_import
        plugins.load_plugins(self.couchdb_port)
        __builtins__['__import__'] = old_import
        plugins.DESKTOPCOUCH_PLUGIN_PATHS = old_paths
        self.assertEqual(self._imported, __name__)
