"""testing desktopcouch/start_local_couchdb.py module"""

import testtools
import os, sys
import desktopcouch.tests as test_environment
from desktopcouch.replication_services import ubuntuone
import desktopcouch
sys.path.append(
    os.path.join(os.path.split(desktopcouch.__file__)[0], "..", "contrib"))

class TestReplication(testtools.TestCase):
    """Testing that the database/designdoc filesystem loader works"""

    def setUp(self):
        super(TestReplication, self).setUp()
        self.db_apple = desktopcouch.records.server.CouchDatabase("apple",
                create=True, ctx=test_environment.test_context)
        other_context = test_environment.create_new_test_environment()
        self.db_banana = desktopcouch.records.server.CouchDatabase("banana",
                create=True, ctx=other_context)

    def test_creation(self):
        # XXX uhm?
        pass


class TestUbuntuoneReplication(testtools.TestCase):
    def setUp(self):
        super(TestUbuntuoneReplication, self).setUp()
        self.ctx = test_environment.create_new_test_environment()

    def test_exclusion(self):
        # When no ubuntuone pairing exists, we get a ValueError.
        self.assertRaises(ValueError, ubuntuone.ReplicationExclusion, ctx=self.ctx)

        # Make fake pairing...
        from desktopcouch.pair.couchdb_pairing import couchdb_io
        result = couchdb_io.put_static_paired_service(None, "ubuntuone",
                ctx=self.ctx)
        self.assertTrue(result != None)

        replication_info = ubuntuone.ReplicationExclusion(ctx=self.ctx)

        db = "banana"
        self.assertNotIn(db, replication_info.all_exclusions())
        replication_info.exclude(db)
        self.assertIn(db, replication_info.all_exclusions())
        replication_info.exclude(db)
        replication_info.exclude(db)
        self.assertIn(db, replication_info.all_exclusions())
        replication_info.replicate(db)
        self.assertNotIn(db, replication_info.all_exclusions())
        replication_info.replicate(db)
        replication_info.replicate(db)
        
