# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch-notes.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Rodrigo Moya <rodrigo.moya@canonical.com>


"""A dictionary based note record representation."""

from desktopcouch.records.record import Record

NOTE_RECORD_TYPE = 'http://www.freedesktop.org/wiki/Specifications/desktopcouch/note'

class Note(Record):
    """An Ubuntuone Note Record."""

    def __init__(self, data=None, record_id=None):
        super(Note, self).__init__(
            record_id=record_id, data=data, record_type=NOTE_RECORD_TYPE)
