/* DuplicityInstance.c generated by valac 0.12.1, the Vala compiler
 * generated from DuplicityInstance.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <gio/gunixinputstream.h>
#include <sys/wait.h>


#define DEJA_DUP_TYPE_DUPLICITY_INSTANCE (deja_dup_duplicity_instance_get_type ())
#define DEJA_DUP_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstance))
#define DEJA_DUP_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))

typedef struct _DejaDupDuplicityInstance DejaDupDuplicityInstance;
typedef struct _DejaDupDuplicityInstanceClass DejaDupDuplicityInstanceClass;
typedef struct _DejaDupDuplicityInstancePrivate DejaDupDuplicityInstancePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_SIMPLE_SETTINGS (deja_dup_simple_settings_get_type ())
#define DEJA_DUP_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettings))
#define DEJA_DUP_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))
#define DEJA_DUP_IS_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_IS_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_SIMPLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))

typedef struct _DejaDupSimpleSettings DejaDupSimpleSettings;
typedef struct _DejaDupSimpleSettingsClass DejaDupSimpleSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _DejaDupDuplicityInstanceReadLogLinesData DejaDupDuplicityInstanceReadLogLinesData;
typedef struct _DejaDupDuplicityInstanceReadLogData DejaDupDuplicityInstanceReadLogData;

struct _DejaDupDuplicityInstance {
	GObject parent_instance;
	DejaDupDuplicityInstancePrivate * priv;
};

struct _DejaDupDuplicityInstanceClass {
	GObjectClass parent_class;
	void (*start) (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error);
};

struct _DejaDupDuplicityInstancePrivate {
	gboolean _verbose;
	guint watch_id;
	GPid child_pid;
	gint* pipes;
	gint pipes_length1;
	gint _pipes_size_;
	GDataInputStream* reader;
	GFile* logfile;
	GFile* scriptfile;
	gboolean process_done;
	gint status;
	gboolean processed_a_message;
};

struct _DejaDupDuplicityInstanceReadLogLinesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupDuplicityInstance* self;
	GList* stanza;
	gchar* _tmp0_;
	gchar* line;
	gchar* _tmp1_;
	GError * err;
	GError * e2;
	GError * _inner_error_;
};

struct _DejaDupDuplicityInstanceReadLogData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupDuplicityInstance* self;
	GInputStream* stream;
	GFileInputStream* _tmp0_;
	GFileInputStream* _tmp1_;
	GUnixInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GError * e;
	GError * _inner_error_;
};


static gpointer deja_dup_duplicity_instance_parent_class = NULL;

GType deja_dup_duplicity_instance_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstancePrivate))
enum  {
	DEJA_DUP_DUPLICITY_INSTANCE_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE
};
gboolean deja_dup_duplicity_instance_is_started (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self);
void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error);
static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error);
static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value);
GType deja_dup_simple_settings_get_type (void) G_GNUC_CONST;
DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir);
#define DEJA_DUP_ROOT_PROMPT_KEY "root-prompt"
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _lambda1_ (DejaDupDuplicityInstance* self);
static void __lambda1__gspawn_child_setup_func (gpointer self);
static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status);
static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self);
static void deja_dup_duplicity_instance_read_log (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_duplicity_instance_read_log_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_);
void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self);
void deja_dup_duplicity_instance_pause (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_stop_child (DejaDupDuplicityInstance* self);
void deja_dup_duplicity_instance_resume (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_cont_child (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_read_log_lines_data_free (gpointer _data);
static void deja_dup_duplicity_instance_read_log_lines (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_duplicity_instance_read_log_lines_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_);
static gboolean deja_dup_duplicity_instance_read_log_lines_co (DejaDupDuplicityInstanceReadLogLinesData* data);
static void deja_dup_duplicity_instance_read_log_lines_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_duplicity_instance_send_done_for_status (DejaDupDuplicityInstance* self);
static gboolean _lambda2_ (DejaDupDuplicityInstance* self);
static gboolean __lambda2__gsource_func (gpointer self);
gboolean deja_dup_duplicity_instance_get_verbose (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza);
static void deja_dup_duplicity_instance_read_log_data_free (gpointer _data);
static gboolean deja_dup_duplicity_instance_read_log_co (DejaDupDuplicityInstanceReadLogData* data);
static void deja_dup_duplicity_instance_read_log_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gint deja_dup_duplicity_instance_num_suffix (const gchar* word, gchar ch, glong start);
static gchar* deja_dup_duplicity_instance_validated_string (const gchar* s);
static gchar* deja_dup_duplicity_instance_compress_string (const gchar* s_in);
static void deja_dup_duplicity_instance_split_line (const gchar* line, gchar*** split, int* split_length1);
static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza);
static gchar* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_duplicity_instance_finalize (GObject* obj);
static void _vala_deja_dup_duplicity_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_duplicity_instance_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _lambda1_ (DejaDupDuplicityInstance* self) {
	setsid ();
}


static void __lambda1__gspawn_child_setup_func (gpointer self) {
	_lambda1_ (self);
}


static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self) {
	deja_dup_duplicity_instance_spawn_finished (self, pid, status);
}


static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* verbose_str;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** myenv;
	gint myenv_length1;
	gint _myenv_size_;
	gint myenv_len;
	guint _tmp8_;
	guint env_len;
	gchar** _tmp9_ = NULL;
	gchar** real_envp;
	gint real_envp_length1;
	gint _real_envp_size_;
	gint i;
	gchar* _tmp18_;
	GList* argv;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* cache_dir;
	gchar* _tmp41_;
	gchar* user_cmd;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	guint _tmp76_;
	gchar** _tmp77_ = NULL;
	gchar** real_argv;
	gint real_argv_length1;
	gint _real_argv_size_;
	GPid _tmp82_;
	guint _tmp83_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_getenv ("DEJA_DUP_DEBUG");
	_tmp1_ = g_strdup (_tmp0_);
	verbose_str = _tmp1_;
	if (verbose_str != NULL) {
		gint _tmp3_;
		_tmp3_ = atoi (verbose_str);
		_tmp2_ = _tmp3_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		deja_dup_duplicity_instance_set_verbose (self, TRUE);
	}
	if (as_root) {
		DejaDupSimpleSettings* _tmp4_ = NULL;
		DejaDupSimpleSettings* settings;
		gboolean _tmp5_;
		_tmp4_ = deja_dup_get_settings (NULL);
		settings = _tmp4_;
		_tmp5_ = g_settings_get_boolean ((GSettings*) settings, DEJA_DUP_ROOT_PROMPT_KEY);
		if (!_tmp5_) {
			as_root = FALSE;
		}
		_g_object_unref0 (settings);
	}
	_tmp7_ = _tmp6_ = g_listenv ();
	myenv = _tmp7_;
	myenv_length1 = _vala_array_length (_tmp6_);
	_myenv_size_ = _vala_array_length (_tmp6_);
	myenv_len = 0;
	while (TRUE) {
		if (!(myenv[myenv_len] != NULL)) {
			break;
		}
		myenv_len = myenv_len + 1;
	}
	_tmp8_ = g_list_length (envp_in);
	env_len = myenv_len + _tmp8_;
	_tmp9_ = g_new0 (gchar*, (env_len + 1) + 1);
	real_envp = _tmp9_;
	real_envp_length1 = env_len + 1;
	_real_envp_size_ = env_len + 1;
	i = 0;
	{
		gboolean _tmp10_;
		_tmp10_ = TRUE;
		while (TRUE) {
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			if (!_tmp10_) {
				i = i + 1;
			}
			_tmp10_ = FALSE;
			if (!(i < myenv_len)) {
				break;
			}
			_tmp11_ = g_getenv (myenv[i]);
			_tmp12_ = g_strdup_printf ("%s=%s", myenv[i], _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (real_envp[i]);
			real_envp[i] = _tmp13_;
		}
	}
	{
		GList* env_collection;
		GList* env_it;
		env_collection = envp_in;
		for (env_it = env_collection; env_it != NULL; env_it = env_it->next) {
			gchar* _tmp14_;
			gchar* env;
			_tmp14_ = g_strdup ((const gchar*) env_it->data);
			env = _tmp14_;
			{
				gint _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp15_ = i;
				i = _tmp15_ + 1;
				_tmp16_ = g_strdup (env);
				_tmp17_ = _tmp16_;
				_g_free0 (real_envp[_tmp15_]);
				real_envp[_tmp15_] = _tmp17_;
				_g_free0 (env);
			}
		}
	}
	_tmp18_ = NULL;
	_g_free0 (real_envp[i]);
	real_envp[i] = _tmp18_;
	argv = NULL;
	{
		GList* arg_collection;
		GList* arg_it;
		arg_collection = argv_in;
		for (arg_it = arg_collection; arg_it != NULL; arg_it = arg_it->next) {
			gchar* _tmp19_;
			gchar* arg;
			_tmp19_ = g_strdup ((const gchar*) arg_it->data);
			arg = _tmp19_;
			{
				gchar* _tmp20_;
				_tmp20_ = g_strdup (arg);
				argv = g_list_append (argv, _tmp20_);
				_g_free0 (arg);
			}
		}
	}
	_tmp21_ = g_strdup ("--verbosity=9");
	argv = g_list_append (argv, _tmp21_);
	_tmp22_ = g_strdup ("--gpg-options=--no-use-agent");
	argv = g_list_append (argv, _tmp22_);
	_tmp23_ = g_get_user_cache_dir ();
	_tmp24_ = g_strdup (_tmp23_);
	cache_dir = _tmp24_;
	if (cache_dir != NULL) {
		gboolean add_dir;
		GFile* _tmp25_ = NULL;
		GFile* cache_file;
		GFile* _tmp26_ = NULL;
		gboolean _tmp27_;
		gboolean _tmp28_;
		add_dir = FALSE;
		_tmp25_ = g_file_new_for_path (cache_dir);
		cache_file = _tmp25_;
		_tmp26_ = g_file_get_child (cache_file, PACKAGE);
		_g_object_unref0 (cache_file);
		cache_file = _tmp26_;
		_tmp27_ = g_file_make_directory_with_parents (cache_file, NULL, &_inner_error_);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch30_g_io_error_exists;
			}
			goto __catch30_g_error;
		}
		if (_tmp28_) {
			add_dir = TRUE;
		}
		goto __finally30;
		__catch30_g_io_error_exists:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			add_dir = TRUE;
			_g_error_free0 (e);
		}
		goto __finally30;
		__catch30_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("DuplicityInstance.vala:86: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally30:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (cache_file);
				_g_free0 (cache_dir);
				__g_list_free__g_free0_0 (argv);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (verbose_str);
				return;
			} else {
				_g_object_unref0 (cache_file);
				_g_free0 (cache_dir);
				__g_list_free__g_free0_0 (argv);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (verbose_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (add_dir) {
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp29_ = g_file_get_path (cache_file);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat ("--archive-dir=", _tmp30_, NULL);
			argv = g_list_append (argv, _tmp31_);
			_g_free0 (_tmp30_);
		}
		_g_object_unref0 (cache_file);
	}
	if (as_root) {
		gint logfd;
		gchar* logname = NULL;
		gchar* _tmp32_ = NULL;
		gint _tmp33_;
		gint _tmp34_;
		GFile* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* _tmp38_ = NULL;
		logfd = 0;
		_tmp33_ = g_file_open_tmp (PACKAGE "-XXXXXX", &_tmp32_, &_inner_error_);
		_g_free0 (logname);
		logname = _tmp32_;
		_tmp34_ = _tmp33_;
		if (_inner_error_ != NULL) {
			_g_free0 (logname);
			goto __catch31_g_error;
		}
		logfd = _tmp34_;
		_tmp35_ = g_file_new_for_path (logname);
		_g_object_unref0 (self->priv->logfile);
		self->priv->logfile = _tmp35_;
		_g_free0 (logname);
		goto __finally31;
		__catch31_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("DuplicityInstance.vala:102: %s\n", e->message);
			g_signal_emit_by_name (self, "done", FALSE, FALSE);
			_g_error_free0 (e);
			_g_free0 (cache_dir);
			__g_list_free__g_free0_0 (argv);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (verbose_str);
			return;
		}
		__finally31:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (cache_dir);
				__g_list_free__g_free0_0 (argv);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (verbose_str);
				return;
			} else {
				_g_free0 (cache_dir);
				__g_list_free__g_free0_0 (argv);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (verbose_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp36_ = g_file_get_path (self->priv->logfile);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strdup_printf ("--log-file=%s", _tmp37_);
		argv = g_list_append (argv, _tmp38_);
		_g_free0 (_tmp37_);
	} else {
		gint _tmp39_;
		gchar* _tmp40_ = NULL;
		_tmp39_ = pipe (self->priv->pipes);
		if (_tmp39_ != 0) {
			g_signal_emit_by_name (self, "done", FALSE, FALSE);
			_g_free0 (cache_dir);
			__g_list_free__g_free0_0 (argv);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (verbose_str);
			return;
		}
		_tmp40_ = g_strdup_printf ("--log-fd=%d", self->priv->pipes[1]);
		argv = g_list_append (argv, _tmp40_);
	}
	_tmp41_ = g_strdup ("duplicity");
	argv = g_list_prepend (argv, _tmp41_);
	user_cmd = NULL;
	{
		GList* a_collection;
		GList* a_it;
		a_collection = argv;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			gchar* _tmp42_;
			gchar* a;
			_tmp42_ = g_strdup ((const gchar*) a_it->data);
			a = _tmp42_;
			{
				if (a == NULL) {
					_g_free0 (a);
					break;
				}
				if (user_cmd == NULL) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup (a);
					_g_free0 (user_cmd);
					user_cmd = _tmp43_;
				} else {
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_;
					gchar* _tmp46_ = NULL;
					_tmp44_ = g_shell_quote (a);
					_tmp45_ = _tmp44_;
					_tmp46_ = g_strdup_printf ("%s %s", user_cmd, _tmp45_);
					_g_free0 (user_cmd);
					user_cmd = _tmp46_;
					_g_free0 (_tmp45_);
				}
				_g_free0 (a);
			}
		}
	}
	if (as_root) {
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_;
		_tmp49_ = g_find_program_in_path ("gksu");
		_tmp50_ = _tmp49_;
		_tmp48_ = _tmp50_ != NULL;
		_g_free0 (_tmp50_);
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		_tmp51_ = g_find_program_in_path ("sh");
		_tmp52_ = _tmp51_;
		_tmp47_ = _tmp52_ != NULL;
		_g_free0 (_tmp52_);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		gchar* scriptname = NULL;
		gchar* _tmp53_ = NULL;
		gint _tmp54_;
		gint scriptfd;
		GFile* _tmp55_ = NULL;
		GString* _tmp56_ = NULL;
		GString* args;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_;
		gchar* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		_tmp54_ = g_file_open_tmp (PACKAGE "-XXXXXX", &_tmp53_, &_inner_error_);
		_g_free0 (scriptname);
		scriptname = _tmp53_;
		scriptfd = _tmp54_;
		if (_inner_error_ != NULL) {
			_g_free0 (scriptname);
			goto __catch32_g_error;
		}
		_tmp55_ = g_file_new_for_path (scriptname);
		_g_object_unref0 (self->priv->scriptfile);
		self->priv->scriptfile = _tmp55_;
		close (scriptfd);
		_tmp56_ = g_string_new ("");
		args = _tmp56_;
		{
			GList* env_collection;
			GList* env_it;
			env_collection = envp_in;
			for (env_it = env_collection; env_it != NULL; env_it = env_it->next) {
				gchar* _tmp57_;
				gchar* env;
				_tmp57_ = g_strdup ((const gchar*) env_it->data);
				env = _tmp57_;
				{
					gchar* _tmp58_ = NULL;
					gchar* _tmp59_;
					_tmp58_ = g_strdup_printf ("export '%s'\n", env);
					_tmp59_ = _tmp58_;
					g_string_append (args, _tmp59_);
					_g_free0 (_tmp59_);
					_g_free0 (env);
				}
			}
		}
		{
			GList* a_collection;
			GList* a_it;
			a_collection = argv;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				gchar* _tmp60_;
				gchar* a;
				_tmp60_ = g_strdup ((const gchar*) a_it->data);
				a = _tmp60_;
				{
					if (a == NULL) {
						_g_free0 (a);
						break;
					}
					if (args->len == 0) {
						gchar* _tmp61_ = NULL;
						gchar* _tmp62_;
						_tmp61_ = g_shell_quote (a);
						_tmp62_ = _tmp61_;
						g_string_append (args, _tmp62_);
						_g_free0 (_tmp62_);
					} else {
						gchar* _tmp63_ = NULL;
						gchar* _tmp64_;
						gchar* _tmp65_;
						gchar* _tmp66_;
						_tmp63_ = g_shell_quote (a);
						_tmp64_ = _tmp63_;
						_tmp65_ = g_strconcat (" ", _tmp64_, NULL);
						_tmp66_ = _tmp65_;
						g_string_append (args, _tmp66_);
						_g_free0 (_tmp66_);
						_g_free0 (_tmp64_);
					}
					_g_free0 (a);
				}
			}
		}
		g_file_replace_contents (self->priv->scriptfile, args->str, (gsize) args->len, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_string_free0 (args);
			_g_free0 (scriptname);
			goto __catch32_g_error;
		}
		__g_list_free__g_free0_0 (argv);
		argv = NULL;
		_tmp67_ = g_file_get_path (self->priv->scriptfile);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_shell_quote (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strdup_printf ("sh %s", _tmp70_);
		argv = g_list_prepend (argv, _tmp71_);
		_g_free0 (_tmp70_);
		_g_free0 (_tmp68_);
		_tmp72_ = g_get_application_name ();
		_tmp73_ = g_strdup (_tmp72_);
		argv = g_list_prepend (argv, _tmp73_);
		_tmp74_ = g_strdup ("--description");
		argv = g_list_prepend (argv, _tmp74_);
		_tmp75_ = g_strdup ("gksu");
		argv = g_list_prepend (argv, _tmp75_);
		_g_string_free0 (args);
		_g_free0 (scriptname);
		goto __finally32;
		__catch32_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("DuplicityInstance.vala:175: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally32:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (user_cmd);
				_g_free0 (cache_dir);
				__g_list_free__g_free0_0 (argv);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (verbose_str);
				return;
			} else {
				_g_free0 (user_cmd);
				_g_free0 (cache_dir);
				__g_list_free__g_free0_0 (argv);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (verbose_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp76_ = g_list_length (argv);
	_tmp77_ = g_new0 (gchar*, _tmp76_ + 1);
	real_argv = _tmp77_;
	real_argv_length1 = _tmp76_;
	_real_argv_size_ = _tmp76_;
	i = 0;
	{
		GList* a_collection;
		GList* a_it;
		a_collection = argv;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			gchar* _tmp78_;
			gchar* a;
			_tmp78_ = g_strdup ((const gchar*) a_it->data);
			a = _tmp78_;
			{
				gint _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_tmp80_ = g_strdup (a);
				_tmp81_ = _tmp80_;
				_g_free0 (real_argv[_tmp79_]);
				real_argv[_tmp79_] = _tmp81_;
				_g_free0 (a);
			}
		}
	}
	g_spawn_async_with_pipes (NULL, real_argv, real_envp, (((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_LEAVE_DESCRIPTORS_OPEN) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, __lambda1__gspawn_child_setup_func, self, &_tmp82_, NULL, NULL, NULL, &_inner_error_);
	self->priv->child_pid = _tmp82_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error_);
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (user_cmd);
			_g_free0 (cache_dir);
			__g_list_free__g_free0_0 (argv);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (verbose_str);
			return;
		} else {
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (user_cmd);
			_g_free0 (cache_dir);
			__g_list_free__g_free0_0 (argv);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (verbose_str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_debug ("DuplicityInstance.vala:196: Running the following duplicity (%i) comma" \
"nd: %s\n", (gint) self->priv->child_pid, user_cmd);
	_tmp83_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->child_pid, _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func, g_object_ref (self), g_object_unref);
	self->priv->watch_id = _tmp83_;
	if (self->priv->pipes[1] != (-1)) {
		close (self->priv->pipes[1]);
	}
	deja_dup_duplicity_instance_read_log (self, NULL, NULL);
	real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (user_cmd);
	_g_free0 (cache_dir);
	__g_list_free__g_free0_0 (argv);
	real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
	myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (verbose_str);
}


void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, gboolean as_root, GError** error) {
	DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS (self)->start (self, argv_in, envp_in, as_root, error);
}


gboolean deja_dup_duplicity_instance_is_started (DejaDupDuplicityInstance* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = ((gint) self->priv->child_pid) > 0;
	return result;
}


void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_duplicity_instance_is_started (self);
	if (_tmp0_) {
		deja_dup_duplicity_instance_kill_child (self);
	} else {
		g_signal_emit_by_name (self, "done", FALSE, TRUE);
	}
}


void deja_dup_duplicity_instance_pause (DejaDupDuplicityInstance* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_duplicity_instance_is_started (self);
	if (_tmp0_) {
		deja_dup_duplicity_instance_stop_child (self);
	}
}


void deja_dup_duplicity_instance_resume (DejaDupDuplicityInstance* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_duplicity_instance_is_started (self);
	if (_tmp0_) {
		deja_dup_duplicity_instance_cont_child (self);
	}
}


static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((pid_t) self->priv->child_pid, SIGKILL);
}


static void deja_dup_duplicity_instance_stop_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((pid_t) self->priv->child_pid, SIGSTOP);
}


static void deja_dup_duplicity_instance_cont_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((pid_t) self->priv->child_pid, SIGCONT);
}


static void deja_dup_duplicity_instance_read_log_lines_data_free (gpointer _data) {
	DejaDupDuplicityInstanceReadLogLinesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupDuplicityInstanceReadLogLinesData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_duplicity_instance_read_log_lines (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogLinesData* _data_;
	_data_ = g_slice_new0 (DejaDupDuplicityInstanceReadLogLinesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_duplicity_instance_read_log_lines);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_duplicity_instance_read_log_lines_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_duplicity_instance_read_log_lines_co (_data_);
}


static void deja_dup_duplicity_instance_read_log_lines_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_) {
	DejaDupDuplicityInstanceReadLogLinesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_duplicity_instance_read_log_lines_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogLinesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_duplicity_instance_read_log_lines_co (data);
}


static gboolean _lambda2_ (DejaDupDuplicityInstance* self) {
	gboolean result = FALSE;
	deja_dup_duplicity_instance_read_log_lines (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static gboolean deja_dup_duplicity_instance_read_log_lines_co (DejaDupDuplicityInstanceReadLogLinesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->stanza = NULL;
	while (TRUE) {
		if (!(data->self->priv->reader != NULL)) {
			break;
		}
		data->_state_ = 1;
		g_data_input_stream_read_line_async (data->self->priv->reader, G_PRIORITY_DEFAULT, NULL, deja_dup_duplicity_instance_read_log_lines_ready, data);
		return FALSE;
		_state_1:
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_data_input_stream_read_line_finish (data->self->priv->reader, data->_res_, NULL, &data->_inner_error_);
		data->line = data->_tmp0_;
		if (data->_inner_error_ != NULL) {
			goto __catch33_g_error;
		}
		if (data->line == NULL) {
			if (data->self->priv->process_done) {
				deja_dup_duplicity_instance_send_done_for_status (data->self);
				_g_free0 (data->line);
				break;
			} else {
				g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda2__gsource_func, g_object_ref (data->self), g_object_unref);
				_g_free0 (data->line);
				__g_list_free__g_free0_0 (data->stanza);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		if (g_strcmp0 (data->line, "") != 0) {
			if (data->self->priv->_verbose) {
				g_print ("DUPLICITY: %s\n", data->line);
			}
			data->_tmp1_ = g_strdup (data->line);
			data->stanza = g_list_append (data->stanza, data->_tmp1_);
		} else {
			if (data->stanza != NULL) {
				if (data->self->priv->_verbose) {
					g_print ("\n");
				}
				deja_dup_duplicity_instance_process_stanza (data->self, data->stanza);
				__g_list_free__g_free0_0 (data->stanza);
				data->stanza = NULL;
			}
		}
		_g_free0 (data->line);
		goto __finally33;
		__catch33_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("DuplicityInstance.vala:312: %s\n", data->err->message);
			_g_error_free0 (data->err);
			break;
		}
		__finally33:
		if (data->_inner_error_ != NULL) {
			__g_list_free__g_free0_0 (data->stanza);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (data->self->priv->reader);
	data->self->priv->reader = NULL;
	if (data->self->priv->logfile != NULL) {
		g_file_delete (data->self->priv->logfile, NULL, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			goto __catch34_g_error;
		}
		goto __finally34;
		__catch34_g_error:
		{
			data->e2 = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("DuplicityInstance.vala:322: %s\n", data->e2->message);
			_g_error_free0 (data->e2);
		}
		__finally34:
		if (data->_inner_error_ != NULL) {
			__g_list_free__g_free0_0 (data->stanza);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	g_object_unref ((GObject*) data->self);
	__g_list_free__g_free0_0 (data->stanza);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_duplicity_instance_read_log_data_free (gpointer _data) {
	DejaDupDuplicityInstanceReadLogData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupDuplicityInstanceReadLogData, data);
}


static void deja_dup_duplicity_instance_read_log (DejaDupDuplicityInstance* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogData* _data_;
	_data_ = g_slice_new0 (DejaDupDuplicityInstanceReadLogData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_duplicity_instance_read_log);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_duplicity_instance_read_log_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_duplicity_instance_read_log_co (_data_);
}


static void deja_dup_duplicity_instance_read_log_finish (DejaDupDuplicityInstance* self, GAsyncResult* _res_) {
	DejaDupDuplicityInstanceReadLogData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_duplicity_instance_read_log_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupDuplicityInstanceReadLogData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_duplicity_instance_read_log_co (data);
}


static gboolean deja_dup_duplicity_instance_read_log_co (DejaDupDuplicityInstanceReadLogData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->priv->logfile != NULL) {
		data->_state_ = 1;
		g_file_read_async (data->self->priv->logfile, G_PRIORITY_DEFAULT, NULL, deja_dup_duplicity_instance_read_log_ready, data);
		return FALSE;
		_state_1:
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_file_read_finish (data->self->priv->logfile, data->_res_, &data->_inner_error_);
		data->_tmp1_ = data->_tmp0_;
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->stream);
			goto __catch35_g_error;
		}
		_g_object_unref0 (data->stream);
		data->stream = (GInputStream*) data->_tmp1_;
	} else {
		data->_tmp2_ = NULL;
		data->_tmp2_ = (GUnixInputStream*) g_unix_input_stream_new (data->self->priv->pipes[0], TRUE);
		_g_object_unref0 (data->stream);
		data->stream = (GInputStream*) data->_tmp2_;
	}
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_data_input_stream_new (data->stream);
	_g_object_unref0 (data->self->priv->reader);
	data->self->priv->reader = data->_tmp3_;
	_g_object_unref0 (data->stream);
	goto __finally35;
	__catch35_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("DuplicityInstance.vala:346: %s\n", data->e->message);
		g_signal_emit_by_name (data->self, "done", FALSE, FALSE);
		_g_error_free0 (data->e);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally35:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_object_ref ((GObject*) data->self);
	deja_dup_duplicity_instance_read_log_lines (data->self, NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gint deja_dup_duplicity_instance_num_suffix (const gchar* word, gchar ch, glong start) {
	gint result = 0;
	gint rv;
	g_return_val_if_fail (word != NULL, 0);
	rv = 0;
	if (start < 0) {
		gint _tmp0_;
		_tmp0_ = strlen (word);
		start = ((glong) _tmp0_) - 1;
	}
	{
		glong i;
		i = start;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar _tmp2_;
				if (!_tmp1_) {
					i = i - 1;
					rv = rv + 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp2_ = string_get (word, i);
				if (_tmp2_ != ch) {
					break;
				}
			}
		}
	}
	result = rv;
	return result;
}


static gchar* deja_dup_duplicity_instance_validated_string (const gchar* s) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* rv;
	const gchar* p;
	gchar* _tmp5_;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_string_new ("");
	rv = _tmp0_;
	p = s;
	while (TRUE) {
		gchar _tmp1_;
		gunichar _tmp2_;
		gunichar ch;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = string_get (p, (glong) 0);
		if (!(_tmp1_ != 0)) {
			break;
		}
		_tmp2_ = g_utf8_get_char_validated (p, (gssize) (-1));
		ch = _tmp2_;
		if (ch == ((gunichar) (-1))) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = ch == ((gunichar) (-2));
		}
		if (_tmp3_) {
			g_string_append (rv, "�");
			p = (const gchar*) (((gchar*) p) + 1);
		} else {
			const gchar* _tmp4_ = NULL;
			g_string_append_unichar (rv, ch);
			_tmp4_ = g_utf8_next_char (p);
			p = _tmp4_;
		}
	}
	_tmp5_ = g_strdup (rv->str);
	result = _tmp5_;
	_g_string_free0 (rv);
	return result;
}


static gchar* deja_dup_duplicity_instance_compress_string (const gchar* s_in) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* rv;
	gint rv_length1;
	gint _rv_size_;
	gchar* s;
	gint s_length1;
	gint _s_size_;
	gint i;
	gint j;
	gchar* _tmp22_;
	g_return_val_if_fail (s_in != NULL, NULL);
	_tmp0_ = strlen (s_in);
	_tmp1_ = g_new0 (gchar, _tmp0_ + 1);
	rv = _tmp1_;
	rv_length1 = _tmp0_ + 1;
	_rv_size_ = _tmp0_ + 1;
	s = (gchar*) s_in;
	s_length1 = -1;
	_s_size_ = -1;
	i = 0;
	j = 0;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		if (!(s[i] != 0)) {
			break;
		}
		if (s[i] == '\\') {
			_tmp2_ = s[i + 1] != 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean bare_escape;
			bare_escape = FALSE;
			switch (s[i + 1]) {
				case 'b':
				{
					gint _tmp3_;
					_tmp3_ = j;
					j = _tmp3_ + 1;
					rv[_tmp3_] = '\b';
					i = i + 2;
					break;
				}
				case 'f':
				{
					gint _tmp4_;
					_tmp4_ = j;
					j = _tmp4_ + 1;
					rv[_tmp4_] = '\f';
					i = i + 2;
					break;
				}
				case 't':
				{
					gint _tmp5_;
					_tmp5_ = j;
					j = _tmp5_ + 1;
					rv[_tmp5_] = '\t';
					i = i + 2;
					break;
				}
				case 'n':
				{
					gint _tmp6_;
					_tmp6_ = j;
					j = _tmp6_ + 1;
					rv[_tmp6_] = '\n';
					i = i + 2;
					break;
				}
				case 'r':
				{
					gint _tmp7_;
					_tmp7_ = j;
					j = _tmp7_ + 1;
					rv[_tmp7_] = '\r';
					i = i + 2;
					break;
				}
				case 'v':
				{
					gint _tmp8_;
					_tmp8_ = j;
					j = _tmp8_ + 1;
					rv[_tmp8_] = '\xb';
					i = i + 2;
					break;
				}
				case 'a':
				{
					gint _tmp9_;
					_tmp9_ = j;
					j = _tmp9_ + 1;
					rv[_tmp9_] = '\x7';
					i = i + 2;
					break;
				}
				case 'x':
				{
					gboolean _tmp10_ = FALSE;
					if (s[i + 2] != 0) {
						_tmp10_ = s[i + 3] != 0;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						gchar* _tmp11_ = NULL;
						gchar* tmpstr;
						gint tmpstr_length1;
						gint _tmpstr_size_;
						gulong _tmp12_;
						gulong val;
						gint _tmp13_;
						_tmp11_ = g_new0 (gchar, 3);
						tmpstr = _tmp11_;
						tmpstr_length1 = 3;
						_tmpstr_size_ = 3;
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						_tmp12_ = strtoul ((const gchar*) tmpstr, NULL, 16);
						val = _tmp12_;
						_tmp13_ = j;
						j = _tmp13_ + 1;
						rv[_tmp13_] = (gchar) val;
						i = i + 4;
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				{
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_ = FALSE;
					if (s[i + 2] != 0) {
						_tmp15_ = s[i + 3] != 0;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						_tmp14_ = s[i + 4] != 0;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						gchar* _tmp16_ = NULL;
						gchar* tmpstr;
						gint tmpstr_length1;
						gint _tmpstr_size_;
						gulong _tmp17_;
						gulong val;
						gint _tmp18_;
						_tmp16_ = g_new0 (gchar, 4);
						tmpstr = _tmp16_;
						tmpstr_length1 = 4;
						_tmpstr_size_ = 4;
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						tmpstr[2] = s[i + 4];
						_tmp17_ = strtoul ((const gchar*) tmpstr, NULL, 8);
						val = _tmp17_;
						_tmp18_ = j;
						j = _tmp18_ + 1;
						rv[_tmp18_] = (gchar) val;
						i = i + 5;
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				default:
				{
					bare_escape = TRUE;
					break;
				}
			}
			if (bare_escape) {
				gint _tmp19_;
				_tmp19_ = j;
				j = _tmp19_ + 1;
				rv[_tmp19_] = s[i + 1];
				i = i + 2;
			}
		} else {
			gint _tmp20_;
			gint _tmp21_;
			_tmp20_ = j;
			j = _tmp20_ + 1;
			_tmp21_ = i;
			i = _tmp21_ + 1;
			rv[_tmp20_] = s[_tmp21_];
		}
	}
	_tmp22_ = g_strdup ((const gchar*) rv);
	result = _tmp22_;
	rv = (g_free (rv), NULL);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static void deja_dup_duplicity_instance_split_line (const gchar* line, gchar*** split, int* split_length1) {
	gchar** _split = NULL;
	int _split_length1 = 0;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** firstsplit;
	gint firstsplit_length1;
	gint _firstsplit_size_;
	GList* splitlist;
	gint i = 0;
	gboolean in_group;
	gchar* _tmp2_;
	gchar* group_word;
	guint _tmp24_;
	gchar** _tmp25_ = NULL;
	g_return_if_fail (line != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0);
	firstsplit = _tmp1_;
	firstsplit_length1 = _vala_array_length (_tmp0_);
	_firstsplit_size_ = _vala_array_length (_tmp0_);
	splitlist = NULL;
	in_group = FALSE;
	_tmp2_ = g_strdup ("");
	group_word = _tmp2_;
	{
		gboolean _tmp3_;
		i = 0;
		_tmp3_ = TRUE;
		while (TRUE) {
			gchar* _tmp4_;
			gchar* word;
			gboolean _tmp6_ = FALSE;
			if (!_tmp3_) {
				i = i + 1;
			}
			_tmp3_ = FALSE;
			if (!(firstsplit[i] != NULL)) {
				break;
			}
			_tmp4_ = g_strdup (firstsplit[i]);
			word = _tmp4_;
			if (firstsplit[i + 1] == NULL) {
				gchar* _tmp5_ = NULL;
				_tmp5_ = string_chomp (word);
				_g_free0 (word);
				word = _tmp5_;
			}
			if (!in_group) {
				gboolean _tmp7_;
				_tmp7_ = g_str_has_prefix (word, "\'");
				_tmp6_ = _tmp7_;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				in_group = TRUE;
			}
			if (in_group) {
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_;
				gchar* _tmp15_ = NULL;
				_tmp9_ = g_str_has_suffix (word, "\'");
				if (_tmp9_) {
					gint _tmp10_;
					gint _tmp11_;
					_tmp10_ = strlen (word);
					_tmp11_ = deja_dup_duplicity_instance_num_suffix (word, '\\', ((glong) _tmp10_) - 2);
					_tmp8_ = (_tmp11_ % 2) == 0;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					in_group = FALSE;
				} else {
					gint _tmp12_;
					_tmp12_ = deja_dup_duplicity_instance_num_suffix (word, '\\', (glong) (-1));
					if ((_tmp12_ % 2) == 1) {
						gint _tmp13_;
						gchar* _tmp14_ = NULL;
						_tmp13_ = strlen (word);
						_tmp14_ = string_substring (word, (glong) 0, (glong) (_tmp13_ - 2));
						_g_free0 (word);
						word = _tmp14_;
					}
				}
				_tmp15_ = deja_dup_duplicity_instance_compress_string (word);
				_g_free0 (word);
				word = _tmp15_;
				if (g_strcmp0 (group_word, "") == 0) {
					gchar* _tmp16_;
					_tmp16_ = g_strdup (word);
					_g_free0 (group_word);
					group_word = _tmp16_;
				} else {
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = g_strconcat (" ", word, NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (group_word, _tmp18_, NULL);
					_g_free0 (group_word);
					group_word = _tmp19_;
					_g_free0 (_tmp18_);
				}
				if (!in_group) {
					gint _tmp20_;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_;
					_tmp20_ = strlen (group_word);
					_tmp21_ = string_substring (group_word, (glong) 1, (glong) (_tmp20_ - 2));
					splitlist = g_list_append (splitlist, _tmp21_);
					_tmp22_ = g_strdup ("");
					_g_free0 (group_word);
					group_word = _tmp22_;
				}
			} else {
				gchar* _tmp23_;
				_tmp23_ = g_strdup (word);
				splitlist = g_list_append (splitlist, _tmp23_);
			}
			_g_free0 (word);
		}
	}
	_tmp24_ = g_list_length (splitlist);
	_tmp25_ = g_new0 (gchar*, _tmp24_ + 1);
	_split = (_vala_array_free (_split, _split_length1, (GDestroyNotify) g_free), NULL);
	_split = _tmp25_;
	_split_length1 = _tmp24_;
	i = 0;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = splitlist;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp26_;
			gchar* s;
			_tmp26_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp26_;
			{
				gint _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = i;
				i = _tmp27_ + 1;
				_tmp28_ = g_strdup (s);
				_tmp29_ = _tmp28_;
				_g_free0 (_split[_tmp27_]);
				_split[_tmp27_] = _tmp29_;
				_g_free0 (s);
			}
		}
	}
	_g_free0 (group_word);
	__g_list_free__g_free0_0 (splitlist);
	firstsplit = (_vala_array_free (firstsplit, firstsplit_length1, (GDestroyNotify) g_free), NULL);
	if (split) {
		*split = _split;
	} else {
		_split = (_vala_array_free (_split, _split_length1, (GDestroyNotify) g_free), NULL);
	}
	if (split_length1) {
		*split_length1 = _split_length1;
	}
}


static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza) {
	gchar** control_line = NULL;
	gint control_line_length1 = 0;
	gint _control_line_size_ = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp1_;
	GList* _tmp2_ = NULL;
	GList* data;
	gchar* _tmp3_ = NULL;
	gchar* text;
	g_return_if_fail (self != NULL);
	deja_dup_duplicity_instance_split_line ((const gchar*) stanza->data, &_tmp0_, &_tmp1_);
	control_line = (_vala_array_free (control_line, control_line_length1, (GDestroyNotify) g_free), NULL);
	control_line = _tmp0_;
	control_line_length1 = _tmp1_;
	_tmp2_ = deja_dup_duplicity_instance_grab_stanza_data (self, stanza);
	data = _tmp2_;
	_tmp3_ = deja_dup_duplicity_instance_grab_stanza_text (self, stanza);
	text = _tmp3_;
	self->priv->processed_a_message = TRUE;
	g_signal_emit_by_name (self, "message", control_line, control_line_length1, data, text);
	_g_free0 (text);
	__g_list_free__g_free0_0 (data);
	control_line = (_vala_array_free (control_line, control_line_length1, (GDestroyNotify) g_free), NULL);
}


static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza) {
	GList* result = NULL;
	GList* list;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	stanza = stanza->next;
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp0_;
			gchar* line;
			_tmp0_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = g_str_has_prefix (line, ". ");
				if (!_tmp1_) {
					gchar* _tmp2_ = NULL;
					gchar* _tmp3_;
					gchar* _tmp4_ = NULL;
					_tmp2_ = string_chomp (line);
					_tmp3_ = _tmp2_;
					_tmp4_ = deja_dup_duplicity_instance_validated_string (_tmp3_);
					list = g_list_append (list, _tmp4_);
					_g_free0 (_tmp3_);
				}
				_g_free0 (line);
			}
		}
	}
	result = list;
	return result;
}


static gchar* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* text;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	text = _tmp0_;
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp1_;
			gchar* line;
			_tmp1_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp1_;
			{
				gboolean _tmp2_;
				_tmp2_ = g_str_has_prefix (line, ". ");
				if (_tmp2_) {
					gchar** _tmp3_;
					gchar** _tmp4_ = NULL;
					gchar** split;
					gint split_length1;
					gint _split_size_;
					gchar* _tmp5_ = NULL;
					gchar* _tmp6_;
					gchar* _tmp7_ = NULL;
					_tmp4_ = _tmp3_ = g_strsplit (line, ". ", 2);
					split = _tmp4_;
					split_length1 = _vala_array_length (_tmp3_);
					_split_size_ = _vala_array_length (_tmp3_);
					_tmp5_ = deja_dup_duplicity_instance_validated_string (split[1]);
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strdup_printf ("%s%s\n", text, _tmp6_);
					_g_free0 (text);
					text = _tmp7_;
					_g_free0 (_tmp6_);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (line);
			}
		}
	}
	_tmp8_ = string_chomp (text);
	result = _tmp8_;
	_g_free0 (text);
	return result;
}


static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->status = status;
	_tmp0_ = WIFEXITED (status);
	if (_tmp0_) {
		gint _tmp1_;
		gint exitval;
		_tmp1_ = WEXITSTATUS (status);
		exitval = _tmp1_;
		g_debug ("DuplicityInstance.vala:568: duplicity (%i) exited with value %i\n", (gint) pid, exitval);
	} else {
		g_debug ("DuplicityInstance.vala:571: duplicity (%i) process killed\n", (gint) pid);
	}
	self->priv->watch_id = (guint) 0;
	g_spawn_close_pid (pid);
	self->priv->process_done = TRUE;
	if (self->priv->reader == NULL) {
		deja_dup_duplicity_instance_send_done_for_status (self);
	}
}


static void deja_dup_duplicity_instance_send_done_for_status (DejaDupDuplicityInstance* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean success;
	gboolean _tmp3_;
	gboolean cancelled;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = WIFEXITED (self->priv->status);
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = WEXITSTATUS (self->priv->status);
		_tmp0_ = _tmp2_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	success = _tmp0_;
	_tmp3_ = WIFEXITED (self->priv->status);
	cancelled = !_tmp3_;
	_tmp6_ = WIFEXITED (self->priv->status);
	if (_tmp6_) {
		_tmp5_ = !self->priv->processed_a_message;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp7_ = FALSE;
		gint _tmp8_;
		_tmp8_ = WEXITSTATUS (self->priv->status);
		if (_tmp8_ == 255) {
			_tmp7_ = TRUE;
		} else {
			gint _tmp9_;
			_tmp9_ = WEXITSTATUS (self->priv->status);
			_tmp7_ = _tmp9_ == 3;
		}
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		cancelled = TRUE;
	}
	_tmp10_ = WIFEXITED (self->priv->status);
	if (_tmp10_) {
		gint _tmp11_;
		_tmp11_ = WEXITSTATUS (self->priv->status);
		g_signal_emit_by_name (self, "exited", _tmp11_);
	}
	self->priv->child_pid = (GPid) 0;
	g_signal_emit_by_name (self, "done", success, cancelled);
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type) {
	DejaDupDuplicityInstance * self = NULL;
	self = (DejaDupDuplicityInstance*) g_object_new (object_type, NULL);
	return self;
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void) {
	return deja_dup_duplicity_instance_construct (DEJA_DUP_TYPE_DUPLICITY_INSTANCE);
}


gboolean deja_dup_duplicity_instance_get_verbose (DejaDupDuplicityInstance* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_verbose;
	return result;
}


static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_verbose = value;
	g_object_notify ((GObject *) self, "verbose");
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_POINTER_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_string (param_values + 4), data2);
}


static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupDuplicityInstance * self;
	gint* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (deja_dup_duplicity_instance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	_tmp0_ = g_new0 (gint, 2);
	self->priv->pipes = (g_free (self->priv->pipes), NULL);
	self->priv->pipes = _tmp0_;
	self->priv->pipes_length1 = 2;
	self->priv->_pipes_size_ = 2;
	self->priv->pipes[1] = -1;
	self->priv->pipes[0] = self->priv->pipes[1];
	return obj;
}


static void deja_dup_duplicity_instance_class_init (DejaDupDuplicityInstanceClass * klass) {
	deja_dup_duplicity_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInstancePrivate));
	DEJA_DUP_DUPLICITY_INSTANCE_CLASS (klass)->start = deja_dup_duplicity_instance_real_start;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_duplicity_instance_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_duplicity_instance_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_duplicity_instance_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_instance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE, g_param_spec_boolean ("verbose", "verbose", "verbose", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("done", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	g_signal_new ("exited", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	g_signal_new ("message", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_POINTER, G_TYPE_STRING);
}


static void deja_dup_duplicity_instance_instance_init (DejaDupDuplicityInstance * self) {
	self->priv = DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE (self);
	self->priv->_verbose = FALSE;
}


static void deja_dup_duplicity_instance_finalize (GObject* obj) {
	DejaDupDuplicityInstance * self;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	if (self->priv->watch_id != 0) {
		g_source_remove (self->priv->watch_id);
	}
	_tmp0_ = deja_dup_duplicity_instance_is_started (self);
	if (_tmp0_) {
		g_debug ("DuplicityInstance.vala:251: duplicity (%i) process killed\n", (gint) self->priv->child_pid);
		deja_dup_duplicity_instance_kill_child (self);
	}
	if (self->priv->scriptfile != NULL) {
		g_file_delete (self->priv->scriptfile, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("DuplicityInstance.vala:259: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	self->priv->pipes = (g_free (self->priv->pipes), NULL);
	_g_object_unref0 (self->priv->reader);
	_g_object_unref0 (self->priv->logfile);
	_g_object_unref0 (self->priv->scriptfile);
	G_OBJECT_CLASS (deja_dup_duplicity_instance_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_instance_get_type (void) {
	static volatile gsize deja_dup_duplicity_instance_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_duplicity_instance_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInstance), 0, (GInstanceInitFunc) deja_dup_duplicity_instance_instance_init, NULL };
		GType deja_dup_duplicity_instance_type_id;
		deja_dup_duplicity_instance_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInstance", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_duplicity_instance_type_id__volatile, deja_dup_duplicity_instance_type_id);
	}
	return deja_dup_duplicity_instance_type_id__volatile;
}


static void _vala_deja_dup_duplicity_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		g_value_set_boolean (value, deja_dup_duplicity_instance_get_verbose (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_duplicity_instance_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		deja_dup_duplicity_instance_set_verbose (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



