/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "ring_options.h"

static int RingOptionsDisplayPrivateIndex;

static CompMetadata ringOptionsMetadata;

static CompPluginVTable *ringPluginVTable = NULL;
CompPluginVTable ringOptionsVTable;

#define RING_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, RingOptions, o)
#define RING_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, RingOptions, o)

typedef struct _RingOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[RingDisplayOptionNum];
    ringDisplayOptionChangeNotifyProc notify[RingDisplayOptionNum];
} RingOptionsDisplay;

typedef struct _RingOptionsScreen
{
    CompOption opt[RingScreenOptionNum];
    ringScreenOptionChangeNotifyProc notify[RingScreenOptionNum];
} RingOptionsScreen;

CompAction * ringGetNextKey (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextKey].value.action;
}

void ringSetNextKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextKey].value.action.initiate = init;
}

void ringSetNextKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextKey].value.action.terminate = term;
}

CompOption * ringGetNextKeyOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextKey];
}

void ringSetNextKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionNextKey] = notify;
}

CompAction * ringGetNextButton (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextButton].value.action;
}

void ringSetNextButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextButton].value.action.initiate = init;
}

void ringSetNextButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextButton].value.action.terminate = term;
}

CompOption * ringGetNextButtonOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextButton];
}

void ringSetNextButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionNextButton] = notify;
}

CompAction * ringGetPrevKey (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevKey].value.action;
}

void ringSetPrevKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevKey].value.action.initiate = init;
}

void ringSetPrevKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevKey].value.action.terminate = term;
}

CompOption * ringGetPrevKeyOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevKey];
}

void ringSetPrevKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionPrevKey] = notify;
}

CompAction * ringGetPrevButton (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevButton].value.action;
}

void ringSetPrevButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevButton].value.action.initiate = init;
}

void ringSetPrevButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevButton].value.action.terminate = term;
}

CompOption * ringGetPrevButtonOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevButton];
}

void ringSetPrevButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionPrevButton] = notify;
}

CompAction * ringGetNextAllKey (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextAllKey].value.action;
}

void ringSetNextAllKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextAllKey].value.action.initiate = init;
}

void ringSetNextAllKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextAllKey].value.action.terminate = term;
}

CompOption * ringGetNextAllKeyOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextAllKey];
}

void ringSetNextAllKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionNextAllKey] = notify;
}

CompAction * ringGetNextAllButton (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextAllButton].value.action;
}

void ringSetNextAllButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextAllButton].value.action.initiate = init;
}

void ringSetNextAllButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextAllButton].value.action.terminate = term;
}

CompOption * ringGetNextAllButtonOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextAllButton];
}

void ringSetNextAllButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionNextAllButton] = notify;
}

CompAction * ringGetPrevAllKey (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevAllKey].value.action;
}

void ringSetPrevAllKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevAllKey].value.action.initiate = init;
}

void ringSetPrevAllKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevAllKey].value.action.terminate = term;
}

CompOption * ringGetPrevAllKeyOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevAllKey];
}

void ringSetPrevAllKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionPrevAllKey] = notify;
}

CompAction * ringGetPrevAllButton (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevAllButton].value.action;
}

void ringSetPrevAllButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevAllButton].value.action.initiate = init;
}

void ringSetPrevAllButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevAllButton].value.action.terminate = term;
}

CompOption * ringGetPrevAllButtonOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevAllButton];
}

void ringSetPrevAllButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionPrevAllButton] = notify;
}

CompAction * ringGetNextGroupKey (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextGroupKey].value.action;
}

void ringSetNextGroupKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextGroupKey].value.action.initiate = init;
}

void ringSetNextGroupKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextGroupKey].value.action.terminate = term;
}

CompOption * ringGetNextGroupKeyOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextGroupKey];
}

void ringSetNextGroupKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionNextGroupKey] = notify;
}

CompAction * ringGetNextGroupButton (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextGroupButton].value.action;
}

void ringSetNextGroupButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextGroupButton].value.action.initiate = init;
}

void ringSetNextGroupButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionNextGroupButton].value.action.terminate = term;
}

CompOption * ringGetNextGroupButtonOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionNextGroupButton];
}

void ringSetNextGroupButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionNextGroupButton] = notify;
}

CompAction * ringGetPrevGroupKey (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevGroupKey].value.action;
}

void ringSetPrevGroupKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevGroupKey].value.action.initiate = init;
}

void ringSetPrevGroupKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevGroupKey].value.action.terminate = term;
}

CompOption * ringGetPrevGroupKeyOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevGroupKey];
}

void ringSetPrevGroupKeyNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionPrevGroupKey] = notify;
}

CompAction * ringGetPrevGroupButton (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevGroupButton].value.action;
}

void ringSetPrevGroupButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevGroupButton].value.action.initiate = init;
}

void ringSetPrevGroupButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    RING_OPTIONS_DISPLAY(d);
    od->opt[RingDisplayOptionPrevGroupButton].value.action.terminate = term;
}

CompOption * ringGetPrevGroupButtonOption (CompDisplay *d)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[RingDisplayOptionPrevGroupButton];
}

void ringSetPrevGroupButtonNotify (CompDisplay *d, ringDisplayOptionChangeNotifyProc notify)
{
    RING_OPTIONS_DISPLAY(d);
    od->notify[RingDisplayOptionPrevGroupButton] = notify;
}

float ringGetSpeed (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionSpeed].value.f;
}

CompOption * ringGetSpeedOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionSpeed];
}

void ringSetSpeedNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionSpeed] = notify;
}

float ringGetTimestep (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTimestep].value.f;
}

CompOption * ringGetTimestepOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionTimestep];
}

void ringSetTimestepNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionTimestep] = notify;
}

int ringGetInactiveOpacity (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionInactiveOpacity].value.i;
}

CompOption * ringGetInactiveOpacityOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionInactiveOpacity];
}

void ringSetInactiveOpacityNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionInactiveOpacity] = notify;
}

CompMatch * ringGetWindowMatch (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionWindowMatch].value.match;
}

CompOption * ringGetWindowMatchOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionWindowMatch];
}

void ringSetWindowMatchNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionWindowMatch] = notify;
}

int ringGetOverlayIcon (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionOverlayIcon].value.i;
}

CompOption * ringGetOverlayIconOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionOverlayIcon];
}

void ringSetOverlayIconNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionOverlayIcon] = notify;
}

Bool ringGetDarkenBack (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionDarkenBack].value.b;
}

CompOption * ringGetDarkenBackOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionDarkenBack];
}

void ringSetDarkenBackNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionDarkenBack] = notify;
}

Bool ringGetMinimized (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionMinimized].value.b;
}

CompOption * ringGetMinimizedOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionMinimized];
}

void ringSetMinimizedNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionMinimized] = notify;
}

Bool ringGetSelectWithMouse (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionSelectWithMouse].value.b;
}

CompOption * ringGetSelectWithMouseOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionSelectWithMouse];
}

void ringSetSelectWithMouseNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionSelectWithMouse] = notify;
}

Bool ringGetRingClockwise (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionRingClockwise].value.b;
}

CompOption * ringGetRingClockwiseOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionRingClockwise];
}

void ringSetRingClockwiseNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionRingClockwise] = notify;
}

int ringGetRingWidth (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionRingWidth].value.i;
}

CompOption * ringGetRingWidthOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionRingWidth];
}

void ringSetRingWidthNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionRingWidth] = notify;
}

int ringGetRingHeight (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionRingHeight].value.i;
}

CompOption * ringGetRingHeightOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionRingHeight];
}

void ringSetRingHeightNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionRingHeight] = notify;
}

int ringGetThumbWidth (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionThumbWidth].value.i;
}

CompOption * ringGetThumbWidthOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionThumbWidth];
}

void ringSetThumbWidthNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionThumbWidth] = notify;
}

int ringGetThumbHeight (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionThumbHeight].value.i;
}

CompOption * ringGetThumbHeightOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionThumbHeight];
}

void ringSetThumbHeightNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionThumbHeight] = notify;
}

float ringGetMinBrightness (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionMinBrightness].value.f;
}

CompOption * ringGetMinBrightnessOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionMinBrightness];
}

void ringSetMinBrightnessNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionMinBrightness] = notify;
}

float ringGetMinScale (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionMinScale].value.f;
}

CompOption * ringGetMinScaleOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionMinScale];
}

void ringSetMinScaleNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionMinScale] = notify;
}

Bool ringGetWindowTitle (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionWindowTitle].value.b;
}

CompOption * ringGetWindowTitleOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionWindowTitle];
}

void ringSetWindowTitleNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionWindowTitle] = notify;
}

Bool ringGetTitleFontBold (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleFontBold].value.b;
}

CompOption * ringGetTitleFontBoldOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionTitleFontBold];
}

void ringSetTitleFontBoldNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionTitleFontBold] = notify;
}

int ringGetTitleFontSize (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleFontSize].value.i;
}

CompOption * ringGetTitleFontSizeOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionTitleFontSize];
}

void ringSetTitleFontSizeNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionTitleFontSize] = notify;
}

unsigned short * ringGetTitleBackColor (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleBackColor].value.c;
}

unsigned short ringGetTitleBackColorRed (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleBackColor].value.c[0];
}

unsigned short ringGetTitleBackColorGreen (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleBackColor].value.c[1];
}

unsigned short ringGetTitleBackColorBlue (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleBackColor].value.c[2];
}

unsigned short ringGetTitleBackColorAlpha (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleBackColor].value.c[3];
}

CompOption * ringGetTitleBackColorOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionTitleBackColor];
}

void ringSetTitleBackColorNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionTitleBackColor] = notify;
}

unsigned short * ringGetTitleFontColor (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleFontColor].value.c;
}

unsigned short ringGetTitleFontColorRed (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleFontColor].value.c[0];
}

unsigned short ringGetTitleFontColorGreen (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleFontColor].value.c[1];
}

unsigned short ringGetTitleFontColorBlue (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleFontColor].value.c[2];
}

unsigned short ringGetTitleFontColorAlpha (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleFontColor].value.c[3];
}

CompOption * ringGetTitleFontColorOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionTitleFontColor];
}

void ringSetTitleFontColorNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionTitleFontColor] = notify;
}

int ringGetTitleTextPlacement (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return os->opt[RingScreenOptionTitleTextPlacement].value.i;
}

CompOption * ringGetTitleTextPlacementOption (CompScreen *s)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[RingScreenOptionTitleTextPlacement];
}

void ringSetTitleTextPlacementNotify (CompScreen *s, ringScreenOptionChangeNotifyProc notify)
{
    RING_OPTIONS_SCREEN(s);
    os->notify[RingScreenOptionTitleTextPlacement] = notify;
}

CompOption * ringGetDisplayOption (CompDisplay *d, RingDisplayOptions num)
{
    RING_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * ringGetScreenOption (CompScreen *s, RingScreenOptions num)
{
    RING_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo ringOptionsDisplayOptionInfo[] = {
    { "next_key", "key", 0, 0, 0 },
    { "next_button", "button", 0, 0, 0 },
    { "prev_key", "key", 0, 0, 0 },
    { "prev_button", "button", 0, 0, 0 },
    { "next_all_key", "key", 0, 0, 0 },
    { "next_all_button", "button", 0, 0, 0 },
    { "prev_all_key", "key", 0, 0, 0 },
    { "prev_all_button", "button", 0, 0, 0 },
    { "next_group_key", "key", 0, 0, 0 },
    { "next_group_button", "button", 0, 0, 0 },
    { "prev_group_key", "key", 0, 0, 0 },
    { "prev_group_button", "button", 0, 0, 0 },
};

static Bool ringOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    RING_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, RingDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case RingDisplayOptionNextKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionNextKey])
                (*od->notify[RingDisplayOptionNextKey]) (d, o, RingDisplayOptionNextKey);
            return TRUE;
        }
        break;
     case RingDisplayOptionNextButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionNextButton])
                (*od->notify[RingDisplayOptionNextButton]) (d, o, RingDisplayOptionNextButton);
            return TRUE;
        }
        break;
     case RingDisplayOptionPrevKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionPrevKey])
                (*od->notify[RingDisplayOptionPrevKey]) (d, o, RingDisplayOptionPrevKey);
            return TRUE;
        }
        break;
     case RingDisplayOptionPrevButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionPrevButton])
                (*od->notify[RingDisplayOptionPrevButton]) (d, o, RingDisplayOptionPrevButton);
            return TRUE;
        }
        break;
     case RingDisplayOptionNextAllKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionNextAllKey])
                (*od->notify[RingDisplayOptionNextAllKey]) (d, o, RingDisplayOptionNextAllKey);
            return TRUE;
        }
        break;
     case RingDisplayOptionNextAllButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionNextAllButton])
                (*od->notify[RingDisplayOptionNextAllButton]) (d, o, RingDisplayOptionNextAllButton);
            return TRUE;
        }
        break;
     case RingDisplayOptionPrevAllKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionPrevAllKey])
                (*od->notify[RingDisplayOptionPrevAllKey]) (d, o, RingDisplayOptionPrevAllKey);
            return TRUE;
        }
        break;
     case RingDisplayOptionPrevAllButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionPrevAllButton])
                (*od->notify[RingDisplayOptionPrevAllButton]) (d, o, RingDisplayOptionPrevAllButton);
            return TRUE;
        }
        break;
     case RingDisplayOptionNextGroupKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionNextGroupKey])
                (*od->notify[RingDisplayOptionNextGroupKey]) (d, o, RingDisplayOptionNextGroupKey);
            return TRUE;
        }
        break;
     case RingDisplayOptionNextGroupButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionNextGroupButton])
                (*od->notify[RingDisplayOptionNextGroupButton]) (d, o, RingDisplayOptionNextGroupButton);
            return TRUE;
        }
        break;
     case RingDisplayOptionPrevGroupKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionPrevGroupKey])
                (*od->notify[RingDisplayOptionPrevGroupKey]) (d, o, RingDisplayOptionPrevGroupKey);
            return TRUE;
        }
        break;
     case RingDisplayOptionPrevGroupButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[RingDisplayOptionPrevGroupButton])
                (*od->notify[RingDisplayOptionPrevGroupButton]) (d, o, RingDisplayOptionPrevGroupButton);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * ringOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    RING_OPTIONS_DISPLAY(d);
    *count = RingDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo ringOptionsScreenOptionInfo[] = {
    { "speed", "float", "<min>0.1</min><max>50.0</max>", 0, 0 },
    { "timestep", "float", "<min>0.1</min><max>50.0</max>", 0, 0 },
    { "inactive_opacity", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "window_match", "match", 0, 0, 0 },
    { "overlay_icon", "int", "<min>0</min><max>2</max>", 0, 0 },
    { "darken_back", "bool", 0, 0, 0 },
    { "minimized", "bool", 0, 0, 0 },
    { "select_with_mouse", "bool", 0, 0, 0 },
    { "ring_clockwise", "bool", 0, 0, 0 },
    { "ring_width", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "ring_height", "int", "<min>1</min><max>100</max>", 0, 0 },
    { "thumb_width", "int", "<min>10</min><max>1024</max>", 0, 0 },
    { "thumb_height", "int", "<min>10</min><max>1024</max>", 0, 0 },
    { "min_brightness", "float", "<min>0.1</min><max>1.0</max>", 0, 0 },
    { "min_scale", "float", "<min>0.1</min><max>1.0</max>", 0, 0 },
    { "window_title", "bool", 0, 0, 0 },
    { "title_font_bold", "bool", 0, 0, 0 },
    { "title_font_size", "int", "<min>6</min><max>96</max>", 0, 0 },
    { "title_back_color", "color", 0, 0, 0 },
    { "title_font_color", "color", 0, 0, 0 },
    { "title_text_placement", "int", "<min>0</min><max>2</max>", 0, 0 },
};

static Bool ringOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    RING_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, RingScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case RingScreenOptionSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionSpeed])
                (*os->notify[RingScreenOptionSpeed]) (s, o, RingScreenOptionSpeed);
            return TRUE;
        }
        break;
     case RingScreenOptionTimestep:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionTimestep])
                (*os->notify[RingScreenOptionTimestep]) (s, o, RingScreenOptionTimestep);
            return TRUE;
        }
        break;
     case RingScreenOptionInactiveOpacity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionInactiveOpacity])
                (*os->notify[RingScreenOptionInactiveOpacity]) (s, o, RingScreenOptionInactiveOpacity);
            return TRUE;
        }
        break;
     case RingScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionWindowMatch])
                (*os->notify[RingScreenOptionWindowMatch]) (s, o, RingScreenOptionWindowMatch);
            return TRUE;
        }
        break;
     case RingScreenOptionOverlayIcon:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionOverlayIcon])
                (*os->notify[RingScreenOptionOverlayIcon]) (s, o, RingScreenOptionOverlayIcon);
            return TRUE;
        }
        break;
     case RingScreenOptionDarkenBack:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionDarkenBack])
                (*os->notify[RingScreenOptionDarkenBack]) (s, o, RingScreenOptionDarkenBack);
            return TRUE;
        }
        break;
     case RingScreenOptionMinimized:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionMinimized])
                (*os->notify[RingScreenOptionMinimized]) (s, o, RingScreenOptionMinimized);
            return TRUE;
        }
        break;
     case RingScreenOptionSelectWithMouse:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionSelectWithMouse])
                (*os->notify[RingScreenOptionSelectWithMouse]) (s, o, RingScreenOptionSelectWithMouse);
            return TRUE;
        }
        break;
     case RingScreenOptionRingClockwise:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionRingClockwise])
                (*os->notify[RingScreenOptionRingClockwise]) (s, o, RingScreenOptionRingClockwise);
            return TRUE;
        }
        break;
     case RingScreenOptionRingWidth:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionRingWidth])
                (*os->notify[RingScreenOptionRingWidth]) (s, o, RingScreenOptionRingWidth);
            return TRUE;
        }
        break;
     case RingScreenOptionRingHeight:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionRingHeight])
                (*os->notify[RingScreenOptionRingHeight]) (s, o, RingScreenOptionRingHeight);
            return TRUE;
        }
        break;
     case RingScreenOptionThumbWidth:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionThumbWidth])
                (*os->notify[RingScreenOptionThumbWidth]) (s, o, RingScreenOptionThumbWidth);
            return TRUE;
        }
        break;
     case RingScreenOptionThumbHeight:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionThumbHeight])
                (*os->notify[RingScreenOptionThumbHeight]) (s, o, RingScreenOptionThumbHeight);
            return TRUE;
        }
        break;
     case RingScreenOptionMinBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionMinBrightness])
                (*os->notify[RingScreenOptionMinBrightness]) (s, o, RingScreenOptionMinBrightness);
            return TRUE;
        }
        break;
     case RingScreenOptionMinScale:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionMinScale])
                (*os->notify[RingScreenOptionMinScale]) (s, o, RingScreenOptionMinScale);
            return TRUE;
        }
        break;
     case RingScreenOptionWindowTitle:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionWindowTitle])
                (*os->notify[RingScreenOptionWindowTitle]) (s, o, RingScreenOptionWindowTitle);
            return TRUE;
        }
        break;
     case RingScreenOptionTitleFontBold:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionTitleFontBold])
                (*os->notify[RingScreenOptionTitleFontBold]) (s, o, RingScreenOptionTitleFontBold);
            return TRUE;
        }
        break;
     case RingScreenOptionTitleFontSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionTitleFontSize])
                (*os->notify[RingScreenOptionTitleFontSize]) (s, o, RingScreenOptionTitleFontSize);
            return TRUE;
        }
        break;
     case RingScreenOptionTitleBackColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionTitleBackColor])
                (*os->notify[RingScreenOptionTitleBackColor]) (s, o, RingScreenOptionTitleBackColor);
            return TRUE;
        }
        break;
     case RingScreenOptionTitleFontColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionTitleFontColor])
                (*os->notify[RingScreenOptionTitleFontColor]) (s, o, RingScreenOptionTitleFontColor);
            return TRUE;
        }
        break;
     case RingScreenOptionTitleTextPlacement:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[RingScreenOptionTitleTextPlacement])
                (*os->notify[RingScreenOptionTitleTextPlacement]) (s, o, RingScreenOptionTitleTextPlacement);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * ringOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    RING_OPTIONS_SCREEN(s);
    *count = RingScreenOptionNum;
    return os->opt;
}

static Bool ringOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    RingOptionsScreen *os;
    
    RING_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(RingOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &ringOptionsMetadata, ringOptionsScreenOptionInfo, os->opt, RingScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void ringOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    RING_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, RingScreenOptionNum);

    free (os);
}

static Bool ringOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    RingOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(RingOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[RingOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &ringOptionsMetadata, ringOptionsDisplayOptionInfo, od->opt, RingDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void ringOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    RING_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, RingDisplayOptionNum);

    free (od);
}

static Bool ringOptionsInit (CompPlugin *p)
{
    RingOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (RingOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&ringOptionsMetadata, "ring",ringOptionsDisplayOptionInfo, RingDisplayOptionNum, ringOptionsScreenOptionInfo, RingScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&ringOptionsMetadata, "ring");
    if (ringPluginVTable && ringPluginVTable->init)
        return ringPluginVTable->init (p);
    return TRUE;
}

static void ringOptionsFini (CompPlugin *p)
{
    if (ringPluginVTable && ringPluginVTable->fini)
        ringPluginVTable->fini (p);

    if (RingOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (RingOptionsDisplayPrivateIndex);

    compFiniMetadata (&ringOptionsMetadata);
}

static CompBool ringOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) ringOptionsInitDisplay,
        (InitPluginObjectProc) ringOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void ringOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) ringOptionsFiniDisplay,
        (FiniPluginObjectProc) ringOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool ringOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = ringOptionsInitObject (p, o);
    if (ringPluginVTable->initObject)
        rv &= ringPluginVTable->initObject (p, o);
    return rv;
}

static void ringOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (ringPluginVTable->finiObject)
        ringPluginVTable->finiObject (p, o);
    ringOptionsFiniObject (p, o);
}

static CompOption * ringOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) ringOptionsGetDisplayOptions,
        (GetPluginObjectOptionsProc) ringOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool ringOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) ringOptionsSetDisplayOption,
        (SetPluginObjectOptionProc) ringOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
ringOptionsGetMetadata (CompPlugin *plugin)
{
    return &ringOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!ringPluginVTable)
    {
        ringPluginVTable = getCompPluginInfo ();
        memcpy(&ringOptionsVTable, ringPluginVTable, sizeof(CompPluginVTable));
        ringOptionsVTable.getMetadata = ringOptionsGetMetadata;
        ringOptionsVTable.init = ringOptionsInit;
        ringOptionsVTable.fini = ringOptionsFini;
        ringOptionsVTable.initObject = ringOptionsInitObjectWrapper;
        ringOptionsVTable.finiObject = ringOptionsFiniObjectWrapper;
        ringOptionsVTable.getObjectOptions = ringOptionsGetObjectOptions;
	ringOptionsVTable.setObjectOption = ringOptionsSetObjectOption;
	
    }
    return &ringOptionsVTable;
}

