/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "expo_options.h"

static int ExpoOptionsDisplayPrivateIndex;

static CompMetadata expoOptionsMetadata;

static CompPluginVTable *expoPluginVTable = NULL;
CompPluginVTable expoOptionsVTable;

#define EXPO_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ExpoOptions, o)
#define EXPO_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ExpoOptions, o)

typedef struct _ExpoOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ExpoDisplayOptionNum];
    expoDisplayOptionChangeNotifyProc notify[ExpoDisplayOptionNum];
} ExpoOptionsDisplay;

typedef struct _ExpoOptionsScreen
{
} ExpoOptionsScreen;

CompAction * expoGetExpoKey (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoKey].value.action;
}

void expoSetExpoKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExpoKey].value.action.initiate = init;
}

void expoSetExpoKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExpoKey].value.action.terminate = term;
}

CompOption * expoGetExpoKeyOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoKey];
}

void expoSetExpoKeyNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionExpoKey] = notify;
}

CompAction * expoGetExpoButton (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoButton].value.action;
}

void expoSetExpoButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExpoButton].value.action.initiate = init;
}

void expoSetExpoButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExpoButton].value.action.terminate = term;
}

CompOption * expoGetExpoButtonOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoButton];
}

void expoSetExpoButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionExpoButton] = notify;
}

CompAction * expoGetExpoEdge (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoEdge].value.action;
}

void expoSetExpoEdgeInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExpoEdge].value.action.initiate = init;
}

void expoSetExpoEdgeTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExpoEdge].value.action.terminate = term;
}

CompOption * expoGetExpoEdgeOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoEdge];
}

void expoSetExpoEdgeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionExpoEdge] = notify;
}

int expoGetDoubleClickTime (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionDoubleClickTime].value.i;
}

CompOption * expoGetDoubleClickTimeOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionDoubleClickTime];
}

void expoSetDoubleClickTimeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionDoubleClickTime] = notify;
}

CompAction * expoGetDndButton (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionDndButton].value.action;
}

void expoSetDndButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionDndButton].value.action.initiate = init;
}

void expoSetDndButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionDndButton].value.action.terminate = term;
}

CompOption * expoGetDndButtonOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionDndButton];
}

void expoSetDndButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionDndButton] = notify;
}

CompAction * expoGetExitButton (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExitButton].value.action;
}

void expoSetExitButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExitButton].value.action.initiate = init;
}

void expoSetExitButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionExitButton].value.action.terminate = term;
}

CompOption * expoGetExitButtonOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExitButton];
}

void expoSetExitButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionExitButton] = notify;
}

CompAction * expoGetNextVpButton (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionNextVpButton].value.action;
}

void expoSetNextVpButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionNextVpButton].value.action.initiate = init;
}

void expoSetNextVpButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionNextVpButton].value.action.terminate = term;
}

CompOption * expoGetNextVpButtonOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionNextVpButton];
}

void expoSetNextVpButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionNextVpButton] = notify;
}

CompAction * expoGetPrevVpButton (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionPrevVpButton].value.action;
}

void expoSetPrevVpButtonInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionPrevVpButton].value.action.initiate = init;
}

void expoSetPrevVpButtonTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->opt[ExpoDisplayOptionPrevVpButton].value.action.terminate = term;
}

CompOption * expoGetPrevVpButtonOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionPrevVpButton];
}

void expoSetPrevVpButtonNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionPrevVpButton] = notify;
}

float expoGetZoomTime (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionZoomTime].value.f;
}

CompOption * expoGetZoomTimeOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionZoomTime];
}

void expoSetZoomTimeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionZoomTime] = notify;
}

Bool expoGetExpoImmediateMove (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionExpoImmediateMove].value.b;
}

CompOption * expoGetExpoImmediateMoveOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoImmediateMove];
}

void expoSetExpoImmediateMoveNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionExpoImmediateMove] = notify;
}

int expoGetExpoAnimation (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionExpoAnimation].value.i;
}

CompOption * expoGetExpoAnimationOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionExpoAnimation];
}

void expoSetExpoAnimationNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionExpoAnimation] = notify;
}

int expoGetDeform (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionDeform].value.i;
}

CompOption * expoGetDeformOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionDeform];
}

void expoSetDeformNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionDeform] = notify;
}

float expoGetDistance (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionDistance].value.f;
}

CompOption * expoGetDistanceOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionDistance];
}

void expoSetDistanceNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionDistance] = notify;
}

float expoGetVpDistance (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionVpDistance].value.f;
}

CompOption * expoGetVpDistanceOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionVpDistance];
}

void expoSetVpDistanceNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionVpDistance] = notify;
}

float expoGetAspectRatio (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionAspectRatio].value.f;
}

CompOption * expoGetAspectRatioOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionAspectRatio];
}

void expoSetAspectRatioNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionAspectRatio] = notify;
}

float expoGetCurve (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionCurve].value.f;
}

CompOption * expoGetCurveOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionCurve];
}

void expoSetCurveNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionCurve] = notify;
}

Bool expoGetHideDocks (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionHideDocks].value.b;
}

CompOption * expoGetHideDocksOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionHideDocks];
}

void expoSetHideDocksNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionHideDocks] = notify;
}

Bool expoGetMipmaps (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionMipmaps].value.b;
}

CompOption * expoGetMipmapsOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionMipmaps];
}

void expoSetMipmapsNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionMipmaps] = notify;
}

int expoGetMultioutputMode (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionMultioutputMode].value.i;
}

CompOption * expoGetMultioutputModeOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionMultioutputMode];
}

void expoSetMultioutputModeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionMultioutputMode] = notify;
}

float expoGetVpBrightness (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionVpBrightness].value.f;
}

CompOption * expoGetVpBrightnessOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionVpBrightness];
}

void expoSetVpBrightnessNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionVpBrightness] = notify;
}

float expoGetVpSaturation (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionVpSaturation].value.f;
}

CompOption * expoGetVpSaturationOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionVpSaturation];
}

void expoSetVpSaturationNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionVpSaturation] = notify;
}

Bool expoGetReflection (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionReflection].value.b;
}

CompOption * expoGetReflectionOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionReflection];
}

void expoSetReflectionNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionReflection] = notify;
}

unsigned short * expoGetGroundColor1 (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor1].value.c;
}

unsigned short expoGetGroundColor1Red (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor1].value.c[0];
}

unsigned short expoGetGroundColor1Green (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor1].value.c[1];
}

unsigned short expoGetGroundColor1Blue (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor1].value.c[2];
}

unsigned short expoGetGroundColor1Alpha (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor1].value.c[3];
}

CompOption * expoGetGroundColor1Option (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionGroundColor1];
}

void expoSetGroundColor1Notify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionGroundColor1] = notify;
}

unsigned short * expoGetGroundColor2 (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor2].value.c;
}

unsigned short expoGetGroundColor2Red (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor2].value.c[0];
}

unsigned short expoGetGroundColor2Green (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor2].value.c[1];
}

unsigned short expoGetGroundColor2Blue (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor2].value.c[2];
}

unsigned short expoGetGroundColor2Alpha (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundColor2].value.c[3];
}

CompOption * expoGetGroundColor2Option (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionGroundColor2];
}

void expoSetGroundColor2Notify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionGroundColor2] = notify;
}

float expoGetGroundSize (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionGroundSize].value.f;
}

CompOption * expoGetGroundSizeOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionGroundSize];
}

void expoSetGroundSizeNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionGroundSize] = notify;
}

float expoGetScaleFactor (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return od->opt[ExpoDisplayOptionScaleFactor].value.f;
}

CompOption * expoGetScaleFactorOption (CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[ExpoDisplayOptionScaleFactor];
}

void expoSetScaleFactorNotify (CompDisplay *d, expoDisplayOptionChangeNotifyProc notify)
{
    EXPO_OPTIONS_DISPLAY(d);
    od->notify[ExpoDisplayOptionScaleFactor] = notify;
}

CompOption * expoGetDisplayOption (CompDisplay *d, ExpoDisplayOptions num)
{
    EXPO_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo expoOptionsDisplayOptionInfo[] = {
    { "expo_key", "key", 0, 0, 0 },
    { "expo_button", "button", 0, 0, 0 },
    { "expo_edge", "edge", 0, 0, 0 },
    { "double_click_time", "int", "<min>50</min><max>2000</max>", 0, 0 },
    { "dnd_button", "button", 0, 0, 0 },
    { "exit_button", "button", 0, 0, 0 },
    { "next_vp_button", "button", 0, 0, 0 },
    { "prev_vp_button", "button", 0, 0, 0 },
    { "zoom_time", "float", "<min>0.1</min><max>5.0</max>", 0, 0 },
    { "expo_immediate_move", "bool", 0, 0, 0 },
    { "expo_animation", "int", "<min>0</min><max>2</max>", 0, 0 },
    { "deform", "int", "<min>0</min><max>2</max>", 0, 0 },
    { "distance", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "vp_distance", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "aspect_ratio", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "curve", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "hide_docks", "bool", 0, 0, 0 },
    { "mipmaps", "bool", 0, 0, 0 },
    { "multioutput_mode", "int", "<min>0</min><max>1</max>", 0, 0 },
    { "vp_brightness", "float", "<min>0.0</min><max>100.0</max>", 0, 0 },
    { "vp_saturation", "float", "<min>0.0</min><max>100.0</max>", 0, 0 },
    { "reflection", "bool", 0, 0, 0 },
    { "ground_color1", "color", 0, 0, 0 },
    { "ground_color2", "color", 0, 0, 0 },
    { "ground_size", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "scale_factor", "float", "<min>0.0</min><max>2.0</max>", 0, 0 },
};

static Bool expoOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    EXPO_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ExpoDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ExpoDisplayOptionExpoKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionExpoKey])
                (*od->notify[ExpoDisplayOptionExpoKey]) (d, o, ExpoDisplayOptionExpoKey);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionExpoButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionExpoButton])
                (*od->notify[ExpoDisplayOptionExpoButton]) (d, o, ExpoDisplayOptionExpoButton);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionExpoEdge:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionExpoEdge])
                (*od->notify[ExpoDisplayOptionExpoEdge]) (d, o, ExpoDisplayOptionExpoEdge);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionDoubleClickTime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionDoubleClickTime])
                (*od->notify[ExpoDisplayOptionDoubleClickTime]) (d, o, ExpoDisplayOptionDoubleClickTime);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionDndButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionDndButton])
                (*od->notify[ExpoDisplayOptionDndButton]) (d, o, ExpoDisplayOptionDndButton);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionExitButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionExitButton])
                (*od->notify[ExpoDisplayOptionExitButton]) (d, o, ExpoDisplayOptionExitButton);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionNextVpButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionNextVpButton])
                (*od->notify[ExpoDisplayOptionNextVpButton]) (d, o, ExpoDisplayOptionNextVpButton);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionPrevVpButton:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionPrevVpButton])
                (*od->notify[ExpoDisplayOptionPrevVpButton]) (d, o, ExpoDisplayOptionPrevVpButton);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionZoomTime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionZoomTime])
                (*od->notify[ExpoDisplayOptionZoomTime]) (d, o, ExpoDisplayOptionZoomTime);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionExpoImmediateMove:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionExpoImmediateMove])
                (*od->notify[ExpoDisplayOptionExpoImmediateMove]) (d, o, ExpoDisplayOptionExpoImmediateMove);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionExpoAnimation:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionExpoAnimation])
                (*od->notify[ExpoDisplayOptionExpoAnimation]) (d, o, ExpoDisplayOptionExpoAnimation);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionDeform:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionDeform])
                (*od->notify[ExpoDisplayOptionDeform]) (d, o, ExpoDisplayOptionDeform);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionDistance:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionDistance])
                (*od->notify[ExpoDisplayOptionDistance]) (d, o, ExpoDisplayOptionDistance);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionVpDistance:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionVpDistance])
                (*od->notify[ExpoDisplayOptionVpDistance]) (d, o, ExpoDisplayOptionVpDistance);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionAspectRatio:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionAspectRatio])
                (*od->notify[ExpoDisplayOptionAspectRatio]) (d, o, ExpoDisplayOptionAspectRatio);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionCurve:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionCurve])
                (*od->notify[ExpoDisplayOptionCurve]) (d, o, ExpoDisplayOptionCurve);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionHideDocks:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionHideDocks])
                (*od->notify[ExpoDisplayOptionHideDocks]) (d, o, ExpoDisplayOptionHideDocks);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionMipmaps:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionMipmaps])
                (*od->notify[ExpoDisplayOptionMipmaps]) (d, o, ExpoDisplayOptionMipmaps);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionMultioutputMode:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionMultioutputMode])
                (*od->notify[ExpoDisplayOptionMultioutputMode]) (d, o, ExpoDisplayOptionMultioutputMode);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionVpBrightness:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionVpBrightness])
                (*od->notify[ExpoDisplayOptionVpBrightness]) (d, o, ExpoDisplayOptionVpBrightness);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionVpSaturation:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionVpSaturation])
                (*od->notify[ExpoDisplayOptionVpSaturation]) (d, o, ExpoDisplayOptionVpSaturation);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionReflection:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionReflection])
                (*od->notify[ExpoDisplayOptionReflection]) (d, o, ExpoDisplayOptionReflection);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionGroundColor1:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionGroundColor1])
                (*od->notify[ExpoDisplayOptionGroundColor1]) (d, o, ExpoDisplayOptionGroundColor1);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionGroundColor2:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionGroundColor2])
                (*od->notify[ExpoDisplayOptionGroundColor2]) (d, o, ExpoDisplayOptionGroundColor2);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionGroundSize:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionGroundSize])
                (*od->notify[ExpoDisplayOptionGroundSize]) (d, o, ExpoDisplayOptionGroundSize);
            return TRUE;
        }
        break;
     case ExpoDisplayOptionScaleFactor:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExpoDisplayOptionScaleFactor])
                (*od->notify[ExpoDisplayOptionScaleFactor]) (d, o, ExpoDisplayOptionScaleFactor);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * expoOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    EXPO_OPTIONS_DISPLAY(d);
    *count = ExpoDisplayOptionNum;
    return od->opt;
}

static Bool expoOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ExpoOptionsScreen *os;
    
    EXPO_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ExpoOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void expoOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    EXPO_OPTIONS_SCREEN (s);

    free (os);
}

static Bool expoOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ExpoOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ExpoOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ExpoOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &expoOptionsMetadata, expoOptionsDisplayOptionInfo, od->opt, ExpoDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void expoOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    EXPO_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ExpoDisplayOptionNum);

    free (od);
}

static Bool expoOptionsInit (CompPlugin *p)
{
    ExpoOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ExpoOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&expoOptionsMetadata, "expo",expoOptionsDisplayOptionInfo, ExpoDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&expoOptionsMetadata, "expo");
    if (expoPluginVTable && expoPluginVTable->init)
        return expoPluginVTable->init (p);
    return TRUE;
}

static void expoOptionsFini (CompPlugin *p)
{
    if (expoPluginVTable && expoPluginVTable->fini)
        expoPluginVTable->fini (p);

    if (ExpoOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ExpoOptionsDisplayPrivateIndex);

    compFiniMetadata (&expoOptionsMetadata);
}

static CompBool expoOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) expoOptionsInitDisplay,
        (InitPluginObjectProc) expoOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void expoOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) expoOptionsFiniDisplay,
        (FiniPluginObjectProc) expoOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool expoOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = expoOptionsInitObject (p, o);
    if (expoPluginVTable->initObject)
        rv &= expoPluginVTable->initObject (p, o);
    return rv;
}

static void expoOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (expoPluginVTable->finiObject)
        expoPluginVTable->finiObject (p, o);
    expoOptionsFiniObject (p, o);
}

static CompOption * expoOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) expoOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool expoOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) expoOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
expoOptionsGetMetadata (CompPlugin *plugin)
{
    return &expoOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!expoPluginVTable)
    {
        expoPluginVTable = getCompPluginInfo ();
        memcpy(&expoOptionsVTable, expoPluginVTable, sizeof(CompPluginVTable));
        expoOptionsVTable.getMetadata = expoOptionsGetMetadata;
        expoOptionsVTable.init = expoOptionsInit;
        expoOptionsVTable.fini = expoOptionsFini;
        expoOptionsVTable.initObject = expoOptionsInitObjectWrapper;
        expoOptionsVTable.finiObject = expoOptionsFiniObjectWrapper;
        expoOptionsVTable.getObjectOptions = expoOptionsGetObjectOptions;
	expoOptionsVTable.setObjectOption = expoOptionsSetObjectOption;
	
    }
    return &expoOptionsVTable;
}

