#!/usr/bin/perl
use File::Basename;

die "Usage: $0 file.sym\n" unless (-r $ARGV[0]); 

$KERNEL=`uname -r`;
($KVERSION,$KPATCHLEVEL,$KSUBLEVEL)=split /\./, $KERNEL;

$SRC=$ARGV[0];
$BASE=basename($SRC,".sym");
$BASE1=$BASE;
$BASE1 =~ s/-/_/g;

$DEST= $BASE . ".c";

$XSYM1="unknown";
$XSYM2="unknown";

if ($KVERSION == 2) {
  if ($KPATCHLEVEL == 1) {
    $XSYM1="EXPORT_SYMBOL(";
    $XSYM2=");\n";
  }
  else {
    $XSYM1="X(";
    $XSYM2="),\n";
  }
}

die "$SRC = $DEST: Error (1)\n" if ($SRC eq $DEST);

print "generating $DEST from $SRC... ";
  
open (SRC, "<$SRC") or die "Cannot open >> $SRC <<\n";
@SRCtext=<SRC>;

open (DEST, ">$DEST") or die "Cannot write to >> $DEST <<\n";

print DEST qq(/*\n);
print DEST qq( *  File generated by script export-symbols from file $SRC...\n);
print DEST qq( *  Don\'t edit!!!\n);
print DEST qq( */\n);
print DEST qq(\n);
print DEST qq(\#define EXPORT_SYMTAB\n);
print DEST qq(\#include "driver.h"\n);

foreach $line (@SRCtext) {
  if ( substr($line,0,1) eq "+" ) { 
    print DEST substr($line , 2);
  }
}

print DEST qq(\#ifndef LINUX_2_1\n);
print DEST qq(struct symbol_table snd_symbol_table_$BASE1 = \{\n);
print DEST qq(\#include <linux/symtab_begin.h>\n);
print DEST qq(\#endif\n);

foreach $line (@SRCtext) {
  chomp($line);
  print DEST "  /* ", substr($line,2), "*/\n" 
    if ( substr($line,0,1) eq "\#" );
  print DEST $XSYM1, $line, $XSYM2 
    if ( substr($line,0,1) ne "\#" && substr($line,0,1) ne "+" );
}

print DEST qq(\#ifndef LINUX_2_1\n);
print DEST qq(\#include <linux/symtab_end.h>\n);
print DEST qq(}\;\n);
print DEST qq(\#endif\n);

print "done\n";
