#include <qlineedit.h>
#include <qcombobox.h>
#include <qtextbrowser.h>
#include <qcheckbox.h>
#include <klocale.h>

#include <apt-front/cache/entity/desktop.h>
#include <apt-front/predicate/factory.h>
#include <ept/debtags/vocabulary.h>
#include <adept/installerview.h>
#include <adept/packageinfo.h>
#include <adept/utils.h>

using namespace adept;
using namespace aptFront;
using namespace cache;

void InstallerView::rebuild()
{
    typedef predicate::Factory< entity::Desktop > Factory;
    if ( m_inRebuild ) {
        QTimer::singleShot( 500, this, SLOT( rebuild() ) );
        return;
    }
    m_inRebuild = true;

    component::Desktop &d = cache::Global::get().component< component::Desktop >();
    ept::debtags::Vocabulary &t =
        cache::Global::get().tags();

    Predicate p = predicate::True< entity::Desktop >();
    if ( m_search->text() != u8( "" ) ) {
        Predicate tmp = Factory::name( u8( m_search->text() ) )
                        or Factory::description( u8( m_search->text() ) );
        p = p and tmp;
    }

    std::string st = "";
    int si = m_suite->currentItem();

    if ( si == 0 ) st = "suite::kde";
    if ( si == 1 ) st = "suite::gnome";

    if ( st != "" )
        p = p and Factory::tag( t.tagByName( st ) );

    if ( !m_unsupported->isChecked() ) {
        p = p and not Factory::sectionSubstring( "contrib" )
            and not Factory::sectionSubstring( "universe" )
            and not Factory::sectionSubstring( "multiverse" );
    }

    if ( !m_nonfree->isChecked() ) {
        p = p and not Factory::sectionSubstring( "non-free" )
            and not Factory::sectionSubstring( "multiverse" )
            and not Factory::sectionSubstring( "restricted" );
    }

    selector()->fill( filteredRange( d.entries(), p ) );

    m_inRebuild = false;
}

InstallerView::InstallerView( QWidget *p , const char *n )
    : InstallerViewUi( p, n ), m_inRebuild( false )
{
    connect( m_search, SIGNAL( textChanged( const QString & ) ),
             this, SLOT( textChanged() ) );
    connect( &timer, SIGNAL( timeout() ), this, SLOT( rebuild() ) );
    connect( m_suite, SIGNAL( activated( int ) ), this, SLOT( rebuild() ) );
    connect( m_unsupported, SIGNAL( toggled( bool ) ), this, SLOT( rebuild() ) );
    connect( m_nonfree, SIGNAL( toggled( bool ) ), this, SLOT( rebuild() ) );
    connect( selector(), SIGNAL( showDescription( cache::entity::Desktop ) ),
             this, SLOT( showDescription( cache::entity::Desktop ) ) );
}

void InstallerView::textChanged() {
    timer.start( 1000, true );
}

void InstallerView::showDescription( entity::Desktop e )
{
    kdDebug() << "InstallerView::showDescription..." << endl;
    m_description->setText( u8( "<b>" ) + e.name() + u8( "</b>" )
                            + i18n( "<br><b>Package:</b> " ) + e.package().name()
                            + formatLongDescription(
                                e.package().longDescription( std::string( "" ) ) ) );
}
