/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -igcd --flex-syntax --case-inverted
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6

#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yytext[0]) {                              \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng > 0 && (                          \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, 1))


#define RETURN_TOKEN(type, str, len) {                       \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED) {      \
		zend_ini_copy_typed_value(ini_lval, type, str, len); \
	} else {                                                 \
		zend_ini_copy_value(ini_lval, str, len);             \
	}                                                        \
	return type;                                             \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		zend_file_handle_dtor(fh);
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[8] = {
		&&yyc_INITIAL,
		&&yyc_ST_OFFSET,
		&&yyc_ST_SECTION_VALUE,
		&&yyc_ST_VALUE,
		&&yyc_ST_SECTION_RAW,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_VARNAME,
		&&yyc_ST_RAW,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy5,  &&yy8,  &&yy2,  &&yy2,  &&yy10, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy11, &&yy13, &&yy13, &&yy2,  &&yy13, &&yy2,  &&yy13, &&yy2,
				&&yy13, &&yy13, &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy15, &&yy2,  &&yy17, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy20, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy21, &&yy22,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy23, &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy24, &&yy2,  &&yy25, &&yy2,  &&yy2,  &&yy13, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy20, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy21, &&yy22,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy23, &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy24, &&yy2,  &&yy13, &&yy13, &&yy13, &&yy13, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
			};
			goto *yytarget[yych];
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy3:
		YYDEBUG(3, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy4,  &&yy4,  &&yy2,  &&yy2,  &&yy4,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy4,  &&yy4,  &&yy2,  &&yy4,  &&yy2,  &&yy4,  &&yy2,
				&&yy4,  &&yy4,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy4,  &&yy2,  &&yy4,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy27, &&yy2,  &&yy2,  &&yy4,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
			};
			goto *yytarget[yych];
		}
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(6, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy5,  &&yy8,  &&yy7,  &&yy7,  &&yy10, &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy5,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy15, &&yy7,  &&yy17, &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,
				&&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7,  &&yy7
			};
			goto *yytarget[yych];
		}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		++YYCURSOR;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy10:
		YYDEBUG(10, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy8;
		goto yy9;
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(12, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy5,  &&yy8,  &&yy2,  &&yy2,  &&yy10, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy11, &&yy4,  &&yy4,  &&yy2,  &&yy4,  &&yy2,  &&yy4,  &&yy2,
				&&yy4,  &&yy4,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy15, &&yy2,  &&yy17, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy27, &&yy2,  &&yy2,  &&yy4,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
			};
			goto *yytarget[yych];
		}
yy13:
		YYDEBUG(13, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(14, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
yy15:
		YYDEBUG(15, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(16, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy15;
		}
		if (yych <= '\n') goto yy30;
		goto yy32;
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		if (yych == '\t') goto yy17;
		if (yych == ' ') goto yy17;
		YYDEBUG(19, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW);
	} else {
		yy_push_state(ST_VALUE);
	}
	return '=';
}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy33;
		if (yych == 'a') goto yy33;
		goto yy3;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy34,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy36, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy34,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy36, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy37, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy38, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy37, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy38, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy41;
		if (yych == 'r') goto yy41;
		goto yy3;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy42;
		if (yych == 'e') goto yy42;
		goto yy3;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW);
	} else {
		yy_push_state(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yych == '\t') goto yy27;
		if (yych == ' ') goto yy27;
		YYDEBUG(29, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
yy30:
		YYDEBUG(30, *YYCURSOR);
		++YYCURSOR;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy30;
		goto yy31;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy43;
		if (yych == 'l') goto yy43;
		goto yy3;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy44, &&yy35, &&yy3,  &&yy3,  &&yy35, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy46, &&yy35, &&yy35, &&yy3,  &&yy35, &&yy3,  &&yy35, &&yy3,
				&&yy35, &&yy35, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy35, &&yy3,  &&yy35, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy48, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy35, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy48, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy35, &&yy35, &&yy35, &&yy35, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy49;
		if (yych == 'l') goto yy49;
		goto yy3;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy46;
		if (yych == 'f') goto yy46;
		goto yy3;
yy38:
		YYDEBUG(38, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(39, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy50, &&yy40, &&yy2,  &&yy2,  &&yy40, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy38, &&yy40, &&yy40, &&yy2,  &&yy40, &&yy2,  &&yy40, &&yy2,
				&&yy40, &&yy40, &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy40, &&yy2,  &&yy40, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy27, &&yy2,  &&yy2,  &&yy40, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy40, &&yy40, &&yy40, &&yy40, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
			};
			goto *yytarget[yych];
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy52;
		if (yych == 'u') goto yy52;
		goto yy3;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy38;
		if (yych == 's') goto yy38;
		goto yy3;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy48;
		if (yych == 's') goto yy48;
		goto yy3;
yy44:
		YYDEBUG(44, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(45, *YYCURSOR);
		if (yych == '\t') goto yy44;
		if (yych == ' ') goto yy44;
		goto yy35;
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy44, &&yy35, &&yy2,  &&yy2,  &&yy35, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy46, &&yy35, &&yy35, &&yy2,  &&yy35, &&yy2,  &&yy35, &&yy2,
				&&yy35, &&yy35, &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy35, &&yy2,  &&yy35, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy27, &&yy2,  &&yy2,  &&yy35, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy35, &&yy35, &&yy35, &&yy35, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
			};
			goto *yytarget[yych];
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy46;
		if (yych == 'e') goto yy46;
		goto yy3;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy53;
		if (yych == 'l') goto yy53;
		goto yy3;
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(51, *YYCURSOR);
		if (yych == '\t') goto yy50;
		if (yych == ' ') goto yy50;
		goto yy40;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy38;
		if (yych == 'e') goto yy38;
		goto yy3;
yy53:
		YYDEBUG(53, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(54, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy56, &&yy55, &&yy2,  &&yy2,  &&yy55, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy53, &&yy55, &&yy55, &&yy2,  &&yy55, &&yy2,  &&yy55, &&yy2,
				&&yy55, &&yy55, &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy55, &&yy2,  &&yy55, &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy27, &&yy2,  &&yy2,  &&yy55, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy55, &&yy55, &&yy55, &&yy55, &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
				&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
			};
			goto *yytarget[yych];
		}
yy55:
		YYDEBUG(55, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(57, *YYCURSOR);
		if (yych == '\t') goto yy56;
		if (yych == ' ') goto yy56;
		goto yy55;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(58, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy63, &&yy65, &&yy60, &&yy60, &&yy65, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy63, &&yy60, &&yy67, &&yy60, &&yy69, &&yy60, &&yy60, &&yy70,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy71, &&yy71, &&yy60,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy60, &&yy65, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy60, &&yy78, &&yy79, &&yy60, &&yy75,
				&&yy60, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60
			};
			goto *yytarget[yych];
		}
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy61:
		YYDEBUG(61, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy60;
		}
		if (yych <= '"') goto yy62;
		if (yych <= '$') goto yy81;
		if (yych <= ';') goto yy62;
		if (yych <= '\\') goto yy78;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy63, &&yy62, &&yy60, &&yy60, &&yy62, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy63, &&yy60, &&yy67, &&yy60, &&yy81, &&yy60, &&yy60, &&yy62,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy62, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy78, &&yy79, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60
			};
			goto *yytarget[yych];
		}
yy65:
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy66;
			if (yych <= '[') goto yy60;
			goto yy83;
		} else {
			if (yych == '{') goto yy85;
			goto yy60;
		}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy87;
		}
		goto yy66;
yy71:
		YYDEBUG(71, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy89;
		goto yy61;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy74, &&yy60, &&yy60, &&yy74, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy74, &&yy60, &&yy81, &&yy60, &&yy60, &&yy74,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy89, &&yy60,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy60, &&yy74, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy78, &&yy74, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60
			};
			goto *yytarget[yych];
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy77, &&yy60, &&yy60, &&yy77, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy77, &&yy60, &&yy81, &&yy60, &&yy60, &&yy77,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy60, &&yy77, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy60, &&yy78, &&yy77, &&yy60, &&yy75,
				&&yy60, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75, &&yy75,
				&&yy75, &&yy75, &&yy75, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60
			};
			goto *yytarget[yych];
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy60;
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy82;
			if (yych <= '[') goto yy60;
			goto yy83;
		} else {
			if (yych != '{') goto yy60;
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy62;
			} else {
				goto yy74;
			}
		} else {
			goto yy77;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy83;
		}
		goto yy60;
yy85:
		YYDEBUG(85, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(88, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy87;
		}
		goto yy91;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(90, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy74, &&yy60, &&yy60, &&yy74, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy74, &&yy60, &&yy81, &&yy60, &&yy60, &&yy74,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy89, &&yy89, &&yy89, &&yy89, &&yy89, &&yy89, &&yy89, &&yy89,
				&&yy89, &&yy89, &&yy60, &&yy74, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy78, &&yy74, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60
			};
			goto *yytarget[yych];
		}
yy91:
		YYDEBUG(91, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(92, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(93, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy98,  &&yy100, &&yy95,  &&yy95,  &&yy100, &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy98,  &&yy95,  &&yy102, &&yy95,  &&yy104, &&yy95,  &&yy95,  &&yy105,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy106, &&yy106, &&yy95,
				&&yy107, &&yy107, &&yy107, &&yy107, &&yy107, &&yy107, &&yy107, &&yy107,
				&&yy107, &&yy107, &&yy95,  &&yy100, &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy95,  &&yy113, &&yy114, &&yy95,  &&yy110,
				&&yy95,  &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95
			};
			goto *yytarget[yych];
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy96:
		YYDEBUG(96, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy95;
		}
		if (yych <= '"') goto yy97;
		if (yych <= '$') goto yy117;
		if (yych <= ';') goto yy97;
		if (yych <= '\\') goto yy113;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(99, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy98,  &&yy97,  &&yy95,  &&yy95,  &&yy97,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy98,  &&yy95,  &&yy102, &&yy95,  &&yy117, &&yy95,  &&yy95,  &&yy97,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy97,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy113, &&yy97,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95
			};
			goto *yytarget[yych];
		}
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(103, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy101;
			if (yych <= '[') goto yy95;
			goto yy119;
		} else {
			if (yych == '{') goto yy121;
			goto yy95;
		}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy123;
		}
		goto yy101;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy96;
		if (yych <= '9') goto yy125;
		goto yy96;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy109, &&yy95,  &&yy95,  &&yy109, &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy109, &&yy95,  &&yy117, &&yy95,  &&yy95,  &&yy109,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy125, &&yy95,
				&&yy107, &&yy107, &&yy107, &&yy107, &&yy107, &&yy107, &&yy107, &&yy107,
				&&yy107, &&yy107, &&yy95,  &&yy109, &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy113, &&yy109, &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95
			};
			goto *yytarget[yych];
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy112, &&yy95,  &&yy95,  &&yy112, &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy112, &&yy95,  &&yy117, &&yy95,  &&yy95,  &&yy112,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy95,  &&yy112, &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy95,  &&yy113, &&yy112, &&yy95,  &&yy110,
				&&yy95,  &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95
			};
			goto *yytarget[yych];
		}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy95;
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy116;
			if (yych <= '\t') goto yy114;
			if (yych <= '\n') goto yy127;
		} else {
			if (yych <= '\r') goto yy128;
			if (yych == ' ') goto yy114;
		}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy117:
		YYDEBUG(117, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy118;
			if (yych <= '[') goto yy95;
			goto yy119;
		} else {
			if (yych != '{') goto yy95;
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy97;
			} else {
				goto yy109;
			}
		} else {
			goto yy112;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy119;
		}
		goto yy95;
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy123;
		}
		goto yy129;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy109, &&yy95,  &&yy95,  &&yy109, &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy109, &&yy95,  &&yy117, &&yy95,  &&yy95,  &&yy109,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy125, &&yy125, &&yy125, &&yy125, &&yy125, &&yy125, &&yy125, &&yy125,
				&&yy125, &&yy125, &&yy95,  &&yy109, &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy113, &&yy109, &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,
				&&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95,  &&yy95
			};
			goto *yytarget[yych];
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		++YYCURSOR;
		goto yy116;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy127;
		goto yy116;
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			 80,  82,  82,  82,  82,  82,  82,  82, 
			 82,  84,  64,  82,  82,  64,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 84,  80,  80,  82, 208,  82,  80,  16, 
			 80,  80,  82,  82,  82,  82,  82,  82, 
			122, 122, 122, 122, 122, 122, 122, 122, 
			122, 122,  82,  80,  82,  80,  82,  82, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  82,  82,  80, 114, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  80,  82,  80,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
		};
		YYDEBUG(131, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy133, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy138, &&yy141, &&yy135, &&yy135, &&yy143, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy138, &&yy144, &&yy147, &&yy135, &&yy149, &&yy135, &&yy144, &&yy150,
				&&yy144, &&yy144, &&yy135, &&yy135, &&yy135, &&yy151, &&yy151, &&yy135,
				&&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152,
				&&yy152, &&yy152, &&yy135, &&yy155, &&yy135, &&yy157, &&yy135, &&yy135,
				&&yy135, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy162, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy163, &&yy164,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy165, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy166, &&yy159, &&yy135, &&yy135, &&yy135, &&yy144, &&yy159,
				&&yy135, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy162, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy163, &&yy164,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy165, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy166, &&yy159, &&yy135, &&yy144, &&yy135, &&yy144, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135
			};
			goto *yytarget[yych];
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy136:
		YYDEBUG(136, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy137, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy137, &&yy137, &&yy135, &&yy135, &&yy137, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy137, &&yy137, &&yy137, &&yy135, &&yy167, &&yy135, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy137, &&yy135, &&yy137, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy137, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy137, &&yy135, &&yy137, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135
			};
			goto *yytarget[yych];
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy138:
		YYDEBUG(138, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(139, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy138, &&yy141, &&yy140, &&yy140, &&yy143, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy138, &&yy140, &&yy147, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy155, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140
			};
			goto *yytarget[yych];
		}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy141;
		goto yy142;
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(145, *YYCURSOR);
		if (yych == '\t') goto yy144;
		if (yych == ' ') goto yy144;
		YYDEBUG(146, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Boolean operators */
	return yytext[0];
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(148, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy134;
			if (yych <= '[') goto yy135;
			goto yy169;
		} else {
			if (yych == '{') goto yy170;
			goto yy135;
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy172;
		}
		goto yy134;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy136;
		if (yych <= '9') goto yy174;
		goto yy136;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(153, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy154, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy154, &&yy154, &&yy135, &&yy135, &&yy154, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy154, &&yy154, &&yy154, &&yy135, &&yy167, &&yy135, &&yy154, &&yy154,
				&&yy154, &&yy154, &&yy135, &&yy135, &&yy135, &&yy135, &&yy174, &&yy135,
				&&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152, &&yy152,
				&&yy152, &&yy152, &&yy135, &&yy154, &&yy135, &&yy154, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy154, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy154, &&yy135, &&yy154, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135
			};
			goto *yytarget[yych];
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy155:
		YYDEBUG(155, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(156, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy155;
		}
		if (yych <= '\n') goto yy176;
		goto yy178;
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(158, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(160, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy161, &&yy161, &&yy135, &&yy135, &&yy161, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy161, &&yy161, &&yy161, &&yy135, &&yy167, &&yy135, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy135, &&yy161, &&yy135, &&yy161, &&yy135, &&yy135,
				&&yy135, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy135, &&yy135, &&yy135, &&yy161, &&yy159,
				&&yy135, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy135, &&yy161, &&yy135, &&yy161, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135
			};
			goto *yytarget[yych];
		}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy179, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy179, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy180,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy182, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy180,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy182, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy183, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy184, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy183, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy184, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy186, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy186, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy187, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy187, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy168;
			if (yych <= '[') goto yy135;
			goto yy169;
		} else {
			if (yych != '{') goto yy135;
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy137;
				} else {
					goto yy154;
				}
			} else {
				goto yy161;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy181;
				} else {
					goto yy185;
				}
			} else {
				goto yy202;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy188;
		}
		goto yy135;
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(173, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy172;
		}
		goto yy190;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(175, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy154, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy154, &&yy154, &&yy135, &&yy135, &&yy154, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy154, &&yy154, &&yy154, &&yy135, &&yy167, &&yy135, &&yy154, &&yy154,
				&&yy154, &&yy154, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy174, &&yy174, &&yy174, &&yy174, &&yy174, &&yy174, &&yy174, &&yy174,
				&&yy174, &&yy174, &&yy135, &&yy154, &&yy135, &&yy154, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy154, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy154, &&yy135, &&yy154, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135,
				&&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135, &&yy135
			};
			goto *yytarget[yych];
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy176;
		goto yy177;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy192, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy192, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy181, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy193, &&yy181, &&yy136, &&yy136, &&yy181, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy193, &&yy181, &&yy181, &&yy136, &&yy136, &&yy136, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy181, &&yy136, &&yy181, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy195, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy181, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy195, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy181, &&yy136, &&yy181, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy196, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy196, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy197, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy197, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy185, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy198, &&yy185, &&yy136, &&yy136, &&yy185, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy198, &&yy185, &&yy185, &&yy136, &&yy136, &&yy136, &&yy185, &&yy185,
				&&yy185, &&yy185, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy185, &&yy136, &&yy185, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy185, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy185, &&yy136, &&yy185, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy200, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy200, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy184, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy184, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy188;
		}
		if (yych <= 0x00) goto yy137;
		if (yych == '\\') goto yy169;
		goto yy135;
yy190:
		YYDEBUG(190, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy195, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy195, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		if (yych == '\t') goto yy193;
		if (yych == ' ') goto yy193;
		goto yy181;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy197, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy197, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy201, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy201, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy181, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy193, &&yy181, &&yy136, &&yy136, &&yy181, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy193, &&yy181, &&yy181, &&yy136, &&yy136, &&yy136, &&yy181, &&yy181,
				&&yy181, &&yy181, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy181, &&yy136, &&yy181, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy181, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy181, &&yy136, &&yy181, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		if (yych == '\t') goto yy198;
		if (yych == ' ') goto yy198;
		goto yy185;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy161, &&yy161, &&yy136, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy161, &&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy161, &&yy161,
				&&yy161, &&yy161, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy184, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy161, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy184, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy161, &&yy136, &&yy161, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy202, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy203, &&yy202, &&yy136, &&yy136, &&yy202, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy203, &&yy202, &&yy202, &&yy136, &&yy136, &&yy136, &&yy202, &&yy202,
				&&yy202, &&yy202, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy136, &&yy202, &&yy136, &&yy202, &&yy136, &&yy136,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy136, &&yy136, &&yy202, &&yy159,
				&&yy136, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159, &&yy159,
				&&yy159, &&yy159, &&yy159, &&yy136, &&yy202, &&yy136, &&yy202, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yych == '\t') goto yy203;
		if (yych == ' ') goto yy203;
		goto yy202;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(205, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy207;
		}
		if (yych <= '\r') goto yy210;
		goto yy212;
yy207:
		YYDEBUG(207, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy207;
		}
		YYDEBUG(209, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy212;
		}
		if (yych <= 0x08) goto yy214;
		if (yych <= '\n') goto yy215;
		if (yych == '\r') goto yy216;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		goto yy214;
yy216:
		YYDEBUG(216, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy215;
		goto yy214;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(217, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy221;
		if (yych == '$') goto yy224;
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
yy220:
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy221;
		}
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy220;
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
	}
/* *********************************** */
yyc_ST_VARNAME:
	YYDEBUG(227, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	{
		static void *yytarget[256] = {
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy232, &&yy232, &&yy229, &&yy229, &&yy232, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy232, &&yy232, &&yy229, &&yy232, &&yy229, &&yy232, &&yy229,
			&&yy232, &&yy232, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy232, &&yy229, &&yy232, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy232, &&yy229, &&yy229, &&yy232, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy232, &&yy232, &&yy234, &&yy232, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229
		};
		goto *yytarget[yych];
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	++YYCURSOR;
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(230, *YYCURSOR);
	{
		static void *yytarget[256] = {
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy231, &&yy231, &&yy229, &&yy229, &&yy231, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy231, &&yy231, &&yy229, &&yy231, &&yy229, &&yy231, &&yy229,
			&&yy231, &&yy231, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy231, &&yy229, &&yy231, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy231, &&yy229, &&yy229, &&yy231, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy231, &&yy231, &&yy231, &&yy231, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229,
			&&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229, &&yy229
		};
		goto *yytarget[yych];
	}
yy231:
	YYDEBUG(231, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
yy232:
	YYDEBUG(232, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(233, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	return 0;
}
yy234:
	YYDEBUG(234, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(235, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{ /* Variable end */
	yy_pop_state();
	return '}';
}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(236, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy238, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy242, &&yy243, &&yy240, &&yy240, &&yy245, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy242, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy246, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240,
				&&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240, &&yy240
			};
			goto *yytarget[yych];
		}
yy238:
		YYDEBUG(238, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(239, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				/* no break */
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	yyleng = YYCURSOR - SCNG(yy_text);

	/* Eat trailing semicolons */
	while (yytext[yyleng - 1] == ';') {
		yyleng--;
	}

	/* Eat leading and trailing double quotes */
	if (yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	} else if (sc) {
		YYCURSOR = sc;
		yyleng = YYCURSOR - SCNG(yy_text);
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy249, &&yy249, &&yy241, &&yy241, &&yy249, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy249, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy249, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241
			};
			goto *yytarget[yych];
		}
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy243;
		goto yy244;
yy246:
		YYDEBUG(246, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(247, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy246;
		}
		if (yych <= '\n') goto yy251;
		goto yy253;
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy249:
		YYDEBUG(249, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy248;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy250;
			if (yych <= '\n') goto yy243;
		} else {
			if (yych <= '\r') goto yy245;
			if (yych == ';') goto yy246;
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy251;
		goto yy252;
	}
}

}
real_world/php20150211_zend_ini_scanner.re:385:13: warning: escape has no effect: '\.' [-Wuseless-escape]
real_world/php20150211_zend_ini_scanner.re:385:32: warning: escape has no effect: '\.' [-Wuseless-escape]
real_world/php20150211_zend_ini_scanner.re:392:27: warning: escape has no effect: '\[' [-Wuseless-escape]
real_world/php20150211_zend_ini_scanner.re:393:11: warning: escape has no effect: '\[' [-Wuseless-escape]
real_world/php20150211_zend_ini_scanner.re:649:7: warning: unreachable rule in condition 'INITIAL' (shadowed by rules at lines 407, 482, 492, 556, 628, 633, 638) [-Wunreachable-rules]
real_world/php20150211_zend_ini_scanner.re:624:50: warning: unreachable rule in condition 'ST_OFFSET' (shadowed by rule at line 574) [-Wunreachable-rules]
real_world/php20150211_zend_ini_scanner.re:624:50: warning: unreachable rule in condition 'ST_SECTION_VALUE' (shadowed by rule at line 574) [-Wunreachable-rules]
real_world/php20150211_zend_ini_scanner.re:649:7: warning: unreachable rule in condition 'ST_VALUE' (shadowed by rules at lines 542, 548, 552, 560, 564, 570, 578, 624, 644) [-Wunreachable-rules]
real_world/php20150211_zend_ini_scanner.re:649:7: warning: unreachable rule in condition 'ST_DOUBLE_QUOTES' (shadowed by rules at lines 583, 588) [-Wunreachable-rules]
real_world/php20150211_zend_ini_scanner.re:649:7: warning: unreachable rule in condition 'ST_RAW' (shadowed by rules at lines 501, 542, 644) [-Wunreachable-rules]
real_world/php20150211_zend_ini_scanner.re:382:0: warning: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
