.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtManage-Children XtManage-Child XtUnmanage-Children XtUnmanage-Child XtChange-ManagedSet XtIs-Managed wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XtManageChildren __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtManageChildren, XtManageChild, XtUnmanageChildren, XtUnmanageChild, XtChangeManagedSet, XtIsManaged \- manage and unmanage children
.SH SYNTAX
typedef Widget *WidgetList;
.HP
void XtManageChildren(WidgetList \fIchildren\fP, Cardinal \fInum_children\fP);
.HP
void XtManageChild(Widget \fIchild\fP);
.HP
void XtUnmanageChildren(WidgetList \fIchildren\fP, Cardinal
\fInum_children\fP);
.HP
void XtUnmanageChild(Widget \fIchild\fP);
.HP
void XtChangeManagedSet(WidgetList \fIunmanage_children\fP,
Cardinal \fInum_unmanage_children\fP, XtDoChangeProc \fIdo_change_proc\fP,
XtPointer \fIclient_data\fP, WidgetList \fImanage_children\fP,
Cardinal \fInum_manage_children\fP);
.HP
Boolean XtIsManaged(Widget \fIwidget\fP);
.SH ARGUMENTS
.IP \fIchild\fP 1i
Specifies the child.
.IP \fIchildren\fP 1i
Specifies a list of child widgets.
.IP \fInum_children\fP 1i
Specifies the number of children.
.IP \fIwidget\fP 1i
Specifies the widget.
.IP \fImanage_children\fP 1i
Specifies the list of widget children to add to the managed set.
.IP \fInum_manage_children\fP 1i
Specifies the number of entries in the manage_children list.
.IP \fIunmanage_children\fP 1i
Specifies the list of widget children to remove from the managed set.
.IP \fInum_unmanage_children\fP 1i
Specifies the number of entries in the unmanage_children list.
.IP \fIdo_change_proc\fP 1i
Specifies the post unmanage, pre manage hook procedure to invoke.
.IP \fIclient_data\fP 1i
Specifies the client data to be passed to the hook procedure.
.SH DESCRIPTION
The
.ZN XtManageChildren
function performs the following:
.IP \(bu 5
Issues an error if the children do not all have the same parent or
if the parent is not a subclass of
.ZN compositeWidgetClass .
.IP \(bu 5
Returns immediately if the common parent is being destroyed;
otherwise, for each unique child on the list,
.ZN XtManageChildren
ignores the child if it already is managed or is being destroyed
and marks it if not.
.IP \(bu 5
If the parent is realized and after all children have been marked,
it makes some of the newly managed children viewable:
.RS
.IP \- 5
Calls the change_managed routine of the widgets' parent.
.IP \- 5
Calls
.ZN XtRealizeWidget
on each previously unmanaged child that is unrealized.
.IP \- 5
Maps each previously unmanaged child that has map_when_managed
.ZN True .
.RE
.LP
Managing children is independent of the ordering of children and
independent of creating and deleting children.
The layout routine of the parent
should consider children whose managed field is
.ZN True
and should ignore all other children.
Note that some composite widgets, especially fixed boxes, call
.ZN XtManageChild
from their insert_child procedure.
.LP
If the parent widget is realized,
its change_managed procedure is called to notify it
that its set of managed children has changed.
The parent can reposition and resize any of its children.
It moves each child as needed by calling
.ZN XtMoveWidget ,
which first updates the x and y fields and then calls
.ZN XMoveWindow
if the widget is realized.
.LP
The
.ZN XtManageChild
function constructs a
.ZN WidgetList
of length one and calls
.ZN XtManageChildren .
.LP
The
.ZN XtUnmanageChildren
function performs the following:
.IP \(bu 5
Issues an error if the children do not all have the same parent
or if the parent is not a subclass of
.ZN compositeWidgetClass .
.IP \(bu 5
Returns immediately if the common parent is being destroyed;
otherwise, for each unique child on the list,
.ZN XtUnmanageChildren
performs the following:
.RS
.IP \- 5
Ignores the child if it already is unmanaged or is being destroyed
and marks it if not.
.IP \- 5
If the child is realized,
it makes it nonvisible by unmapping it.
.RE
.IP \(bu 5
Calls the change_managed routine of the widgets' parent
after all children have been marked
if the parent is realized.
.LP
.ZN XtUnmanageChildren
does not destroy the children widgets.
Removing widgets from a parent's managed set is often a temporary banishment,
and, some time later, you may manage the children again.
.LP
The
.ZN XtUnmanageChild
function constructs a widget list
of length one and calls
.ZN XtUnmanageChildren .
.LP
The
.ZN XtChangeManagedSet
function performs the following:
.IP \(bu 5
Issues an error if the widgets specified in the \fImanage_children\fP
and the \fIunmanage_children\fP lists to no all have the same parent, or
if that parent is not a subclass of compositeWidgetClass.
.IP \(bu 5
Returns immediately if the common parent is being destroyed.
.IP \(bu 5
If no
.ZN CompositeClassExtension
is defined, or a
.ZN CompositeClassExtension
is defined but with an \fIallows_change_managed_set\fP field with a
value of
.ZN False ,
and
.ZN XtChangeManagedSet
was invoked with a non-NULL \fIdo_change_proc\fP procedure
then
.ZN XtChangeManagedSet
performs the following:
.RS
.IP \- 5
Calls
.ZN XtUnmanageChildren
(\fIunmanage_children\fP, \fInum_unmanage_children\fP).
.IP \- 5
Calls the \fIdo_change_proc\fP specified.
.IP \- 5
Calls
.ZN XtManageChildren
(\fImanage_children\fP, \fInum_manage_children\fP) and then returns
immediately.
.RE
.IP \(bu 5
Otherwise, if a
.ZN CompositeClassExtension
is defined with an \fIallows_change_managed_set\fP field with a value of
.ZN True ,
or if no
.ZN CompositeClassExtension
is defined, and
.ZN XtChangeManagedSet was invoked with a NULL
\fIdo_change_proc\fP procedure, then the following is
performed:
.RS
.IP \- 5
For each child on the \fIunmanage_children\fP list; if the child is
already unmanaged or is being destroyed it is ignored, otherwise it
is marked as being unmanaged and if it is realized it is made nonvisible
by being unmapped.
.IP \- 5
If the \fIdo_change_proc\fP procedure is non-NULL then
it is invoked as specified.
.IP \- 5
For each child on the \fImanage_children\fP list; if the child is
already managed or it is being destroyed it is ignored, otherwise it
is marked as managed
.RE
.IP \(bu 5
If the parent is realized and after all children have been marked, the
change_managed method of the parent is invoked and subsequently some
of the newly managed children are made viewable by:
.RS
.IP \- 5
Calling
.ZN XtRealizeWidget
on each of the previously unmanaged child that is unrealized.
.IP \- 5
Mapping each previously unmanaged child that has \fImap_when_managed\fP
.ZN True .
.RE
.LP
The
.ZN XtIsManaged
function returns
.ZN True
if the specified widget is of class RectObj or any subclass thereof and
is managed, or
.ZN False
otherwise.
.SH "SEE ALSO"
XtMapWidget(__libmansuffix__),
XtRealizeWidget(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
