; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx1010 -amdgpu-opt-vgpr-liverange=true -stop-after=si-opt-vgpr-liverange -verify-machineinstrs < %s | FileCheck -check-prefix=SI %s

; a normal if-else
define amdgpu_ps float @else1(i32 %z, float %v) #0 {
  ; SI-LABEL: name: else1
  ; SI: bb.0.main_body:
  ; SI:   successors: %bb.3(0x40000000), %bb.1(0x40000000)
  ; SI:   liveins: $vgpr0, $vgpr1
  ; SI:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY1]], implicit $exec
  ; SI:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.3
  ; SI: bb.1.Flow:
  ; SI:   successors: %bb.2(0x40000000), %bb.4(0x40000000)
  ; SI:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %13:vgpr_32, %bb.0, %4, %bb.3
  ; SI:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY]], %bb.0, undef %15:vgpr_32, %bb.3
  ; SI:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.4, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.2
  ; SI: bb.2.if:
  ; SI:   successors: %bb.4(0x80000000)
  ; SI:   %3:vgpr_32 = nofpexcept V_ADD_F32_e32 killed [[PHI1]], [[PHI1]], implicit $mode, implicit $exec
  ; SI:   S_BRANCH %bb.4
  ; SI: bb.3.else:
  ; SI:   successors: %bb.1(0x80000000)
  ; SI:   %4:vgpr_32 = nofpexcept V_MUL_F32_e32 1077936128, killed [[COPY]], implicit $mode, implicit $exec
  ; SI:   S_BRANCH %bb.1
  ; SI: bb.4.end:
  ; SI:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, %3, %bb.2
  ; SI:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   $vgpr0 = COPY killed [[PHI2]]
  ; SI:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = fmul float %v, 2.0
  br label %end

else:
  %v.else = fmul float %v, 3.0
  br label %end

end:
  %r = phi float [ %v.if, %if ], [ %v.else, %else ]
  ret float %r
}


; %v was used after if-else
define amdgpu_ps float @else2(i32 %z, float %v) #0 {
  ; SI-LABEL: name: else2
  ; SI: bb.0.main_body:
  ; SI:   successors: %bb.3(0x40000000), %bb.1(0x40000000)
  ; SI:   liveins: $vgpr0, $vgpr1
  ; SI:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY1]], implicit $exec
  ; SI:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.3
  ; SI: bb.1.Flow:
  ; SI:   successors: %bb.2(0x40000000), %bb.4(0x40000000)
  ; SI:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %15:vgpr_32, %bb.0, %4, %bb.3
  ; SI:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.4, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.2
  ; SI: bb.2.if:
  ; SI:   successors: %bb.4(0x80000000)
  ; SI:   %3:vgpr_32 = nofpexcept V_ADD_F32_e32 killed [[COPY]], [[COPY]], implicit $mode, implicit $exec
  ; SI:   S_BRANCH %bb.4
  ; SI: bb.3.else:
  ; SI:   successors: %bb.1(0x80000000)
  ; SI:   %4:vgpr_32 = nofpexcept V_MUL_F32_e32 1077936128, [[COPY]], implicit $mode, implicit $exec
  ; SI:   S_BRANCH %bb.1
  ; SI: bb.4.end:
  ; SI:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY]], %bb.1, %3, %bb.2
  ; SI:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, %3, %bb.2
  ; SI:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   %14:vgpr_32 = nofpexcept V_ADD_F32_e32 killed [[PHI1]], killed [[PHI2]], implicit $mode, implicit $exec
  ; SI:   $vgpr0 = COPY killed %14
  ; SI:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = fmul float %v, 2.0
  br label %end

else:
  %v.else = fmul float %v, 3.0
  br label %end

end:
  %r0 = phi float [ %v.if, %if ], [ %v, %else ]
  %r1 = phi float [ %v.if, %if ], [ %v.else, %else ]
  %r2 = fadd float %r0, %r1
  ret float %r2
}

; if-else inside loop, %x can be optimized, but %v cannot be.
define amdgpu_ps float @else3(i32 %z, float %v, i32 inreg %bound, i32 %x0) #0 {
  ; SI-LABEL: name: else3
  ; SI: bb.0.entry:
  ; SI:   successors: %bb.1(0x80000000)
  ; SI:   liveins: $vgpr0, $vgpr1, $sgpr0, $vgpr2
  ; SI:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr2
  ; SI:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY killed $sgpr0
  ; SI:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY3]], implicit $exec
  ; SI:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; SI: bb.1.for.body:
  ; SI:   successors: %bb.4(0x40000000), %bb.2(0x40000000)
  ; SI:   [[PHI:%[0-9]+]]:sreg_32 = PHI [[S_MOV_B32_]], %bb.0, %14, %bb.5
  ; SI:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY]], %bb.0, %13, %bb.5
  ; SI:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF [[V_CMP_GT_I32_e64_]], %bb.2, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.4
  ; SI: bb.2.Flow:
  ; SI:   successors: %bb.3(0x40000000), %bb.5(0x40000000)
  ; SI:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI undef %34:vgpr_32, %bb.1, %10, %bb.4
  ; SI:   [[PHI3:%[0-9]+]]:vgpr_32 = PHI undef %35:vgpr_32, %bb.1, %9, %bb.4
  ; SI:   [[PHI4:%[0-9]+]]:vgpr_32 = PHI [[PHI1]], %bb.1, undef %38:vgpr_32, %bb.4
  ; SI:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.5, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.3
  ; SI: bb.3.if:
  ; SI:   successors: %bb.5(0x80000000)
  ; SI:   %7:vgpr_32 = nofpexcept V_MUL_F32_e32 [[PHI]], [[COPY2]], implicit $mode, implicit $exec
  ; SI:   [[V_ADD_U32_e32_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e32 1, killed [[PHI4]], implicit $exec
  ; SI:   S_BRANCH %bb.5
  ; SI: bb.4.else:
  ; SI:   successors: %bb.2(0x80000000)
  ; SI:   %9:vgpr_32 = nofpexcept V_MUL_F32_e32 [[COPY2]], [[PHI1]], implicit $mode, implicit $exec
  ; SI:   [[V_MUL_LO_U32_e64_:%[0-9]+]]:vgpr_32 = V_MUL_LO_U32_e64 killed [[PHI1]], 3, implicit $exec
  ; SI:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY killed [[V_MUL_LO_U32_e64_]]
  ; SI:   S_BRANCH %bb.2
  ; SI: bb.5.if.end:
  ; SI:   successors: %bb.6(0x04000000), %bb.1(0x7c000000)
  ; SI:   [[PHI5:%[0-9]+]]:vgpr_32 = PHI [[PHI3]], %bb.2, %7, %bb.3
  ; SI:   [[PHI6:%[0-9]+]]:vgpr_32 = PHI [[PHI2]], %bb.2, [[V_ADD_U32_e32_]], %bb.3
  ; SI:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   [[V_ADD_U32_e32_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e32 1, [[PHI6]], implicit $exec
  ; SI:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 killed [[PHI]], 1, implicit-def dead $scc
  ; SI:   S_CMP_LT_I32 [[S_ADD_I32_]], [[COPY1]], implicit-def $scc
  ; SI:   S_CBRANCH_SCC1 %bb.1, implicit killed $scc
  ; SI:   S_BRANCH %bb.6
  ; SI: bb.6.for.end:
  ; SI:   %33:vgpr_32 = nofpexcept V_ADD_F32_e32 killed [[PHI6]], killed [[PHI5]], implicit $mode, implicit $exec
  ; SI:   $vgpr0 = COPY killed %33
  ; SI:   SI_RETURN_TO_EPILOG killed $vgpr0
entry:
;  %break = icmp sgt i32 %bound, 0
;  br i1 %break, label %for.body, label %for.end
  br label %for.body

for.body:
  %i = phi i32 [ 0, %entry ], [ %inc, %if.end ]
  %x = phi i32 [ %x0, %entry ], [ %xinc, %if.end ]
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %i.tmp = bitcast i32 %i to float
  %v.if = fmul float %v, %i.tmp
  %x.if = add i32 %x, 1
  br label %if.end

else:
  %x.tmp = bitcast i32 %x to float
  %v.else = fmul float %v, %x.tmp
  %x.else = mul i32 %x, 3
  br label %if.end

if.end:
  %v.endif = phi float [ %v.if, %if ], [ %v.else, %else ]
  %x.endif = phi i32 [ %x.if, %if ], [ %x.else, %else ]

  %xinc = add i32 %x.endif, 1
  %inc = add i32 %i, 1
  %cond = icmp slt i32 %inc, %bound
  br i1 %cond, label %for.body, label %for.end

for.end:
  %x_float = bitcast i32 %x.endif to float
  %r = fadd float %x_float, %v.endif
  ret float %r
}

; a loop inside an if-else
define amdgpu_ps float @loop(i32 %z, float %v, i32 inreg %bound, float(float)* %extern_func, float(float)* %extern_func2) #0 {
  ; SI-LABEL: name: loop
  ; SI: bb.0.main_body:
  ; SI:   successors: %bb.5(0x40000000), %bb.1(0x40000000)
  ; SI:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; SI:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr5
  ; SI:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr4
  ; SI:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY killed $vgpr3
  ; SI:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY killed $vgpr2
  ; SI:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY5]], implicit $exec
  ; SI:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.5
  ; SI: bb.1.Flow:
  ; SI:   successors: %bb.2(0x40000000), %bb.8(0x40000000)
  ; SI:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %29:vgpr_32, %bb.0, %4, %bb.7
  ; SI:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY4]], %bb.0, undef %45:vgpr_32, %bb.7
  ; SI:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[COPY3]], %bb.0, undef %47:vgpr_32, %bb.7
  ; SI:   [[PHI3:%[0-9]+]]:vgpr_32 = PHI [[COPY2]], %bb.0, undef %49:vgpr_32, %bb.7
  ; SI:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.8, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.2
  ; SI: bb.2.if:
  ; SI:   successors: %bb.3(0x80000000)
  ; SI:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[PHI2]], %subreg.sub0, killed [[PHI3]], %subreg.sub1
  ; SI:   [[S_MOV_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI: bb.3:
  ; SI:   successors: %bb.3(0x40000000), %bb.4(0x40000000)
  ; SI:   [[PHI4:%[0-9]+]]:vreg_64 = PHI undef %51:vreg_64, %bb.3, [[REG_SEQUENCE]], %bb.2
  ; SI:   [[PHI5:%[0-9]+]]:vgpr_32 = PHI undef %53:vgpr_32, %bb.3, [[PHI1]], %bb.2
  ; SI:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI4]].sub0, implicit $exec
  ; SI:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI4]].sub1, implicit $exec
  ; SI:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; SI:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], killed [[PHI4]], implicit $exec
  ; SI:   [[S_AND_SAVEEXEC_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY6:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY killed [[COPY6]]
  ; SI:   $vgpr0 = COPY killed [[PHI5]]
  ; SI:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE1]], 0, csr_amdgpu_highregs, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_]], implicit-def dead $scc
  ; SI:   SI_WATERFALL_LOOP %bb.3, implicit $exec
  ; SI: bb.4:
  ; SI:   successors: %bb.8(0x80000000)
  ; SI:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_]]
  ; SI:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY killed [[COPY7]]
  ; SI:   S_BRANCH %bb.8
  ; SI: bb.5.else:
  ; SI:   successors: %bb.6(0x80000000)
  ; SI:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[COPY1]], %subreg.sub0, killed [[COPY]], %subreg.sub1
  ; SI:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI: bb.6:
  ; SI:   successors: %bb.6(0x40000000), %bb.7(0x40000000)
  ; SI:   [[PHI6:%[0-9]+]]:vreg_64 = PHI undef %55:vreg_64, %bb.6, [[REG_SEQUENCE2]], %bb.5
  ; SI:   [[PHI7:%[0-9]+]]:vgpr_32 = PHI undef %57:vgpr_32, %bb.6, [[COPY4]], %bb.5
  ; SI:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI6]].sub0, implicit $exec
  ; SI:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI6]].sub1, implicit $exec
  ; SI:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_2]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; SI:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE3]], killed [[PHI6]], implicit $exec
  ; SI:   [[S_AND_SAVEEXEC_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_1]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY9:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY killed [[COPY9]]
  ; SI:   $vgpr0 = COPY killed [[PHI7]]
  ; SI:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE3]], 0, csr_amdgpu_highregs, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_1]], implicit-def dead $scc
  ; SI:   SI_WATERFALL_LOOP %bb.6, implicit $exec
  ; SI: bb.7:
  ; SI:   successors: %bb.1(0x80000000)
  ; SI:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_1]]
  ; SI:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY killed [[COPY10]]
  ; SI:   S_BRANCH %bb.1
  ; SI: bb.8.end:
  ; SI:   [[PHI8:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, [[COPY8]], %bb.4
  ; SI:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   $vgpr0 = COPY killed [[PHI8]]
  ; SI:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = call amdgpu_gfx float %extern_func(float %v)
  br label %end

else:
  %v.else = call amdgpu_gfx float %extern_func2(float %v)
  br label %end

end:
  %r = phi float [ %v.if, %if ], [ %v.else, %else ]
  ret float %r
}

; a loop inside an if-else, but the variable is still in use after the if-else
define amdgpu_ps float @loop_with_use(i32 %z, float %v, i32 inreg %bound, float(float)* %extern_func, float(float)* %extern_func2) #0 {
  ; SI-LABEL: name: loop_with_use
  ; SI: bb.0.main_body:
  ; SI:   successors: %bb.5(0x40000000), %bb.1(0x40000000)
  ; SI:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5
  ; SI:   [[COPY:%[0-9]+]]:vgpr_32 = COPY killed $vgpr5
  ; SI:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY killed $vgpr4
  ; SI:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY killed $vgpr3
  ; SI:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY killed $vgpr2
  ; SI:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY killed $vgpr1
  ; SI:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   [[V_CMP_GT_I32_e64_:%[0-9]+]]:sreg_32 = V_CMP_GT_I32_e64 6, killed [[COPY5]], implicit $exec
  ; SI:   [[SI_IF:%[0-9]+]]:sreg_32 = SI_IF killed [[V_CMP_GT_I32_e64_]], %bb.1, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.5
  ; SI: bb.1.Flow:
  ; SI:   successors: %bb.2(0x40000000), %bb.8(0x40000000)
  ; SI:   [[PHI:%[0-9]+]]:vgpr_32 = PHI undef %30:vgpr_32, %bb.0, %4, %bb.7
  ; SI:   [[PHI1:%[0-9]+]]:vgpr_32 = PHI [[COPY3]], %bb.0, undef %46:vgpr_32, %bb.7
  ; SI:   [[PHI2:%[0-9]+]]:vgpr_32 = PHI [[COPY2]], %bb.0, undef %48:vgpr_32, %bb.7
  ; SI:   [[SI_ELSE:%[0-9]+]]:sreg_32 = SI_ELSE killed [[SI_IF]], %bb.8, implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   S_BRANCH %bb.2
  ; SI: bb.2.if:
  ; SI:   successors: %bb.3(0x80000000)
  ; SI:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[PHI1]], %subreg.sub0, killed [[PHI2]], %subreg.sub1
  ; SI:   [[S_MOV_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI: bb.3:
  ; SI:   successors: %bb.3(0x40000000), %bb.4(0x40000000)
  ; SI:   [[PHI3:%[0-9]+]]:vreg_64 = PHI undef %50:vreg_64, %bb.3, [[REG_SEQUENCE]], %bb.2
  ; SI:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI3]].sub0, implicit $exec
  ; SI:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI3]].sub1, implicit $exec
  ; SI:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; SI:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], killed [[PHI3]], implicit $exec
  ; SI:   [[S_AND_SAVEEXEC_B32_:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY6:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY killed [[COPY6]]
  ; SI:   $vgpr0 = COPY [[COPY4]]
  ; SI:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE1]], 0, csr_amdgpu_highregs, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_]], implicit-def dead $scc
  ; SI:   SI_WATERFALL_LOOP %bb.3, implicit $exec
  ; SI: bb.4:
  ; SI:   successors: %bb.8(0x80000000)
  ; SI:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_]]
  ; SI:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY killed [[COPY7]]
  ; SI:   S_BRANCH %bb.8
  ; SI: bb.5.else:
  ; SI:   successors: %bb.6(0x80000000)
  ; SI:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE killed [[COPY1]], %subreg.sub0, killed [[COPY]], %subreg.sub1
  ; SI:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_MOV_B32 $exec_lo
  ; SI: bb.6:
  ; SI:   successors: %bb.6(0x40000000), %bb.7(0x40000000)
  ; SI:   [[PHI4:%[0-9]+]]:vreg_64 = PHI undef %52:vreg_64, %bb.6, [[REG_SEQUENCE2]], %bb.5
  ; SI:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI4]].sub0, implicit $exec
  ; SI:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sgpr_32 = V_READFIRSTLANE_B32 [[PHI4]].sub1, implicit $exec
  ; SI:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_2]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; SI:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_32_xm0_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE3]], killed [[PHI4]], implicit $exec
  ; SI:   [[S_AND_SAVEEXEC_B32_1:%[0-9]+]]:sreg_32_xm0_xexec = S_AND_SAVEEXEC_B32 killed [[V_CMP_EQ_U64_e64_1]], implicit-def $exec, implicit-def dead $scc, implicit $exec
  ; SI:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY9:%[0-9]+]]:sgpr_128 = COPY $sgpr100_sgpr101_sgpr102_sgpr103
  ; SI:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY killed [[COPY9]]
  ; SI:   $vgpr0 = COPY [[COPY4]]
  ; SI:   dead $sgpr30_sgpr31 = SI_CALL killed [[REG_SEQUENCE3]], 0, csr_amdgpu_highregs, implicit killed $sgpr0_sgpr1_sgpr2_sgpr3, implicit killed $vgpr0, implicit-def $vgpr0
  ; SI:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; SI:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY killed $vgpr0
  ; SI:   $exec_lo = S_XOR_B32_term $exec_lo, killed [[S_AND_SAVEEXEC_B32_1]], implicit-def dead $scc
  ; SI:   SI_WATERFALL_LOOP %bb.6, implicit $exec
  ; SI: bb.7:
  ; SI:   successors: %bb.1(0x80000000)
  ; SI:   $exec_lo = S_MOV_B32 killed [[S_MOV_B32_1]]
  ; SI:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY killed [[COPY10]]
  ; SI:   S_BRANCH %bb.1
  ; SI: bb.8.end:
  ; SI:   [[PHI5:%[0-9]+]]:vgpr_32 = PHI [[PHI]], %bb.1, [[COPY8]], %bb.4
  ; SI:   SI_END_CF killed [[SI_ELSE]], implicit-def dead $exec, implicit-def dead $scc, implicit $exec
  ; SI:   %27:vgpr_32 = nofpexcept V_ADD_F32_e32 killed [[PHI5]], killed [[COPY4]], implicit $mode, implicit $exec
  ; SI:   $vgpr0 = COPY killed %27
  ; SI:   SI_RETURN_TO_EPILOG killed $vgpr0
main_body:
  %cc = icmp sgt i32 %z, 5
  br i1 %cc, label %if, label %else

if:
  %v.if = call amdgpu_gfx float %extern_func(float %v)
  br label %end

else:
  %v.else = call amdgpu_gfx float %extern_func2(float %v)
  br label %end

end:
  %r = phi float [ %v.if, %if ], [ %v.else, %else ]
  %r2 = fadd float %r, %v
  ret float %r2
}

attributes #0 = { nounwind }
