/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;

public final class Class
implements Serializable {
    public static native Class forName(String var0) throws ClassNotFoundException;

    public static native Class forName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public native Class[] getClasses();

    public native ClassLoader getClassLoader();

    public native Class getComponentType();

    public native Constructor getConstructor(Class[] var1) throws NoSuchMethodException, SecurityException;

    private native Constructor[] _getConstructors(boolean var1) throws SecurityException;

    public Constructor[] getConstructors() throws SecurityException {
        return this._getConstructors(false);
    }

    public native Constructor getDeclaredConstructor(Class[] var1) throws NoSuchMethodException, SecurityException;

    public native Class[] getDeclaredClasses() throws SecurityException;

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        return this._getConstructors(true);
    }

    public native Field getDeclaredField(String var1) throws NoSuchFieldException, SecurityException;

    public native Field[] getDeclaredFields() throws SecurityException;

    private native Method _getDeclaredMethod(String var1, Class[] var2);

    public Method getDeclaredMethod(String methodName, Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkMemberAccess(this, 1);
            Package p = this.getPackage();
            if (p != null) {
                sm.checkPackageAccess(p.getName());
            }
        }
        if ("<init>".equals(methodName) || "<clinit>".equals(methodName)) {
            throw new NoSuchMethodException(methodName);
        }
        Method m = this._getDeclaredMethod(methodName, parameterTypes);
        if (m == null) {
            throw new NoSuchMethodException(methodName);
        }
        return m;
    }

    public native Method[] getDeclaredMethods() throws SecurityException;

    public native Class getDeclaringClass();

    private native Field getField(String var1, int var2) throws NoSuchFieldException, SecurityException;

    public Field getField(String fieldName) throws NoSuchFieldException, SecurityException {
        Field fld;
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMemberAccess(this, 1);
        }
        if ((fld = this.getField(fieldName, fieldName.hashCode())) == null) {
            throw new NoSuchFieldException(fieldName);
        }
        return fld;
    }

    private native Field[] _getFields(Field[] var1, int var2);

    public native Field[] getFields() throws SecurityException;

    public Package getPackage() {
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            String name = this.getName();
            String pkg = "";
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                pkg = name.substring(0, idx);
            }
            return cl.getPackage(pkg);
        }
        return null;
    }

    public native Class[] getInterfaces();

    private final native void getSignature(StringBuffer var1);

    private static final native String getSignature(Class[] var0, boolean var1);

    public native Method _getMethod(String var1, Class[] var2);

    public Method getMethod(String methodName, Class[] parameterTypes) throws NoSuchMethodException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkMemberAccess(this, 0);
            Package p = this.getPackage();
            if (p != null) {
                sm.checkPackageAccess(p.getName());
            }
        }
        if ("<init>".equals(methodName) || "<clinit>".equals(methodName)) {
            throw new NoSuchMethodException(methodName);
        }
        Method m = this._getMethod(methodName, parameterTypes);
        if (m == null) {
            throw new NoSuchMethodException(methodName);
        }
        return m;
    }

    private native int _getMethods(Method[] var1, int var2);

    public native Method[] getMethods() throws SecurityException;

    public native int getModifiers();

    public native String getName();

    public URL getResource(String resourceName) {
        String name = this.resourcePath(resourceName);
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResource(name);
        }
        return loader.getResource(name);
    }

    public InputStream getResourceAsStream(String resourceName) {
        String name = this.resourcePath(resourceName);
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return loader.getResourceAsStream(name);
    }

    private String resourcePath(String resourceName) {
        if (resourceName.startsWith("/")) {
            return resourceName.substring(1);
        }
        Class c = this;
        while (c.isArray()) {
            c = c.getComponentType();
        }
        String packageName = c.getName().replace('.', '/');
        int end = packageName.lastIndexOf(47);
        if (end == -1) {
            return resourceName;
        }
        return packageName.substring(0, end + 1) + resourceName;
    }

    public Object[] getSigners() {
        return null;
    }

    public native Class getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public native boolean isPrimitive();

    public native Object newInstance() throws InstantiationException, IllegalAccessException;

    private native ProtectionDomain getProtectionDomain0();

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ClassLoader.protectionDomainPermission);
        }
        if ((protectionDomain = this.getProtectionDomain0()) == null) {
            return ClassLoader.unknownProtectionDomain;
        }
        return protectionDomain;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public boolean desiredAssertionStatus() {
        ClassLoader c;
        block20: {
            Object status;
            block19: {
                block18: {
                    block17: {
                        c = this.getClassLoader();
                        if (c == null) {
                            return VMClassLoader.defaultAssertionStatus();
                        }
                        if (c.classAssertionStatus == null) break block17;
                        ClassLoader classLoader = c;
                        synchronized (classLoader) {
                            block15: {
                                try {
                                    status = c.classAssertionStatus.get(this.getName());
                                    if (status == null) break block15;
                                    boolean bl = status.equals(Boolean.TRUE);
                                    Object var5_9 = null;
                                    return bl;
                                }
                                catch (Throwable throwable) {
                                    Object var5_11 = null;
                                    throw throwable;
                                }
                            }
                            Object var5_10 = null;
                            break block18;
                        }
                    }
                    status = ClassLoader.systemClassAssertionStatus.get(this.getName());
                    if (status != null) {
                        boolean bl = status.equals(Boolean.TRUE);
                        return bl;
                    }
                }
                if (c.packageAssertionStatus == null) break block19;
                ClassLoader classLoader = c;
                synchronized (classLoader) {
                    block16: {
                        try {
                            String name = Class.getPackagePortion(this.getName());
                            if ("".equals(name)) {
                                status = c.packageAssertionStatus.get(null);
                            } else {
                                do {
                                    status = c.packageAssertionStatus.get(name);
                                } while (!"".equals(name = Class.getPackagePortion(name)) && status == null);
                            }
                            if (status == null) break block16;
                            boolean bl = status.equals(Boolean.TRUE);
                            Object var7_14 = null;
                            return bl;
                        }
                        catch (Throwable throwable) {
                            Object var7_16 = null;
                            throw throwable;
                        }
                    }
                    Object var7_15 = null;
                    break block20;
                }
            }
            String name = Class.getPackagePortion(this.getName());
            if ("".equals(name)) {
                status = ClassLoader.systemPackageAssertionStatus.get(null);
            } else {
                do {
                    status = ClassLoader.systemPackageAssertionStatus.get(name);
                } while (!"".equals(name = Class.getPackagePortion(name)) && status == null);
            }
            if (status != null) {
                boolean bl = status.equals(Boolean.TRUE);
                return bl;
            }
        }
        boolean bl = c.defaultAssertionStatus;
        return bl;
    }

    private Class() {
    }

    private void checkMemberAccess(int flags) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkMemberAccess(this, flags);
        }
    }

    private native void initializeClass();

    protected native void finalize();

    private static String getPackagePortion(String name) {
        int lastInd = name.lastIndexOf(46);
        if (lastInd == -1) {
            return "";
        }
        return name.substring(0, lastInd);
    }
}

