/*  settings.c
 *  
 *  Copyright (C) 2003 Edscott Wilson Garcia (edscott@users.sourceforge.net)
 *  Copyright (C) 2002 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *
 *   modified for xffm by Edscott Wilson Garcia
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <glib.h>
#include <gtk/gtk.h>

#include <libxfce4util/util.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

/*#include "misc.h"*/
#include "settings.h"

#include "preferences.i"
/* keep gcc happy */
preferences_t *prefs = opt_branches_titles;

#define ROOT	"xffm"

#define CONFIG_VERSION  "0.6"

int geometryX = -1, geometryY = -1, hpane = -1;
#define XFFM_THEME "gnome"
#define XFFM_ICON_SIZE 2

/* the size of env_string must coincide with that of env_vars! */
gchar *env_string[17]={
	NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL
};
char *env_vars[]={
	"TERM",
	"XFFM_HOME",
	"XFFM_STATUS_LINE_LENGTH",
	"XFFM_MAX_PREVIEW_SIZE",
	"SMB_USER",
	"SMB_CODESET",
	"XFFM_APPEND_FILES",
	"XFFM_HIDE_BOOK",
	"XFFM_HIDE_LOCAL",
	"XFFM_HIDE_NETWORK",
	"XFFM_HIDE_APPS",
	"XFFM_HIDE_FIND",
	"XFFM_HIDE_TRASH",
	"XFFM_HIDE_FSTAB",
	"XFFM_HOLD_XTERM",
	"XFFM_DEFAULT_UNLINK",
	NULL
};


char **find_themes(char *where)
{
    char **themes = NULL;
    GList *list = NULL, *li;
    GDir *gdir;
    const char *file;
    int i, len;

    {
	gdir = g_dir_open(where, 0, NULL);

	if(gdir)
	{
	    while((file = g_dir_read_name(gdir)))
	    {
		char *path = g_build_filename(where, file, NULL);

		if(!g_list_find_custom(list, file, (GCompareFunc) strcmp) && g_file_test(path, G_FILE_TEST_IS_DIR))
		{
		    list = g_list_append(list, g_strdup(file));
		}

		g_free(path);
		path=NULL;
	    }

	    g_dir_close(gdir);
	}
    }

    len = g_list_length(list);

    themes = g_new0(char *, len + 1);

    for(i = 0, li = list; li; li = li->next, i++)
    {
	themes[i] = (char *)li->data;
    }

    g_list_free(list);

    return themes;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
  Reading xml
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
static xmlDocPtr xmlconfig = NULL;

#if 0
static xmlDocPtr make_empty_doc(void)
{
    xmlDocPtr doc;
    xmlNodePtr root;

    doc = xmlNewDoc("1.0");
    doc->children = xmlNewDocRawNode(doc, NULL, ROOT, NULL);

    root = (xmlNodePtr) doc->children;
    xmlDocSetRootElement(doc, root);

    xmlNewTextChild(root, NULL, "CONFIG_VERSION",CONFIG_VERSION);
    xmlNewTextChild(root, NULL, "preferences", NULL);
    xmlNewTextChild(root, NULL, "view", NULL);
    xmlNewTextChild(root, NULL, "options", NULL);
    xmlNewTextChild(root, NULL, "geometry", NULL);

    return doc;
}
#endif

void get_config(tree_details_t ** tree_details_p,char *rcfile)
{
    xmlChar *value;
    xmlNodePtr node;
    int i;


    (*tree_details_p)->preferences = 0;
    (*tree_details_p)->homedir = NULL;
    (*tree_details_p)->smb_user = NULL;
    (*tree_details_p)->xffm_layer = 1;
    (*tree_details_p)->icon_size = XFFM_ICON_SIZE;
    (*tree_details_p)->theme = g_strdup(XFFM_THEME);


    /* global xmlDocPtr */
    if(!xmlconfig){
       xmlKeepBlanksDefault(0);
       xmlconfig = xmlParseFile(rcfile);
       if (!xmlconfig) {
	       goto new_xffm_config;
       }
    }

    node = xmlDocGetRootElement(xmlconfig);
    if(!node){
	xmlFreeDoc(xmlconfig);
        goto new_xffm_config;
    }

    if(!xmlStrEqual(node->name, (const xmlChar *)ROOT))
    {
	xmlFreeDoc(xmlconfig);
new_xffm_config:
    	(*tree_details_p)->preferences = (SHOW_MM | SHOW_TB1 | SHOW_TB2 | IMAGE_PREVIEW | FILETYPE_SUBS | AUTOSCROLL | DRAG_DO_COPY);
	xmlconfig = NULL;
	write_xffm_config(tree_details_p);
	
	return;
    }
    
    
    for(node = node->children; node; node = node->next){
	if(xmlStrEqual(node->name, (const xmlChar *)"CONFIG_VERSION")){
		char *e=xmlNodeListGetString(xmlconfig, node->children, 1);
		if (strcmp(e,CONFIG_VERSION)==0)
		{
			break;
		} else {
		    xmlFreeDoc(xmlconfig);
       		    goto new_xffm_config;
		    

#if 0			    
		    for (i=0;env_vars[i];i++){
		      if (!getenv(env_vars[i]) || !strlen(getenv(env_vars[i])))
		      {
			gchar *value=NULL;
			  /*printf("DBG: ... envars=%s\n",env_vars[i]);*/
	      		if (strcmp(env_vars[i],"XFFM_MAX_PREVIEW_SIZE")==0) 
				value=g_strdup("256");
	      		if (strcmp(env_vars[i],"XFFM_STATUS_LINE_LENGTH")==0) 
				value=g_strdup("48");
	      		if (strcmp(env_vars[i],"SMB_USER")==0) 
				value=g_strdup("GUEST%");
	      		if (strcmp(env_vars[i],"SMB_CODESET")==0){
    			  const char *fc;
		   	  g_get_charset(&fc);
    			  if (fc) value = g_strdup(fc);
    			  else value = g_strdup("ISO-8859-1");
    			  if (strcmp(value,"UTF-8")==0 || 
					  strcmp(value,"ASCII")==0){
	    		   g_free(value);
	    		   value = g_strdup("ISO-8859-1");
			  }
			}
	      		if (strcmp(env_vars[i],"XFFM_HOME")==0) 
				if (getenv("HOME")) value=g_strdup(getenv("HOME"));
			if (value){
			  /*printf("DBG: envars=%s\n",env_vars[i]);
			  printf("DBG: value=%s\n",value);*/
	    		  g_free(env_string[i]);
		    	  env_string[i]= g_strconcat(env_vars[i],"=",value,NULL);
            		  putenv(env_string[i]);
	    		  g_free(value);
			}
			/*else printf("DBG: not valid %s\n",env_vars[i]);*/
		      }
		    }
#endif
		    write_xffm_config(tree_details_p);
		    return;
		}
	}

    }
    node = xmlDocGetRootElement(xmlconfig);

    /* Now parse the xml tree */
    for(node = node->children; node; node = node->next)
    {
	/*printf("DBG:child=%s\n",node->name); */
	if(xmlStrEqual(node->name, (const xmlChar *)"preferences"))
	{
	    for(i = 0; preferences_titles[i].xml_option; i++)
	    {
		value = xmlGetProp(node, (const xmlChar *)preferences_titles[i].xml_option);
		if(value)
		{
		    (*tree_details_p)->preferences |= (atoi(value) & preferences_titles[i].flag);
		    g_free(value);value=NULL;
		}
	    }
	    for(i = 0; opt_col_titles[i].xml_option; i++)
	    {
		value = xmlGetProp(node, (const xmlChar *)opt_col_titles[i].xml_option);
		if(value)
		{
		    (*tree_details_p)->preferences |= (atoi(value) & opt_col_titles[i].flag);
		    g_free(value);value=NULL;
		}
	    }
	    for(i = 0; opt_view_titles[i].xml_option; i++)
	    {
		value = xmlGetProp(node, (const xmlChar *)opt_view_titles[i].xml_option);
		if(value)
		{
		    (*tree_details_p)->preferences |= (atoi(value) & opt_view_titles[i].flag);
		    g_free(value);value=NULL;
		}
	    }
	}
	if(xmlStrEqual(node->name, (const xmlChar *)"options"))
	{
#if 0
	    value = xmlGetProp(node, (const xmlChar *)"homedir");
	    if(value)
		(*tree_details_p)->homedir = g_strdup(value);
	    else
		(*tree_details_p)->homedir = NULL;
	    value = xmlGetProp(node, (const xmlChar *)"smb_user");
	    if(value)
		(*tree_details_p)->smb_user = g_strdup(value);
	    else
		(*tree_details_p)->smb_user = NULL;
	    value = xmlGetProp(node, (const xmlChar *)"xffm_layer");
	    (*tree_details_p)->xffm_layer = (value) ? atoi(value) : -1;
#endif
	    
	    value = xmlGetProp(node, (const xmlChar *)"icon_size");

	    if (value) 
	    {
		(*tree_details_p)->icon_size = atoi(value);
		g_free(value);value=NULL;
	    }
	    else 
	    {
		(*tree_details_p)->icon_size = -1;
	    }
	    
	    value = xmlGetProp(node, (const xmlChar *)"theme");
	    if(value) {
		g_free((*tree_details_p)->theme);    
		(*tree_details_p)->theme = (char*)value;
	    }
	}

	if(xmlStrEqual(node->name, (const xmlChar *)"geometry"))
	{
	    value = xmlGetProp(node, (const xmlChar *)"width");
	    geometryX = (value) ? atoi(value) : -1;
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"height");
	    geometryY = (value) ? atoi(value) : -1;
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"hpane");
	    hpane = (value) ? atoi(value) : -1;
	    g_free(value);value=NULL;
	}

    }
    xmlFreeDoc(xmlconfig);
    xmlconfig = NULL;
}

void get_xffm_config(tree_details_t ** tree_details_p){
   char rcfile[_POSIX_PATH_MAX];
   xfce_get_userfile_r(rcfile, _POSIX_PATH_MAX-1, "xffm%cxffmrc.xml",
		   G_DIR_SEPARATOR);
   get_config(tree_details_p,rcfile);
}

void get_local_xffm_config(tree_details_t ** tree_details_p){
   char rcfile[_POSIX_PATH_MAX];
   xfce_get_userfile_r(rcfile, _POSIX_PATH_MAX-1, "xffm%cxffmrc.xml",
		   G_DIR_SEPARATOR);
   get_config(tree_details_p,rcfile);
}

void xffm_write_xml(xmlNodePtr root, tree_details_t ** tree_details_p)
{
    xmlNodePtr node;
    xmlNodePtr child;
    char value[32];
    int i;
    
    node = xmlNewTextChild(root, NULL, "CONFIG_VERSION",CONFIG_VERSION);

    node = xmlNewTextChild(root, NULL, "preferences", NULL);
    for(i = 0; preferences_titles[i].xml_option; i++)
    {
	snprintf(value, 32, "%d", (*tree_details_p)->preferences & preferences_titles[i].flag);
	xmlSetProp(node, preferences_titles[i].xml_option, value);
    }
    for(i = 0; opt_remote_titles[i].xml_option; i++)
    {
	snprintf(value, 32, "%d", (*tree_details_p)->preferences & opt_remote_titles[i].flag);
	xmlSetProp(node, opt_remote_titles[i].xml_option, value);
    }
    for(i = 0; opt_col_titles[i].xml_option; i++)
    {
	snprintf(value, 32, "%d", (*tree_details_p)->preferences & opt_col_titles[i].flag);
	xmlSetProp(node, opt_col_titles[i].xml_option, value);
    }

#if 0
    node = xmlNewTextChild(root, NULL, "view", NULL);
    for(i = 0; view_titles[i].xml_option; i++)
    {
	snprintf(value, 32, "%d", (*tree_details_p)->preferences & view_titles[i].flag);
	xmlSetProp(node, view_titles[i].xml_option, value);
    }
#endif
    node = xmlNewTextChild(root, NULL, "options", NULL);
#if 0
    if((*tree_details_p)->homedir)
	xmlSetProp(node, "homedir", (*tree_details_p)->homedir);
    if((*tree_details_p)->smb_user)
	xmlSetProp(node, "smb_user", (*tree_details_p)->smb_user);

    snprintf(value, 32, "%d", (*tree_details_p)->xffm_layer);
    xmlSetProp(node, "xffm_layer", value);
#endif
    
    snprintf(value, 32, "%d", (*tree_details_p)->icon_size);
    xmlSetProp(node, "icon_size", value);
    xmlSetProp(node, "theme", (*tree_details_p)->theme);

    /*if((*tree_details_p)->preferences & SAVE_GEOMETRY)*/
    if ((*tree_details_p)->window){
    	GtkWidget *hpaned= lookup_widget((*tree_details_p)->window, "hpaned1");
	geometryX = (*tree_details_p)->window->allocation.width;
	geometryY = (*tree_details_p)->window->allocation.height;
	child = xmlNewTextChild(root, NULL, "geometry", NULL);
	snprintf(value, 32, "%d", geometryX);
	xmlSetProp(child, "width", value);

	snprintf(value, 32, "%d", geometryY);
	xmlSetProp(child, "height", value);
	
	snprintf(value, 32, "%d",gtk_paned_get_position((GtkPaned *)hpaned));
	xmlSetProp(child, "hpane", value);
	
    }

    {
      int i;
      for (i=0;env_vars[i];i++) if (strcmp("SMB_USER",env_vars[i])!=0){
        node = xmlNewTextChild(root, NULL, env_vars[i], NULL);
	/*printf("DBG write %s ->%s<\n",env_vars[i],getenv(env_vars[i]));*/
        if (getenv(env_vars[i]) && strlen(getenv(env_vars[i]))){
		/*printf("DBG: OK!\n");*/
           xmlSetProp(node, "env", getenv(env_vars[i]));
	}
	/*else	printf("DBG: KO!\n");*/
      }	 
     }	
    
}

void write_config(tree_details_t ** tree_details_p,char *rcfile)
{
    char *dir;
    xmlNodePtr root;

    if(!g_file_test(rcfile, G_FILE_TEST_EXISTS))
    {
	dir = g_path_get_dirname(rcfile);

	if(!g_file_test(dir, G_FILE_TEST_IS_DIR))
	    mkdir(dir, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);

	g_free(dir);dir=NULL;
    }

    xmlconfig = xmlNewDoc("1.0");
    xmlconfig->children = xmlNewDocRawNode(xmlconfig, NULL, ROOT, NULL);

    root = (xmlNodePtr) xmlconfig->children;
    xmlDocSetRootElement(xmlconfig, root);

    xffm_write_xml(root, tree_details_p);

    xmlSaveFormatFile(rcfile, xmlconfig, 1);

    xmlFreeDoc(xmlconfig);
    xmlconfig = NULL;
}

void write_xffm_config(tree_details_t ** tree_details_p)
{
    char rcfile[_POSIX_PATH_MAX];

    xfce_get_userfile_r(rcfile, _POSIX_PATH_MAX-1, "xffm%cxffmrc.xml",
		   G_DIR_SEPARATOR);
    write_config(tree_details_p,rcfile);
    chmod(rcfile,0644);
}
void write_local_xffm_config(tree_details_t ** tree_details_p)
{
    char rcfile[_POSIX_PATH_MAX];

    xfce_get_userfile_r(rcfile, _POSIX_PATH_MAX-1, "xffm%cxffmrc.xml",
		   G_DIR_SEPARATOR);
    write_config(tree_details_p,rcfile);
    chmod(rcfile,0644);
}

/***   callbackS   ***/
