/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libgnome/gnome-i18n.h>
#include "gul-gobject-misc.h"
#include "galeon-marshal.h"
#include "gul-bonobo-extensions.h"
#include <gtk/gtkspinbutton.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkstock.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkvbox.h>
#include "gul-tbi-zoom.h"
#include "gul-tb-button.h"
#include "prefs-strings.h"
#include "eel-gconf-extensions.h"
#include <string.h>

#define NOT_IMPLEMENTED g_warning ("not implemented: " G_STRLOC);
//#define DEBUG_MSG(x) g_print x
#define DEBUG_MSG(x)

/**
 * Private data
 */
struct _GulTbiZoomPrivate 
{
	GtkWidget *spin;
	GulTbButton *gtb;
};


/**
 * Private functions, only availble from this file
 */
static void		gul_tbi_zoom_class_init			(GulTbiZoomClass *klass);
static void		gul_tbi_zoom_init			(GulTbiZoom *tb);
static void		gul_tbi_zoom_finalize_impl		(GObject *o);
static GtkWidget *	gul_tbi_zoom_get_widget_impl		(GulTbItem *i);
static GdkPixbuf *	gul_tbi_zoom_get_icon_impl		(GulTbItem *i);
static gchar *		gul_tbi_zoom_get_name_human_impl	(GulTbItem *i);
static gchar *		gul_tbi_zoom_to_string_impl		(GulTbItem *i);
static gboolean		gul_tbi_zoom_is_unique_impl		(GulTbItem *i);
static GulTbItem *	gul_tbi_zoom_clone_impl			(GulTbItem *i);
static void		gul_tbi_zoom_parse_properties_impl	(GulTbItem *i, const gchar *props);
static void		gul_tbi_zoom_add_to_bonobo_tb_impl	(GulTbItem *i, 
								 BonoboUIComponent *ui, 
								 const char *container_path,
								 guint index);


static gpointer gul_tb_item_class;

/**
 * TbiZoom object
 */

MAKE_GET_TYPE (gul_tbi_zoom, "GulTbiZoom", GulTbiZoom, gul_tbi_zoom_class_init, 
	       gul_tbi_zoom_init, GUL_TYPE_TB_ITEM);

static void
gul_tbi_zoom_class_init (GulTbiZoomClass *klass)
{
	G_OBJECT_CLASS (klass)->finalize = gul_tbi_zoom_finalize_impl;
	
	GUL_TB_ITEM_CLASS (klass)->get_widget = gul_tbi_zoom_get_widget_impl;
	GUL_TB_ITEM_CLASS (klass)->get_icon = gul_tbi_zoom_get_icon_impl;
	GUL_TB_ITEM_CLASS (klass)->get_name_human = gul_tbi_zoom_get_name_human_impl;
	GUL_TB_ITEM_CLASS (klass)->to_string = gul_tbi_zoom_to_string_impl;
	GUL_TB_ITEM_CLASS (klass)->is_unique = gul_tbi_zoom_is_unique_impl;
	GUL_TB_ITEM_CLASS (klass)->clone = gul_tbi_zoom_clone_impl;
	GUL_TB_ITEM_CLASS (klass)->parse_properties = gul_tbi_zoom_parse_properties_impl;
	GUL_TB_ITEM_CLASS (klass)->add_to_bonobo_tb = gul_tbi_zoom_add_to_bonobo_tb_impl;
	
	gul_tb_item_class = g_type_class_peek_parent (klass);
}

static void 
gul_tbi_zoom_init (GulTbiZoom *tbi)
{
	GulTbiZoomPrivate *p = g_new0 (GulTbiZoomPrivate, 1);
	tbi->priv = p;
}

GulTbiZoom *
gul_tbi_zoom_new (void)
{
	GulTbiZoom *ret = g_object_new (GUL_TYPE_TBI_ZOOM, NULL);
	return ret;
}

static void
gul_tbi_zoom_finalize_impl (GObject *o)
{
	GulTbiZoom *it = GUL_TBI_ZOOM (o);
	GulTbiZoomPrivate *p = it->priv;

	if (p->spin)
	{
		g_object_unref (p->spin);
	}

	if (p->gtb)
	{
		g_object_unref (p->gtb);
	}

	g_free (p);
	
	DEBUG_MSG (("GulTbiZoom finalized\n"));
	
	G_OBJECT_CLASS (gul_tb_item_class)->finalize (o);
}

static GtkWidget *
gul_tbi_zoom_get_widget_impl (GulTbItem *i)
{
	GulTbiZoom *iz = GUL_TBI_ZOOM (i);
	GulTbiZoomPrivate *p = iz->priv;

	if (!p->gtb)
	{
		p->spin = gtk_spin_button_new_with_range (10, 990, 10);
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (p->spin), 100);
		g_object_ref (p->spin);
		gtk_object_sink (GTK_OBJECT (p->spin));

		p->gtb = gul_tb_button_new ();
		g_object_ref (p->gtb);
		gtk_object_sink (GTK_OBJECT (p->gtb));

		gul_tb_button_set_label (p->gtb, _("Zoom"));
		gul_tb_button_set_priority (p->gtb, TRUE);
		gul_tb_button_set_tooltip_text (p->gtb, _("Zoom"));
		gul_tb_button_set_sensitivity (p->gtb, TRUE);
		gul_tb_button_set_show_button (p->gtb, FALSE);
		gtk_widget_show (p->spin);
		gul_tb_button_set_widget (p->gtb, p->spin);
	}

	return GTK_WIDGET (p->gtb);
}

GtkWidget *
gul_tbi_zoom_get_spinner (GulTbiZoom *i)
{
	GulTbiZoomPrivate *p = i->priv;
	gul_tbi_zoom_get_widget_impl (GUL_TB_ITEM (i));
	return p->spin;
}

static GdkPixbuf *
gul_tbi_zoom_get_icon_impl (GulTbItem *i)
{
	static GdkPixbuf *pb = NULL;
	if (!pb)
	{
		/* what's the easier way? */
		GtkWidget *b = gtk_spin_button_new_with_range (0, 1, 0.5);
		pb = gtk_widget_render_icon (b,
					     GTK_STOCK_ZOOM_IN,
					     GTK_ICON_SIZE_SMALL_TOOLBAR,
					     NULL);
		gtk_widget_destroy (b);
	}
	return g_object_ref (pb);
}

static gchar *
gul_tbi_zoom_get_name_human_impl (GulTbItem *i)
{
	return g_strdup (_("Zoom"));
}

static gchar *
gul_tbi_zoom_to_string_impl (GulTbItem *i)
{
	/* if it had any properties, the string should include them */
	return g_strdup_printf ("%s=zoom", i->id);
}

static gboolean
gul_tbi_zoom_is_unique_impl (GulTbItem *i)
{
	return TRUE;
}

static GulTbItem *
gul_tbi_zoom_clone_impl (GulTbItem *i)
{
	GulTbItem *ret = GUL_TB_ITEM (gul_tbi_zoom_new ());
	
	gul_tb_item_set_id (ret, i->id);

	/* should copy properties too, if any */
	/* the zoom value is not copied, not sure if it should... */

	return ret;
}

static void
gul_tbi_zoom_add_to_bonobo_tb_impl (GulTbItem *i, BonoboUIComponent *ui, 
				    const char *container_path, guint index)
{
	GtkWidget *w = gul_tb_item_get_widget (i);
	gtk_widget_show (w);
	gul_bonobo_add_numbered_widget (ui, w, index, container_path);
}

static void
gul_tbi_zoom_parse_properties_impl (GulTbItem *it, const gchar *props)
{
	/* we have no properties */
}

