#ifndef _CONF_H
#define _CONF_H

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

extern void conf_init(void);
extern void conf_clear(void);

extern void conf_set_ptt(void);

extern void conf_set_string(const gchar *key, const gchar *val);
extern void conf_set_bool(const gchar *key, gboolean val);
extern void conf_set_int(const gchar *key, gint val);
extern void conf_set_float(const gchar *key, gdouble val);

extern gchar *conf_get_string(const gchar *key, const gchar *def);
extern gboolean conf_get_bool(const gchar *key, gboolean def);
extern gint conf_get_int(const gchar *key, gint def);
extern gdouble conf_get_float(const gchar *key, gdouble def);

#define	conf_get_mycall()	conf_get_string("info/mycall",	"")
#define	conf_get_myname()	conf_get_string("info/myname",	"")
#define	conf_get_myqth()	conf_get_string("info/myqth",	"")
#define	conf_get_myloc()	conf_get_string("info/myloc",	"")
#define	conf_get_myemail()	conf_get_string("info/myemail",	"")

#define	conf_get_timefmt()	conf_get_string("misc/timefmt",	"%H:%M:%S %Z")
#define	conf_get_datefmt()	conf_get_string("misc/datefmt",	"%d.%m.%Y")

#define	BANDS_DEFAULT		"1.8,3.5,7,10,14,18,21,24,28"
#define conf_get_qsobands()	conf_get_string("misc/bands",	BANDS_DEFAULT)

#define	conf_get_logfile()	conf_get_string("misc/logfile",	"~/gMFSK.log")

#define	conf_get_sounddev()	conf_get_string("sound/dev",	"/dev/dsp")
#define conf_get_eightbit()	conf_get_bool("sound/8bit",	FALSE)
#define conf_get_stereo()	conf_get_bool("sound/stereo",	FALSE)
#define conf_get_fulldup()	conf_get_bool("sound/fulldup",	FALSE)
#define conf_get_testmode()	conf_get_bool("sound/testmode",	FALSE)

#define	conf_get_pttdev()	conf_get_string("ptt/dev",	"none")
#define conf_get_pttinv()	conf_get_bool("ptt/8bit",	FALSE)
#define conf_get_pttmode()	conf_get_int("ptt/mode",	2)

#define	conf_get_hellapp()	conf_get_string("apps/hellapp", "ghell")

#ifdef __cplusplus
}
#endif

#endif
