var args;
var globalScreenName = null;
var anonymous=false;
var mywindow = null;

/*
 * Function: WarnUserOnload()
 * Arguments: None
 * Return: None
 * Description: This function is called when the warn dialog is loaded. The screenname variable
 * is getting passed from the window open function which is now retrieved. A Warning message 
 * with the obtained screen name is added to the dilaog along with the OK and Cancel button.
*/

function WarnUserOnload()
{
	var screenName = top.window.arguments[0].screenName;
	var message =  " " + aimString("confirm.WarnUser").replace(/%ScreenName%/g, screenName);
	var element = document.getElementById("WarningHtml");
	var textNode = document.createTextNode(message);

	element.appendChild(textNode);
  labels = document.getElementById("okCancelButtonsRight");
  element = document.getElementById("ok");
  element.setAttribute("label", labels.getAttribute("button1Label"));
  element = document.getElementById("cancel");
  element.setAttribute("label", labels.getAttribute("button2Label"));
 	
	doSetOKCancel(WarnTheSucker, DontWarnTheSucker);
}

/*
 * Function: WarnUserOnUnload()
 * Arguments: None
 * Return: None
 * Description: This function is called when the warn dialog is unloaded.
 * DO we need this??
*/

function WarnUserOnUnload()
{
	// WarnUserOnUnload
}


/*
 * Function: toggleWarnAnonymouslyPref()
 * Arguments: None
 * Return: None
 * Description: This function is called when the warn anonymously check box in the
 * warning dialog gets clicked. If the user chooses to issue a warning anonymously  (less
 * severe warning and warnee is not revealed), then a global variable anonymous is set.
 * This will be later used by WarnUser function in WarnTheSucker where the actual warning is done.
*/

function toggleWarnAnonymouslyPref()
{
	var element = document.getElementById("WarnAnonymouslyCheckbox");
	anonymous = element.checked;
}


/*
 * Function: cmdPeopleWarn()
 * Arguments: None
 * Return: None
 * Description: This function is used to show the warning dialog.  This is called 
 * when uses clicks on the warn button or menu item People->Warn is invoked. It
 * gets the screenname and puts the warning dialog window. The screen name is passed
 * as an argument to the window open function which will be retrieved later  by the
 * WarnUserOnload() function. (See Above)
*/

function cmdPeopleWarn()
{
	globalScreenName = AimIMGetFormScreenName();
	if (!globalScreenName)
		return;
	var warnUserArgs = new Object();
	warnUserArgs.screenName = globalScreenName;
	window.openDialog("chrome://aim/content/WarnUser.xul","_blank", "chrome,dialog=no",warnUserArgs)
}





/*
* The warnUserCallback is he mechanism that gets used to process the results back from the server
* and backend once a warning request has been issued.
*/

var warnUserCallback = new Object();

/*
 * Function: OnWarnUserComplete
 * Arguments: None
 * Return: 
 *    screenName  --  the warned screen name
 *    delta --  the actual warning amount 
 *    newPercent  --  the updated warning percent after the delta has been added.
 * Description: This is the callback that gets called if the warning went through successfully.
 * It opens a alert window with the information that the screen name has been warned and their new
 * warning level.
*/

warnUserCallback.OnWarnUserComplete = function(screenName,delta,newPercent)
{
  top.alert(aimString("msg.WarnComplete").replace(/%ScreenName%/, screenName).replace(/%DeltaApplied%/, delta).replace(/%NewLevel%/, newPercent));
};

/*
 * Function: OnWarnUserError
 * Arguments: None
 * Return: 
 *    screenName  --  the warned screen name
 *    pErrMsg --  the reason for warning failure
 * Description: This is the callback that gets called if the warning failed for some reason. It opens a alert 
 * window describing that the specified screen name target could not be warned and the reason for it.
*/

warnUserCallback.OnWarnUserError = function(screenName,pErrMsg) 
{
  top.alert(aimString("msg.WarnError").replace(/%ScreenName%/, screenName));
};

/*
 * Function: WarnTheSucker() 
 * Arguments: None
 * Return: None
 * Description: This function gets the aimWarnings interface and uses the WarnUser method to 
 * issue a warning. The screenname to warn is obtained from the warning dialog window. 
 * The global variable anonymous holds the information whether the user wants to warn directly or anonymously.
 * These values are passed as parameters to WarnUser method along with the warnUserCallback (See Above). The 
 * call back will then hold the return values of the warning. 
*/

function WarnTheSucker() 
{

	var pIAimWarnings = aimWarnings();
	if (!pIAimWarnings)
		return;
	//actually C++ does not use the callback object right now
  pIAimWarnings.WarnUser( top.window.arguments[0].screenName , anonymous , warnUserCallback);
	window.close();
}

/*
 * Function: DontWarnTheSucker() 
 * Arguments: None
 * Return: None
 * Description: This function is used when the user decides not to warn the user from warning dialog,
 * by clikcing on Cancel button. It just closes the warning dialog window.
*/
function DontWarnTheSucker() 
{
	window.close();
}

