

// XXX Global to determine if our onload handler has been called yet.
// For some reason, our onunload handler is getting called before onload
// on the first time we create App.xul. This is a workaround.
var gFirstTime = 1;
var timercatch = false;

function GoAway( target )
{
	var name = target.getAttribute('MsgText');
	if(name=='')
	{
		try 
		{
		  name= document.getElementById('tbAway').getElementsByTagName("menuitem")[1].getAttribute('MsgText')
		}
		catch (e)
		{
			//Some error finding tbAway message-Setting default backup message
			name=aimString("away.DefaultMessage");
		}
	}

	locateManager = aimLocateManager();
  if (locateManager)
		locateManager.SetUserInfoAwayMessage(name);
}

var targetElement = null;

function GoAwayWait(target,wait)
{
	targetElement = target;
	setTimeout('GoAway( targetElement )',wait)
}

/*
 * Function: AimAppOnWndLoad()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called once app.xul has finished loading.Initializes the
 *		sidebar.
*/

function AimAppOnWndLoad()
{
  // XXX See note at the top of the file
	gFirstTime = 0;

	setTimeout("CheckBuddyPanel()",500);
    
  setAdTimer();

  updateCurrentAppWindow();

  addAppSessionListener();

  setTimeout("aimSession().SetAppIcon()", 1000);


}

/*
 * Function: AimAppOnWndUnload()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called once app.xul has been unloaded. 
*/

function AimAppOnWndUnload()
{
	// XXX See note at the top of the file

  if(gFirstTime == 1)
		return;
  removeAppSessionListener();
}

//************  Command Handling ****************

/*
 * Function: cmdNewBrowser()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Function invoked from menu or toolbar to create a new 
 * 		browser window. 
 * 
 * Bugs: URL is hardcoded. Needs to open a user-specified preference.
*/

function cmdNewBrowser()
{
	aimCmdNewBrowser("http://home.netscape.com");
}

/*
 * Function: cmdNewEmail()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Function invoked from menu or toolbar to create a new
 *		messenger window. 
*/

function cmdNewEmail()
{
	aimCmdNewEmail();
}



function cmdNewChat(invScreenName,invProposal,invScreenNames,toExistingWindow,invMode)
{
  if (isIcq() != true )
  {
    //App is aim - in this case shift-ctrl-C which invokes cmdNewchat should bring up chat window
  inviteArgsObj = {
    inviteProposalScreenName: invScreenName, 
    inviteProposalObj: invProposal,
    invitedScreenNames: invScreenNames,
    inviteToExistingWindow: toExistingWindow,
    inviteMode: invMode
  }
  window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no',inviteArgsObj);
  }
  else
  {
   //App is aim - in this case shift-ctrl-C which invokes cmdNewchat should bring up add Contact window.
      cmdAddBuddy();
  }
}

/*
 * Function: cmdNewIM()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Function invoked from menu or toolbar to create a new IM 
 *		window. Loads the window into a pre-connect state, e.g., the 
 *		dialog consists of screen name field and an editor. This
 *		function determines which buddy is selected in the list. 
 *		If a buddy is selected (the first one found) and is online,
 *		the screenname field in the IM window is initialized to that
 *		buddy. Otherwise, the screen name field is set to "".
*/

function cmdNewIM()
{
  var screenName = getSelectedScreenName();
  if (AimOnlineAway())
    ComeBack();
  if (!aimBuddyIsOnline(screenName))
    screenName = null;
	
  if (screenName != null) {
    var pIAimIM = aimIMObject();
    if (pIAimIM)
      var pWindow = pIAimIM.GetExistingIM(screenName);
    if (pWindow) {
      pWindow.focus();
      return;
    }
  }
  aimIMInvokeIMForm(screenName);
}

/*
 * Function: getSelectedBuddiesFromList()
 *
 * Arguments: None
 * 
 * Return: array of strings of buddies
 * 	that are currently selected (expands Groups to all buddies in group).
 *
 * Description: Function invoked via cmdNewChatSidebar to poll the
 *		Buddy list to find out which buddies (and expanded groups are selected).
 *		This function will always return an Array.
 *	
*/

function getSelectedBuddiesFromList()
{
  var tree = getSelectedTreeName();
  var col = getSelectedTabName();
  var selectedBuddies = new Array();
  var selectedGroups = new Array();
  var groupCount = 0;
  var buddyCount = 0;
  if (!tree || !col) return;
  var rangeCount = tree.treeBoxObject.selection.getRangeCount();
  if (rangeCount == 0)
    return null;
  var view = tree.treeBoxObject.view;
  var totalRowCount = view.rowCount;
  for(var i = 0; i < rangeCount; i++) {
    var startIndex = {};
    var endIndex = {};
    tree.treeBoxObject.selection.getRangeAt(i, startIndex, endIndex);
    for (var j = startIndex.value; j <= endIndex.value; j++) {
      var inOffline = IsIndexinSpecialGroup(tree, col, j);
      if (inOffline)
        break;

      var level = view.getLevel(j);
      if (level == 0) {
        //ok..a group (not in offline gp) is selected.
        var groupResource = GetBuddyResource(tree, j);
        var groupName = GetBuddyAttribute(tree, groupResource, "Name");
        if (!CheckForDuplicateInArray(selectedGroups, groupName)) {
          // we really don't need this check...but just in case ;-)
          selectedGroups[groupCount++] = groupName;
        }
      }
      else {
        // ok..a buddy is selected. Make sure the group associated with this buddy is not in the selectedGroups list.
        var parentIndex = view.getParentIndex(j);
        var parentResource = GetBuddyResource(tree, parentIndex);
        var parentName = GetBuddyAttribute(tree, parentResource, "Name");
        if (!CheckForDuplicateInArray(selectedGroups, parentName)) {
          var buddyResource = GetBuddyResource(tree, j);
          var buddyName = GetBuddyAttribute(tree, buddyResource, "ScreenName");
          if (!CheckForDuplicateInArray(selectedBuddies, buddyName)) {
            selectedBuddies[buddyCount++] = buddyName;
          }
        }


      }
    }
  }

  //till now we have all the information about the selected buddies and the groups (NOT the buddies underneath
  //the selected groups.
  for (var m=0; m < selectedGroups.length; m++) {
    var viewIndex = GetGroupIndex(tree, col, selectedGroups[m]);
    if (viewIndex < 0) {
      dump("Unable to find the group index for group: " + selectedGroups[m] + "\n");
      return;
    }

    //open the group
    if(!view.isContainerOpen(viewIndex))
      view.toggleOpenState(viewIndex);

    //get the buddies
    var groupIndex = viewIndex;
    totalRowCount = view.rowCount;
    while ((groupIndex < totalRowCount-1) && (viewIndex == view.getParentIndex(++groupIndex))) {
      var buddyResource1 = GetBuddyResource(tree, groupIndex);
      var buddyName1 = GetBuddyAttribute(tree, buddyResource1, "ScreenName");
      if (!CheckForDuplicateInArray(selectedBuddies, buddyName1))
        selectedBuddies[buddyCount++] = buddyName1;
    } //while

  } //for

  return selectedBuddies;
}

/* For the given parameter, this fn returns the index of the groupName */
function GetGroupIndex(tree, col, groupName)
{
  var view = tree.treeBoxObject.view;
  var totalRowCount = view.rowCount;
  for (var k=0; k<totalRowCount; k++) {
    var level = view.getLevel(k);
    //groups are always at index 0
    if (level == 0) {
      var parentResource = GetBuddyResource(tree, k);
      var cellText = GetBuddyAttribute(tree, parentResource, "Name");
      if (cellText == groupName)
        return k;
    }
  }
  return -1;
}

/* Just checks for any duplication in the array */
function CheckForDuplicateInArray(aarray, element)
{
  for (var i=0; i<aarray.length; i++) {
    if (aarray[i] == element)
      return true;
  }
  return false;
}

/*Checks for any duplicatation in the name property in an array */
function CheckForDuplicateNameInArray(aarray, element)
{
  for (var i=0; i<aarray.length; i++) {
    if (aarray[i].name == element)
      return true;
  }
  return false;
}

/* Checks whether the index is in Special group
   Right now only Special group: Awaiting Authorization
   Maybe later on Offline and Collected buddies will fall under this category ;-)
*/

function IsIndexinSpecialGroup(tree, col, index)
{
  var offlineIndex = -1;
  var view = tree.treeBoxObject.view;
  var totalRowCount = view.rowCount;
  for (var k=0; k<totalRowCount; k++) {
    var level = view.getLevel(k);
    if (level == 0) {
      var cellText = view.getCellText(k, col);
      if (cellText == aimString("msg.AuthGroup")) {
      
        offlineIndex = k;
        break;
      }
    }
  }

  if ((index >= offlineIndex) && (offlineIndex != -1))
    return true;
  else
    return false;

}


/*
 * Function: cmdSignOn()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called from menu item or toolbar. Passes control to sidebar
 *		panel cmdSignOn() (see SidebarPanel/SidebarPanel.js)
*/

function cmdSignOn()
{
	//var sidebarframe = top.frames["AppPanel"];
	//var sidebarframe=top.AIMDocumentPath;
    var sidebarframe=getsidebarframe();

  if(sidebarframe) {
	  sidebarframe.cmdPanelSignOn();
  }
  
}

/*
 * Function: cmdSignOff()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Calls aimSessionLogoff to close current IM session. 
 * 	
 *
*/

function cmdSignOff()
{
  /* Set pref to be false so that auto login doesnt get fired for every launch */
  aimPrefsManager().SetBoolPref("aim.session.appfirstlogin", false, null,true);
  aimSessionLogoff();

}

/*
 * Function: cmdCancelSignOn()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called during connection startup if cancel button is pressed.
 * 		Cancels the IM session by calling cmdSignOff().
 *		
*/

function cmdCancelSignOn()
{
    aimPrefsManager().SetBoolPref("aim.session.firsttry", false, null, true);
	cmdSignOff();
}

/*
 * Function: cmdClose()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Invoked from close menu item, or from cmdSignOffAndClose(),
 *		below. Causes the app window to be closed.
 *
*/

function cmdClose()
{
   //aimCmdClose();
   top.close();
}

/*
 * Function: cmdSignOffAndClose()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called in response to user selecting signoff and close menu
 *		item. Signs off the current IM session and closes the 
 *		standalone window.
*/

function createInstance( contractid, iidName )
{
	var iid = eval( "Components.interfaces." + iidName );
    	return Components.classes[ contractid ].createInstance( iid );
}

function cmdExportBuddyList()
{
    	nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

    fp.init(window, aimString("title.exportbudlist"), nsIFilePicker.modeSave);
    fp.appendFilter(aimString("budlist.title"), aimString("budlist.filter"));
    fp.appendFilters(nsIFilePicker.filterAll);

	try {
		var ret = fp.show();
		if ( ret == nsIFilePicker.returnOK || ret == nsIFilePicker.returnReplace) {
			var status;
			status = aimBuddyExportBuddyList(fp.file);
/*
			if ( status == false )
				aimErrorBox(aimString("msg.exporttryagain"));
			else
				aimErrorBox(aimString("msg.exportsuccess"));
*/
		}
	} 
	catch (ex) {
		aimErrorBox(aimString("msg.exportfailure"));
	}
	return;
}


function cmdImportBuddyList()
{

	nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

    fp.init(window, aimString("title.importbudlist"), nsIFilePicker.modeOpen);
    fp.appendFilter(aimString("budlist.title"), aimString("budlist.filter"));
    fp.appendFilters(nsIFilePicker.filterAll);

	try {
		var ret = fp.show();
		if ( ret == nsIFilePicker.returnOK ) {
			var status;
			aimBuddyImportBuddyList(fp.file);
		}
	}
	catch (ex) {
		aimErrorBox(aimString("msg.importfailure"));
	}
	return;
}

function cmdSignOffAndClose()
{
	cmdSignOff();
	cmdClose();
}

/*
 * Function: cmdAddBuddy()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called in response to menu item of toolbar button in standalone
 *		for adding a buddy to a buddy group. Opens BuddyAddBuddy.xul to
 *		place a dialog that can be used to add a buddy.
 *
 * Bugs:	Needs to support inline editing.
 * 
*/

function cmdAddBuddy()
{
  var sidebarframe=getsidebarframe();
	var foundOne = false;
	var selectedGroup = "";
  var elt = sidebarframe;
  if (!sidebarframe)
    elt = window;
  var tree = elt.document.getElementById("ListSetup");
   if (!tree )
 	 return;

  var isGroupPresent = aimCheckForGroupCount();
  if (!isGroupPresent) {
    (aimString("msg.NoGroups"));
  	return;
  }

  var groups = aimGetSelectedBuddyGroups();
	openDialog("chrome://aim/content/BuddyAddBuddy.xul", "", 
		"modal=yes,titlebar,chrome", groups, tree, null);
}

/*
 * Function: cmdAddGroup()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called in response to menu item of toolbar button in standalone
 *		for adding a buddy group. Opens BuddyAddGroup.xul to place a 
 *		dialog that can be used to add a buddy group.
 *
 * Bugs:	Needs to support inline editing.
 * 
*/

function cmdAddGroup()
{
	openDialog("chrome://aim/content/BuddyAddGroup.xul", "", "modal=yes,titlebar,chrome");
}

/*
 * Function: SelectedGroup()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Constructor function for SelectedGroup objects
 * 		
 *		
*/

function SelectedGroup()
{
  var index = 0;
	var selected = "false";
	var name = null;
}

/*
 * Function: SelectedBuddy()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Constructor function for SelectedBuddy objects
 * 		
*/

function SelectedBuddy()
{
	var parentname = null;
	var name = null;
}

/*
 * Function: cmdDelete()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Called in response to user clicking delete toolbar button or
 *		selecting delete menu item. Deletes all selected groups (and
 *		the buddies they contain) and all selected buddies.
*/

function cmdDelete()
{
  var tree = getSelectedTreeName();
  var col = getSelectedTabName();
  var selectedBuddies = new Array();
  var selectedGroups = new Array();
  var groupCount = 0;
  var buddyCount = 0;
  var lastSelectedIndex;
  if (!tree || !col) return;
  var groupCount = 0;
  var buddyCount = 0;
  var rangeCount = tree.treeBoxObject.selection.getRangeCount();
  if (rangeCount == 0) {
    // nothing is selected
    aimErrorBox(aimString("msg.NothingToDelete"));
    return;
  }
  var view = tree.treeBoxObject.view;
  for(var i = 0; i < rangeCount; i++) {
    var startIndex = {};
    var endIndex = {};
    tree.treeBoxObject.selection.getRangeAt(i, startIndex, endIndex);
    lastSelectedIndex = endIndex.value;
    for (var j = startIndex.value; j <= endIndex.value; j++) {
      var level = view.getLevel(j);
      if (level == 0) {
        var groupResource = GetBuddyResource(tree, j);
        var groupName = GetBuddyAttribute(tree, groupResource, "Name");
        // Special groups like Offline have no resources. So the value will be null.
        if (groupName == aimString("msg.AuthGroup")|| groupName == null) {
          aimErrorBox(aimString("msg.CannotDeleteAuthGroup"));
          continue;
        }
        
        selectedGroups[groupCount] = new SelectedGroup;
        selectedGroups[groupCount].name = groupName;
        selectedGroups[groupCount].index = j;
        groupCount++;



      } //if level ==0
      else {
        if (level == 1) {
          var parentIndex = view.getParentIndex(j);
          var parentResource = GetBuddyResource(tree, parentIndex);
          var parentName = GetBuddyAttribute(tree, parentResource, "Name");
          if (parentName == aimString("msg.AuthGroup") || parentName == null) {
             // A contact from the special group Authorization awaiting has been selected.
             var buddyResource = GetBuddyResource(tree, j);
             var buddyName = GetBuddyAttribute(tree, buddyResource, "ScreenName");
             selectedBuddies[buddyCount] = new SelectedBuddy;
             selectedBuddies[buddyCount].name = buddyName;
             selectedBuddies[buddyCount].parentname = aimString("msg.AuthGroup");
            // a group under Offline is selected.
          /*  var offlineGroupResource = GetBuddyResource(tree, j);
            var offlineGroupName = GetBuddyAttribute(tree, offlineGroupResource, "Name");
            if (!CheckForDuplicateNameInArray(selectedGroups, offlineGroupName)) {
              selectedGroups[groupCount] = new SelectedGroup;
              selectedGroups[groupCount].name = offlineGroupName;
              selectedGroups[groupCount].index = j;
              groupCount++;

            }
           */


          } //if offline
          else {
            // a Online buddy is selected
            if (!tree.treeBoxObject.selection.isSelected(parentIndex)) {
              //If the parent is already selected, ignore the selection. Else get the parent name
              var buddyResource = GetBuddyResource(tree, j);
              var buddyName = GetBuddyAttribute(tree, buddyResource, "ScreenName");
              selectedBuddies[buddyCount] = new SelectedBuddy;
              selectedBuddies[buddyCount].name = buddyName;
              selectedBuddies[buddyCount].parentname = parentName;
              buddyCount++;
            } //if


          } //else

        } //if level 1
        else {
          if (level == 2) {
            //Offline buddy is selected..
            var offlineParentIndex = view.getParentIndex(j);
            if (!tree.treeBoxObject.selection.isSelected(offlineParentIndex)) {
              //If the parent is already selected, ignore the selection. Else get the parent name
              //get the offline parent name
              var offlineParentResource = GetBuddyResource(tree, offlineParentIndex);
              var offlineParentName = GetBuddyAttribute(tree, offlineParentResource, "Name");
              
              // if the group is already selected in the Online, ignore it.
              if (!CheckForDuplicateNameInArray(selectedGroups, offlineParentName)) {
                var buddyResource = GetBuddyResource(tree, j);
                var buddyName = GetBuddyAttribute(tree, buddyResource, "ScreenName");
                selectedBuddies[buddyCount] = new SelectedBuddy;
                selectedBuddies[buddyCount].name = buddyName;
                selectedBuddies[buddyCount].parentname = offlineParentName;
                buddyCount++;
              }
            } //if
          } //if 
        } //else
      } //else
    } //for
  } //for



  var answer;
  var hasCancelled = 0;
  for (var g=0; g<selectedGroups.length; g++) {
    if (selectedGroups[g].name != null && selectedGroups[g].name != "" ) {
      if (isIcq() != true ) {
        answer = top.confirm(aimString("confirm.DeleteGroup").replace(/%GroupName%/, selectedGroups[g].name));
        }
      else {
        answer = top.confirm(aimString("confirm.DeleteGroup_ICQ").replace(/%GroupName%/, selectedGroups[g].name));
        }
      if (answer == true)
        aimBuddyRemoveBuddyGroup(selectedGroups[g].name);
      else
        if (!hasCancelled)
          hasCancelled = 1;
    }
  }

  for (var b=0; b<selectedBuddies.length; b++) {
    if (selectedBuddies[b].name != null && selectedBuddies[b].name != "" ) {
      if (isIcq() != true ) {
        answer  = top.confirm(aimString("confirm.DeleteBuddy").replace(/%BuddyName%/, selectedBuddies[b].name).replace(/%GroupName%/, selectedBuddies[b].parentname));
        }
      else {
        answer  = top.confirm(aimString("confirm.DeleteBuddy_ICQ").replace(/%BuddyName%/, selectedBuddies[b].name).replace(/%GroupName%/, selectedBuddies[b].parentname));
        }
      if (answer == true) {
        if (selectedBuddies[b].parentname == aimString("msg.AuthGroup")) {
           // If this is the Awaiting authorization special group remove from feedbag and datasource
           aimBuddyManager().RemoveBuddyAll(selectedBuddies[b].name);
           aimFeedbagManager().ClearAuthorization(selectedBuddies[b].name);
           continue;
        }
        aimBuddyRemoveBuddy(selectedBuddies[b].parentname, selectedBuddies[b].name);
     }
      else
        if (!hasCancelled)
          hasCancelled = 1;
    }
  }

  var totalRowCount = view.rowCount;
  if (!hasCancelled) {
    // The view maintains the selection if the user has cancelled the deletion. So don't worry about selecting the
    // next index in this case
    if ((lastSelectedIndex + 1) > totalRowCount)
      //if there is nothing after the last selected one, select the last one.
      SelectIndex(totalRowCount-1);
    else
      SelectIndex(lastSelectedIndex);
  }

}



function cmdAbEditCard()
{
  var sidebarframe=getsidebarframe();
  var selectedGroup = "";
  var wasSelected = false;
  var tree = sidebarframe.document.getElementById("ListSetup");
	var tab = sidebarframe.document.getElementById("OnlineOrgTabPanel");   
	// in the online tab and the user hit delete
  if ( tab.selectedIndex == 0 )
    return;
  var groups = aimBuddyTreeFindGroups( tree );
  top.selectedGroups = new Array();
  for (var i = 0; i != groups.length; i++) {
  // make a record for this group
    top.selectedGroups[i] = new SelectedGroup;
    top.selectedGroups[i].selectedBuddies = new Array();
    top.selectedGroups[i].name = groups[i].getAttribute("Name");
    if (groups[i].getAttribute("selected") == "true") {
      wasSelected = "true";
      top.selectedGroups[i].selected = "true";
    }
    else
      top.selectedGroups[i].selected = "false";                                                   // find the buddy nodes for this group.
 
    var buddies = null;
    for (var j = 0; j != groups[i].childNodes.length; j++)
    {
      if (groups[i].childNodes[j].nodeName == "treechildren")
      {
        // found it.
        buddies = groups[i].childNodes[j].childNodes;
        break;
      }
    }
 
    if (buddies)
    {
      for (var j = 0; j != buddies.length; j++)
      {
        top.selectedGroups[i].selectedBuddies[j] = new SelectedBuddy;
        if (buddies[j].getAttribute("selected") == "true") {
          // buddy is selected. Save the name
          // and set the selected flag to true
          wasSelected = "true";
          top.selectedGroups[i].selectedBuddies[j].name = buddies[j].getAttribute("ScreenName");
          top.selectedGroups[i].selectedBuddies[j].selected = "true";
        }
        else
          top.selectedGroups[i].selectedBuddies[j].selected = "false";
      }
    }                     
	}
 
  for ( var i = 0; i != top.selectedGroups.length; i++ ) {
    selectedGroup = top.selectedGroups[i].name;
    if ( top.selectedGroups[i].selected == "true" ) {
   	  aimErrorBox(aimString("msg.SelectBuddy")); 
		}
    else {
      for ( var j = 0; j != top.selectedGroups[i].selectedBuddies.length; j++ ) {
        if ( top.selectedGroups[i].selectedBuddies[j].selected == "true" ) {
          selectedBuddy = top.selectedGroups[i].selectedBuddies[j].name;
          if ( selectedBuddy && selectedBuddy != "" ) {
            // XXX DOES THIS STILL WORK, IS IT STILL NEEDED?
			      var card = aimABInfo().getPersonalAbCardFromAttribute("_AimScreenName", selectedBuddy, false);
        	  goEditCardDialog("moz-abmdbdirectory://abook.mab",card,null);
          }
        }                  
	    }
    }
  }
 
}       


function cmdCustom()
{
  url = aimString("app.custom.url");
  aimCmdNewBrowser(url);
}

function cmdAdClick()
{
 	aimCmdNewBrowser(aimRegionString("app.ad.link"));
  }

var ad_access=1;

function setAdTimer()
{

  var adButton = top.document.getElementById("adButton");
	var adImage = aimRegionString("app.ad.image")+"?access=" + ad_access;

  ad_access++;
  var adTimer = aimString("app.ad.timer");

  if(adButton)
    	adButton.setAttribute("src", adImage);

  if(window)
    window.setTimeout('setAdTimer()', adTimer);
}

function getSidebarDs()
{
var PANELS_RDF_FILE = "UPnls";
try {
     var locator_service = Components.classes["@mozilla.org/file/directory_service;1"].getService();
      if (locator_service)
        locator_service = locator_service.QueryInterface(Components.interfaces.nsIProperties);
	  var sidebar_file = locator_service.get(PANELS_RDF_FILE, Components.interfaces.nsIFile);
      if (!sidebar_file.exists()) {
        //Sidebar panels file does not exist?
        return;
      }
		var file_url = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIFileURL);
		file_url.file = sidebar_file;
	    return file_url.spec;
    } catch (ex) {
       throw(ex);
    }
 }

function CheckBuddyPanel()
{
  var RDF = aimRDF();
  this.nc = "http://home.netscape.com/NC-rdf#";
  this.resource = 'urn:sidebar:current-panel-list';
	var panel_list =RDF.GetDataSource(getSidebarDs()).GetTarget(RDF.GetResource("urn:sidebar:current-panel-list"),RDF.GetResource("http://home.netscape.com/NC-rdf#"+"panel-list"),  true);
	if (panel_list) {
		panel_list.QueryInterface(Components.interfaces.nsIRDFResource);
	}
  var container = Components.classes["@mozilla.org/rdf/container;1"].createInstance();
	try { 
    container = container.QueryInterface(Components.interfaces.nsIRDFContainer);
    container.Init(RDF.GetDataSource(getSidebarDs()), panel_list);
    const RDF_CONTRACTID = "@mozilla.org/rdf/rdf-service;1";
    const nsIRDFService = Components.interfaces.nsIRDFService;
    this.datasource = RDF.GetDataSource(getSidebarDs());
    this.rdf = Components.classes[RDF_CONTRACTID].getService(nsIRDFService);
  } catch (ex)
  {
    if (timercatch == false)
    {
      timercatch = true;
      setTimeout("CheckBuddyPanel()",5000);
    }
    
//    throw(ex);
  }
	var panel_resource = RDF.GetResource("urn:sidebar:panel:im-panel");
	var im_resource=RDF.GetResource("urn:sidebar:3rdparty-panel:chrome://aim/content/SidebarPanel.xul");
	var panel_index = container.IndexOf(panel_resource);
	var panel_index2 = container.IndexOf(im_resource);
	if ((panel_index == -1) && (panel_index2==-1))
	{
	  if ((typeof window.sidebar == "object") && (typeof window.sidebar.addPanel == "function")) 
    { 
//  This line was broken by mstoltz's security fix to disallow chrome urls passed to addPanel
//  Eventually when the security fix is done properly (i.e. checking the caller rather than blindly disallowing chrome)
//  We should use this addPanel call and back out all the changes I made to this file in this checkin.
//         window.sidebar.addPanel ("Buddy List","chrome://aim/content/SidebarPanel.xul",""); 

      var aTitle = "Buddy List";
      var aContentURL = "chrome://aim/content/SidebarPanel.xul";

      this.datasource.Assert(panel_resource,
                             this.rdf.GetResource(this.nc + "title"),
                             this.rdf.GetLiteral(aTitle),
                             true);
      this.datasource.Assert(panel_resource,
                            this.rdf.GetResource(this.nc + "content"),
                            this.rdf.GetLiteral(aContentURL),
                            true);
      container.AppendElement(panel_resource);
      // Use an assertion to pass a "refresh" event to all the sidebars.
      // They use observers to watch for this assertion (in sidebarOverlay.js).
      this.datasource.Assert(this.rdf.GetResource(this.resource),
                             this.rdf.GetResource(this.nc + "refresh"),
                             this.rdf.GetLiteral("true"),
                             true);
      this.datasource.Unassert(this.rdf.GetResource(this.resource),
                               this.rdf.GetResource(this.nc + "refresh"),
                               this.rdf.GetLiteral("true"));

      /* Write the modified panels out. */
      const nsIRDFRemoteDataSource = Components.interfaces.nsIRDFRemoteDataSource;
      this.datasource.QueryInterface(nsIRDFRemoteDataSource).Flush();
	  }
	} 
  SidebarSelectPanel(document.getElementById("urn:sidebar:panel:im-panel"), false, false);
}

 
 /******
  * Request info about a user and display it in a tooltip (after callback).
  ******/
 
function fillInfoTooltip(aEvent, aTooltipNode)
{
  var tree = document.getElementById("OnlineBuddies");
  var bx = tree.treeBoxObject;
  var row = {}; var col = {}; var obj = {};
  bx.getCellAt(aEvent.clientX, aEvent.clientY, row, col, obj);
  var rowValue = row.value;
  var tooltip = document.getElementById("infoTooltip");
  if (rowValue < 0) {
    tooltip.setAttribute("collapsed", "true");
    return;
  }
  var buddyResource = GetBuddyResource(tree, rowValue);
  var name = GetBuddyAttribute(tree, buddyResource, "ScreenName");
  var view = tree.treeBoxObject.view;
  var level = view.getLevel(rowValue);
  var inOffline = IsIndexinSpecialGroup(tree, col.value, rowValue);
  if (level != 1 || inOffline) {
    // if this is a mac do this bad hack to hide the tooltip
    if (navigator.appVersion.indexOf("Macintosh") != -1)
      document.getElementById("hideload").setAttribute("collapsed", "true");
    else
      tooltip.setAttribute("collapsed", "true");
    return;
  }
  
   // this check is required to prevent redundant 
   // re-requests while waiting for the callback
   if (!rowValue._RequestingInfo) {
     //var name = getScreenNameFromNode(aTreecell);
     //var tooltip = document.getElementById("infoTooltip");
 
     if (name && name != "" && tooltip) {
	   var elOnline = document.getElementById("infoTooltipOnlineTime");
       elOnline.setAttribute("value", "");
	   var elStatusTime = document.getElementById("infoTooltipStatusTime");
       elStatusTime.setAttribute("value", "");
       // if this is a mac do this bad hack to hide the tooltip
       if (navigator.appVersion.indexOf("Macintosh") != -1)
         document.getElementById("hideload").setAttribute("collapsed", "true");
       else
         tooltip.setAttribute("collapsed", "true");
       rowValue._RequestingInfo = true;
 
       // send the request and wait for callback
	   var listenerCap = new TooltipCapListener(rowValue, tooltip);
       try {
		aimLocateManager().RequestUserInfoCapabilities(listenerCap, name);
       } catch (ex) {
         //ERROR: unable to retrieve AIM user info for name
         return;
       }
     }
   }
 }
 
 /******
  * Search up the tree for first treeitem node.
  ******/
 
 function getScreenNameFromNode(aNode)
 {
   var node = aNode;
   while (node.localName != "treeitem") {
     node = node.parentNode;
   }
   return node ? node.getAttribute("ScreenName") : null;
 }
 

 

 /******
  * Event listener used for RequestUserInfoCapabilities
  ******/
 
 function TooltipCapListener(aTreecell, aTooltip)
 {
   this.mTreecell = aTreecell;
   this.mTooltip = aTooltip;
 }
 
 TooltipCapListener.prototype = {
	OnRequestUserInfoCapabilitiesComplete: function(aScreenName, aUserObj)
 	{
     var now = new Date().getTime()/1000;
     // TODO: search within mTooltip for text elements instead of id search
     
     // fill the screen name
     var elName = document.getElementById("infoTooltipName");
  
     aimABInfo = aimManager().QueryInterface(Components.interfaces.nsIAimABInfo);
     if (aimABInfo) {
        var card = aimABInfo.getPersonalAbCardFromAttribute("_AimScreenName", aScreenName, false);
        if (card) {
          if (card.nickName)
            elName.setAttribute("value", card.nickName);
          else if (card.displayName)
            elName.setAttribute("value", card.displayName);
               else
            elName.setAttribute("value", aScreenName);
          }
		  else
          elName.setAttribute("value", aScreenName);
     }
	 else
       elName.setAttribute("value", aScreenName);

     
   // fill the online line
   var elOnline = document.getElementById("infoTooltipOnlineTime");
   var since = aUserObj.GetOnlineSinceTime();
   elOnline.setAttribute("value", getPrettyDateDiff(now, since));
	 var elOnlineId = document.getElementById("infoTooltipOnlineTimeId");
   elOnlineId.setAttribute("value", aimString("tooltip.online") + ":");
   
   // fill the status line
   var elStatus = document.getElementById("infoTooltipStatus");
	 var elStatusTime = document.getElementById("infoTooltipStatusTime");
   if (aUserObj.IsIdle()) {
     elStatus.setAttribute("value", aimString("tooltip.idle") + ":");
     var statusDate = aUserObj.GetIdleSinceTime();
     elStatusTime.setAttribute("value", getPrettyDateDiff(now, statusDate));
   } else if (aUserObj.IsAway()) {
	   elStatus.setAttribute("value", aimString("tooltip.status") + ":");
     elStatusTime.setAttribute("value", aimString("tooltip.away"));
   } else {
	  elStatus.setAttribute("value", aimString("tooltip.status") + ": ");
    elStatusTime.setAttribute("value", aimString("tooltip.active"));
   }
   
   if (isIcq() != true ) 
   {  
     // fill the warnings line
     var warnings = document.getElementById("infoTooltipWarnings");
     warnings.setAttribute("value", aUserObj.GetWarningPercent() + "%");
	   var warningsId = document.getElementById("infoTooltipWarningsId");
     warningsId.setAttribute("value", aimString("tooltip.warnings") + ":");
     var cp = new String(aScreenName);
     if ((cp.charCodeAt(0) > 47) && (cp.charCodeAt(0) < 58)) 
     {
      // is an icq number, do not show warnings
      warningsId.setAttribute("hidden", "true");
      warnings.setAttribute("hidden", "true");
     }
     else
     {
      warningsId.setAttribute("hidden", "false");
      warnings.setAttribute("hidden", "false");
     }

     
  // fill in the Service Type (AOL, Internet, Administrator...)     
	 var elFlagService = document.getElementById("infoTooltipFlagValue");
	 var flagServiceValue = aUserObj.GetFlags();
	 var serviceString = "";
	 var serviceEnums = Components.interfaces.nsAimServiceTypes;
	 if (flagServiceValue & serviceEnums.Transient)
		serviceString = aimString("IdsflagTrial.label") + " ";
	 if (flagServiceValue & serviceEnums.Aol)
		serviceString = serviceString + aimString("IdsflagAol.label") + " ";
	 if (flagServiceValue & serviceEnums.Free)
	    serviceString = serviceString + aimString("IdsflagInternet.label") + " ";
	 if (flagServiceValue & serviceEnums.Administrator)
	    serviceString = serviceString + aimString("IdsflagAdministrator.label") + " ";
	 
   elFlagService.setAttribute("value", serviceString);
	 var elFlagServiceId = document.getElementById("infoTooltipFlag");
   elFlagServiceId.setAttribute("value", aimString("tooltip.service") + ":");
   elFlagService.setAttribute("hidden", "false");
   elFlagServiceId.setAttribute("hidden", "false");

     
  // fill in the Capabilities
	var elCapabilities = document.getElementById("capabilitiesValue");
  var elCapabilitiesId = document.getElementById("capabilities");
  elCapabilitiesId.setAttribute("hidden", "false");
  elCapabilities.setAttribute("hidden", "false");
	try {
		var capMask = aUserObj.GetCapabilities();
    if (capMask == 0) {
      elCapabilitiesId.setAttribute("hidden", "true");
      elCapabilities.setAttribute("hidden", "true");
    } else {
      var capEnums = Components.interfaces.nsAimCapabilitesMask;
      var capString = "";
        if (capEnums.buddyIcon & capMask) {
          if (capString == "")
            // if it is the first capability, just add it
            capString += aimString("tooltip.buddyicon");
          else
            // if some capability already present just add a comma and the capability
            capString += ", " + aimString("tooltip.buddyicon");
        }
        if (capEnums.chat & capMask) {
          if (capString == "")
            capString += aimString("tooltip.chat");
          else
            capString += ", " + aimString("tooltip.chat");
        }
        if (capEnums.filexfer & capMask) {
          if (capString == "")
            capString += aimString("tooltip.filexfer");
          else
            capString += ", " + aimString("tooltip.filexfer");
        }
        if (capEnums.unification & capMask) {
          if (capString == "")
            capString += aimString("tooltip.unification");
          else
            capString += ", "+aimString("tooltip.unification");
        }
         
      elCapabilities.setAttribute("value", capString);
      elCapabilitiesId.setAttribute("value", aimString("tooltip.capabilities") + ":");
    }
	} catch (e) {}
  
      // fill the Display Name line
  var dnValue = document.getElementById("displayNameValue");
  var curDispName = aimFeedbagManager().GetDispName(aScreenName);
  var displayName = document.getElementById("displayName");
  if (curDispName != null) {
    dnValue.setAttribute("value", curDispName);
    displayName.setAttribute("value", aimString("tooltip.displayName") + ":");
    displayName.setAttribute("hidden", "false");
    dnValue.setAttribute("hidden", "false");
  }
  else {
    displayName.setAttribute("hidden", "true");
    dnValue.setAttribute("hidden", "true");
  }

   
     

  } //end if icq
  else
  {
    //Hide warning capabilities etc in Icq     
    document.getElementById("infoTooltipWarningsId").setAttribute("hidden", "true");
    document.getElementById("infoTooltipWarnings").setAttribute("hidden", "true");
    document.getElementById("infoTooltipFlag").setAttribute("hidden", "true");
    document.getElementById("infoTooltipFlagValue").setAttribute("hidden", "true");
    document.getElementById("capabilitiesValue").setAttribute("hidden", "true");
    document.getElementById("capabilities").setAttribute("hidden", "true");
    
  }

     // show the tooltip
     // if this is a mac do this bad hack to hide the tooltip
     if (navigator.appVersion.indexOf("Macintosh") != -1)
	     document.getElementById("hideload").removeAttribute("collapsed");
	 else
	     this.mTooltip.removeAttribute("collapsed");
     this.mTreecell._RequestingInfo = false;
 	},
 
	OnRequestUserInfoCapabilitiesError: function(aScreenName, aError)
 	{
     this.mTreecell._RequestingInfo = false;
 	}
 };
 

function cmdChangePassword() {
	window.openDialog('chrome://aim/content/AimChangePassword.xul','','modal=no,titlebar,chrome,centerscreen',null);
}

function cmdConfirmAccount() {
	window.openDialog('chrome://aim/content/AimConfirmAccount.xul','','modal=yes,titlebar,chrome,centerscreen',null);
}

function cmdChangeEmail() {
	window.openDialog('chrome://aim/content/AimChangeEmail.xul','','modal=no,titlebar,chrome,centerscreen',null);
}

function cmdGetMemberInfo() {
  var screenName = getSelectedScreenName();
  window.openDialog('chrome://aim/content/GetMemberInfo.xul','_blank','chrome,all,dialog=no', screenName);
}


/*
* Name: cmdBuddyAlert
* Arguments: none. 
* Description: This function is called by command handler of cmd_buddyAlert. It chooses the appropriate tree where
* the event is triggered from and checks to see if there is a screenName attribute on the selected node. Then it opens
* the BuddyAlert dialog by passign the screenname as an argument.
* Return Value: none
* Author: Prassanna<prass@netscape.com> 
*/

function cmdBuddyAlert(isedit) {
  var screenName = getSelectedScreenName();
  if (screenName && (screenName != null)) 
  {
    if (isedit == 1)
      window.openDialog('chrome://aim/content/AimBuddyAlert.xul','_blank','chrome,all,dialog=no', screenName, 1);
    else  
      window.openDialog('chrome://aim/content/AimBuddyAlert.xul','_blank','chrome,all,dialog=no', screenName, null);
  }
}

/*
* Name: cmdDelBuddyAlert
* Arguments: none. 
* Description: This function is called by command handler of cmd_delbuddyAlert. It chooses the appropriate tree where
* the event is triggered from and checks to see if there is a screenName attribute on the selected node. Then it removes 
* the screen name from the buddy alert list.
* Return Value: none
* Author: Prassanna<prass@netscape.com> 
*/

function cmdDelBuddyAlert() {
  var screenName = getSelectedScreenName();
  if (screenName && (screenName != null))
    aimBuddyManager().DeleteBuddyFromAlertList(screenName); 
}

function cmdNewAway()
{
  if (isIcq() == true )
    window.openDialog("chrome://aim/content/AddIcqAwayMessage.xul","_blank", "chrome,close,titlebar,modal", "", "", "");
  else
    window.openDialog("chrome://aim/content/AddAwayMessage.xul","_blank", "chrome,close,titlebar,modal", "", "", "");
}

function sendFile()
{
  window.openDialog("chrome://aim/content/sendfile.xul","_blank", "chrome,close,titlebar", "", "", "");
}

function addAppSessionListener() {
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService();
  observerService = observerService.QueryInterface(Components.interfaces.nsIObserverService);
  if (observerService) {
    observerService.addObserver(sessionAppObserver, "sessionMode-changed", false);
  } else {
    dump("failed to get observer service\n");
  }
}

function removeAppSessionListener() {
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService();
  observerService = observerService.QueryInterface(Components.interfaces.nsIObserverService);
  if (observerService)
  {
  observerService.removeObserver(sessionAppObserver, "sessionMode-changed");
  }
}


var sessionAppObserver = {
  observe: function(subject, message, data) {
  if (message == 'sessionMode-changed') {
     // Update sessionMode attribut which updates all images thru css
     window.document.getElementById("sessionAppWatcher").setAttribute("sessionMode", data);
     UpdateAppMenus(data);
     }
  }
}


function cmdRegistUser()
{
 // Open regist user url;
  regLink = aimString("icq.register.url");
  dump("SURESH: regLink = " + regLink + "\n");
  openTopWin(regLink);  
  return;
}

function updateCurrentAppWindow()
{
  var connectionName;
  connectionName = aimPrefsManager().GetCharPref("aim.session.userconnectionname", null, true);       
  if (connectionName == "ICQ")
  {
    // Change the sessionMode to Icq. Originally in xul it was initialized to Aim by default.
    window.document.getElementById("sessionAppWatcher").setAttribute("sessionMode", "Icq");
    UpdateAppMenus("Icq");
  }
}

function UpdateAppMenus(sessionName)
{
  switch (sessionName) {
        case "Icq": document.getElementById('menu_File_Icq').removeAttribute("hidden");
                    document.getElementById('menu_File').setAttribute("hidden", "true");
                    document.getElementById('editOptionsid_Icq').removeAttribute("hidden");
                    document.getElementById('editOptionsid').setAttribute("hidden", "true");
                    break;
        case "Aim": document.getElementById('menu_File_Icq').setAttribute("hidden", "true");
                    document.getElementById('menu_File').removeAttribute("hidden");
                    document.getElementById('editOptionsid_Icq').setAttribute("hidden", "true");
                    document.getElementById('editOptionsid').removeAttribute("hidden");
                    break;   
  }
  
}

/*
 * Name: cmdRename
 * Arguments: none. 
 * Description: This function is called by command handler of cmd_rename. It opens the add buddy dialog from which user can remane
 * Return Value: none
 * Author: Prassanna<prass@netscape.com> 
 */
 
function cmdRename()
{
   var user=getSelectedScreenName();
   var tree = getSelectedTreeName();
   var currentIndex = tree.currentIndex;
   var rangeCount = tree.treeBoxObject.selection.getRangeCount();
   if (rangeCount > 1 || rangeCount < 1) { 
     // We dont support multiple selectetion for rename :-(
     aimErrorBox(aimString("msg.SelectContact"));
     return;
     }
   var view = tree.treeBoxObject.view;
   var parentIndex = view.getParentIndex(currentIndex);
   if (currentIndex > 0) {
       var groupResource = GetBuddyResource(tree, parentIndex);
       var groupName = GetBuddyAttribute(tree, groupResource, "Name");
   }
   if (user) {
     openDialog("chrome://aim/content/RenameBuddy.xul", "", "modal=yes,titlebar,chrome,centerscreen", groupName, user);
   }
   else
     aimErrorBox(aimString("msg.SelectContact"));
}


/*
* Name: cmdRequestAuth
* Arguments: none. 
* Description: This function is called by command handler of cmd_rerequest auth. It chooses the appropriate tree where
* the event is triggered from and checks to see if there is a screenName attribute on the selected node. Then it opens
* the authorization request window with the screenname.
* Return Value: none
* Author: Prassanna<prass@netscape.com> 
*/

function cmdRequestAuth()
{
  var auth_msg=aimString("icq.rerequestauth");
  var user=getSelectedScreenName();
  var isinlist = new Object();
  aimFeedbagManager().IsInAuthList(user, isinlist);
   // Ifin auth await group open rerequest auth window
  if (isinlist.value == true) {
    window.openDialog('chrome://aim/content/icqAuthOutgoing.xul','_blank','chrome,all,dialog=no',user, auth_msg);
    }
  else
    aimErrorBox(aimString("msg.authtryagain"));  
}