/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef MSGFMT_H
#define MSGFMT_H

#include <qcstring.h>
#include <qstring.h>
#include <qobject.h>

#include "catalogitem.h"

class KProcess;

class Msgfmt : QObject
{
   Q_OBJECT
public:
   enum Status{NoExecutable,Ok,SyntaxError,Error};
   Msgfmt(QObject* parent=0,const char* name=0);

   Status checkSyntax(QString file,QString& output);
   Status checkSyntaxInDir(QString dir,QString regexp,QString& output);

private slots:
   void addToOutput(KProcess*,char *buffer, int buflen);

private:
    static QString tempSaveName();
    QString _output;
};

#endif // MSGFMT_H
