/*------------------------------ nsContextMenu ---------------------------------
|   This JavaScript "class" is used to implement the IM standalon's            |
|   content-area context menu.                                                 |
|                                                                              |
|   For usage, see references to this class in contextMenu.xul.                |
|                                                                              |
------------------------------------------------------------------------------*/
// global context menu
//var contextMenu = null;

function nsContextMenu( xulMenu ) {
  this.menu		          = null;
  this.onlineTab        = false;
  this.listSetupTab     = false;
  this.sidebar          = false;
  this.screenName       = "";
  this.target           = null;

  // Initialize new menu.
  this.initMenu( xulMenu );
}

// Prototype for nsContextMenu "class."
nsContextMenu.prototype = {

    // onDestroy is a no-op at this point.
    onDestroy : function () {
    },

    // Initialize context menu.
    initMenu : function ( popup, event ) {
        
        this.menu = popup;

        // Get contextual info.
        this.setTarget( document.popupNode );
    
        // Initialize (disable/remove) menu items.
        this.initItems();
    },

    initItems : function () {
        this.initOnlineItems();
        this.initListSetupItems();
    },

    initOnlineItems : function () {
        this.showItem( "context-sendIM", this.onlineTab );
        this.showItem( "context-sendChat", this.onlineTab );
        this.showItem( "onlineseparator", this.onlineTab );
        //this.showItem( "context-EditList", this.sidebar );
    },

    initListSetupItems : function () {
//        this.showItem( "context-addBuddy", this.listSetupTab );
//        this.showItem( "context-addGroup", this.listSetupTab );
//	    this.showItem( "context-delete", this.listSetupTab );
		//this.showItem( "context-editAB", this.listSetupTab );
    },

    // Set various context menu attributes based on the state of the world.
    setTarget : function ( node ) {
        // Remember the node that was clicked.
        this.target = node;
		  	var sidebarframe=window; 
	  	// determine if we're in the standalone or sidebar
		var parentState = top.document.getElementById("AimSidebarState");
		if(!parentState)
		{
			var tab = sidebarframe.document.getElementById("OnlineOrgTabPanel");
			if (tab.getAttribute('index') == 0 )  
				{
				this.sidebar = true;   
				this.onlineTab = true;
				this.listSetupTab = false;
				}        
                       else
				{
				this.sidebar = true;   
                                this.onlineTab = false;
                                this.listSetupTab = true;  
				}
        }
        else
        {
		      var curTab;
		      curTab = parentState.getAttribute("AimSidebarTab");
          // Determine if we're in the Online tab or List Setup tab
		      if(curTab == "Online")
			      {
				      this.onlineTab = true;
				      this.listSetupTab  = false;
              this.sidebar = false;
			      }
		      else
			      {
				      this.listSetupTab = true;
				      this.onlineTab = false;
              this.sidebar = false;
			      }
          }

        // set the screen name based on the target
        this.screenName = this.target.parentNode.parentNode.getAttribute('ScreenName');
        //dump("Context: Screen name is " + this.screenName + "\n");
    },

    // sendIM
    cmdContextSendIM : function () {
      dump("Context: Send IM\n");
	cmdNewIM();
/*      if (aimIMDoesIMExist(this.screenName))
			  aimErrorBox(aimString("msg.DuplicateIM"));
		  else 
				aimIMInvokeIMForm(this.screenName, null);
*/
    },

    // sendChat
    cmdContextSendChat : function () {
    	  //window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no','', false,'outgoingchat');
     inviteArgsObj = {
     	inviteProposalScreenName: '', 
     	inviteProposalObj: null,
     	invitedScreenNames: getSelectedBuddiesFromList(),
     	inviteToExistingWindow: false,
     	inviteMode: 'outgoingchat'
     	}
    	  window.openDialog('chrome://aim/content/chatInviteBuddy.xul','_blank','chrome,all,dialog=no',inviteArgsObj);


		  dump("Context: Chat\n");
    },

    // Edit List
    cmdContextEditList : function  () {
      dump("Context: Edit List\n");
      //toOpenWindowByType2('Aim:AimApp', 'chrome://aim/content/App.xul');
    },

    // addbuddy
    cmdContextAddBuddy : function () {
      dump("Context: Add Buddy\n");
      cmdAddBuddy();
    },

    // addGroup
    cmdContextAddGroup : function () {
      dump("Context: Add Group\n");
      cmdAddGroup();
    },

  	// delete
    cmdContextDelete : function () {
      dump("Context: Delete\n");
      cmdDelete();
    },

	//cmdContextEditAB : function () {
      //dump("Context: Edit AddressBook\n");
	  //cmdAbEditCard();
	//},     

    // Utilities

    // Show/hide one item (specified via name or the item element itself).
    showItem : function ( itemOrId, show ) {
        var item = null;
        if ( itemOrId.constructor == String ) {
            // Argument specifies item id.
            item = document.getElementById( itemOrId );
        } else {
            // Argument is the item itself.
            item = itemOrId;
        }
        if ( item ) {
            var styleIn = item.getAttribute( "style" );
            var styleOut = styleIn;
            if ( show ) {
                // Remove style="display:none;".
                styleOut = styleOut.replace( "display:none;", "" );

            } else {
                // Set style="display:none;".
                if ( styleOut.indexOf( "display:none;" ) == -1 ) {
                    // Add style the first time we need to.
                    styleOut += "display:none;";
                }
            }
            // Only set style if it's different.
            if ( styleIn != styleOut ) {
                item.setAttribute( "style", styleOut );
            }
        }
    },

    // Set given attribute of specified context-menu item.  If the
    // value is null, then it removes the attribute (which works
    // nicely for the disabled attribute).
    setItemAttr : function ( id, attr, val ) {
        var elem = document.getElementById( id );
        if ( elem ) {
            if ( val == null ) {
                // null indicates attr should be removed.
                elem.removeAttribute( attr );
            } else {
                // Set attr=val.
                elem.setAttribute( attr, val );
            }
        }
    },

    // Set context menu attribute according to like attribute of another node
    // (such as a broadcaster).
    setItemAttrFromNode : function ( item_id, attr, other_id ) {
        var elem = document.getElementById( other_id );
        if ( elem && elem.getAttribute( attr ) == "true" ) {
            this.setItemAttr( item_id, attr, "true" );
        } else {
            this.setItemAttr( item_id, attr, null );
        }
    }
};
