var strBundleService = null;
var regionalBundle = null;

/* 
 * Name: aimRDF
 *
 * Arguments: None
 *
 * Description:
 *
 * Returns: the nsIRDF service
 *
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDF()
{
	var RDF = null;

	try {
		var RDFClass = Components.classes["@mozilla.org/rdf/rdf-service;1"];
		if ( RDFClass )
			RDF = RDFClass.getService(Components.interfaces.nsIRDFService);
	}
	catch( ex ) {
	}

	return RDF;

}

/* 
 * Name: aimRDFDataSource
 *
 * Arguments: None
 *
 * Description:
 *
 * Returns: the AIM rdf data source
 *
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDFDataSource()
{
	var AimDataSource = null;
	try {
		var rdf = aimRDF();
		if ( rdf ) {
			AimDataSource = rdf.GetDataSource("rdf:AIM");
		}
	} catch (ex) {}

	return AimDataSource;
}

/* 
 * Name: aimRDFSession
 *
 * Arguments: None
 *
 * Description:
 *
 * Returns: the NC:AIM/session resource
 *
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDFSession()
{
	var rdf = aimRDF();
	if ( rdf ) {
		return rdf.GetResource("NC:AIM/Session");
	}
	return null;
}

/* 
 * Name: aimRDFSessionState
 *
 * Arguments: None
 *
 * Description:
 *
 * Returns: the OnlineState resource
 *
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDFSessionState()
{
	var rdf = aimRDF();
	if ( rdf ) {
		return rdf.GetResource("http://home.netscape.com/NC-rdf#OnlineState");
	}
	return null;
}

/* 
 * Name: aimRDFWarningStatus
 *
 * Arguments: None
 *
 * Description:
 *
 * Returns: the nsIRDF service
 *
 * Author: syd@netscape.com 5/18/2001
 *
*/

function aimRDFWarningStatus()
{
	var rdf = aimRDF();
	if ( rdf ) {
		return rdf.GetResource("http://home.netscape.com/NC-rdf#Warning");
	}
	return null;
}

function aimGetStrBundle(path)
{
  var strBundle = null;

  if (!strBundleService) {
      try {
          strBundleService =
              Components.classes["@mozilla.org/intl/stringbundle;1"].getService(); 
          strBundleService = 
              strBundleService.QueryInterface(Components.interfaces.nsIStringBundleService);
      } catch (ex) {
          dump("\n--** aimGetStrBundle: strBundleService failed: " + ex + "\n");
          return null;
      }
  }

  strBundle = strBundleService.createBundle(path); 
  if (!strBundle) {
	dump("\n--** aimGetStrBundle: strBundle createInstance " + path + " failed **--\n");
  }
  return strBundle;
}

function aimRegionString(name)
{
	if (!regionalBundle) {
		regionalBundle = aimGetStrBundle("chrome://aim-region/locale/region.properties");
	}

	if (regionalBundle) {
		try {
			return regionalBundle.GetStringFromName(name);
		} catch (ex) {
			dump("\n-->aimRegionString(name)=" + name + " failed! \n");	
		}
	}
	return "";
}

function aimGetArgs(data)
{
	var args = new Object();
	var pairs = data.split(",");
	dump("GetArgs: argument: {" + data + "}\n");

	for (var i = pairs.length - 1; i >= 0; i--)
	{
		var pos = pairs[i].indexOf('=');
		if (pos == -1)
			continue;
		var argname = pairs[i].substring(0, pos);
		var argvalue = pairs[i].substring(pos + 1);
		if (argvalue.charAt(0) == "'" && argvalue.charAt(argvalue.length - 1) == "'")
			args[argname] = argvalue.substring(1, argvalue.length - 1);
		else
			args[argname] = unescape(argvalue);
	}
	return args;
}

function aimString(name)
{

	var myAimSession = aimSession();
	if ( myAimSession ) {
		var pIStringBundle = aimSession().QueryInterface(Components.interfaces.nsIStringBundle);
		if (pIStringBundle)
			return pIStringBundle.GetStringFromName(name);
	}
	return "";
}

function aimErrorBox(errorText)
{
	top.alert(errorText);
}

/* Global menu commands. Menu commands that might be useful to multiple apps go here */

function aimCmdNewBrowser(url)
{
	var Browser_pref=null;
	try
	{
          Browser_pref = Components.classes["@mozilla.org/preferences;1"];
          if (Browser_pref)       Browser_pref = Browser_pref.getService();
          if (Browser_pref)       Browser_pref = Browser_pref.QueryInterface(Components.interfaces.nsIPref);
	}
	catch (ex)
	{
          dump("failed to get prefs service!\n");
          Browser_pref = null;
	}

	if (Browser_pref.GetBoolPref("network.protocols.useSystemDefaults"))
     {
	    var uri = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI); 
		uri.spec=url;
		aimAdminManager().LoadDefaultBrowser(uri);
		}
	else
		window.openDialog( "chrome://navigator/content/navigator.xul", "_blank", "chrome,all,dialog=no", url);
}


function aimCmdNewEmail()
{
	dump("Implement Menu Command cmdNewEmail()\n");

	openDialog("chrome://messenger/content/messengercompose/messengercompose.xul", "");
	dump( "Leaving aimCmdNewEmail()\n" );

}

// this function tries to find where the groups data in the tree starts, 
// and returns the node, else null. 

function aimBuddyTreeFindGroups( tree )
{
	if ( !tree ) {
		return( null);
	}

	else if ( !tree.childNodes )
	{
		return( null );
	}

	for ( var i = 0; i < tree.childNodes.length; i++ ) {
		if ( tree.childNodes[i].nodeName == "treechildren" ) {
			return( tree.childNodes[i].childNodes );
		}
	}
	return( null );
}

function aimGlobalCmdStartupWizard()
{
	var windowManager = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator'].getService();

	var	windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);

	var topWindow = windowManagerInterface.getMostRecentWindow("Aim:StartupWizard");
  if(topWindow)
    topWindow.focus();
  else
    window.openDialog('chrome://aim/content/migrationWizard.xul','CPW','chrome,titlebar,resizable=yes',document);
}

function ClearMenuList( menulist )
{
	if ( menulist ) {
		menulist.selectedItem = null;
		while( menulist.firstChild )
			menulist.removeChild( menulist.firstChild );
	}
}

function AppendStringToMenulist(menulist, string)
{
  if (menulist) {
    var menupopup = menulist.firstChild;
    // May not have any popup yet -- so create one
    if (!menupopup) {
      menupopup = document.createElement("menupopup");
      if (menupopup)
        menulist.appendChild(menupopup);
      else {
        dump("Failed to create menupoup\n");
        return null;
      }
    }
    menuItem = document.createElement("menuitem");
    if (menuItem) {
      menuItem.setAttribute("label", string);
      menupopup.appendChild(menuItem);
      return menuItem;
    }
  }
  return null;
}
