var keywordList =[];
var bundle;

/**
 * Keyword dropdown actions.  [Netscape Commercial Specific]
 **/
function executeKeyword( keywordNumb )
  {
    var url = bundle.getString(keywordList[keywordNumb]+"Keyword");
    var startFocus = bundle.getString(keywordList[keywordNumb]+"Start");
    var endFocus = bundle.getString(keywordList[keywordNumb]+"End");
    if (startFocus != endFocus) {
      gURLBar.focus();
      gURLBar.value = url;
      gURLBar.setSelectionRange(startFocus, endFocus);
    } else {
      appCore.loadUrl(url);
    }
  }

keywordsInitialized = false;
function initializeKeywords()
  {
    var menuPopup = document.getElementById("keyverbs");
    if (keywordsInitialized || !menuPopup) {
      return;
    }
    keywordsInitialized = true;
    bundle = document.getElementById("bundle_navigator_region");
    var keywords = bundle.getString("keywords");
    keywordList = keywords.split(",");
    var i;
    for (i=0; i<keywordList.length; i++) {
      var menuItem = document.createElement("menuitem");
      menuItem.setAttribute("class", "menuitem-non-iconic");
      menuItem.setAttribute("label", bundle.getString(keywordList[i]+"Label"));
      menuItem.setAttribute("oncommand", "executeKeyword("+i+");");
      menuItem.setAttribute("position", i);
      menuPopup.appendChild(menuItem);
    }
  }

function executeKeywordCommand( aEvent )
  {
    var keyword = aEvent.target.getAttribute( "keyword" );
    if( keyword )
      {
        executeKeyword( keyword );
        return;
      }
  }        


// enable/disable pop-up menu according to keyword.enabled preference
function toggleKeywordMenu()
{
  var popupMenu = document.getElementById("ubhist-keyword-popup");
  if (popupMenu) {
    var collapsedVal = nsPreferences.getBoolPref("keyword.enabled", true) ? "false" : "true";
    popupMenu.setAttribute("collapsed", collapsedVal);
  }
} 

addEventListener("load", toggleKeywordMenu, true);

