/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu = null;
    private static PropertyChangeListener changeHandler;
    private Component prevFocusOwner;
    private InputMap windowInputMap;
    private static transient MouseGrabber mouseGrabber;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        this.popupMenu.setOpaque(true);
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    protected void installListeners() {
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
        if (changeHandler == null) {
            changeHandler = new PropertyChangeHandler();
        }
        this.popupMenu.addPropertyChangeListener(changeHandler);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.popupMenu, actionMap);
        Object[] objectArray = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings");
        if (objectArray != null) {
            this.windowInputMap = LookAndFeel.makeComponentInputMap(this.popupMenu, objectArray);
            SwingUtilities.replaceUIInputMap(this.popupMenu, 2, this.windowInputMap);
        }
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("PopupMenu.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("cancel", new CancelAction());
        actionMapUIResource.put("selectNext", new SelectNextItemAction());
        actionMapUIResource.put("selectPrevious", new SelectPreviousItemAction());
        actionMapUIResource.put("selectParent", new SelectParentItemAction());
        actionMapUIResource.put("selectChild", new SelectChildItemAction());
        actionMapUIResource.put("return", new ReturnAction());
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupMenu);
    }

    protected void uninstallListeners() {
        if (changeHandler != null) {
            this.popupMenu.removePropertyChangeListener(changeHandler);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private static Window getWindow(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Window) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Window)component2;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        int n3 = menuElementArray.length;
        while (n2 < n3) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        while (n2 >= 0) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            --n2;
        }
        return null;
    }

    static {
        mouseGrabber = null;
    }

    private static class SelectChildItemAction
    extends AbstractAction {
        private SelectChildItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1].getComponent().isEnabled() && menuElementArray[menuElementArray.length - 1].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                menuElementArray2[menuElementArray.length] = ((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).getPopupMenu();
                MenuElement[] menuElementArray3 = menuElementArray2[menuElementArray.length].getSubElements();
                if (menuElementArray3.length > 0) {
                    menuElementArray2[menuElementArray.length + 1] = BasicPopupMenuUI.nextEnabledChild(menuElementArray3, 0);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray4;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement2 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray4 = menuElementArray[0].getSubElements();
                    int n = 0;
                    int n2 = menuElementArray4.length;
                    while (n < n2) {
                        if (menuElementArray4[n] == menuElementArray[1] && (menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, n + 1)) == null) {
                            menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                        ++n;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement2 = null;
                    } else {
                        menuElementArray4 = jPopupMenu.getSubElements();
                        if (menuElementArray4.length > 0) {
                            menuElement2 = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                    }
                    MenuElement[] menuElementArray5 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                }
            }
        }
    }

    private static class SelectParentItemAction
    extends AbstractAction {
        private SelectParentItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 3 && menuElementArray[menuElementArray.length - 3].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 3].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray3;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement2 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray3 = menuElementArray[0].getSubElements();
                    int n = 0;
                    int n2 = menuElementArray3.length;
                    while (n < n2) {
                        if (menuElementArray3[n] == menuElementArray[1] && (menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray3, n - 1)) == null) {
                            menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray3, menuElementArray3.length - 1);
                        }
                        ++n;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement2 = null;
                    } else {
                        menuElementArray3 = jPopupMenu.getSubElements();
                        if (menuElementArray3.length > 0) {
                            menuElement2 = BasicPopupMenuUI.nextEnabledChild(menuElementArray3, 0);
                        }
                    }
                    MenuElement[] menuElementArray4 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                }
            }
        }
    }

    private static class SelectPreviousItemAction
    extends AbstractAction {
        private SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block4: {
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block3;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block4;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block3;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = BasicPopupMenuUI.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                    if (menuElementArray3[menuElementArray.length] == null) break block3;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block3;
                }
                MenuElement[] menuElementArray4 = menuElement.getSubElements();
                int n = 0;
                int n2 = menuElementArray4.length;
                while (n < n2) {
                    if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                        MenuElement menuElement2 = BasicPopupMenuUI.previousEnabledChild(menuElementArray4, n - 1);
                        if (menuElement2 == null) {
                            menuElement2 = BasicPopupMenuUI.previousEnabledChild(menuElementArray4, menuElementArray4.length - 1);
                        }
                        if (menuElement2 == null) break;
                        menuElementArray[menuElementArray.length - 1] = menuElement2;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        private SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                MenuElement menuElement;
                MenuElement[] menuElementArray;
                block4: {
                    menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray.length <= 1) break block3;
                    menuElement = menuElementArray[menuElementArray.length - 2];
                    if (!(menuElement.getComponent() instanceof JMenu)) break block4;
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length <= 0) break block3;
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = BasicPopupMenuUI.nextEnabledChild(menuElementArray2, 0);
                    if (menuElementArray3[menuElementArray.length] == null) break block3;
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                    break block3;
                }
                MenuElement[] menuElementArray4 = menuElement.getSubElements();
                int n = 0;
                int n2 = menuElementArray4.length;
                while (n < n2) {
                    if (menuElementArray4[n] == menuElementArray[menuElementArray.length - 1]) {
                        MenuElement menuElement2 = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, n + 1);
                        if (menuElement2 == null) {
                            menuElement2 = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                        if (menuElement2 == null) break;
                        menuElementArray[menuElementArray.length - 1] = menuElement2;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    private class ReturnAction
    extends AbstractAction {
        private ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    ((JMenuItem)menuElement).doClick(0);
                    ((JMenuItem)menuElement).setArmed(false);
                }
            }
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private static class MouseGrabber
    implements MouseListener,
    MouseMotionListener,
    WindowListener,
    ComponentListener,
    ChangeListener {
        Vector grabbed = new Vector();
        MenuElement lastGrabbed = null;
        boolean lastGrabbedMenuBarChild = false;
        MenuElement[] lastPathSelected = new MenuElement[0];

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
        }

        private void requestAddGrab(Component component) {
            Window window = BasicPopupMenuUI.getWindow(component);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            Component component2 = null;
            int n = 0;
            while (component2 == null && n < menuElementArray.length) {
                if (menuElementArray[n] instanceof JPopupMenu) {
                    component2 = menuElementArray[n].getComponent();
                }
                ++n;
            }
            this.grabContainer(window, component2);
        }

        private void requestRemoveGrab() {
            this.ungrabContainers();
        }

        void cancelPopupMenu() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastGrabbed == this.getFirstPopup()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                this.ungrabContainers();
            } else {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                Component component = menuElementArray[0].getComponent();
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.requestAddGrab(component);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.requestRemoveGrab();
            }
            if (menuElementArray != null && menuElementArray.length > 2 && menuElementArray[0] instanceof JMenuBar && this.lastGrabbedMenuBarChild && this.lastGrabbed != this.getFirstPopup()) {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
            this.lastPathSelected = menuElementArray;
        }

        private MenuElement getFirstPopup() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            MenuElement menuElement = null;
            int n = 0;
            while (menuElement == null && n < menuElementArray.length) {
                if (menuElementArray[n] instanceof JPopupMenu) {
                    menuElement = menuElementArray[n];
                }
                ++n;
            }
            return menuElement;
        }

        void grabContainer(Container container, Component component) {
            if (container == component) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            this.lastGrabbed = this.getFirstPopup();
            this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
                ((Window)container).addComponentListener(this);
                this.grabbed.addElement(container);
            }
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n2 = 0;
                while (n2 < n) {
                    Component component2 = componentArray[n2];
                    if (component2.isVisible()) {
                        component2.addMouseListener(this);
                        component2.addMouseMotionListener(this);
                        this.grabbed.addElement(component2);
                        if (component2 instanceof Container) {
                            Container container2 = (Container)component2;
                            this.grabContainer(container2, component);
                        }
                    }
                    ++n2;
                }
            }
        }

        void ungrabContainers() {
            int n = 0;
            int n2 = this.grabbed.size();
            while (n < n2) {
                Component component = (Component)this.grabbed.elementAt(n);
                if (component instanceof Window) {
                    ((Window)component).removeWindowListener(this);
                    ((Window)component).removeComponentListener(this);
                } else {
                    component.removeMouseListener(this);
                    component.removeMouseMotionListener(this);
                }
                ++n;
            }
            this.grabbed = new Vector();
            this.lastGrabbed = null;
            this.lastGrabbedMenuBarChild = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            this.cancelPopupMenu();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JPopupMenu jPopupMenu = (JPopupMenu)propertyChangeEvent.getSource();
            if (string != null && string.equals("visible")) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                BasicPopupMenuUI basicPopupMenuUI = (BasicPopupMenuUI)jPopupMenu.getUI();
                if (bl) {
                    boolean bl2;
                    if (basicPopupMenuUI.windowInputMap != null) {
                        SwingUtilities.replaceUIInputMap(jPopupMenu, 2, basicPopupMenuUI.windowInputMap);
                    }
                    basicPopupMenuUI.prevFocusOwner = null;
                    Container container = jPopupMenu.getParent();
                    while (container != null) {
                        if (container instanceof Window) {
                            basicPopupMenuUI.prevFocusOwner = ((Window)container).getFocusOwner();
                            break;
                        }
                        container = container.getParent();
                    }
                    if (basicPopupMenuUI.prevFocusOwner instanceof JComponent && ((JComponent)basicPopupMenuUI.prevFocusOwner).getRootPane() != jPopupMenu.getRootPane()) {
                        basicPopupMenuUI.prevFocusOwner = null;
                    }
                    if (!(bl2 = jPopupMenu.isRequestFocusEnabled())) {
                        jPopupMenu.setRequestFocusEnabled(true);
                        jPopupMenu.requestFocus();
                        jPopupMenu.setRequestFocusEnabled(false);
                    } else {
                        jPopupMenu.requestFocus();
                    }
                } else {
                    if (basicPopupMenuUI.windowInputMap != null) {
                        SwingUtilities.replaceUIInputMap(jPopupMenu, 2, null);
                    }
                    if (basicPopupMenuUI.prevFocusOwner != null) {
                        if (basicPopupMenuUI.prevFocusOwner instanceof JComponent) {
                            JComponent jComponent = (JComponent)basicPopupMenuUI.prevFocusOwner;
                            boolean bl3 = jComponent.isRequestFocusEnabled();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(true);
                            }
                            basicPopupMenuUI.prevFocusOwner.requestFocus();
                            if (!bl3) {
                                jComponent.setRequestFocusEnabled(false);
                            }
                        } else {
                            basicPopupMenuUI.prevFocusOwner.requestFocus();
                        }
                        basicPopupMenuUI.prevFocusOwner = null;
                    }
                }
            }
        }
    }
}

