#!/bin/sh

# libmove sourcelib targetlib
#
# This allows you to move a new shared library into place,
# even on a running system.
libmove() {
  LIBSOURCE=$1
  LIBTARGET=$2
  LIBFOO="`dirname $LIBTARGET`/libfoo.so.0.0.0"
  # link duplicate of target lib so we can safely copy over it:
  if [ -r $LIBTARGET ]; then
    cp -a $LIBTARGET $LIBFOO
    if [ -x /sbin/ldconfig ]; then
      ldconfig -l $LIBFOO 2> /dev/null
    fi
  fi
  mv $LIBSOURCE $LIBTARGET
  if [ -x /sbin/ldconfig ]; then
    ldconfig -l $LIBTARGET 2> /dev/null
  fi
  rm -f $LIBFOO
}

# Before using libmove, try to install everything we can:
( cd lib/incoming
  for file in * ; do
    if [ ! -r ../$file ]; then
      cp -a $file ..
    fi
  done )
if [ -x /sbin/ldconfig ]; then
  /sbin/ldconfig
fi

( cd lib/incoming
  for file in * ; do
    libmove $file ../$file
  done )
#### Now, get rid of the temporary directory:
rm -rf lib/incoming

if [ -x /sbin/ldconfig ]; then
  ( cd lib ; /sbin/ldconfig . )
else # In case there's no ldconfig, make the links manually:
  ( cd lib ; rm -rf libtermcap.so.2 )
  ( cd lib ; ln -sf libtermcap.so.2.0.8 libtermcap.so.2 )
fi

# Devel link:
( cd usr/lib ; rm -rf libtermcap.so )
( cd usr/lib ; ln -sf /lib/libtermcap.so.2.0.8 libtermcap.so )
