/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cachescheme;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.plugin.cachescheme.EntryNotFoundException;
import sun.plugin.usability.UserProfile;

public class HTMLVersionTable {
    private static char separator = (char)124;
    private static String _filename = UserProfile.getHTMLCacheTableFile();
    private static String _cachedir = UserProfile.getHTMLCacheDir();
    Properties _versionTable = new Properties();

    public void load() throws IOException {
        File file = new File(_filename);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(_filename);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            this._versionTable.load(bufferedInputStream);
            bufferedInputStream.close();
            fileInputStream.close();
        }
    }

    public void save() throws IOException {
        File file = new File(_cachedir);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(_filename);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this._versionTable.store(bufferedOutputStream, "This File is Machine Generated.  DO NOT EDIT IT.  Changing it will BREAK the Applet Installation Cache, which will in turn cause the Java Plug-in to break.");
        bufferedOutputStream.close();
        fileOutputStream.close();
    }

    public void add(String string, String string2, String string3, String string4) {
        this._versionTable.put(string, string2 + separator + string3 + separator + string4);
    }

    public void remove(String string) {
        this._versionTable.remove(string);
    }

    public String getVersion(String string) throws EntryNotFoundException {
        String string2 = this.getVersionEntry(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
        if (stringTokenizer.countTokens() < 3) {
            throw new EntryNotFoundException("Version information is not found in the version table for " + string);
        }
        String string3 = stringTokenizer.nextToken().trim();
        return string3;
    }

    public String getPath(String string) throws EntryNotFoundException {
        String string2 = this.getVersionEntry(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
        if (stringTokenizer.countTokens() < 3) {
            throw new EntryNotFoundException("Path information is not found in the version table for " + string);
        }
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken().trim();
        return string3;
    }

    public String getFilename(String string) throws EntryNotFoundException {
        String string2 = this.getVersionEntry(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
        if (stringTokenizer.countTokens() < 3) {
            throw new EntryNotFoundException("Filename information is not found in the version table for " + string);
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken().trim();
        return string3;
    }

    private String getVersionEntry(String string) throws EntryNotFoundException {
        String string2 = (String)this._versionTable.get(string);
        if (string2 == null) {
            throw new EntryNotFoundException(string + " is not found in version table");
        }
        return string2;
    }
}

