/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbcCallableStatement
extends JdbcOdbcPreparedStatement
implements CallableStatement {
    public byte[] scalez = new byte[200];
    private boolean lastParameterNull = false;

    public JdbcOdbcCallableStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public void registerOutParameter(int n2, int n3) throws SQLException {
        this.registerOutParameter(n2, n3, 0);
    }

    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        int n5;
        this.setSqlType(n2, n3);
        if (n2 <= 200) {
            this.scalez[n2] = (byte)n4;
        }
        this.setOutputParameter(n2, true);
        switch (n3) {
            case 91: {
                n5 = 10;
                break;
            }
            case 92: {
                n5 = 8;
                break;
            }
            case 93: {
                n5 = 19;
                if (n4 <= 0) break;
                n5 += n4 + 1;
                break;
            }
            case -7: {
                n5 = 1;
                break;
            }
            case -6: {
                n5 = 4;
                break;
            }
            case 5: {
                n5 = 6;
                break;
            }
            case 4: {
                n5 = 11;
                break;
            }
            case -5: {
                n5 = 20;
                break;
            }
            case 7: {
                n5 = 13;
                break;
            }
            case 6: 
            case 8: {
                n5 = 22;
                break;
            }
            case 2: 
            case 3: {
                n5 = 38;
                break;
            }
            default: {
                n5 = this.getPrecision(n3);
                if (n5 > 0 && n5 <= 8000) break;
                n5 = 8000;
            }
        }
        byte[] byArray = this.getLengthBuf(n2);
        n3 = OdbcDef.jdbcTypeToOdbc(n3);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        Object object = null;
        object = this.boundParams[n2 - 1].isInOutParameter() && this.boundParams[n2 - 1].boundValue == null ? null : this.allocBindBuf(n2, n5 + 1);
        if (this.boundParams[n2 - 1].isInOutParameter()) {
            if (this.boundParams[n2 - 1].boundValue == null) {
                this.OdbcApi.SQLBindInOutParameterNull(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, byArray, lArray);
            } else if (n3 == 8) {
                if (this.boundParams[n2 - 1].boundType == 8) {
                    double d2 = (Double)this.boundParams[n2 - 1].boundValue;
                    String string = Double.toString(d2);
                    try {
                        object = this.CharsToBytes(this.OdbcApi.charSet, string.toCharArray());
                        this.boundParams[n2 - 1].resetBindDataBuffer((byte[])object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, (byte[])object, byArray, lArray);
                }
            } else if (n3 == -2 || n3 == -4 && ((byte[])this.boundParams[n2 - 1].boundValue).length < 8000 || n3 == -3 && ((byte[])this.boundParams[n2 - 1].boundValue).length < 8000) {
                if (this.boundParams[n2 - 1].boundType == -2 || this.boundParams[n2 - 1].boundType == -3 || this.boundParams[n2 - 1].boundType == -4) {
                    this.OdbcApi.SQLBindInOutParameterBinary(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, (byte[])object, byArray, lArray);
                }
            } else if (n3 == 11) {
                if (this.boundParams[n2 - 1].boundType == 93) {
                    Timestamp timestamp = (Timestamp)this.boundParams[n2 - 1].boundValue;
                    String string = timestamp.toString();
                    try {
                        object = this.CharsToBytes(this.OdbcApi.charSet, string.toCharArray());
                        this.boundParams[n2 - 1].resetBindDataBuffer((byte[])object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, (byte[])object, byArray, lArray);
                }
            } else {
                this.OdbcApi.SQLBindInOutParameterString(this.hStmt, n2, n3, n5, this.boundParams[n2 - 1].scale, (byte[])object, byArray, lArray);
            }
        } else {
            this.OdbcApi.SQLBindOutParameterString(this.hStmt, n2, n3, n4, (byte[])object, byArray, lArray);
        }
        this.boundParams[n2 - 1].pA1 = lArray[0];
        this.boundParams[n2 - 1].pA2 = lArray[1];
        this.boundParams[n2 - 1].pB1 = lArray[2];
        this.boundParams[n2 - 1].pB2 = lArray[3];
    }

    public boolean wasNull() throws SQLException {
        return this.lastParameterNull;
    }

    public String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        int n3 = this.getSqlType(n2);
        String string = null;
        try {
            byte[] byArray = this.getDataBuf(n2);
            if (byArray != null) {
                string = this.BytesToChars(this.OdbcApi.charSet, byArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("String value for OUT parameter " + n2 + "=" + string);
        }
        return string;
    }

    public boolean getBoolean(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return false;
        }
        boolean bl2 = false;
        String string = this.getString(n2).trim();
        if (string.equals("1")) {
            bl2 = true;
        }
        return bl2;
    }

    public byte getByte(int n2) throws SQLException {
        return (byte)this.getInt(n2);
    }

    public short getShort(int n2) throws SQLException {
        return (short)this.getInt(n2);
    }

    public int getInt(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0;
        }
        Integer n3 = new Integer(this.getString(n2).trim());
        return n3;
    }

    public long getLong(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0L;
        }
        Long l2 = new Long(this.getString(n2).trim());
        return l2;
    }

    public float getFloat(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0.0f;
        }
        Float f2 = new Float(this.getString(n2).trim());
        return f2.floatValue();
    }

    public double getDouble(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return 0.0;
        }
        Double d2 = new Double(this.getString(n2).trim());
        return d2;
    }

    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n2).trim());
        return bigDecimal.setScale(n3, 6);
    }

    public byte[] getBytes(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        if (this.boundParams[n2 - 1].isInOutParameter()) {
            byte[] byArray;
            int n3 = this.getParamLength(n2);
            if (n3 < (byArray = this.getDataBuf(n2)).length) {
                byte[] byArray2 = new byte[n3];
                int n4 = 0;
                while (n4 < this.getParamLength(n2)) {
                    byArray2[n4] = byArray[n4];
                    ++n4;
                }
                this.boundParams[n2 - 1].resetBindDataBuffer(byArray2);
                return byArray2;
            }
            return byArray;
        }
        return JdbcOdbcObject.hexStringToByteArray(this.getString(n2).trim());
    }

    public Date getDate(int n2) throws SQLException {
        String string = this.getString(n2).trim();
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public Time getTime(int n2) throws SQLException {
        String string = this.getString(n2).trim();
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        String string = this.getString(n2).trim();
        if (string == null) {
            return null;
        }
        if (string.length() == 10) {
            string = string + " 00:00:00";
        }
        return Timestamp.valueOf(string);
    }

    public Object getObject(int n2) throws SQLException {
        Object object = null;
        int n3 = this.getSqlType(n2);
        if (this.isNull(n2)) {
            return null;
        }
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n2);
                break;
            }
            case 2: 
            case 3: {
                if (n2 <= 200) {
                    object = this.getBigDecimal(n2, this.scalez[n2]);
                    break;
                }
                object = this.getBigDecimal(n2, 4);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n2));
                break;
            }
            case -6: {
                object = new Integer(this.getByte(n2));
                break;
            }
            case 5: {
                object = new Integer(this.getShort(n2));
                break;
            }
            case 4: {
                object = new Integer(this.getInt(n2));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n2));
                break;
            }
            case 6: 
            case 7: {
                object = new Float(this.getFloat(n2));
                break;
            }
            case 8: {
                object = new Double(this.getDouble(n2));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n2);
                break;
            }
            case 91: {
                object = this.getDate(n2);
                break;
            }
            case 92: {
                object = this.getTime(n2);
                break;
            }
            case 93: {
                object = this.getTimestamp(n2);
            }
        }
        return object;
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n2).trim());
        return bigDecimal;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return null;
    }

    public Ref getRef(int n2) throws SQLException {
        return null;
    }

    public Blob getBlob(int n2) throws SQLException {
        return null;
    }

    public Clob getClob(int n2) throws SQLException {
        return null;
    }

    public Array getArray(int n2) throws SQLException {
        return null;
    }

    public Date getDate(int n2, Calendar calendar) throws SQLException {
        long l2 = 0L;
        Date date = null;
        String string = this.getString(n2).trim();
        if (string != null) {
            date = Date.valueOf(string);
            calendar.setTime(date);
            l2 = calendar.getTime().getTime();
        } else if (string == null) {
            return null;
        }
        if (l2 == 0L) {
            return null;
        }
        return new Date(l2);
    }

    public Time getTime(int n2, Calendar calendar) throws SQLException {
        long l2 = 0L;
        Time time = null;
        String string = this.getString(n2).trim();
        if (string != null) {
            try {
                time = Time.valueOf(string);
                calendar.setTime(time);
                l2 = calendar.getTime().getTime();
            }
            catch (Exception exception) {}
        } else if (string == null) {
            return null;
        }
        if (l2 == 0L) {
            return null;
        }
        return new Time(l2);
    }

    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        long l2 = 0L;
        Timestamp timestamp = null;
        String string = this.getString(n2).trim();
        if (string != null) {
            if (string.length() == 10) {
                string = string + " 00:00:00";
            }
            try {
                timestamp = Timestamp.valueOf(string);
                calendar.setTime(timestamp);
                l2 = calendar.getTime().getTime();
            }
            catch (Exception exception) {}
        } else if (string == null) {
            return null;
        }
        if (l2 == 0L) {
            return null;
        }
        return new Timestamp(l2);
    }

    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
    }

    protected boolean isNull(int n2) throws SQLException {
        if (!this.isOutputParameter(n2)) {
            throw new SQLException("Parameter " + n2 + " is not an OUTPUT parameter");
        }
        boolean bl2 = false;
        boolean bl3 = bl2 = this.getParamLength(n2) == -1;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Output Parameter " + n2 + " null: " + bl2);
        }
        this.lastParameterNull = bl2;
        return bl2;
    }

    protected void setOutputParameter(int n2, boolean bl2) {
        if (n2 >= 1 && n2 <= this.numParams) {
            this.boundParams[n2 - 1].setOutputParameter(bl2);
        }
    }

    protected boolean isOutputParameter(int n2) {
        boolean bl2 = false;
        if (n2 >= 1 && n2 <= this.numParams) {
            bl2 = this.boundParams[n2 - 1].isOutputParameter();
        }
        return bl2;
    }

    public synchronized void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0L) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0L;
                this.FreeParams();
                int n2 = 1;
                while (this.boundParams != null && n2 <= this.boundParams.length) {
                    this.boundParams[n2 - 1].binaryData = null;
                    this.boundParams[n2 - 1].initialize();
                    this.boundParams[n2 - 1].paramInputStream = null;
                    this.boundParams[n2 - 1].inputParameter = false;
                    ++n2;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.myConnection.deregisterStatement(this);
    }

    public synchronized void FreeParams() throws NullPointerException {
        try {
            int n2 = 1;
            while (n2 <= this.boundParams.length) {
                if (this.boundParams[n2 - 1].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pA1, this.boundParams[n2 - 1].pA2);
                    this.boundParams[n2 - 1].pA1 = 0L;
                    this.boundParams[n2 - 1].pA2 = 0L;
                }
                if (this.boundParams[n2 - 1].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pB1, this.boundParams[n2 - 1].pB2);
                    this.boundParams[n2 - 1].pB1 = 0L;
                    this.boundParams[n2 - 1].pB2 = 0L;
                }
                if (this.boundParams[n2 - 1].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[n2 - 1].pC1, this.boundParams[n2 - 1].pC2);
                    this.boundParams[n2 - 1].pC1 = 0L;
                    this.boundParams[n2 - 1].pC2 = 0L;
                }
                if (this.boundParams[n2 - 1].pS1 != 0L) {
                    JdbcOdbc.ReleaseStoredChars(this.boundParams[n2 - 1].pS1, this.boundParams[n2 - 1].pS2);
                    this.boundParams[n2 - 1].pS1 = 0L;
                    this.boundParams[n2 - 1].pS2 = 0L;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public URL getURL(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String string, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(String string, boolean bl2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setShort(String string, short s2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setInt(String string, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setLong(String string, long l2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFloat(String string, float f2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(String string, double d2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String string, Object object, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String string, int n2, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void registerOutParameter(String string, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public short getShort(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getInt(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long getLong(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

