/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.GraphicsEnvironment;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.PlatformFont;
import sun.io.CharToByteConverter;
import sun.io.CharToByteISO8859_1;

public class MFontPeer
extends PlatformFont {
    private String xfsname;
    private String converter;

    private static native void initIDs();

    public MFontPeer(String string, int n2) {
        super(string, n2);
        if (this.props != null) {
            this.xfsname = this.props.getProperty("fontset." + this.aliasName + "." + this.styleString);
        }
    }

    public CharToByteConverter getFontCharset(final String string, String string2) {
        CharToByteConverter charToByteConverter = string.equals("default") ? (CharToByteConverter)PlatformFont.charsetRegistry.get(string2) : (CharToByteConverter)PlatformFont.charsetRegistry.get(string);
        if (charToByteConverter instanceof CharToByteConverter) {
            return charToByteConverter;
        }
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return Class.forName("sun.io." + string, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        try {
                            return Class.forName("sun.awt.motif." + string, true, Thread.currentThread().getContextClassLoader());
                        }
                        catch (ClassNotFoundException classNotFoundException3) {
                            return null;
                        }
                    }
                }
            }
        });
        if (clazz == null) {
            return this.getDefaultFontCharset(string2);
        }
        try {
            charToByteConverter = (CharToByteConverter)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return this.getDefaultFontCharset(string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            return this.getDefaultFontCharset(string2);
        }
        if (string.equals("default")) {
            PlatformFont.charsetRegistry.put(string2, charToByteConverter);
        } else {
            PlatformFont.charsetRegistry.put(string, charToByteConverter);
        }
        return charToByteConverter;
    }

    private CharToByteConverter getDefaultFontCharset(String string) {
        return new CharToByteISO8859_1();
    }

    private static String getDefaultMotifFontSet() {
        String string = PlatformFont.fprops.getProperty("fontset.default");
        if (string != null) {
            int n2;
            while ((n2 = string.indexOf("%d")) >= 0) {
                string = string.substring(0, n2) + "140" + string.substring(n2 + 2);
            }
        }
        return string;
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            MFontPeer.initIDs();
        }
    }
}

