/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.objects.Comparator;
import org.apache.xpath.objects.EqualComparator;
import org.apache.xpath.objects.GreaterThanComparator;
import org.apache.xpath.objects.GreaterThanOrEqualComparator;
import org.apache.xpath.objects.LessThanComparator;
import org.apache.xpath.objects.LessThanOrEqualComparator;
import org.apache.xpath.objects.NotEqualComparator;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XNodeSet
extends XObject {
    protected DTMManager m_dtmMgr;
    static LessThanComparator S_LT = new LessThanComparator();
    static LessThanOrEqualComparator S_LTE = new LessThanOrEqualComparator();
    static GreaterThanComparator S_GT = new GreaterThanComparator();
    static GreaterThanOrEqualComparator S_GTE = new GreaterThanOrEqualComparator();
    static EqualComparator S_EQ = new EqualComparator();
    static NotEqualComparator S_NEQ = new NotEqualComparator();

    public DTMManager getDTMMgr() {
        return this.m_dtmMgr;
    }

    protected XNodeSet() {
    }

    public XNodeSet(DTMIterator dTMIterator) {
        super(dTMIterator);
        this.m_dtmMgr = dTMIterator.getDTMManager();
    }

    public XNodeSet(DTMManager dTMManager) {
        super(new NodeSetDTM(dTMManager));
        this.m_dtmMgr = dTMManager;
    }

    public XNodeSet(int n2, DTMManager dTMManager) {
        super(new NodeSetDTM(dTMManager));
        this.m_dtmMgr = dTMManager;
        if (-1 != n2) {
            ((NodeSetDTM)this.m_obj).addNode(n2);
        }
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "#NODESET";
    }

    public double getNumberFromNode(int n2) {
        XMLString xMLString = this.m_dtmMgr.getDTM(n2).getStringValue(n2);
        return xMLString.toDouble();
    }

    public double num() {
        DTMIterator dTMIterator = this.iter();
        int n2 = dTMIterator.nextNode();
        return n2 != -1 ? this.getNumberFromNode(n2) : Double.NaN;
    }

    public double numWithSideEffects() {
        DTMIterator dTMIterator = this.iterRaw();
        int n2 = dTMIterator.nextNode();
        return n2 != -1 ? this.getNumberFromNode(n2) : Double.NaN;
    }

    public boolean bool() {
        return this.iter().nextNode() != -1;
    }

    public boolean boolWithSideEffects() {
        return this.iterRaw().nextNode() != -1;
    }

    public XMLString getStringFromNode(int n2) {
        if (-1 != n2) {
            return this.m_dtmMgr.getDTM(n2).getStringValue(n2);
        }
        return XString.EMPTYSTRING;
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        DTMIterator dTMIterator = this.iter();
        int n2 = dTMIterator.nextNode();
        if (n2 != -1) {
            this.m_dtmMgr.getDTM(n2).dispatchCharactersEvents(n2, contentHandler, false);
        }
    }

    public XMLString xstr() {
        DTMIterator dTMIterator = this.iter();
        int n2 = dTMIterator.nextNode();
        return n2 != -1 ? this.getStringFromNode(n2) : XString.EMPTYSTRING;
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        XString xString = (XString)this.xstr();
        xString.appendToFsb(fastStringBuffer);
    }

    public void allowDetachToRelease(boolean bl2) {
        if (null != this.m_obj) {
            ((DTMIterator)this.m_obj).allowDetachToRelease(bl2);
        }
    }

    public void detach() {
        if (null != this.m_obj) {
            Object object = this.m_obj;
            this.m_obj = null;
            ((DTMIterator)object).detach();
        }
    }

    public String str() {
        DTMIterator dTMIterator = this.iter();
        int n2 = dTMIterator.nextNode();
        return n2 != -1 ? this.getStringFromNode(n2).toString() : "";
    }

    public NodeIterator nodeset() throws TransformerException {
        return new DTMNodeIterator(this.iter());
    }

    public NodeList nodelist() throws TransformerException {
        return new DTMNodeList(this.iter());
    }

    public DTMIterator iterRaw() {
        return (DTMIterator)this.m_obj;
    }

    public DTMIterator iter() {
        try {
            return ((DTMIterator)this.m_obj).cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public NodeSetDTM mutableNodeset() {
        NodeSetDTM nodeSetDTM;
        if (this.m_obj instanceof NodeSetDTM) {
            nodeSetDTM = (NodeSetDTM)this.m_obj;
        } else {
            nodeSetDTM = new NodeSetDTM(this.iter());
            this.m_obj = nodeSetDTM;
        }
        return nodeSetDTM;
    }

    public boolean compare(XObject xObject, Comparator comparator) throws TransformerException {
        boolean bl2 = false;
        int n2 = xObject.getType();
        if (4 == n2) {
            int n3;
            DTMIterator dTMIterator = this.iter();
            DTMIterator dTMIterator2 = ((XNodeSet)xObject).iter();
            Vector vector = null;
            block0: while (-1 != (n3 = dTMIterator.nextNode())) {
                int n4;
                XMLString xMLString = this.getStringFromNode(n3);
                if (null == vector) {
                    while (-1 != (n4 = dTMIterator2.nextNode())) {
                        XMLString xMLString2 = this.getStringFromNode(n4);
                        if (comparator.compareStrings(xMLString, xMLString2)) {
                            bl2 = true;
                            continue block0;
                        }
                        if (null == vector) {
                            vector = new Vector();
                        }
                        vector.addElement(xMLString2);
                    }
                    continue;
                }
                n4 = vector.size();
                int n5 = 0;
                while (n5 < n4) {
                    if (comparator.compareStrings(xMLString, (XMLString)vector.elementAt(n5))) {
                        bl2 = true;
                        continue block0;
                    }
                    ++n5;
                }
            }
        } else if (1 == n2) {
            double d2 = this.bool() ? 1.0 : 0.0;
            double d3 = xObject.num();
            bl2 = comparator.compareNumbers(d2, d3);
        } else if (2 == n2) {
            int n6;
            DTMIterator dTMIterator = this.iter();
            double d4 = xObject.num();
            while (-1 != (n6 = dTMIterator.nextNode())) {
                double d5 = this.getNumberFromNode(n6);
                if (!comparator.compareNumbers(d5, d4)) continue;
                bl2 = true;
                break;
            }
        } else if (5 == n2) {
            int n7;
            XMLString xMLString = xObject.xstr();
            DTMIterator dTMIterator = this.iter();
            while (-1 != (n7 = dTMIterator.nextNode())) {
                XMLString xMLString3 = this.getStringFromNode(n7);
                if (!comparator.compareStrings(xMLString3, xMLString)) continue;
                bl2 = true;
                break;
            }
        } else if (3 == n2) {
            int n8;
            XMLString xMLString = xObject.xstr();
            DTMIterator dTMIterator = this.iter();
            while (-1 != (n8 = dTMIterator.nextNode())) {
                XMLString xMLString4 = this.getStringFromNode(n8);
                if (!comparator.compareStrings(xMLString4, xMLString)) continue;
                bl2 = true;
                break;
            }
        } else {
            bl2 = comparator.compareNumbers(this.num(), xObject.num());
        }
        return bl2;
    }

    public boolean lessThan(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_LT);
    }

    public boolean lessThanOrEqual(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_LTE);
    }

    public boolean greaterThan(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_GT);
    }

    public boolean greaterThanOrEqual(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_GTE);
    }

    public boolean equals(XObject xObject) {
        try {
            return this.compare(xObject, S_EQ);
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
    }

    public boolean notEquals(XObject xObject) throws TransformerException {
        return this.compare(xObject, S_NEQ);
    }
}

