/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String insertContentAction = "insert-content";
    public static final String insertBreakAction = "insert-break";
    public static final String insertTabAction = "insert-tab";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String deleteNextCharAction = "delete-next";
    public static final String readOnlyAction = "set-read-only";
    public static final String writableAction = "set-writable";
    public static final String cutAction = "cut-to-clipboard";
    public static final String copyAction = "copy-to-clipboard";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String beepAction = "beep";
    public static final String pageUpAction = "page-up";
    public static final String pageDownAction = "page-down";
    static final String selectionPageUpAction = "selection-page-up";
    static final String selectionPageDownAction = "selection-page-down";
    static final String selectionPageLeftAction = "selection-page-left";
    static final String selectionPageRightAction = "selection-page-right";
    public static final String forwardAction = "caret-forward";
    public static final String backwardAction = "caret-backward";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String upAction = "caret-up";
    public static final String downAction = "caret-down";
    public static final String selectionUpAction = "selection-up";
    public static final String selectionDownAction = "selection-down";
    public static final String beginWordAction = "caret-begin-word";
    public static final String endWordAction = "caret-end-word";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String previousWordAction = "caret-previous-word";
    public static final String nextWordAction = "caret-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String beginLineAction = "caret-begin-line";
    public static final String endLineAction = "caret-end-line";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String beginAction = "caret-begin";
    public static final String endAction = "caret-end";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionEndAction = "selection-end";
    public static final String selectWordAction = "select-word";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectAllAction = "select-all";
    static final String unselectAction = "unselect";
    static final String toggleComponentOrientationAction = "toggle-componentOrientation";
    public static final String defaultKeyTypedAction = "default-typed";
    private static final Action[] defaultActions = new Action[]{new InsertContentAction(), new DeletePrevCharAction(), new DeleteNextCharAction(), new ReadOnlyAction(), new WritableAction(), new CutAction(), new CopyAction(), new PasteAction(), new VerticalPageAction("page-up", -1, false), new VerticalPageAction("page-down", 1, false), new VerticalPageAction("selection-page-up", -1, true), new VerticalPageAction("selection-page-down", 1, true), new PageAction("selection-page-left", true, true), new PageAction("selection-page-right", false, true), new InsertBreakAction(), new BeepAction(), new NextVisualPositionAction("caret-forward", false, 3), new NextVisualPositionAction("caret-backward", false, 7), new NextVisualPositionAction("selection-forward", true, 3), new NextVisualPositionAction("selection-backward", true, 7), new NextVisualPositionAction("caret-up", false, 1), new NextVisualPositionAction("caret-down", false, 5), new NextVisualPositionAction("selection-up", true, 1), new NextVisualPositionAction("selection-down", true, 5), new BeginWordAction("caret-begin-word", false), new EndWordAction("caret-end-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("selection-end-word", true), new PreviousWordAction("caret-previous-word", false), new NextWordAction("caret-next-word", false), new PreviousWordAction("selection-previous-word", true), new NextWordAction("selection-next-word", true), new BeginLineAction("caret-begin-line", false), new EndLineAction("caret-end-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("selection-end-line", true), new BeginParagraphAction("caret-begin-paragraph", false), new EndParagraphAction("caret-end-paragraph", false), new BeginParagraphAction("selection-begin-paragraph", true), new EndParagraphAction("selection-end-paragraph", true), new BeginAction("caret-begin", false), new EndAction("caret-end", false), new BeginAction("selection-begin", true), new EndAction("selection-end", true), new DefaultKeyTypedAction(), new InsertTabAction(), new SelectWordAction(), new SelectLineAction(), new SelectParagraphAction(), new SelectAllAction(), new UnselectAction(), new ToggleComponentOrientationAction(), new DumpModelAction()};

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public Caret createCaret() {
        return null;
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public void read(InputStream inputStream, Document document, int n2) throws IOException, BadLocationException {
        this.read(new InputStreamReader(inputStream), document, n2);
    }

    public void write(OutputStream outputStream, Document document, int n2, int n3) throws IOException, BadLocationException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.write(outputStreamWriter, document, n2, n3);
        outputStreamWriter.flush();
    }

    MutableAttributeSet getInputAttributes() {
        return null;
    }

    public void read(Reader reader, Document document, int n2) throws IOException, BadLocationException {
        int n3;
        char[] cArray = new char[4096];
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = document.getLength() == 0;
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        while ((n3 = reader.read(cArray, 0, cArray.length)) != -1) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                switch (cArray[n5]) {
                    case '\r': {
                        if (bl2) {
                            bl4 = true;
                            if (n5 == 0) {
                                document.insertString(n2, "\n", mutableAttributeSet);
                                ++n2;
                                break;
                            }
                            cArray[n5 - 1] = 10;
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    case '\n': {
                        if (!bl2) break;
                        if (n5 > n4 + 1) {
                            document.insertString(n2, new String(cArray, n4, n5 - n4 - 1), mutableAttributeSet);
                            n2 += n5 - n4 - 1;
                        }
                        bl2 = false;
                        n4 = n5;
                        bl3 = true;
                        break;
                    }
                    default: {
                        if (!bl2) break;
                        bl4 = true;
                        if (n5 == 0) {
                            document.insertString(n2, "\n", mutableAttributeSet);
                            ++n2;
                        } else {
                            cArray[n5 - 1] = 10;
                        }
                        bl2 = false;
                    }
                }
                ++n5;
            }
            if (n4 >= n3) continue;
            if (bl2) {
                if (n4 >= n3 - 1) continue;
                document.insertString(n2, new String(cArray, n4, n3 - n4 - 1), mutableAttributeSet);
                n2 += n3 - n4 - 1;
                continue;
            }
            document.insertString(n2, new String(cArray, n4, n3 - n4), mutableAttributeSet);
            n2 += n3 - n4;
        }
        if (bl2) {
            document.insertString(n2, "\n", mutableAttributeSet);
            bl4 = true;
        }
        if (bl5) {
            if (bl3) {
                document.putProperty(EndOfLineStringProperty, "\r\n");
            } else if (bl4) {
                document.putProperty(EndOfLineStringProperty, "\r");
            } else {
                document.putProperty(EndOfLineStringProperty, "\n");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write(Writer var1_1, Document var2_2, int var3_3, int var4_4) throws IOException, BadLocationException {
        block10: {
            if (var3_3 < 0 || var3_3 + var4_4 > var2_2.getLength()) {
                throw new BadLocationException("DefaultEditorKit.write", var3_3);
            }
            var5_5 = new Segment();
            var6_6 = var4_4;
            var7_7 = var3_3;
            var8_8 = var2_2.getProperty("__EndOfLine__");
            if (var8_8 == null) {
                try {
                    var8_8 = System.getProperty("line.separator");
                }
                catch (SecurityException var9_9) {
                    // empty catch block
                }
            }
            var9_10 = var8_8 instanceof String != false ? (String)var8_8 : null;
            if (var8_8 == null || var9_10.equals("\n")) ** GOTO lbl41
            while (var6_6 > 0) {
                var10_11 = Math.min(var6_6, 4096);
                var2_2.getText(var7_7, var10_11, var5_5);
                var11_13 = var5_5.offset;
                var12_14 = var5_5.array;
                var13_15 = var11_13 + var5_5.count;
                var14_16 = var11_13;
                while (var14_16 < var13_15) {
                    if (var12_14[var14_16] == '\n') {
                        if (var14_16 > var11_13) {
                            var1_1.write(var12_14, var11_13, var14_16 - var11_13);
                        }
                        var1_1.write(var9_10);
                        var11_13 = var14_16 + 1;
                    }
                    ++var14_16;
                }
                if (var13_15 > var11_13) {
                    var1_1.write(var12_14, var11_13, var13_15 - var11_13);
                }
                var7_7 += var10_11;
                var6_6 -= var10_11;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                var10_12 = Math.min(var6_6, 4096);
                var2_2.getText(var7_7, var10_12, var5_5);
                var1_1.write(var5_5.array, var5_5.offset, var5_5.count);
                var7_7 += var10_12;
                var6_6 -= var10_12;
lbl41:
                // 2 sources

                ** while (var6_6 > 0)
            }
        }
        var1_1.flush();
    }

    static class ToggleComponentOrientationAction
    extends TextAction {
        ToggleComponentOrientationAction() {
            super(DefaultEditorKit.toggleComponentOrientationAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                ComponentOrientation componentOrientation = jTextComponent.getComponentOrientation();
                ComponentOrientation componentOrientation2 = componentOrientation == ComponentOrientation.RIGHT_TO_LEFT ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
                jTextComponent.setComponentOrientation(componentOrientation2);
                jTextComponent.repaint();
            }
        }
    }

    static class UnselectAction
    extends TextAction {
        UnselectAction() {
            super(DefaultEditorKit.unselectAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setCaretPosition(jTextComponent.getCaretPosition());
            }
        }
    }

    static class SelectAllAction
    extends TextAction {
        SelectAllAction() {
            super(DefaultEditorKit.selectAllAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                jTextComponent.setCaretPosition(0);
                jTextComponent.moveCaretPosition(document.getLength());
            }
        }
    }

    static class SelectParagraphAction
    extends TextAction {
        private Action start = new BeginParagraphAction("pigdog", false);
        private Action end = new EndParagraphAction("pigdog", true);

        SelectParagraphAction() {
            super(DefaultEditorKit.selectParagraphAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectLineAction
    extends TextAction {
        private Action start = new BeginLineAction("pigdog", false);
        private Action end = new EndLineAction("pigdog", true);

        SelectLineAction() {
            super(DefaultEditorKit.selectLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class SelectWordAction
    extends TextAction {
        private Action start = new BeginWordAction("pigdog", false);
        private Action end = new EndWordAction("pigdog", true);

        SelectWordAction() {
            super(DefaultEditorKit.selectWordAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }
    }

    static class EndAction
    extends TextAction {
        private boolean select;

        EndAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Document document = jTextComponent.getDocument();
                int n2 = document.getLength();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n2);
                } else {
                    jTextComponent.setCaretPosition(n2);
                }
            }
        }
    }

    static class BeginAction
    extends TextAction {
        private boolean select;

        BeginAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (this.select) {
                    jTextComponent.moveCaretPosition(0);
                } else {
                    jTextComponent.setCaretPosition(0);
                }
            }
        }
    }

    static class EndParagraphAction
    extends TextAction {
        private boolean select;

        EndParagraphAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n2 = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n2);
                n2 = Math.min(jTextComponent.getDocument().getLength(), element.getEndOffset());
                if (this.select) {
                    jTextComponent.moveCaretPosition(n2);
                } else {
                    jTextComponent.setCaretPosition(n2);
                }
            }
        }
    }

    static class BeginParagraphAction
    extends TextAction {
        private boolean select;

        BeginParagraphAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n2 = jTextComponent.getCaretPosition();
                Element element = Utilities.getParagraphElement(jTextComponent, n2);
                n2 = element.getStartOffset();
                if (this.select) {
                    jTextComponent.moveCaretPosition(n2);
                } else {
                    jTextComponent.setCaretPosition(n2);
                }
            }
        }
    }

    static class EndLineAction
    extends TextAction {
        private boolean select;

        EndLineAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n2 = jTextComponent.getCaretPosition();
                    int n3 = Utilities.getRowEnd(jTextComponent, n2);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n3);
                    } else {
                        jTextComponent.setCaretPosition(n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class BeginLineAction
    extends TextAction {
        private boolean select;

        BeginLineAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n2 = jTextComponent.getCaretPosition();
                    int n3 = Utilities.getRowStart(jTextComponent, n2);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n3);
                    } else {
                        jTextComponent.setCaretPosition(n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class NextWordAction
    extends TextAction {
        private boolean select;

        NextWordAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n2 = jTextComponent.getCaretPosition();
                boolean bl2 = false;
                try {
                    n2 = Utilities.getNextWord(jTextComponent, n2);
                }
                catch (BadLocationException badLocationException) {
                    int n3 = jTextComponent.getDocument().getLength();
                    if (n2 != n3) {
                        n2 = n3;
                    }
                    bl2 = true;
                }
                if (!bl2) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class PreviousWordAction
    extends TextAction {
        private boolean select;

        PreviousWordAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n2 = jTextComponent.getCaretPosition();
                boolean bl2 = false;
                try {
                    n2 = Utilities.getPreviousWord(jTextComponent, n2);
                }
                catch (BadLocationException badLocationException) {
                    if (n2 != 0) {
                        n2 = 0;
                    }
                    bl2 = true;
                }
                if (!bl2) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class EndWordAction
    extends TextAction {
        private boolean select;

        EndWordAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n2 = jTextComponent.getCaretPosition();
                    int n3 = Utilities.getWordEnd(jTextComponent, n2);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n3);
                    } else {
                        jTextComponent.setCaretPosition(n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        private boolean select;

        BeginWordAction(String string, boolean bl2) {
            super(string);
            this.select = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n2 = jTextComponent.getCaretPosition();
                    int n3 = Utilities.getWordStart(jTextComponent, n2);
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n3);
                    } else {
                        jTextComponent.setCaretPosition(n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    static class NextVisualPositionAction
    extends TextAction {
        private boolean select;
        private int direction;

        NextVisualPositionAction(String string, boolean bl2, int n2) {
            super(string);
            this.select = bl2;
            this.direction = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                DefaultCaret defaultCaret = caret instanceof DefaultCaret ? (DefaultCaret)caret : null;
                int n2 = caret.getDot();
                Position.Bias[] biasArray = new Position.Bias[1];
                Point point = caret.getMagicCaretPosition();
                try {
                    Object object;
                    if (point == null && (this.direction == 1 || this.direction == 5)) {
                        object = defaultCaret != null ? jTextComponent.getUI().modelToView(jTextComponent, n2, defaultCaret.getDotBias()) : jTextComponent.modelToView(n2);
                        point = new Point(((Rectangle)object).x, ((Rectangle)object).y);
                    }
                    n2 = (object = jTextComponent.getNavigationFilter()) != null ? ((NavigationFilter)object).getNextVisualPositionFrom(jTextComponent, n2, defaultCaret != null ? defaultCaret.getDotBias() : Position.Bias.Forward, this.direction, biasArray) : jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n2, defaultCaret != null ? defaultCaret.getDotBias() : Position.Bias.Forward, this.direction, biasArray);
                    if (biasArray[0] == null) {
                        biasArray[0] = Position.Bias.Forward;
                    }
                    if (defaultCaret != null) {
                        if (this.select) {
                            defaultCaret.moveDot(n2, biasArray[0]);
                        } else {
                            defaultCaret.setDot(n2, biasArray[0]);
                        }
                    } else if (this.select) {
                        caret.moveDot(n2);
                    } else {
                        caret.setDot(n2);
                    }
                    if (point != null && (this.direction == 1 || this.direction == 5)) {
                        jTextComponent.getCaret().setMagicCaretPosition(point);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    static class DumpModelAction
    extends TextAction {
        DumpModelAction() {
            super("dump-model");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (document = jTextComponent.getDocument()) instanceof AbstractDocument) {
                ((AbstractDocument)document).dump(System.err);
            }
        }
    }

    static class PageAction
    extends TextAction {
        private boolean select;
        private boolean left;

        public PageAction(String string, boolean bl2, boolean bl3) {
            super(string);
            this.select = bl3;
            this.left = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Rectangle rectangle = new Rectangle();
                jTextComponent.computeVisibleRect(rectangle);
                rectangle.x = this.left ? Math.max(0, rectangle.x - rectangle.width) : (rectangle.x += rectangle.width);
                int n2 = jTextComponent.getCaretPosition();
                if (n2 != -1) {
                    n2 = this.left ? jTextComponent.viewToModel(new Point(rectangle.x, rectangle.y)) : jTextComponent.viewToModel(new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1));
                    Document document = jTextComponent.getDocument();
                    if (n2 != 0 && n2 > document.getLength() - 1) {
                        n2 = document.getLength() - 1;
                    } else if (n2 < 0) {
                        n2 = 0;
                    }
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n2);
                    } else {
                        jTextComponent.setCaretPosition(n2);
                    }
                }
            }
        }
    }

    static class VerticalPageAction
    extends TextAction {
        private boolean select;
        private int direction;

        public VerticalPageAction(String string, int n2, boolean bl2) {
            super(string);
            this.select = bl2;
            this.direction = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                Rectangle rectangle = jTextComponent.getVisibleRect();
                Rectangle rectangle2 = new Rectangle(rectangle);
                int n2 = jTextComponent.getCaretPosition();
                int n3 = this.direction * rectangle.height;
                int n4 = rectangle.y;
                Caret caret = jTextComponent.getCaret();
                Point point = caret.getMagicCaretPosition();
                rectangle2.y = this.constrainY(jTextComponent, rectangle.y + n3, n3);
                if (n2 != -1) {
                    try {
                        int n5;
                        Rectangle rectangle3 = jTextComponent.modelToView(n2);
                        int n6 = n5 = point != null ? point.x : rectangle3.x;
                        int n7 = rectangle.contains(rectangle3.x, rectangle3.y) ? jTextComponent.viewToModel(new Point(n5, this.constrainY(jTextComponent, rectangle3.y + n3, 0))) : (this.direction == -1 ? jTextComponent.viewToModel(new Point(n5, rectangle2.y)) : jTextComponent.viewToModel(new Point(n5, rectangle2.y + rectangle.height)));
                        n7 = this.constrainOffset(jTextComponent, n7);
                        if (n7 != n2) {
                            this.adjustScrollIfNecessary(jTextComponent, rectangle2, n4, n7);
                            if (this.select) {
                                jTextComponent.moveCaretPosition(n7);
                            } else {
                                jTextComponent.setCaretPosition(n7);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (point != null) {
                    caret.setMagicCaretPosition(point);
                }
                jTextComponent.scrollRectToVisible(rectangle2);
            }
        }

        private int constrainY(JTextComponent jTextComponent, int n2, int n3) {
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 + n3 > jTextComponent.getHeight()) {
                n2 = Math.max(0, jTextComponent.getHeight() - n3);
            }
            return n2;
        }

        private int constrainOffset(JTextComponent jTextComponent, int n2) {
            Document document = jTextComponent.getDocument();
            if (n2 != 0 && n2 > document.getLength()) {
                n2 = document.getLength();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            return n2;
        }

        private void adjustScrollIfNecessary(JTextComponent jTextComponent, Rectangle rectangle, int n2, int n3) {
            try {
                Rectangle rectangle2 = jTextComponent.modelToView(n3);
                if (rectangle2.y < rectangle.y || rectangle2.y > rectangle.y + rectangle.height || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                    int n4 = rectangle2.y < rectangle.y ? rectangle2.y : rectangle2.y + rectangle2.height - rectangle.height;
                    if (this.direction == -1 && n4 < n2 || this.direction == 1 && n4 > n2) {
                        rectangle.y = n4;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
        }
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    static class WritableAction
    extends TextAction {
        WritableAction() {
            super(DefaultEditorKit.writableAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(true);
            }
        }
    }

    static class ReadOnlyAction
    extends TextAction {
        ReadOnlyAction() {
            super(DefaultEditorKit.readOnlyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
            }
        }
    }

    static class DeleteNextCharAction
    extends TextAction {
        DeleteNextCharAction() {
            super(DefaultEditorKit.deleteNextCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl2 = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n2 = caret.getDot();
                    int n3 = caret.getMark();
                    if (n2 != n3) {
                        document.remove(Math.min(n2, n3), Math.abs(n2 - n3));
                        bl2 = false;
                    } else if (n2 < document.getLength()) {
                        int n4 = 1;
                        if (n2 < document.getLength() - 1) {
                            String string = document.getText(n2, 2);
                            char c2 = string.charAt(0);
                            char c3 = string.charAt(1);
                            if (c2 >= '\ud800' && c2 <= '\udbff' && c3 >= '\udc00' && c3 <= '\udfff') {
                                n4 = 2;
                            }
                        }
                        document.remove(n2, n4);
                        bl2 = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl2) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
        }
    }

    static class DeletePrevCharAction
    extends TextAction {
        DeletePrevCharAction() {
            super(DefaultEditorKit.deletePrevCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl2 = true;
            if (jTextComponent != null && jTextComponent.isEditable()) {
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n2 = caret.getDot();
                    int n3 = caret.getMark();
                    if (n2 != n3) {
                        document.remove(Math.min(n2, n3), Math.abs(n2 - n3));
                        bl2 = false;
                    } else if (n2 > 0) {
                        int n4 = 1;
                        if (n2 > 1) {
                            String string = document.getText(n2 - 2, 2);
                            char c2 = string.charAt(0);
                            char c3 = string.charAt(1);
                            if (c2 >= '\ud800' && c2 <= '\udbff' && c3 >= '\udc00' && c3 <= '\udfff') {
                                n4 = 2;
                            }
                        }
                        document.remove(n2 - n4, n4);
                        bl2 = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl2) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                jTextComponent.replaceSelection("\t");
            }
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                jTextComponent.replaceSelection("\n");
            }
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                    return;
                }
                String string = actionEvent.getActionCommand();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                char c2;
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    return;
                }
                String string = actionEvent.getActionCommand();
                int n2 = actionEvent.getModifiers();
                if (string != null && string.length() > 0 && (n2 & 8) == (n2 & 2) && (c2 = string.charAt(0)) >= ' ' && c2 != '\u007f') {
                    jTextComponent.replaceSelection(string);
                }
            }
        }
    }
}

