/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    private static View[] ZERO = new View[0];
    private View[] children = new View[1];
    private int nchildren = 0;
    private short left;
    private short right;
    private short top;
    private short bottom;
    private Rectangle childAlloc = new Rectangle();

    public CompositeView(Element element) {
        super(element);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        if (viewFactory == null) {
            return;
        }
        Element element = this.getElement();
        int n2 = element.getElementCount();
        if (n2 > 0) {
            View[] viewArray = new View[n2];
            int n3 = 0;
            while (n3 < n2) {
                viewArray[n3] = viewFactory.create(element.getElement(n3));
                ++n3;
            }
            this.replace(0, 0, viewArray);
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && this.nchildren == 0) {
            ViewFactory viewFactory = this.getViewFactory();
            this.loadChildren(viewFactory);
        }
    }

    public int getViewCount() {
        return this.nchildren;
    }

    public View getView(int n2) {
        return this.children[n2];
    }

    public void replace(int n2, int n3, View[] viewArray) {
        int n4;
        if (viewArray == null) {
            viewArray = ZERO;
        }
        int n5 = n2;
        while (n5 < n2 + n3) {
            if (this.children[n5].getParent() == this) {
                this.children[n5].setParent(null);
            }
            this.children[n5] = null;
            ++n5;
        }
        int n6 = viewArray.length - n3;
        int n7 = n2 + n3;
        int n8 = this.nchildren - n7;
        int n9 = n7 + n6;
        if (this.nchildren + n6 >= this.children.length) {
            n4 = Math.max(2 * this.children.length, this.nchildren + n6);
            View[] viewArray2 = new View[n4];
            System.arraycopy(this.children, 0, viewArray2, 0, n2);
            System.arraycopy(viewArray, 0, viewArray2, n2, viewArray.length);
            System.arraycopy(this.children, n7, viewArray2, n9, n8);
            this.children = viewArray2;
        } else {
            System.arraycopy(this.children, n7, this.children, n9, n8);
            System.arraycopy(viewArray, 0, this.children, n2, viewArray.length);
        }
        this.nchildren += n6;
        n4 = 0;
        while (n4 < viewArray.length) {
            viewArray[n4].setParent(this);
            ++n4;
        }
    }

    public Shape getChildAllocation(int n2, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        this.childAllocation(n2, rectangle);
        return rectangle;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        View view;
        int n3;
        boolean bl2 = bias == Position.Bias.Backward;
        int n4 = n3 = bl2 ? Math.max(0, n2 - 1) : n2;
        if (bl2 && n3 < this.getStartOffset()) {
            return null;
        }
        int n5 = this.getViewIndexAtPosition(n3);
        if (n5 != -1 && n5 < this.getViewCount() && (view = this.getView(n5)) != null && n3 >= view.getStartOffset() && n3 < view.getEndOffset()) {
            Shape shape2 = this.getChildAllocation(n5, shape);
            if (shape2 == null) {
                return null;
            }
            Shape shape3 = view.modelToView(n2, shape2, bias);
            if (shape3 == null && view.getEndOffset() == n2 && ++n5 < this.getViewCount()) {
                view = this.getView(n5);
                shape3 = view.modelToView(n2, this.getChildAllocation(n5, shape), bias);
            }
            return shape3;
        }
        throw new BadLocationException("Position not represented by view", n2);
    }

    public Shape modelToView(int n2, Position.Bias bias, int n3, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        View view;
        Rectangle rectangle2;
        Rectangle rectangle3;
        if (n2 == this.getStartOffset() && n3 == this.getEndOffset()) {
            return shape;
        }
        View view2 = this.getViewAtPosition(bias == Position.Bias.Backward ? Math.max(0, n2 - 1) : n2, rectangle3 = new Rectangle(rectangle2 = this.getInsideAllocation(shape)));
        if (view2 == (view = this.getViewAtPosition(bias2 == Position.Bias.Backward ? Math.max(0, n3 - 1) : n3, rectangle = new Rectangle(rectangle2)))) {
            if (view2 == null) {
                return shape;
            }
            return view2.modelToView(n2, bias, n3, bias2, rectangle3);
        }
        int n4 = this.getViewCount();
        int n5 = 0;
        while (n5 < n4) {
            View view3 = this.getView(n5);
            if (view3 == view2 || view3 == view) {
                View view4;
                Rectangle rectangle4;
                Rectangle rectangle5 = new Rectangle();
                if (view3 == view2) {
                    rectangle4 = view2.modelToView(n2, bias, view2.getEndOffset(), Position.Bias.Backward, rectangle3).getBounds();
                    view4 = view;
                } else {
                    rectangle4 = view.modelToView(view.getStartOffset(), Position.Bias.Forward, n3, bias2, rectangle).getBounds();
                    view4 = view2;
                }
                while (++n5 < n4 && (view3 = this.getView(n5)) != view4) {
                    rectangle5.setBounds(rectangle2);
                    this.childAllocation(n5, rectangle5);
                    rectangle4.add(rectangle5);
                }
                if (view4 != null) {
                    Shape shape2 = view4 == view ? view.modelToView(view.getStartOffset(), Position.Bias.Forward, n3, bias2, rectangle) : view2.modelToView(n2, bias, view2.getEndOffset(), Position.Bias.Backward, rectangle3);
                    if (shape2 instanceof Rectangle) {
                        rectangle4.add((Rectangle)shape2);
                    } else {
                        rectangle4.add(shape2.getBounds());
                    }
                }
                return rectangle4;
            }
            ++n5;
        }
        throw new BadLocationException("Position not represented by view", n2);
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        if (this.isBefore((int)f2, (int)f3, rectangle)) {
            int n2 = -1;
            try {
                n2 = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, shape, 3, biasArray);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (n2 == -1) {
                n2 = this.getStartOffset();
                biasArray[0] = Position.Bias.Forward;
            }
            return n2;
        }
        if (this.isAfter((int)f2, (int)f3, rectangle)) {
            int n3 = -1;
            try {
                n3 = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, shape, 7, biasArray);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (n3 == -1) {
                n3 = this.getEndOffset() - 1;
                biasArray[0] = Position.Bias.Forward;
            }
            return n3;
        }
        View view = this.getViewAtPoint((int)f2, (int)f3, rectangle);
        if (view != null) {
            return view.viewToModel(f2, f3, rectangle, biasArray);
        }
        return -1;
    }

    public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        Rectangle rectangle = this.getInsideAllocation(shape);
        switch (n3) {
            case 1: {
                return this.getNextNorthSouthVisualPositionFrom(n2, bias, shape, n3, biasArray);
            }
            case 5: {
                return this.getNextNorthSouthVisualPositionFrom(n2, bias, shape, n3, biasArray);
            }
            case 3: {
                return this.getNextEastWestVisualPositionFrom(n2, bias, shape, n3, biasArray);
            }
            case 7: {
                return this.getNextEastWestVisualPositionFrom(n2, bias, shape, n3, biasArray);
            }
        }
        throw new IllegalArgumentException("Bad direction: " + n3);
    }

    public int getViewIndex(int n2, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            --n2;
        }
        if (n2 >= this.getStartOffset() && n2 < this.getEndOffset()) {
            return this.getViewIndexAtPosition(n2);
        }
        return -1;
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int n2, Rectangle rectangle) {
        int n3 = this.getViewIndexAtPosition(n2);
        if (n3 >= 0 && n3 < this.getViewCount()) {
            View view = this.getView(n3);
            if (rectangle != null) {
                this.childAllocation(n3, rectangle);
            }
            return view;
        }
        return null;
    }

    protected int getViewIndexAtPosition(int n2) {
        Element element = this.getElement();
        return element.getElementIndex(n2);
    }

    protected Rectangle getInsideAllocation(Shape shape) {
        if (shape != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.childAlloc.setBounds(rectangle);
            this.childAlloc.x += this.left;
            this.childAlloc.y += this.top;
            this.childAlloc.width -= this.left + this.right;
            this.childAlloc.height -= this.top + this.bottom;
            return this.childAlloc;
        }
        return null;
    }

    protected void setParagraphInsets(AttributeSet attributeSet) {
        this.top = (short)StyleConstants.getSpaceAbove(attributeSet);
        this.left = (short)StyleConstants.getLeftIndent(attributeSet);
        this.bottom = (short)StyleConstants.getSpaceBelow(attributeSet);
        this.right = (short)StyleConstants.getRightIndent(attributeSet);
    }

    protected void setInsets(short s2, short s3, short s4, short s5) {
        this.top = s2;
        this.left = s3;
        this.right = s5;
        this.bottom = s4;
    }

    protected short getLeftInset() {
        return this.left;
    }

    protected short getRightInset() {
        return this.right;
    }

    protected short getTopInset() {
        return this.top;
    }

    protected short getBottomInset() {
        return this.bottom;
    }

    protected int getNextNorthSouthVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        return Utilities.getNextVisualPositionFrom(this, n2, bias, shape, n3, biasArray);
    }

    protected int getNextEastWestVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        return Utilities.getNextVisualPositionFrom(this, n2, bias, shape, n3, biasArray);
    }

    protected boolean flipEastAndWestAtEnds(int n2, Position.Bias bias) {
        return false;
    }
}

