/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalComboBoxUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new MetalComboPopup(this.comboBox);
    }

    protected JButton createArrowButton() {
        MetalComboBoxButton metalComboBoxButton = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        metalComboBoxButton.setMargin(new Insets(0, 1, 1, 3));
        return metalComboBoxButton;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    public void layoutComboBox(Container container, MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        if (this.comboBox.isEditable()) {
            metalComboBoxLayoutManager.superLayout(container);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int n2 = this.comboBox.getWidth();
            int n3 = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, n2 - (insets.left + insets.right), n3 - (insets.top + insets.bottom));
        }
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void configureEditor() {
        super.configureEditor();
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            Insets insets = metalComboBoxButton.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + metalComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            Insets insets3 = this.comboBox.getInsets();
            if (this.editor instanceof JComponent) {
                Insets insets4 = ((JComponent)this.editor).getInsets();
                dimension.height += insets4.top + insets4.bottom;
            }
            dimension.height += insets.top + insets.bottom;
            dimension.height += insets3.top + insets3.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void delegateFocus(MouseEvent mouseEvent) {
            super.delegateFocus(mouseEvent);
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer(Container container) {
            MetalComboBoxUI.this.layoutComboBox(container, this);
        }

        public void superLayout(Container container) {
            super.layoutContainer(container);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)MetalComboBoxUI.this.arrowButton;
                metalComboBoxButton.setIconOnly(MetalComboBoxUI.this.comboBox.isEditable());
                MetalComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setBackground(color);
                MetalComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                MetalComboBoxUI.this.arrowButton.setForeground(color);
                MetalComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

