/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.CenterLayout;

public class BasicColorChooserUI
extends ColorChooserUI {
    JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    boolean isMultiPanel = false;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        return abstractColorChooserPanelArray;
    }

    protected void uninstallDefaultChoosers() {
        int n2 = 0;
        while (n2 < this.defaultChoosers.length) {
            this.chooser.removeChooserPanel(this.defaultChoosers[n2]);
            ++n2;
        }
    }

    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.singlePanel = new JPanel(new CenterLayout());
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(jComponent.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
    }

    protected void installPreviewPanel() {
        this.previewPanelHolder = new JPanel(new CenterLayout());
        String string = UIManager.getString((Object)"ColorChooser.previewText", this.chooser.getLocale());
        this.previewPanelHolder.setBorder(new TitledBorder(string));
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.chooser.add((Component)this.previewPanelHolder, "South");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (BasicColorChooserUI.this.chooser.getDragEnabled()) {
                    TransferHandler transferHandler = BasicColorChooserUI.this.chooser.getTransferHandler();
                    transferHandler.exportAsDrag(BasicColorChooserUI.this.chooser, mouseEvent, 1);
                }
            }
        };
        this.previewPanel.addMouseListener(mouseAdapter);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        TransferHandler transferHandler = this.chooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            if (propertyChangeEvent.getPropertyName().equals("chooserPanels")) {
                Container container;
                object2 = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                object = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                int n2 = 0;
                while (n2 < ((AbstractColorChooserPanel[])object2).length) {
                    Container container2 = object2[n2].getParent();
                    if (container2 != null) {
                        container = container2.getParent();
                        if (container != null) {
                            container.remove(container2);
                        }
                        object2[n2].uninstallChooserPanel(BasicColorChooserUI.this.chooser);
                    }
                    ++n2;
                }
                int n3 = ((AbstractColorChooserPanel[])object).length;
                if (n3 == 0) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    return;
                }
                if (n3 == 1) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    container = new JPanel(new CenterLayout());
                    container.add((Component)object[0]);
                    BasicColorChooserUI.this.singlePanel.add((Component)container, "Center");
                    BasicColorChooserUI.this.chooser.add(BasicColorChooserUI.this.singlePanel);
                } else {
                    if (((AbstractColorChooserPanel[])object2).length < 2) {
                        BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.singlePanel);
                        BasicColorChooserUI.this.tabbedPane = new JTabbedPane();
                        BasicColorChooserUI.this.chooser.add((Component)BasicColorChooserUI.this.tabbedPane, "Center");
                    }
                    int n4 = 0;
                    while (n4 < ((Object)object).length) {
                        JPanel jPanel = new JPanel(new CenterLayout());
                        String string = ((AbstractColorChooserPanel)object[n4]).getDisplayName();
                        int n5 = ((AbstractColorChooserPanel)object[n4]).getMnemonic();
                        jPanel.add((Component)object[n4]);
                        BasicColorChooserUI.this.tabbedPane.addTab(string, jPanel);
                        if (n5 > 0) {
                            BasicColorChooserUI.this.tabbedPane.setMnemonicAt(n4, n5);
                            BasicColorChooserUI.this.tabbedPane.setDisplayedMnemonicIndexAt(n4, ((AbstractColorChooserPanel)object[n4]).getDisplayedMnemonicIndex());
                        }
                        ++n4;
                    }
                }
                BasicColorChooserUI.this.chooser.applyComponentOrientation(BasicColorChooserUI.this.chooser.getComponentOrientation());
                int n6 = 0;
                while (n6 < ((Object)object).length) {
                    ((AbstractColorChooserPanel)object[n6]).installChooserPanel(BasicColorChooserUI.this.chooser);
                    ++n6;
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("previewPanel")) {
                object2 = (JComponent)propertyChangeEvent.getOldValue();
                object = (JComponent)propertyChangeEvent.getNewValue();
                if (object2 != null) {
                    BasicColorChooserUI.this.chooser.remove((Component)object2);
                }
                BasicColorChooserUI.this.chooser.add((Component)object, "South");
                BasicColorChooserUI.this.previewPanel = object;
            }
            if (propertyChangeEvent.getPropertyName().equals("componentOrientation")) {
                object2 = (ComponentOrientation)propertyChangeEvent.getNewValue();
                object = (JColorChooser)propertyChangeEvent.getSource();
                if (object2 != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    ((Container)object).applyComponentOrientation((ComponentOrientation)object2);
                    ((JColorChooser)object).updateUI();
                }
            }
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (BasicColorChooserUI.this.previewPanel != null) {
                BasicColorChooserUI.this.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                BasicColorChooserUI.this.previewPanel.repaint();
            }
        }
    }
}

